/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.proxy;

import com.blazebit.persistence.view.EntityViewManager;
import com.blazebit.persistence.view.impl.metamodel.AbstractMethodAttribute;
import com.blazebit.persistence.view.impl.metamodel.ManagedViewTypeImplementor;
import com.blazebit.persistence.view.impl.metamodel.MappingConstructorImpl;
import com.blazebit.persistence.view.impl.proxy.AbstractReflectionInstantiator;
import com.blazebit.persistence.view.impl.proxy.ProxyFactory;
import com.blazebit.persistence.view.metamodel.ViewType;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.List;

public class DirectConstructorReflectionInstantiator<T>
extends AbstractReflectionInstantiator<T> {
    private final Constructor<T> constructor;
    private final int idSwapIndex;

    public DirectConstructorReflectionInstantiator(MappingConstructorImpl<T> mappingConstructor, ProxyFactory proxyFactory, ManagedViewTypeImplementor<T> viewType, Class<?>[] parameterTypes, EntityViewManager entityViewManager, List<AbstractReflectionInstantiator.MutableBasicUserTypeEntry> mutableBasicUserTypes, List<AbstractReflectionInstantiator.TypeConverterEntry> typeConverterEntries) {
        super(mutableBasicUserTypes, typeConverterEntries, parameterTypes);
        Constructor<T> javaConstructor;
        Class<T> proxyClazz = proxyFactory.getProxy(entityViewManager, viewType);
        try {
            javaConstructor = proxyClazz.getDeclaredConstructor(parameterTypes);
            javaConstructor.setAccessible(true);
        }
        catch (NoSuchMethodException | SecurityException ex) {
            throw new IllegalArgumentException("The given mapping constructor '" + mappingConstructor + "' does not map to a constructor of the proxy class: " + proxyClazz.getName(), ex);
        }
        this.constructor = javaConstructor;
        this.idSwapIndex = viewType instanceof ViewType ? ((AbstractMethodAttribute)((ViewType)viewType).getIdAttribute()).getAttributeIndex() : 0;
    }

    @Override
    public T newInstance(Object[] tuple) {
        try {
            if (this.idSwapIndex != 0) {
                Object tmp = tuple[0];
                tuple[0] = tuple[this.idSwapIndex];
                tuple[this.idSwapIndex] = tmp;
            }
            this.prepareTuple(tuple);
            T instance = this.constructor.newInstance(tuple);
            this.finalizeInstance(instance);
            return instance;
        }
        catch (Exception ex) {
            Object[] types = new String[tuple.length];
            for (int i = 0; i < types.length; ++i) {
                types[i] = tuple[i] == null ? null : tuple[i].getClass().getName();
            }
            throw new RuntimeException("Could not invoke the proxy constructor '" + this.constructor + "' with the given tuple: " + Arrays.toString(tuple) + " with the types: " + Arrays.toString(types), ex);
        }
    }
}

