/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.update.flush;

import com.blazebit.persistence.SubqueryBuilder;
import com.blazebit.persistence.UpdateCriteriaBuilder;
import com.blazebit.persistence.parser.util.JpaMetamodelUtils;
import com.blazebit.persistence.spi.ExtendedManagedType;
import com.blazebit.persistence.view.impl.EntityViewManagerImpl;
import com.blazebit.persistence.view.impl.accessor.Accessors;
import com.blazebit.persistence.view.impl.accessor.AttributeAccessor;
import com.blazebit.persistence.view.impl.accessor.PassthroughAttributeAccessor;
import com.blazebit.persistence.view.impl.update.UpdateContext;
import com.blazebit.persistence.view.impl.update.flush.UnmappedAttributeCascadeDeleter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.SingularAttribute;

public class UnmappedWritableBasicAttributeSetNullCascadeDeleter
implements UnmappedAttributeCascadeDeleter {
    private static final Logger LOG = Logger.getLogger(UnmappedWritableBasicAttributeSetNullCascadeDeleter.class.getName());
    private final Class<?> ownerEntityClass;
    private final Map<String, String> removeByIdMappings;
    private final Map<String, ByOwnerIdEntry> removeByOwnerIdMappings;

    public UnmappedWritableBasicAttributeSetNullCascadeDeleter(EntityViewManagerImpl evm, ManagedType<?> ownerType, ExtendedManagedType<?> extendedManagedType, Map<String, String> writableMappings) {
        this.ownerEntityClass = extendedManagedType.getType().getJavaType();
        HashMap<String, String> removeByIdMappings = new HashMap<String, String>(writableMappings.size());
        HashMap<String, ByOwnerIdEntry> removeByOwnerIdMappings = new HashMap<String, ByOwnerIdEntry>(writableMappings.size());
        SingularAttribute idAttribute = null;
        String ownerIdAttributePrefix = null;
        if (ownerType instanceof EntityType) {
            idAttribute = JpaMetamodelUtils.getSingleIdAttribute((IdentifiableType)((EntityType)ownerType));
            ownerIdAttributePrefix = JpaMetamodelUtils.getSingleIdAttribute((IdentifiableType)((EntityType)ownerType)).getName() + ".";
        }
        for (Map.Entry<String, String> entry : writableMappings.entrySet()) {
            String elementIdAttribute = extendedManagedType.getIdAttribute().getName();
            removeByIdMappings.put(entry.getValue(), elementIdAttribute);
            Set idAttributes = evm.getJpaProvider().getJoinMappingPropertyNames((EntityType)extendedManagedType.getType(), null, entry.getValue()).keySet();
            if (idAttributes.isEmpty()) {
                if (entry.getKey().startsWith(ownerIdAttributePrefix)) {
                    AttributeAccessor accessor = Accessors.forEntityMapping(evm, JpaMetamodelUtils.resolveFieldClass((Class)ownerType.getJavaType(), (Attribute)idAttribute), entry.getKey().substring(ownerIdAttributePrefix.length()));
                    removeByOwnerIdMappings.put(entry.getValue(), new ByOwnerIdEntry(entry.getValue(), accessor));
                    continue;
                }
                removeByOwnerIdMappings.put(entry.getValue(), new ByOwnerIdEntry("e." + idAttribute.getName(), ownerType.getJavaType(), "sub." + entry.getKey() + " = e." + entry.getValue(), PassthroughAttributeAccessor.INSTANCE));
                continue;
            }
            removeByOwnerIdMappings.put(entry.getValue(), new ByOwnerIdEntry(entry.getValue() + "." + (String)idAttributes.iterator().next(), PassthroughAttributeAccessor.INSTANCE));
        }
        this.removeByIdMappings = removeByIdMappings;
        this.removeByOwnerIdMappings = removeByOwnerIdMappings;
    }

    @Override
    public String getAttributeValuePath() {
        return null;
    }

    @Override
    public boolean requiresDeleteCascadeAfterRemove() {
        return false;
    }

    @Override
    public void removeById(UpdateContext context, Object id) {
        UpdateCriteriaBuilder updateCb = context.getEntityViewManager().getCriteriaBuilderFactory().update(context.getEntityManager(), this.ownerEntityClass, "e");
        for (Map.Entry<String, String> entry : this.removeByIdMappings.entrySet()) {
            updateCb.setExpression(entry.getKey(), "NULL");
            updateCb.where(entry.getValue()).eq(id);
        }
        updateCb.executeUpdate();
    }

    @Override
    public void removeByOwnerId(UpdateContext context, Object ownerId) {
        UpdateCriteriaBuilder updateCb = context.getEntityViewManager().getCriteriaBuilderFactory().update(context.getEntityManager(), this.ownerEntityClass, "e");
        for (Map.Entry<String, ByOwnerIdEntry> entry : this.removeByOwnerIdMappings.entrySet()) {
            updateCb.setExpression(entry.getKey(), "NULL");
            ByOwnerIdEntry value = entry.getValue();
            if (value.subqueryEntityClass == null) {
                updateCb.where(value.ownerIdMapping).eq(value.ownerIdAccessor.getValue(ownerId));
                continue;
            }
            ((SubqueryBuilder)updateCb.whereExists().from(value.subqueryEntityClass, "sub").where(value.ownerIdMapping).eq(value.ownerIdAccessor.getValue(ownerId))).end();
        }
        updateCb.executeUpdate();
    }

    @Override
    public UnmappedAttributeCascadeDeleter createFlusherWiseDeleter() {
        return this;
    }

    private static class ByOwnerIdEntry {
        private final String ownerIdMapping;
        private final Class<?> subqueryEntityClass;
        private final String subqueryCorrelation;
        private final AttributeAccessor ownerIdAccessor;

        public ByOwnerIdEntry(String ownerIdMapping, AttributeAccessor ownerIdAccessor) {
            this.ownerIdMapping = ownerIdMapping;
            this.subqueryEntityClass = null;
            this.subqueryCorrelation = null;
            this.ownerIdAccessor = ownerIdAccessor;
        }

        public ByOwnerIdEntry(String ownerIdMapping, Class<?> subqueryEntityClass, String subqueryCorrelation, AttributeAccessor ownerIdAccessor) {
            this.ownerIdMapping = ownerIdMapping;
            this.subqueryEntityClass = subqueryEntityClass;
            this.subqueryCorrelation = subqueryCorrelation;
            this.ownerIdAccessor = ownerIdAccessor;
        }
    }
}

