/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.collection;

import com.blazebit.persistence.view.impl.collection.CollectionAction;
import com.blazebit.persistence.view.impl.collection.CollectionOperations;
import com.blazebit.persistence.view.impl.collection.CollectionRemoveListener;
import com.blazebit.persistence.view.impl.collection.RecordingCollection;
import com.blazebit.persistence.view.impl.collection.RecordingUtils;
import com.blazebit.persistence.view.impl.entity.ViewToEntityMapper;
import com.blazebit.persistence.view.impl.update.UpdateContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CollectionRemoveAllAction<C extends Collection<E>, E>
implements CollectionAction<C> {
    private final Collection<Object> elements;

    public CollectionRemoveAllAction(int size, boolean allowDuplicates) {
        this.elements = allowDuplicates ? new ArrayList<Object>(size) : Collections.newSetFromMap(new IdentityHashMap(size));
    }

    public CollectionRemoveAllAction(Object element, boolean allowDuplicates) {
        this.elements = allowDuplicates ? new ArrayList<Object>() : Collections.newSetFromMap(new IdentityHashMap());
        this.elements.add(element);
    }

    public CollectionRemoveAllAction(Collection<?> collection, boolean allowDuplicates) {
        if (allowDuplicates) {
            this.elements = new ArrayList(collection);
        } else {
            this.elements = Collections.newSetFromMap(new IdentityHashMap(collection.size()));
            this.elements.addAll(collection);
        }
    }

    private CollectionRemoveAllAction(CollectionRemoveAllAction<C, E> action) {
        if (action.elements instanceof Set) {
            this.elements = Collections.newSetFromMap(new IdentityHashMap(action.elements.size()));
            this.elements.addAll(action.elements);
        } else {
            this.elements = new ArrayList<Object>(action.elements);
        }
    }

    private CollectionRemoveAllAction(Collection<Object> collection) {
        this.elements = collection;
    }

    public static <C extends Collection<E>, E> CollectionRemoveAllAction<C, E> retainAll(Collection<?> c, C delegate, boolean allowDuplicates) {
        int size = c.size() >= delegate.size() ? delegate.size() : delegate.size() - c.size();
        Collection<Object> removedElements = allowDuplicates ? new ArrayList(size) : Collections.newSetFromMap(new IdentityHashMap(size));
        for (E e : delegate) {
            if (c.contains(e)) continue;
            removedElements.add(e);
        }
        return new CollectionRemoveAllAction<C, E>(removedElements);
    }

    @Override
    public void doAction(C collection, UpdateContext context, ViewToEntityMapper mapper, CollectionRemoveListener removeListener) {
        if (removeListener != null) {
            for (Object e : collection) {
                removeListener.onCollectionRemove(context, e);
            }
        }
        if (mapper != null) {
            if (this.elements.size() == 1) {
                collection.remove(mapper.applyToEntity(context, null, this.elements.iterator().next()));
            } else {
                ArrayList<Object> entities = new ArrayList<Object>(this.elements);
                mapper.applyAll(context, entities);
                collection.removeAll(entities);
            }
        } else {
            collection.removeAll(this.elements);
        }
    }

    @Override
    public void undo(C collection, Collection<?> removedObjects, Collection<?> addedObjects) {
        for (Object element : this.elements) {
            if (!removedObjects.contains(element)) continue;
            collection.add((Object)element);
        }
    }

    @Override
    public boolean containsObject(C collection, Object o) {
        for (Object element : this.elements) {
            if (element != o) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public Collection<Object> getAddedObjects() {
        return Collections.emptyList();
    }

    @Override
    public Collection<Object> getRemovedObjects() {
        return this.elements;
    }

    @Override
    public Collection<Object> getAddedObjects(C collection) {
        return Collections.emptyList();
    }

    @Override
    public Collection<Object> getRemovedObjects(C collection) {
        return this.elements;
    }

    @Override
    public CollectionAction<C> replaceObject(Object oldElem, Object elem) {
        List<Object> newElements = RecordingUtils.replaceElements(this.elements, oldElem, elem);
        if (newElements == null) {
            return null;
        }
        return new CollectionRemoveAllAction<C, E>(newElements, this.elements instanceof List);
    }

    @Override
    public CollectionAction<C> replaceObjects(Map<Object, Object> objectMapping) {
        List<Object> newElements = RecordingUtils.replaceElements(this.elements, objectMapping);
        if (newElements == null) {
            return new CollectionRemoveAllAction<C, E>(this);
        }
        return new CollectionRemoveAllAction<C, E>(newElements, this.elements instanceof List);
    }

    @Override
    public void addAction(RecordingCollection<?, ?> recordingCollection, List<CollectionAction<C>> actions) {
        CollectionOperations op = new CollectionOperations(actions);
        int removeIndex = op.removeElements(recordingCollection, this.elements);
        if (removeIndex != -1) {
            actions.add(removeIndex, this);
        }
        op.removeEmpty();
    }

    public void add(Object o) {
        this.elements.add(o);
    }

    public Collection<Object> onRemoveObjects(Collection<Object> objectsToRemove) {
        this.elements.addAll(objectsToRemove);
        return Collections.emptyList();
    }

    public Collection<Object> onAddObjects(Collection<Object> objectsToAdd) {
        return RecordingUtils.compensateObjects(this.elements, objectsToAdd);
    }
}

