/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.metamodel;

import com.blazebit.persistence.view.MappingIndex;
import com.blazebit.persistence.view.MappingInheritance;
import com.blazebit.persistence.view.MappingInheritanceMapKey;
import com.blazebit.persistence.view.MappingInheritanceSubtype;
import com.blazebit.persistence.view.MappingParameter;
import com.blazebit.persistence.view.MappingSingular;
import com.blazebit.persistence.view.impl.metamodel.AbstractAnnotationAttributeMappingReader;
import com.blazebit.persistence.view.impl.metamodel.ConstructorMapping;
import com.blazebit.persistence.view.impl.metamodel.MetamodelBootContext;
import com.blazebit.persistence.view.impl.metamodel.ParameterAttributeMapping;
import com.blazebit.persistence.view.impl.metamodel.ViewMapping;
import com.blazebit.persistence.view.metamodel.PluralAttribute;
import com.blazebit.reflection.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class AnnotationParameterAttributeMappingReader
extends AbstractAnnotationAttributeMappingReader {
    public AnnotationParameterAttributeMappingReader(MetamodelBootContext context) {
        super(context);
    }

    public ParameterAttributeMapping readParameterAttributeMapping(ViewMapping viewMapping, Annotation mapping, ConstructorMapping constructorMapping, int index, AnnotatedElement annotatedElement) {
        Class elementType;
        Class keyType;
        Type declaredElementType;
        Type declaredKeyType;
        Type declaredType;
        Constructor<?> constructor = constructorMapping.getConstructor();
        Class entityViewClass = viewMapping.getEntityViewClass();
        Type parameterType = ReflectionUtils.resolve((Class)entityViewClass, (Type)constructor.getGenericParameterTypes()[index]);
        Class type = ReflectionUtils.resolveType((Class)entityViewClass, (Type)parameterType);
        boolean forceSingular = annotatedElement.isAnnotationPresent(MappingSingular.class) || annotatedElement.isAnnotationPresent(MappingParameter.class);
        boolean isCollection = !forceSingular && (Collection.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type));
        PluralAttribute.ElementCollectionType elementCollectionType = null;
        if (isCollection) {
            Type[] typeArguments = ((ParameterizedType)parameterType).getActualTypeArguments();
            declaredType = parameterType;
            declaredKeyType = typeArguments.length > 1 ? typeArguments[0] : null;
            declaredElementType = typeArguments[typeArguments.length - 1];
            keyType = ReflectionUtils.resolveType((Class)entityViewClass, (Type)declaredKeyType);
            elementType = ReflectionUtils.resolveType((Class)entityViewClass, (Type)declaredElementType);
            if (elementType != null && Collection.class.isAssignableFrom(elementType)) {
                Type[] elementTypeArguments = ((ParameterizedType)declaredElementType).getActualTypeArguments();
                elementCollectionType = this.getElementCollectionType(elementType);
                declaredElementType = elementTypeArguments[0];
                elementType = ReflectionUtils.resolveType((Class)entityViewClass, (Type)declaredElementType);
            }
        } else {
            declaredType = parameterType;
            declaredKeyType = null;
            declaredElementType = null;
            keyType = null;
            elementType = null;
        }
        Map<Class<?>, String> typeMappings = this.resolveInheritanceSubtypeMappings(annotatedElement, type);
        Map<Class<?>, String> keyTypeMappings = this.resolveKeyInheritanceSubtypeMappings(annotatedElement, keyType);
        Map<Class<?>, String> elementTypeMappings = this.resolveElementInheritanceSubtypeMappings(annotatedElement, elementType);
        ParameterAttributeMapping parameterMapping = new ParameterAttributeMapping(viewMapping, mapping, annotatedElement.getAnnotation(MappingIndex.class), this.context, constructorMapping, index, isCollection, elementCollectionType, type, keyType, elementType, declaredType, declaredKeyType, declaredElementType, typeMappings, keyTypeMappings, elementTypeMappings);
        this.applyCommonMappings(parameterMapping, annotatedElement);
        return parameterMapping;
    }

    private Map<Class<?>, String> resolveInheritanceSubtypeMappings(AnnotatedElement annotatedElement, Class<?> type) {
        MappingInheritance inheritance = annotatedElement.getAnnotation(MappingInheritance.class);
        if (inheritance != null) {
            Class<?> baseType = null;
            if (!inheritance.onlySubtypes()) {
                baseType = type;
            }
            return this.resolveInheritanceSubtypeMappings(annotatedElement, baseType, inheritance.value());
        }
        return this.resolveInheritanceSubtypeMappings(annotatedElement, null, null);
    }

    private Map<Class<?>, String> resolveKeyInheritanceSubtypeMappings(AnnotatedElement annotatedElement, Class<?> keyType) {
        MappingInheritanceMapKey inheritance = annotatedElement.getAnnotation(MappingInheritanceMapKey.class);
        if (inheritance != null) {
            Class<?> baseType = null;
            if (!inheritance.onlySubtypes()) {
                baseType = keyType;
            }
            return this.resolveInheritanceSubtypeMappings(annotatedElement, baseType, inheritance.value());
        }
        return null;
    }

    private Map<Class<?>, String> resolveElementInheritanceSubtypeMappings(AnnotatedElement annotatedElement, Class<?> elementType) {
        MappingInheritance inheritance = annotatedElement.getAnnotation(MappingInheritance.class);
        if (inheritance != null) {
            Class<?> baseType = null;
            if (!inheritance.onlySubtypes()) {
                baseType = elementType;
            }
            return this.resolveInheritanceSubtypeMappings(annotatedElement, baseType, inheritance.value());
        }
        return this.resolveInheritanceSubtypeMappings(annotatedElement, null, null);
    }

    private Map<Class<?>, String> resolveInheritanceSubtypeMappings(AnnotatedElement annotatedElement, Class<?> baseType, MappingInheritanceSubtype[] subtypes) {
        if (subtypes == null) {
            MappingInheritanceSubtype subtype = annotatedElement.getAnnotation(MappingInheritanceSubtype.class);
            if (subtype == null) {
                return null;
            }
            subtypes = new MappingInheritanceSubtype[]{subtype};
        }
        HashMap mappings = new HashMap(subtypes.length);
        if (baseType != null) {
            mappings.put(baseType, null);
        }
        for (MappingInheritanceSubtype subtype : subtypes) {
            String mapping = subtype.mapping();
            if (mapping.isEmpty()) {
                mapping = null;
            }
            mappings.put(subtype.value(), mapping);
        }
        return mappings;
    }
}

