/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.objectbuilder;

import com.blazebit.persistence.ObjectBuilder;
import com.blazebit.persistence.view.impl.objectbuilder.DelegatingObjectBuilder;
import com.blazebit.persistence.view.impl.objectbuilder.TupleReuse;
import java.util.Arrays;

public class ReducerViewTypeObjectBuilder<T>
extends DelegatingObjectBuilder<T> {
    private final int start;
    private final int suffix;
    private final int length;
    private final boolean keepTuplePrefix;
    private final FastArrayList newTuple;

    public ReducerViewTypeObjectBuilder(ObjectBuilder<T> delegate, int start, int suffix, int length, boolean keepTuplePrefix) {
        super(delegate);
        this.start = start;
        this.suffix = suffix;
        this.length = length;
        this.keepTuplePrefix = keepTuplePrefix;
        this.newTuple = new FastArrayList(length);
    }

    @Override
    public T build(Object[] tuple) {
        this.newTuple.clear();
        for (int i = this.start; i < this.start + this.length; ++i) {
            if (tuple[i] == TupleReuse.CONSUMED) continue;
            this.newTuple.add(tuple[i]);
        }
        Object result = this.buildObject(tuple, this.newTuple.getArray());
        if (this.keepTuplePrefix) {
            Object[] tupleWithPrefix = new Object[this.start + this.suffix + 1];
            System.arraycopy(tuple, 0, tupleWithPrefix, 0, this.start);
            System.arraycopy(tuple, tuple.length - this.suffix, tupleWithPrefix, this.start + 1, this.suffix);
            tupleWithPrefix[this.start] = result;
            result = tupleWithPrefix;
        }
        return result;
    }

    protected T buildObject(Object[] originalTuple, Object[] tuple) {
        return (T)this.delegate.build(tuple);
    }

    private static class FastArrayList {
        private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
        private Object[] array;
        private int size = 0;

        public FastArrayList(int initialSize) {
            this.array = new Object[initialSize];
        }

        public void clear() {
            this.size = 0;
        }

        public Object[] getArray() {
            if (this.array.length == this.size) {
                return this.array;
            }
            this.array = Arrays.copyOf(this.array, this.size);
            return this.array;
        }

        public void add(Object value) {
            if (this.size < this.array.length) {
                this.array[this.size] = value;
            } else {
                this.grow(this.size + 1);
                this.array[this.size] = value;
            }
            ++this.size;
        }

        private void grow(int minCapacity) {
            int oldCapacity = this.array.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - 0x7FFFFFF7 > 0) {
                newCapacity = FastArrayList.hugeCapacity(minCapacity);
            }
            this.array = Arrays.copyOf(this.array, newCapacity);
        }

        private static int hugeCapacity(int minCapacity) {
            if (minCapacity < 0) {
                throw new OutOfMemoryError();
            }
            return minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
        }
    }
}

