/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.proxy;

import com.blazebit.persistence.view.EntityViewManager;
import com.blazebit.persistence.view.impl.metamodel.ManagedViewTypeImplementor;
import com.blazebit.persistence.view.impl.metamodel.MappingConstructorImpl;
import com.blazebit.persistence.view.impl.proxy.AbstractReflectionInstantiator;
import com.blazebit.persistence.view.impl.proxy.ProxyFactory;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.List;

public class TupleConstructorReflectionInstantiator<T>
extends AbstractReflectionInstantiator<T> {
    private final Constructor<T> constructor;
    private final Object[] defaultObject;

    public TupleConstructorReflectionInstantiator(MappingConstructorImpl<T> mappingConstructor, ProxyFactory proxyFactory, ManagedViewTypeImplementor<T> viewType, Class<?>[] parameterTypes, EntityViewManager entityViewManager, List<AbstractReflectionInstantiator.MutableBasicUserTypeEntry> mutableBasicUserTypes, List<AbstractReflectionInstantiator.TypeConverterEntry> typeConverterEntries) {
        super(mutableBasicUserTypes, typeConverterEntries, parameterTypes);
        Object[] defaultObject;
        Constructor<T> javaConstructor;
        Class<T> proxyClazz = proxyFactory.getProxy(entityViewManager, viewType);
        try {
            if (mappingConstructor == null) {
                javaConstructor = proxyClazz.getDeclaredConstructor(proxyClazz, Integer.TYPE, Object[].class);
                defaultObject = new Object[]{null, 0, null};
            } else {
                int parameterSize = mappingConstructor.getParameterAttributes().size();
                Class[] types = new Class[parameterSize + 3];
                types[0] = proxyClazz;
                types[1] = Integer.TYPE;
                types[2] = Object[].class;
                System.arraycopy(parameterTypes, parameterTypes.length - parameterSize, types, 3, parameterSize);
                javaConstructor = proxyClazz.getDeclaredConstructor(types);
                defaultObject = AbstractReflectionInstantiator.createDefaultObject(3, parameterTypes, parameterSize);
                defaultObject[1] = 0;
            }
        }
        catch (NoSuchMethodException | SecurityException ex) {
            throw new IllegalArgumentException("The given mapping constructor '" + mappingConstructor + "' does not map to a constructor of the proxy class: " + proxyClazz.getName(), ex);
        }
        if (javaConstructor == null) {
            throw new IllegalArgumentException("The given mapping constructor '" + mappingConstructor + "' does not map to a constructor of the proxy class: " + proxyClazz.getName());
        }
        this.constructor = javaConstructor;
        this.defaultObject = defaultObject;
    }

    @Override
    public T newInstance(Object[] tuple) {
        try {
            this.prepareTuple(tuple);
            Object[] array = Arrays.copyOf(this.defaultObject, this.defaultObject.length);
            array[2] = tuple;
            T instance = this.constructor.newInstance(array);
            this.finalizeInstance(instance);
            return instance;
        }
        catch (Exception ex) {
            Object[] types = new String[tuple.length];
            for (int i = 0; i < types.length; ++i) {
                types[i] = tuple[i] == null ? null : tuple[i].getClass().getName();
            }
            throw new RuntimeException("Could not invoke the proxy constructor '" + this.constructor + "' with the given tuple: " + Arrays.toString(tuple) + " with the types: " + Arrays.toString(types), ex);
        }
    }
}

