/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.type;

import com.blazebit.persistence.view.spi.type.TypeConverter;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public class OptionalDoubleTypeConverter
implements TypeConverter<Object, Object> {
    private static final Method OF;
    private static final Method GET_AS_DOUBLE;
    private static final Method IS_PRESENT;
    private static final Object EMPTY;

    public Class<?> getUnderlyingType(Class<?> owningClass, Type declaredType) {
        return Double.class;
    }

    public Object convertToViewType(Object object) {
        if (object == null) {
            return EMPTY;
        }
        try {
            return OF.invoke(null, object);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Object convertToUnderlyingType(Object object) {
        try {
            if (object == null || !((Boolean)IS_PRESENT.invoke(object, new Object[0])).booleanValue()) {
                return null;
            }
            return GET_AS_DOUBLE.invoke(object, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        Method of = null;
        Method getAsDouble = null;
        Method isPresent = null;
        Object empty = null;
        try {
            Class<?> c = Class.forName("java.util.OptionalDouble");
            of = c.getDeclaredMethod("of", Double.TYPE);
            getAsDouble = c.getDeclaredMethod("getAsDouble", new Class[0]);
            isPresent = c.getMethod("isPresent", new Class[0]);
            empty = c.getMethod("empty", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        OF = of;
        GET_AS_DOUBLE = getAsDouble;
        IS_PRESENT = isPresent;
        EMPTY = empty;
    }
}

