/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl;

import com.blazebit.persistence.FullQueryBuilder;
import com.blazebit.persistence.parser.expression.ExpressionFactory;
import com.blazebit.persistence.spi.JpqlMacro;
import com.blazebit.persistence.view.FetchStrategy;
import com.blazebit.persistence.view.impl.BatchCorrelationMode;
import com.blazebit.persistence.view.impl.metamodel.AbstractMethodAttribute;
import com.blazebit.persistence.view.impl.metamodel.ManagedViewTypeImplementor;
import com.blazebit.persistence.view.metamodel.MethodAttribute;
import com.blazebit.persistence.view.metamodel.PluralAttribute;
import com.blazebit.persistence.view.metamodel.SingularAttribute;
import com.blazebit.persistence.view.metamodel.Type;
import com.blazebit.persistence.view.metamodel.ViewType;
import com.blazebit.persistence.view.spi.EmbeddingViewJpqlMacro;
import com.blazebit.persistence.view.spi.ViewJpqlMacro;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;

public final class EntityViewConfiguration {
    private static final NavigableSet<String> EMPTY_SET = new TreeSet<String>();
    private final FullQueryBuilder<?, ?> criteriaBuilder;
    private final ExpressionFactory expressionFactory;
    private final ViewJpqlMacro viewJpqlMacro;
    private final EmbeddingViewJpqlMacro embeddingViewJpqlMacro;
    private final Map<String, Object> optionalParameters;
    private final NavigableSet<String> fetches;
    private final Map<String, Integer> batchSizeConfiguration;
    private final Map<String, BatchCorrelationMode> expectBatchCorrelationValuesConfiguration;

    public EntityViewConfiguration(FullQueryBuilder<?, ?> criteriaBuilder, ExpressionFactory expressionFactory, ViewJpqlMacro viewJpqlMacro, EmbeddingViewJpqlMacro embeddingViewJpqlMacro, Map<String, Object> optionalParameters, Map<String, Object> properties, Collection<String> fetches, String attributePath) {
        this(criteriaBuilder, expressionFactory, viewJpqlMacro, embeddingViewJpqlMacro, optionalParameters, properties, EntityViewConfiguration.getFetches(fetches, attributePath));
    }

    public EntityViewConfiguration(FullQueryBuilder<?, ?> criteriaBuilder, ExpressionFactory expressionFactory, ViewJpqlMacro viewJpqlMacro, EmbeddingViewJpqlMacro embeddingViewJpqlMacro, Map<String, Object> optionalParameters, Map<String, Object> properties, Collection<String> fetches, ManagedViewTypeImplementor<?> managedViewType) {
        this(criteriaBuilder, expressionFactory, viewJpqlMacro, embeddingViewJpqlMacro, optionalParameters, properties, EntityViewConfiguration.getFetches(fetches, managedViewType));
    }

    private EntityViewConfiguration(FullQueryBuilder<?, ?> criteriaBuilder, ExpressionFactory expressionFactory, ViewJpqlMacro viewJpqlMacro, EmbeddingViewJpqlMacro embeddingViewJpqlMacro, Map<String, Object> optionalParameters, Map<String, Object> properties, NavigableSet<String> fetches) {
        HashMap<String, Integer> batchSizeConfiguration = new HashMap<String, Integer>(properties.size());
        HashMap<String, Integer> expectBatchCorrelationValuesConfiguration = new HashMap<String, Integer>(properties.size());
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            Object value;
            String key = entry.getKey();
            if (key.startsWith("com.blazebit.persistence.view.batch_size")) {
                value = this.getBatchSize(key, entry.getValue());
                if (key.length() == "com.blazebit.persistence.view.batch_size".length()) {
                    batchSizeConfiguration.put("", (Integer)value);
                    continue;
                }
                if (key.length() < "com.blazebit.persistence.view.batch_size".length() + 2) {
                    throw new IllegalArgumentException("Invalid batch size configuration!");
                }
                key = key.substring("com.blazebit.persistence.view.batch_size".length() + 1);
                batchSizeConfiguration.put(key, (Integer)value);
                continue;
            }
            if (key.startsWith("com.blazebit.persistence.view.batch_correlation_values")) {
                value = this.getExpectBatchCorrelationValues(key, entry.getValue());
                if (key.length() == "com.blazebit.persistence.view.batch_correlation_values".length()) {
                    expectBatchCorrelationValuesConfiguration.put("", (Integer)value);
                    continue;
                }
                if (key.length() < "com.blazebit.persistence.view.batch_correlation_values".length() + 2) {
                    throw new IllegalArgumentException("Invalid batch correlation values expectation configuration!");
                }
                key = key.substring("com.blazebit.persistence.view.batch_correlation_values".length() + 1);
                expectBatchCorrelationValuesConfiguration.put(key, (Integer)value);
                continue;
            }
            if (!key.startsWith("com.blazebit.persistence.view.batch_mode")) continue;
            value = this.getExpectBatchCorrelationValues(key, entry.getValue());
            if (key.length() == "com.blazebit.persistence.view.batch_mode".length()) {
                expectBatchCorrelationValuesConfiguration.put("", (Integer)value);
                continue;
            }
            if (key.length() < "com.blazebit.persistence.view.batch_mode".length() + 2) {
                throw new IllegalArgumentException("Invalid batch mode expectation configuration!");
            }
            key = key.substring("com.blazebit.persistence.view.batch_mode".length() + 1);
            expectBatchCorrelationValuesConfiguration.put(key, (Integer)value);
        }
        this.criteriaBuilder = criteriaBuilder;
        this.expressionFactory = expressionFactory;
        this.viewJpqlMacro = viewJpqlMacro;
        this.embeddingViewJpqlMacro = embeddingViewJpqlMacro;
        this.optionalParameters = new HashMap<String, Object>(optionalParameters);
        this.fetches = fetches;
        this.batchSizeConfiguration = Collections.unmodifiableMap(batchSizeConfiguration);
        this.expectBatchCorrelationValuesConfiguration = Collections.unmodifiableMap(expectBatchCorrelationValuesConfiguration);
        this.criteriaBuilder.registerMacro("view", (JpqlMacro)viewJpqlMacro);
        this.criteriaBuilder.registerMacro("embedding_view", (JpqlMacro)embeddingViewJpqlMacro);
    }

    private EntityViewConfiguration(EntityViewConfiguration original, FullQueryBuilder<?, ?> criteriaBuilder, NavigableSet<String> fetches, EmbeddingViewJpqlMacro embeddingViewJpqlMacro) {
        this.criteriaBuilder = criteriaBuilder;
        this.expressionFactory = original.expressionFactory;
        this.viewJpqlMacro = original.viewJpqlMacro;
        this.embeddingViewJpqlMacro = embeddingViewJpqlMacro;
        this.optionalParameters = original.optionalParameters;
        this.fetches = fetches;
        this.batchSizeConfiguration = original.batchSizeConfiguration;
        this.expectBatchCorrelationValuesConfiguration = original.expectBatchCorrelationValuesConfiguration;
    }

    private static NavigableSet<String> getFetches(Collection<String> fetches, String attributePath) {
        NavigableSet<String> filteredFetches;
        if (fetches.isEmpty()) {
            filteredFetches = EMPTY_SET;
        } else {
            filteredFetches = new TreeSet<String>();
            String prefix = attributePath + ".";
            for (String fetch : fetches) {
                if (!fetch.startsWith(prefix)) continue;
                filteredFetches.add(fetch.substring(prefix.length()));
            }
        }
        return filteredFetches;
    }

    private static NavigableSet<String> getFetches(Collection<String> fetches, ManagedViewTypeImplementor<?> managedViewType) {
        NavigableSet<String> filteredFetches;
        if (fetches.isEmpty()) {
            filteredFetches = EMPTY_SET;
        } else {
            filteredFetches = new TreeSet<String>();
            if (managedViewType instanceof ViewType) {
                EntityViewConfiguration.addIdFetches((ViewType)managedViewType, filteredFetches, new StringBuilder());
            }
            for (String fetch : fetches) {
                String[] parts = fetch.split("\\.");
                Type t = managedViewType;
                StringBuilder sb = new StringBuilder();
                int i = 0;
                while (t instanceof ManagedViewTypeImplementor) {
                    Type viewType = t;
                    if (i != 0 && viewType instanceof ViewType) {
                        EntityViewConfiguration.addIdFetches((ViewType)viewType, filteredFetches, sb);
                    }
                    if (i == parts.length) {
                        int length = sb.length();
                        for (String path : viewType.getRecursiveAttributes().keySet()) {
                            sb.setLength(length);
                            sb.append(path);
                            filteredFetches.add(sb.toString());
                        }
                        break;
                    }
                    sb.append(parts[i]);
                    MethodAttribute attribute = viewType.getAttribute(parts[i]);
                    t = attribute instanceof PluralAttribute ? ((PluralAttribute)attribute).getElementType() : ((SingularAttribute)attribute).getType();
                    if ((attribute.getFetchStrategy() == FetchStrategy.SELECT || attribute.getFetchStrategy() == FetchStrategy.SUBSELECT) && ((AbstractMethodAttribute)attribute).getCorrelationProviderFactory() != null) {
                        filteredFetches.add(sb.toString());
                    }
                    sb.append('.');
                    ++i;
                }
                filteredFetches.add(fetch);
            }
        }
        return filteredFetches;
    }

    private static void addIdFetches(ViewType<?> viewType, Set<String> filteredFetches, StringBuilder sb) {
        MethodAttribute idAttribute = viewType.getIdAttribute();
        String idName = idAttribute.getName();
        StringBuilder idSb = new StringBuilder(sb.length() + idName.length()).append((CharSequence)sb).append(idName);
        filteredFetches.add(idSb.toString());
        Type idType = ((SingularAttribute)idAttribute).getType();
        if (idType instanceof ManagedViewTypeImplementor) {
            idSb.append('.');
            int length = idSb.length();
            for (String path : ((ManagedViewTypeImplementor)idType).getRecursiveAttributes().keySet()) {
                idSb.setLength(length);
                idSb.append(path);
                filteredFetches.add(idSb.toString());
            }
        }
    }

    public EntityViewConfiguration forSubview(FullQueryBuilder<?, ?> criteriaBuilder, String attributePath, EmbeddingViewJpqlMacro embeddingViewJpqlMacro) {
        return new EntityViewConfiguration(this, criteriaBuilder, EntityViewConfiguration.getFetches(this.fetches, attributePath), embeddingViewJpqlMacro);
    }

    public FullQueryBuilder<?, ?> getCriteriaBuilder() {
        return this.criteriaBuilder;
    }

    public ExpressionFactory getExpressionFactory() {
        return this.expressionFactory;
    }

    public Map<String, Object> getOptionalParameters() {
        return this.optionalParameters;
    }

    public Set<String> getFetches() {
        return this.fetches;
    }

    public boolean hasSubFetches(String attributePath) {
        if (this.fetches.isEmpty()) {
            return true;
        }
        String fetchedPath = this.fetches.ceiling(attributePath);
        return fetchedPath != null && (fetchedPath.length() == attributePath.length() || fetchedPath.startsWith(attributePath) && fetchedPath.length() > attributePath.length() && fetchedPath.charAt(attributePath.length()) == '.');
    }

    public ViewJpqlMacro getViewJpqlMacro() {
        return this.viewJpqlMacro;
    }

    public EmbeddingViewJpqlMacro getEmbeddingViewJpqlMacro() {
        return this.embeddingViewJpqlMacro;
    }

    public int getBatchSize() {
        return this.getBatchSize("");
    }

    public int getBatchSize(String attributePath) {
        return this.getBatchSize(attributePath, -1);
    }

    public int getBatchSize(String attributePath, int defaultValue) {
        Integer value = this.batchSizeConfiguration.get(attributePath);
        if (value == null) {
            value = this.batchSizeConfiguration.get("");
        }
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    private Integer getBatchSize(String key, Object value) {
        Integer val = null;
        if (value instanceof Integer) {
            val = (Integer)value;
        } else if (value instanceof String) {
            val = Integer.parseInt(value.toString());
        }
        if (val == null) {
            throw new IllegalArgumentException("Invalid batch size configuration for key: " + key);
        }
        if (val < 1) {
            throw new IllegalArgumentException("Invalid batch size configuration " + val + " for key: " + key);
        }
        return val;
    }

    public BatchCorrelationMode getExpectBatchCorrelationValues() {
        return this.getExpectBatchCorrelationValues("");
    }

    public BatchCorrelationMode getExpectBatchCorrelationValues(String attributePath) {
        return this.getExpectBatchCorrelationValues(attributePath, BatchCorrelationMode.VALUES);
    }

    private BatchCorrelationMode getExpectBatchCorrelationValues(String attributePath, BatchCorrelationMode defaultValue) {
        BatchCorrelationMode value = this.expectBatchCorrelationValuesConfiguration.get(attributePath);
        if (value == null) {
            value = this.expectBatchCorrelationValuesConfiguration.get("");
        }
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    private BatchCorrelationMode getExpectBatchCorrelationValues(String key, Object value) {
        BatchCorrelationMode val = null;
        if (value instanceof Boolean) {
            val = (Boolean)value != false ? BatchCorrelationMode.VALUES : BatchCorrelationMode.VIEW_ROOTS;
        } else if (value instanceof String) {
            String s = (String)value;
            if ("true".equalsIgnoreCase(s) || "values".equalsIgnoreCase(s)) {
                val = BatchCorrelationMode.VALUES;
            } else if ("false".equalsIgnoreCase(s) || "view_roots".equalsIgnoreCase(s)) {
                val = BatchCorrelationMode.VIEW_ROOTS;
            } else if ("embedding_views".equalsIgnoreCase(s)) {
                val = BatchCorrelationMode.EMBEDDING_VIEWS;
            } else {
                throw new IllegalArgumentException("Invalid batch correlation expectation configuration " + s + " for key: " + key);
            }
        }
        if (val == null) {
            throw new IllegalArgumentException("Invalid batch correlation expectation configuration for key: " + key);
        }
        return val;
    }
}

