/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.objectbuilder.transformator;

import com.blazebit.persistence.view.impl.objectbuilder.TupleRest;
import com.blazebit.persistence.view.impl.objectbuilder.transformator.TupleTransformatorLevel;
import com.blazebit.persistence.view.impl.objectbuilder.transformator.UpdatableViewMap;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.TupleListTransformer;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.TupleTransformer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class TupleTransformator {
    private final List<TupleTransformatorLevel> transformatorLevels;

    public TupleTransformator(List<TupleTransformatorLevel> transformatorLevels) {
        this.transformatorLevels = transformatorLevels;
    }

    public List<Object[]> transformAll(List<Object[]> tupleList) {
        UpdatableViewMap updatableViewMap = new UpdatableViewMap();
        for (int i = 0; i < this.transformatorLevels.size(); ++i) {
            if (this.transformatorLevels.get((int)i).tupleTransformers.length != 0) {
                ListIterator<Object[]> newTupleListIter = tupleList.listIterator();
                while (newTupleListIter.hasNext()) {
                    Object[] tuple = newTupleListIter.next();
                    newTupleListIter.set(this.transform(i, tuple, updatableViewMap));
                }
            }
            tupleList = this.transform(i, tupleList);
        }
        if (this.transformatorLevels.size() > 1) {
            HashSet<TupleRest> tupleSet = new HashSet<TupleRest>(tupleList.size());
            Iterator<Object[]> tupleListIter = tupleList.iterator();
            while (tupleListIter.hasNext()) {
                if (tupleSet.add(new TupleRest(tupleListIter.next(), 0, 0))) continue;
                tupleListIter.remove();
            }
        }
        return tupleList;
    }

    private Object[] transform(int level, Object[] tuple, UpdatableViewMap updatableViewMap) {
        TupleTransformer[] tupleTransformers = this.transformatorLevels.get((int)level).tupleTransformers;
        Object[] currentTuple = tuple;
        for (int i = 0; i < tupleTransformers.length; ++i) {
            currentTuple = tupleTransformers[i].transform(currentTuple, updatableViewMap);
        }
        return currentTuple;
    }

    private List<Object[]> transform(int level, List<Object[]> tupleList) {
        TupleListTransformer tupleListTransformer = this.transformatorLevels.get((int)level).tupleListTransformer;
        if (tupleListTransformer == null) {
            return tupleList;
        }
        return tupleListTransformer.transform(tupleList);
    }
}

