/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.objectbuilder.transformer;

import com.blazebit.persistence.view.impl.objectbuilder.ContainerAccumulator;
import com.blazebit.persistence.view.impl.objectbuilder.mapper.MultisetList;
import com.blazebit.persistence.view.impl.objectbuilder.transformator.TupleTransformator;
import com.blazebit.persistence.view.impl.objectbuilder.transformator.UpdatableViewMap;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.TupleListTransformer;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.TupleTransformer;
import com.blazebit.persistence.view.spi.type.BasicUserTypeStringSupport;
import com.blazebit.persistence.view.spi.type.TypeConverter;
import java.util.Iterator;
import java.util.List;

public class MultisetTupleListTransformer
extends TupleListTransformer {
    private final boolean hasSelectOrSubselectFetchedAttributes;
    private final TupleTransformator tupleTransformator;
    private final TupleTransformer subviewTupleTransformer;
    private final TupleTransformer indexSubviewTupleTransformer;
    private final int indexStartIndex;
    private final BasicUserTypeStringSupport<Object>[] fieldConverters;
    private final TypeConverter<Object, Object> elementConverter;
    private final ContainerAccumulator<Object> containerAccumulator;
    private final boolean dirtyTracking;

    public MultisetTupleListTransformer(int startIndex, boolean hasSelectOrSubselectFetchedAttributes, TupleTransformator tupleTransformator, TupleTransformer subviewTupleTransformer, TupleTransformer indexSubviewTupleTransformer, int indexStartIndex, BasicUserTypeStringSupport<Object>[] fieldConverters, TypeConverter<Object, Object> elementConverter, ContainerAccumulator<Object> containerAccumulator, boolean dirtyTracking) {
        super(startIndex);
        this.hasSelectOrSubselectFetchedAttributes = hasSelectOrSubselectFetchedAttributes;
        this.tupleTransformator = tupleTransformator;
        this.subviewTupleTransformer = subviewTupleTransformer;
        this.indexSubviewTupleTransformer = indexSubviewTupleTransformer;
        this.indexStartIndex = indexStartIndex;
        this.elementConverter = elementConverter;
        this.fieldConverters = fieldConverters;
        this.containerAccumulator = containerAccumulator;
        this.dirtyTracking = dirtyTracking;
    }

    @Override
    public int getConsumableIndex() {
        return -1;
    }

    @Override
    public List<Object[]> transform(List<Object[]> tuples) {
        Iterator<Object[]> tupleListIter = tuples.iterator();
        if (this.hasSelectOrSubselectFetchedAttributes) {
            MultisetList nestedTuples = new MultisetList(this.startIndex, tuples);
            int index = 0;
            while (tupleListIter.hasNext()) {
                Object[] tuple = tupleListIter.next();
                if (tuple[this.startIndex] != null) {
                    List objects = (List)tuple[this.startIndex];
                    for (int i = 0; i < objects.size(); ++i) {
                        Object[] elementTuple = (Object[])objects.get(i);
                        for (int j = 0; j < this.fieldConverters.length; ++j) {
                            if (!(elementTuple[j] instanceof CharSequence)) continue;
                            elementTuple[j] = this.fieldConverters[j].fromString((CharSequence)elementTuple[j]);
                        }
                    }
                    nestedTuples.addSize(index, objects.size());
                } else {
                    nestedTuples.addSize(index, 0);
                }
                ++index;
            }
            if (this.tupleTransformator != null) {
                this.tupleTransformator.transformAll(nestedTuples);
            }
            UpdatableViewMap updatableViewMap = new UpdatableViewMap();
            for (Object[] tuple : tuples) {
                Object collection = this.containerAccumulator.createContainer(this.dirtyTracking, 0);
                if (tuple[this.startIndex] != null) {
                    List objects = (List)tuple[this.startIndex];
                    for (int i = 0; i < objects.size(); ++i) {
                        Object indexObject = null;
                        if (this.indexSubviewTupleTransformer != null) {
                            indexObject = this.indexSubviewTupleTransformer.transform((Object[])objects.get(i), updatableViewMap)[this.indexSubviewTupleTransformer.getConsumeStartIndex()];
                        } else if (this.indexStartIndex != -1) {
                            indexObject = ((Object[])objects.get(i))[this.indexStartIndex];
                        }
                        if (this.subviewTupleTransformer == null) {
                            this.add(collection, indexObject, ((Object[])objects.get(i))[this.startIndex]);
                            continue;
                        }
                        Object[] transformedTuple = this.subviewTupleTransformer.transform((Object[])objects.get(i), updatableViewMap);
                        this.add(collection, indexObject, transformedTuple[0]);
                    }
                }
                tuple[this.startIndex] = collection;
            }
        } else {
            while (tupleListIter.hasNext()) {
                Object[] tuple = tupleListIter.next();
                if (tuple[this.startIndex] == null) continue;
                List objects = (List)tuple[this.startIndex];
                for (int i = 0; i < objects.size(); ++i) {
                    Object[] elementTuple = (Object[])objects.get(i);
                    for (int j = 0; j < this.fieldConverters.length; ++j) {
                        if (!(elementTuple[j] instanceof CharSequence)) continue;
                        elementTuple[j] = this.fieldConverters[j].fromString((CharSequence)elementTuple[j]);
                    }
                }
            }
            UpdatableViewMap updatableViewMap = new UpdatableViewMap();
            for (Object[] tuple : tuples) {
                Object collection = this.containerAccumulator.createContainer(this.dirtyTracking, 0);
                if (tuple[this.startIndex] != null) {
                    List objects = (List)tuple[this.startIndex];
                    if (this.tupleTransformator != null) {
                        this.tupleTransformator.transformAll(objects);
                    }
                    for (int i = 0; i < objects.size(); ++i) {
                        Object indexObject = null;
                        if (this.indexSubviewTupleTransformer != null) {
                            indexObject = this.indexSubviewTupleTransformer.transform((Object[])objects.get(i), updatableViewMap)[this.indexSubviewTupleTransformer.getConsumeStartIndex() - 1];
                        } else if (this.indexStartIndex != -1) {
                            indexObject = ((Object[])objects.get(i))[this.indexStartIndex];
                        }
                        if (this.subviewTupleTransformer == null) {
                            this.add(collection, indexObject, ((Object[])objects.get(i))[this.startIndex]);
                            continue;
                        }
                        Object[] transformedTuple = this.subviewTupleTransformer.transform((Object[])objects.get(i), updatableViewMap);
                        this.add(collection, indexObject, transformedTuple[0]);
                    }
                }
                tuple[this.startIndex] = collection;
            }
        }
        return tuples;
    }

    protected void add(Object collection, Object index, Object value) {
        if (this.elementConverter != null) {
            value = this.elementConverter.convertToViewType(value);
        }
        this.containerAccumulator.add(collection, index, value, this.dirtyTracking);
    }
}

