/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.objectbuilder.transformer;

import com.blazebit.persistence.view.impl.objectbuilder.mapper.MultisetList;
import com.blazebit.persistence.view.impl.objectbuilder.transformator.TupleTransformator;
import com.blazebit.persistence.view.impl.objectbuilder.transformator.UpdatableViewMap;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.TupleListTransformer;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.TupleTransformer;
import com.blazebit.persistence.view.spi.type.BasicUserTypeStringSupport;
import com.blazebit.persistence.view.spi.type.TypeConverter;
import java.util.Iterator;
import java.util.List;

public class SingularMultisetTupleListTransformer<C>
extends TupleListTransformer {
    private final boolean hasSelectOrSubselectFetchedAttributes;
    private final TupleTransformator tupleTransformator;
    private final TupleTransformer subviewTupleTransformer;
    private final BasicUserTypeStringSupport<Object>[] fieldConverters;
    private final TypeConverter<Object, Object> elementConverter;

    public SingularMultisetTupleListTransformer(int startIndex, boolean hasSelectOrSubselectFetchedAttributes, TupleTransformator tupleTransformator, TupleTransformer subviewTupleTransformer, BasicUserTypeStringSupport<Object>[] fieldConverters, TypeConverter<Object, Object> elementConverter) {
        super(startIndex);
        this.hasSelectOrSubselectFetchedAttributes = hasSelectOrSubselectFetchedAttributes;
        this.tupleTransformator = tupleTransformator;
        this.subviewTupleTransformer = subviewTupleTransformer;
        this.elementConverter = elementConverter;
        this.fieldConverters = fieldConverters;
    }

    @Override
    public int getConsumableIndex() {
        return -1;
    }

    @Override
    public List<Object[]> transform(List<Object[]> tuples) {
        Iterator<Object[]> tupleListIter = tuples.iterator();
        if (this.hasSelectOrSubselectFetchedAttributes) {
            MultisetList nestedTuples = new MultisetList(this.startIndex, tuples);
            int index = 0;
            while (tupleListIter.hasNext()) {
                Object[] tuple = tupleListIter.next();
                if (tuple[this.startIndex] != null) {
                    List objects = (List)tuple[this.startIndex];
                    for (int i = 0; i < objects.size(); ++i) {
                        Object[] elementTuple = (Object[])objects.get(i);
                        for (int j = 0; j < this.fieldConverters.length; ++j) {
                            if (!(elementTuple[j] instanceof CharSequence)) continue;
                            elementTuple[j] = this.fieldConverters[j].fromString((CharSequence)elementTuple[j]);
                        }
                    }
                    nestedTuples.addSize(index, objects.size());
                } else {
                    nestedTuples.addSize(index, 0);
                }
                ++index;
            }
            this.tupleTransformator.transformAll(nestedTuples);
            UpdatableViewMap updatableViewMap = new UpdatableViewMap();
            for (Object[] tuple : tuples) {
                List objects;
                if (tuple[this.startIndex] == null || (objects = (List)tuple[this.startIndex]).size() <= 0) continue;
                Object[] transformedTuple = this.subviewTupleTransformer.transform((Object[])objects.get(0), updatableViewMap);
                if (this.elementConverter == null) {
                    tuple[this.startIndex] = transformedTuple[0];
                    continue;
                }
                tuple[this.startIndex] = this.elementConverter.convertToViewType(transformedTuple[0]);
            }
        } else {
            while (tupleListIter.hasNext()) {
                Object[] tuple = tupleListIter.next();
                if (tuple[this.startIndex] == null) continue;
                List objects = (List)tuple[this.startIndex];
                for (int i = 0; i < objects.size(); ++i) {
                    Object[] elementTuple = (Object[])objects.get(i);
                    for (int j = 0; j < this.fieldConverters.length; ++j) {
                        if (!(elementTuple[j] instanceof CharSequence)) continue;
                        elementTuple[j] = this.fieldConverters[j].fromString((CharSequence)elementTuple[j]);
                    }
                }
            }
            UpdatableViewMap updatableViewMap = new UpdatableViewMap();
            for (Object[] tuple : tuples) {
                if (tuple[this.startIndex] == null) continue;
                List objects = (List)tuple[this.startIndex];
                this.tupleTransformator.transformAll(objects);
                if (objects.size() <= 0) continue;
                Object[] transformedTuple = this.subviewTupleTransformer.transform((Object[])objects.get(0), updatableViewMap);
                if (this.elementConverter == null) {
                    tuple[this.startIndex] = transformedTuple[0];
                    continue;
                }
                tuple[this.startIndex] = this.elementConverter.convertToViewType(transformedTuple[0]);
            }
        }
        return tuples;
    }
}

