/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.objectbuilder.transformer.correlation;

import com.blazebit.persistence.FullQueryBuilder;
import com.blazebit.persistence.LimitBuilder;
import com.blazebit.persistence.ObjectBuilder;
import com.blazebit.persistence.PaginatedCriteriaBuilder;
import com.blazebit.persistence.ParameterHolder;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionFactory;
import com.blazebit.persistence.spi.JpqlMacro;
import com.blazebit.persistence.view.CorrelationBuilder;
import com.blazebit.persistence.view.CorrelationProvider;
import com.blazebit.persistence.view.CorrelationProviderFactory;
import com.blazebit.persistence.view.impl.EntityViewConfiguration;
import com.blazebit.persistence.view.impl.EntityViewManagerImpl;
import com.blazebit.persistence.view.impl.macro.CorrelatedSubqueryViewRootJpqlMacro;
import com.blazebit.persistence.view.impl.macro.MutableEmbeddingViewJpqlMacro;
import com.blazebit.persistence.view.impl.macro.MutableViewJpqlMacro;
import com.blazebit.persistence.view.impl.metamodel.ManagedViewTypeImplementor;
import com.blazebit.persistence.view.impl.objectbuilder.ContainerAccumulator;
import com.blazebit.persistence.view.impl.objectbuilder.LateAdditionalObjectBuilder;
import com.blazebit.persistence.view.impl.objectbuilder.Limiter;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.correlation.AbstractCorrelatedTupleListTransformer;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.correlation.Correlator;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.correlation.SubqueryCorrelationBuilder;
import com.blazebit.persistence.view.metamodel.ManagedViewType;
import com.blazebit.persistence.view.metamodel.MethodAttribute;
import com.blazebit.persistence.view.metamodel.SingularAttribute;
import com.blazebit.persistence.view.metamodel.ViewType;
import com.blazebit.persistence.view.spi.EmbeddingViewJpqlMacro;
import com.blazebit.persistence.view.spi.ViewJpqlMacro;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractCorrelatedSubselectTupleListTransformer
extends AbstractCorrelatedTupleListTransformer {
    private static final Logger LOG = Logger.getLogger(AbstractCorrelatedSubselectTupleListTransformer.class.getName());
    protected final EntityViewManagerImpl evm;
    protected final String viewRootAlias;
    protected final String viewRootIdExpression;
    protected final int viewRootIdMapperCount;
    protected final String embeddingViewPath;
    protected final String embeddingViewIdExpression;
    protected final int embeddingViewIdMapperCount;
    protected final int maximumViewMapperCount;
    protected final String correlationBasisExpression;
    protected final String correlationKeyExpression;
    protected final int valueIndex;
    protected int viewIndex;
    protected int keyIndex;
    protected FullQueryBuilder<?, ?> criteriaBuilder;
    protected CorrelatedSubqueryViewRootJpqlMacro viewRootJpqlMacro;
    protected MutableEmbeddingViewJpqlMacro embeddingViewJpqlMacro;

    public AbstractCorrelatedSubselectTupleListTransformer(ExpressionFactory ef, Correlator correlator, ContainerAccumulator<?> containerAccumulator, EntityViewManagerImpl evm, ManagedViewTypeImplementor<?> viewRootType, String viewRootAlias, ManagedViewTypeImplementor<?> embeddingViewType, String embeddingViewPath, Expression correlationResult, String correlationBasisExpression, String correlationKeyExpression, CorrelationProviderFactory correlationProviderFactory, String attributePath, String[] fetches, String[] indexFetches, Expression indexExpression, Correlator indexCorrelator, int viewRootIndex, int embeddingViewIndex, int tupleIndex, Class<?> correlationBasisType, Class<?> correlationBasisEntity, Limiter limiter, EntityViewConfiguration entityViewConfiguration) {
        super(ef, correlator, containerAccumulator, viewRootType, embeddingViewType, correlationResult, correlationProviderFactory, attributePath, fetches, indexFetches, indexExpression, indexCorrelator, viewRootIndex, embeddingViewIndex, tupleIndex, correlationBasisType, correlationBasisEntity, limiter, entityViewConfiguration);
        this.evm = evm;
        this.viewRootAlias = viewRootAlias;
        String viewRootAliasPrefix = viewRootAlias + ".";
        this.viewRootIdExpression = viewRootAliasPrefix + this.getEntityIdName(viewRootType.getEntityClass());
        this.viewRootIdMapperCount = AbstractCorrelatedSubselectTupleListTransformer.viewIdMapperCount(viewRootType);
        this.embeddingViewPath = embeddingViewPath;
        this.embeddingViewIdExpression = viewRootAlias.equals(embeddingViewPath) ? viewRootAliasPrefix + this.getEntityIdName(embeddingViewType.getEntityClass()) : embeddingViewPath + "." + this.getEntityIdName(embeddingViewType.getEntityClass());
        this.embeddingViewIdMapperCount = AbstractCorrelatedSubselectTupleListTransformer.viewIdMapperCount(embeddingViewType);
        this.maximumViewMapperCount = Math.max(1, Math.max(this.viewRootIdMapperCount, this.embeddingViewIdMapperCount));
        this.correlationBasisExpression = correlationBasisExpression;
        this.correlationKeyExpression = correlationKeyExpression;
        this.valueIndex = correlator.getElementOffset();
    }

    private static int viewIdMapperCount(ManagedViewType<?> viewRootType) {
        MethodAttribute idAttribute;
        if (viewRootType instanceof ViewType && (idAttribute = ((ViewType)viewRootType).getIdAttribute()).isSubview()) {
            return AbstractCorrelatedSubselectTupleListTransformer.viewIdMapperCount(idAttribute);
        }
        return 0;
    }

    private static int viewIdMapperCount(MethodAttribute<?, ?> attribute) {
        if (attribute.isSubview()) {
            ManagedViewType viewType = (ManagedViewType)((SingularAttribute)attribute).getType();
            int count = 0;
            for (MethodAttribute methodAttribute : viewType.getAttributes()) {
                count += AbstractCorrelatedSubselectTupleListTransformer.viewIdMapperCount(methodAttribute);
            }
            return count;
        }
        return 1;
    }

    private ObjectBuilder<Object[]> createViewAwareObjectBuilder(ManagedViewType<?> viewType, EntityViewConfiguration configuration, String viewRoot) {
        MethodAttribute idAttribute;
        if (!(viewType instanceof ViewType) || !(idAttribute = ((ViewType)viewType).getIdAttribute()).isSubview()) {
            return null;
        }
        ManagedViewType idViewType = (ManagedViewType)((SingularAttribute)idAttribute).getType();
        return this.evm.createObjectBuilder((ManagedViewTypeImplementor)idViewType, null, viewRoot, "", this.criteriaBuilder, configuration, 1, 1, false);
    }

    @Override
    public List<Object[]> transform(List<Object[]> tuples) {
        ObjectBuilder<?> indexBuilder;
        ExpressionFactory ef;
        int maximumSlotsFilled;
        int i;
        Class viewRootEntityClass = this.viewRootType.getEntityClass();
        String idAttributePath = this.getEntityIdName(viewRootEntityClass);
        FullQueryBuilder<?, ?> queryBuilder = this.entityViewConfiguration.getCriteriaBuilder();
        Map<String, Object> optionalParameters = this.entityViewConfiguration.getOptionalParameters();
        Class correlationBasisEntityType = this.correlationBasisEntity;
        String viewRootExpression = this.viewRootAlias;
        EmbeddingViewJpqlMacro embeddingViewJpqlMacro = this.entityViewConfiguration.getEmbeddingViewJpqlMacro();
        ViewJpqlMacro viewJpqlMacro = this.entityViewConfiguration.getViewJpqlMacro();
        if (queryBuilder instanceof PaginatedCriteriaBuilder) {
            this.criteriaBuilder = queryBuilder.copyCriteriaBuilder(Object[].class, false);
        } else {
            LimitBuilder limitBuilder = (LimitBuilder)queryBuilder;
            if (this.jpaProvider.supportsSubqueryInFunction() && (limitBuilder.getFirstResult() > 0 || limitBuilder.getMaxResults() < Integer.MAX_VALUE)) {
                try {
                    this.criteriaBuilder = queryBuilder.copyCriteriaBuilder(Object[].class, true).page(limitBuilder.getFirstResult(), limitBuilder.getMaxResults()).copyCriteriaBuilder(Object[].class, false);
                }
                catch (IllegalStateException ex) {
                    LOG.log(Level.WARNING, "Could not create a paginated criteria builder for SUBSELECT fetching which might lead to bad performance", ex);
                    this.criteriaBuilder = queryBuilder.copyCriteriaBuilder(Object[].class, false);
                }
            } else {
                this.criteriaBuilder = queryBuilder.copyCriteriaBuilder(Object[].class, false);
            }
        }
        int originalFirstResult = 0;
        int originalMaxResults = Integer.MAX_VALUE;
        ((LimitBuilder)this.criteriaBuilder).setFirstResult(originalFirstResult);
        ((LimitBuilder)this.criteriaBuilder).setMaxResults(originalMaxResults);
        this.viewRootJpqlMacro = new CorrelatedSubqueryViewRootJpqlMacro(this.criteriaBuilder, optionalParameters, false, viewRootEntityClass, idAttributePath, viewRootExpression);
        this.criteriaBuilder.registerMacro("view", (JpqlMacro)viewJpqlMacro);
        this.criteriaBuilder.registerMacro("view_root", (JpqlMacro)this.viewRootJpqlMacro);
        this.criteriaBuilder.registerMacro("embedding_view", (JpqlMacro)embeddingViewJpqlMacro);
        String oldViewPath = viewJpqlMacro.getViewPath();
        String oldEmbeddingViewPath = embeddingViewJpqlMacro.getEmbeddingViewPath();
        viewJpqlMacro.setViewPath(this.correlationResult);
        embeddingViewJpqlMacro.setEmbeddingViewPath(this.embeddingViewPath);
        String joinBase = this.embeddingViewPath;
        SubqueryCorrelationBuilder correlationBuilder = new SubqueryCorrelationBuilder((ParameterHolder<?>)queryBuilder, optionalParameters, this.criteriaBuilder, this.correlationAlias, this.correlationExternalAlias, this.correlationResult, this.correlationBasisType, correlationBasisEntityType, joinBase, this.attributePath, 1, this.limiter, true);
        CorrelationProvider provider = this.correlationProviderFactory.create(this.entityViewConfiguration.getCriteriaBuilder(), this.entityViewConfiguration.getOptionalParameters());
        provider.applyCorrelation((CorrelationBuilder)correlationBuilder, this.correlationBasisExpression);
        if (this.criteriaBuilder instanceof LimitBuilder && (originalFirstResult != ((LimitBuilder)this.criteriaBuilder).getFirstResult() || originalMaxResults != ((LimitBuilder)this.criteriaBuilder).getMaxResults())) {
            throw new IllegalArgumentException("Correlation provider '" + provider + "' wrongly uses setFirstResult() or setMaxResults() on the query builder which might lead to wrong results. Use SELECT fetching with batch size 1 or reformulate the correlation provider to use the limit/offset in a subquery!");
        }
        if (this.fetches.length != 0) {
            for (i = 0; i < this.fetches.length; ++i) {
                this.criteriaBuilder.fetch(this.fetches[i]);
            }
        }
        if (this.indexFetches.length != 0) {
            for (i = 0; i < this.indexFetches.length; ++i) {
                this.criteriaBuilder.fetch(this.indexFetches[i]);
            }
        }
        String correlationRoot = correlationBuilder.getCorrelationRoot();
        int tupleSuffix = this.maximumViewMapperCount + 1 + (this.indexCorrelator == null && this.indexExpression == null ? 0 : 1);
        LateAdditionalObjectBuilder objectBuilder = this.correlator.finish(this.criteriaBuilder, this.entityViewConfiguration, 0, tupleSuffix, correlationRoot, embeddingViewJpqlMacro, true);
        boolean usesViewRoot = this.viewRootJpqlMacro.usesViewMacro();
        boolean usesEmbeddingView = embeddingViewJpqlMacro.usesEmbeddingView();
        if (usesEmbeddingView && !(this.embeddingViewType instanceof ViewType)) {
            throw new IllegalStateException("The use of EMBEDDING_VIEW in the correlation for '" + this.embeddingViewType.getJavaType().getName() + "." + this.attributePath.substring(this.attributePath.lastIndexOf(46) + 1) + "' is illegal because the embedding view type '" + this.embeddingViewType.getJavaType().getName() + "' does not declare a @IdMapping!");
        }
        if (usesViewRoot && !(this.viewRootType instanceof ViewType)) {
            throw new IllegalStateException("The use of VIEW_ROOT in the correlation for '" + this.embeddingViewType.getJavaType().getName() + "." + this.attributePath.substring(this.attributePath.lastIndexOf(46) + 1) + "' is illegal because the view root type '" + this.viewRootType.getJavaType().getName() + "' does not declare a @IdMapping!");
        }
        int totalSize = tuples.size();
        HashMap<Object, Map<Object, AbstractCorrelatedTupleListTransformer.TuplePromise>> viewRoots = new HashMap<Object, Map<Object, AbstractCorrelatedTupleListTransformer.TuplePromise>>(totalSize);
        if (usesEmbeddingView) {
            maximumSlotsFilled = this.embeddingViewIdMapperCount == 0 ? 1 : this.embeddingViewIdMapperCount;
            this.keyIndex = this.maximumViewMapperCount - maximumSlotsFilled + 2 + this.valueIndex;
            this.viewIndex = this.maximumViewMapperCount - maximumSlotsFilled + 1 + this.valueIndex;
        } else if (usesViewRoot) {
            maximumSlotsFilled = this.viewRootIdMapperCount == 0 ? 1 : this.viewRootIdMapperCount;
            this.keyIndex = this.maximumViewMapperCount - maximumSlotsFilled + 2 + this.valueIndex;
            this.viewIndex = this.maximumViewMapperCount - maximumSlotsFilled + 1 + this.valueIndex;
        } else {
            maximumSlotsFilled = 0;
            this.keyIndex = this.maximumViewMapperCount + 1 + this.valueIndex;
            this.viewIndex = 1 + this.valueIndex;
        }
        for (int i2 = maximumSlotsFilled; i2 < this.maximumViewMapperCount; ++i2) {
            this.criteriaBuilder.select("NULL");
        }
        if (usesEmbeddingView) {
            ef = (ExpressionFactory)this.criteriaBuilder.getService(ExpressionFactory.class);
            EntityViewConfiguration configuration = new EntityViewConfiguration(this.criteriaBuilder, ef, (ViewJpqlMacro)new MutableViewJpqlMacro(), (EmbeddingViewJpqlMacro)new MutableEmbeddingViewJpqlMacro(), Collections.emptyMap(), Collections.emptyMap(), this.entityViewConfiguration.getFetches(), this.attributePath);
            ObjectBuilder<Object[]> embeddingViewObjectBuilder = this.createViewAwareObjectBuilder(this.embeddingViewType, configuration, this.embeddingViewIdExpression);
            if (embeddingViewObjectBuilder == null) {
                this.criteriaBuilder.select(this.embeddingViewIdExpression);
            } else {
                objectBuilder = new LateAdditionalObjectBuilder(objectBuilder, embeddingViewObjectBuilder, true);
                this.criteriaBuilder.selectNew((ObjectBuilder)objectBuilder);
            }
            for (Object[] tuple : tuples) {
                AbstractCorrelatedTupleListTransformer.TuplePromise viewRootPromise;
                Object embeddingViewKey = tuple[this.embeddingViewIndex];
                Object correlationValueKey = tuple[this.startIndex];
                if (embeddingViewKey == null || correlationValueKey == null) continue;
                HashMap<Object, AbstractCorrelatedTupleListTransformer.TuplePromise> viewRootCorrelationValues = (HashMap<Object, AbstractCorrelatedTupleListTransformer.TuplePromise>)viewRoots.get(embeddingViewKey);
                if (viewRootCorrelationValues == null) {
                    viewRootCorrelationValues = new HashMap<Object, AbstractCorrelatedTupleListTransformer.TuplePromise>();
                    viewRoots.put(embeddingViewKey, viewRootCorrelationValues);
                }
                if ((viewRootPromise = (AbstractCorrelatedTupleListTransformer.TuplePromise)viewRootCorrelationValues.get(correlationValueKey)) == null) {
                    viewRootPromise = new AbstractCorrelatedTupleListTransformer.TuplePromise(this.startIndex);
                    viewRootCorrelationValues.put(correlationValueKey, viewRootPromise);
                }
                viewRootPromise.add(tuple);
            }
        } else if (usesViewRoot) {
            ef = (ExpressionFactory)this.criteriaBuilder.getService(ExpressionFactory.class);
            EntityViewConfiguration configuration = new EntityViewConfiguration(this.criteriaBuilder, ef, (ViewJpqlMacro)new MutableViewJpqlMacro(), (EmbeddingViewJpqlMacro)new MutableEmbeddingViewJpqlMacro(), Collections.emptyMap(), Collections.emptyMap(), this.entityViewConfiguration.getFetches(), this.attributePath);
            ObjectBuilder<Object[]> viewRootObjectBuilder = this.createViewAwareObjectBuilder(this.viewRootType, configuration, this.viewRootIdExpression);
            if (viewRootObjectBuilder == null) {
                this.criteriaBuilder.select(this.viewRootIdExpression);
            } else {
                objectBuilder = new LateAdditionalObjectBuilder(objectBuilder, viewRootObjectBuilder, true);
                this.criteriaBuilder.selectNew((ObjectBuilder)objectBuilder);
            }
            for (Object[] tuple : tuples) {
                AbstractCorrelatedTupleListTransformer.TuplePromise viewRootPromise;
                Object viewRootKey = tuple[this.viewRootIndex];
                Object correlationValueKey = tuple[this.startIndex];
                if (viewRootKey == null || correlationValueKey == null) continue;
                HashMap<Object, AbstractCorrelatedTupleListTransformer.TuplePromise> viewRootCorrelationValues = (HashMap<Object, AbstractCorrelatedTupleListTransformer.TuplePromise>)viewRoots.get(viewRootKey);
                if (viewRootCorrelationValues == null) {
                    viewRootCorrelationValues = new HashMap<Object, AbstractCorrelatedTupleListTransformer.TuplePromise>();
                    viewRoots.put(viewRootKey, viewRootCorrelationValues);
                }
                if ((viewRootPromise = (AbstractCorrelatedTupleListTransformer.TuplePromise)viewRootCorrelationValues.get(correlationValueKey)) == null) {
                    viewRootPromise = new AbstractCorrelatedTupleListTransformer.TuplePromise(this.startIndex);
                    viewRootCorrelationValues.put(correlationValueKey, viewRootPromise);
                }
                viewRootPromise.add(tuple);
            }
        } else {
            HashMap<Object, AbstractCorrelatedTupleListTransformer.TuplePromise> viewRootCorrelationValues = new HashMap<Object, AbstractCorrelatedTupleListTransformer.TuplePromise>(tuples.size());
            viewRoots.put(null, viewRootCorrelationValues);
            for (Object[] tuple : tuples) {
                Object correlationValueKey = tuple[this.startIndex];
                if (correlationValueKey == null) continue;
                AbstractCorrelatedTupleListTransformer.TuplePromise viewRootPromise = (AbstractCorrelatedTupleListTransformer.TuplePromise)viewRootCorrelationValues.get(correlationValueKey);
                if (viewRootPromise == null) {
                    viewRootPromise = new AbstractCorrelatedTupleListTransformer.TuplePromise(this.startIndex);
                    viewRootCorrelationValues.put(correlationValueKey, viewRootPromise);
                }
                viewRootPromise.add(tuple);
            }
        }
        this.criteriaBuilder.select(this.correlationKeyExpression);
        if (this.indexCorrelator != null && (indexBuilder = this.indexCorrelator.finish(this.criteriaBuilder, this.entityViewConfiguration, this.maximumViewMapperCount + 2, 0, this.indexExpression, embeddingViewJpqlMacro, true)) != null) {
            this.criteriaBuilder.selectNew((ObjectBuilder)new LateAdditionalObjectBuilder(objectBuilder, indexBuilder, false));
        }
        this.populateParameters(this.criteriaBuilder);
        viewJpqlMacro.setViewPath(oldViewPath);
        embeddingViewJpqlMacro.setEmbeddingViewPath(oldEmbeddingViewPath);
        List resultList = this.criteriaBuilder.getResultList();
        this.populateResult(viewRoots, resultList);
        this.fillDefaultValues(viewRoots);
        return tuples;
    }

    protected void populateResult(Map<Object, Map<Object, AbstractCorrelatedTupleListTransformer.TuplePromise>> correlationValues, List<Object[]> list) {
        HashMap collections = new HashMap(list.size());
        for (int i = 0; i < list.size(); ++i) {
            Object result;
            Object[] element = list.get(i);
            HashMap viewRootResult = (HashMap)collections.get(element[this.viewIndex]);
            if (viewRootResult == null) {
                viewRootResult = new HashMap();
                collections.put(element[this.viewIndex], viewRootResult);
            }
            if ((result = viewRootResult.get(element[this.keyIndex])) == null) {
                result = this.createDefaultResult();
                viewRootResult.put(element[this.keyIndex], result);
            }
            Object indexObject = null;
            if (this.indexCorrelator != null || this.indexExpression != null) {
                indexObject = element[this.keyIndex + 1];
            }
            this.containerAccumulator.add(result, indexObject, element[this.valueIndex], this.isRecording());
        }
        for (Map.Entry entry : collections.entrySet()) {
            Map<Object, AbstractCorrelatedTupleListTransformer.TuplePromise> tuplePromiseMap = correlationValues.get(entry.getKey());
            if (tuplePromiseMap == null) continue;
            for (Map.Entry correlationEntry : ((Map)entry.getValue()).entrySet()) {
                AbstractCorrelatedTupleListTransformer.TuplePromise tuplePromise = tuplePromiseMap.get(correlationEntry.getKey());
                if (tuplePromise == null) continue;
                tuplePromise.onResult(this.postConstruct(correlationEntry.getValue()), this);
            }
        }
    }
}

