/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.update.flush;

import com.blazebit.persistence.CriteriaBuilder;
import com.blazebit.persistence.DeleteCriteriaBuilder;
import com.blazebit.persistence.InsertCriteriaBuilder;
import com.blazebit.persistence.UpdateCriteriaBuilder;
import com.blazebit.persistence.view.FlushStrategy;
import com.blazebit.persistence.view.impl.EntityViewManagerImpl;
import com.blazebit.persistence.view.impl.accessor.AttributeAccessor;
import com.blazebit.persistence.view.impl.accessor.InitialValueAttributeAccessor;
import com.blazebit.persistence.view.impl.change.DirtyChecker;
import com.blazebit.persistence.view.impl.change.MapDirtyChecker;
import com.blazebit.persistence.view.impl.collection.CollectionRemoveListener;
import com.blazebit.persistence.view.impl.collection.MapAction;
import com.blazebit.persistence.view.impl.collection.MapClearAction;
import com.blazebit.persistence.view.impl.collection.MapInstantiatorImplementor;
import com.blazebit.persistence.view.impl.collection.MapPutAction;
import com.blazebit.persistence.view.impl.collection.MapPutAllAction;
import com.blazebit.persistence.view.impl.collection.MapRemoveAction;
import com.blazebit.persistence.view.impl.collection.RecordingCollection;
import com.blazebit.persistence.view.impl.collection.RecordingMap;
import com.blazebit.persistence.view.impl.entity.MapViewToEntityMapper;
import com.blazebit.persistence.view.impl.entity.ViewToEntityMapper;
import com.blazebit.persistence.view.impl.update.EntityViewUpdater;
import com.blazebit.persistence.view.impl.update.UpdateContext;
import com.blazebit.persistence.view.impl.update.UpdateQueryFactory;
import com.blazebit.persistence.view.impl.update.flush.AbstractPluralAttributeFlusher;
import com.blazebit.persistence.view.impl.update.flush.BasicDirtyChecker;
import com.blazebit.persistence.view.impl.update.flush.CollectionElementAttributeFlusher;
import com.blazebit.persistence.view.impl.update.flush.DirtyAttributeFlusher;
import com.blazebit.persistence.view.impl.update.flush.FusedMapActions;
import com.blazebit.persistence.view.impl.update.flush.MergeMapKeyAttributeFlusher;
import com.blazebit.persistence.view.impl.update.flush.MergeMapValueAttributeFlusher;
import com.blazebit.persistence.view.impl.update.flush.PersistCollectionElementAttributeFlusher;
import com.blazebit.persistence.view.impl.update.flush.PostFlushCollectionElementByIdDeleter;
import com.blazebit.persistence.view.impl.update.flush.PostFlushCollectionElementDeleter;
import com.blazebit.persistence.view.impl.update.flush.PostFlushDeleter;
import com.blazebit.persistence.view.impl.update.flush.TypeDescriptor;
import com.blazebit.persistence.view.impl.update.flush.UnmappedOwnerAwareDeleter;
import com.blazebit.persistence.view.spi.type.BasicUserType;
import com.blazebit.persistence.view.spi.type.DirtyStateTrackable;
import com.blazebit.persistence.view.spi.type.EntityViewProxy;
import com.blazebit.persistence.view.spi.type.MutableStateTrackable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.Tuple;

public class MapAttributeFlusher<E, V extends Map<?, ?>>
extends AbstractPluralAttributeFlusher<MapAttributeFlusher<E, V>, MapAction<?>, RecordingMap<?, ?, ?>, E, V>
implements DirtyAttributeFlusher<MapAttributeFlusher<E, V>, E, V>,
MapDirtyChecker<V, Object, E> {
    private static final Map.Entry<Object, Object> REMOVED_MARKER = new AbstractMap.SimpleEntry<Object, Object>(null, null);
    private final MapInstantiatorImplementor<?, ?> mapInstantiator;
    private final MapViewToEntityMapper mapper;
    private final MapViewToEntityMapper loadOnlyMapper;
    private final CollectionRemoveListener keyCascadeDeleteListener;
    private final CollectionRemoveListener keyRemoveListener;
    private final TypeDescriptor keyDescriptor;
    private final BasicDirtyChecker<Object> keyDirtyChecker;

    public MapAttributeFlusher(String attributeName, String mapping, Class<?> ownerEntityClass, String ownerIdAttributeName, String ownerMapping, DirtyAttributeFlusher<?, ?, ?> ownerIdFlusher, DirtyAttributeFlusher<?, ?, ?> elementFlusher, boolean supportsCollectionDml, FlushStrategy flushStrategy, AttributeAccessor attributeMapper, InitialValueAttributeAccessor viewAttributeAccessor, boolean optimisticLockProtected, boolean collectionUpdatable, CollectionRemoveListener keyCascadeDeleteListener, CollectionRemoveListener elementCascadeDeleteListener, CollectionRemoveListener keyRemoveListener, CollectionRemoveListener elementRemoveListener, boolean viewOnlyDeleteCascaded, boolean jpaProviderDeletesCollection, TypeDescriptor keyDescriptor, TypeDescriptor elementDescriptor, MapViewToEntityMapper mapper, MapViewToEntityMapper loadOnlyMapper, MapInstantiatorImplementor<?, ?> mapInstantiator) {
        super(attributeName, mapping, collectionUpdatable || elementDescriptor.isMutable(), ownerEntityClass, ownerIdAttributeName, ownerMapping, ownerIdFlusher, elementFlusher, supportsCollectionDml, flushStrategy, attributeMapper, viewAttributeAccessor, optimisticLockProtected, collectionUpdatable, viewOnlyDeleteCascaded, jpaProviderDeletesCollection, elementCascadeDeleteListener, elementRemoveListener, elementDescriptor);
        this.mapInstantiator = mapInstantiator;
        this.keyDescriptor = keyDescriptor;
        this.keyDirtyChecker = keyDescriptor.isSubview() || keyDescriptor.isJpaEntity() ? null : new BasicDirtyChecker(keyDescriptor);
        this.keyRemoveListener = keyRemoveListener;
        this.keyCascadeDeleteListener = keyCascadeDeleteListener;
        this.mapper = mapper;
        this.loadOnlyMapper = loadOnlyMapper;
    }

    protected MapAttributeFlusher(MapAttributeFlusher original, boolean fetch) {
        this(original, fetch, (AbstractPluralAttributeFlusher.PluralFlushOperation)null, (List<MapAction<?>>)null, (List<CollectionElementAttributeFlusher<E, V>>)null);
    }

    protected MapAttributeFlusher(MapAttributeFlusher original, boolean fetch, AbstractPluralAttributeFlusher.PluralFlushOperation flushOperation, List<? extends MapAction<?>> collectionActions, List<CollectionElementAttributeFlusher<E, V>> elementFlushers) {
        super(original, fetch, flushOperation, collectionActions, elementFlushers);
        this.mapInstantiator = original.mapInstantiator;
        this.keyDescriptor = original.keyDescriptor;
        this.keyDirtyChecker = original.keyDirtyChecker;
        this.keyRemoveListener = original.keyRemoveListener;
        this.keyCascadeDeleteListener = original.keyCascadeDeleteListener;
        this.mapper = original.mapper;
        this.loadOnlyMapper = original.loadOnlyMapper;
    }

    protected V createMap(int size) {
        return (V)this.mapInstantiator.createMap(size);
    }

    protected V createJpaMap(int size) {
        return (V)this.mapInstantiator.createJpaMap(size);
    }

    @Override
    protected V createJpaCollection() {
        return (V)this.mapInstantiator.createJpaMap(0);
    }

    protected RecordingMap<?, ?, ?> createRecordingMap(int size) {
        return (RecordingMap)this.mapInstantiator.createRecordingMap(size);
    }

    @Override
    public V cloneDeep(Object view, V oldValue, V newValue) {
        boolean cloneValue;
        if (newValue == null || newValue.isEmpty()) {
            return newValue;
        }
        BasicUserType<Object> keyBasicUserType = this.keyDescriptor.getBasicUserType();
        BasicUserType<Object> elementBasicUserType = this.elementDescriptor.getBasicUserType();
        boolean cloneKey = keyBasicUserType != null && this.keyDescriptor.shouldFlushMutations() && !this.keyDescriptor.isSubview() && !keyBasicUserType.supportsDirtyChecking() && keyBasicUserType.supportsDeepCloning();
        boolean bl = cloneValue = elementBasicUserType != null && this.elementDescriptor.shouldFlushMutations() && !this.elementDescriptor.isSubview() && !elementBasicUserType.supportsDirtyChecking() && elementBasicUserType.supportsDeepCloning();
        if (cloneKey || cloneValue) {
            Object newCollection;
            if (cloneKey && cloneValue) {
                Object newCollection2;
                Object collection = newCollection2 = this.createMap(newValue.size());
                for (Map.Entry entry : newValue.entrySet()) {
                    collection.put((Object)keyBasicUserType.deepClone(entry.getKey()), (Object)elementBasicUserType.deepClone(entry.getValue()));
                }
                return (V)newCollection2;
            }
            if (cloneKey) {
                Object newCollection3;
                Object collection = newCollection3 = this.createMap(newValue.size());
                for (Map.Entry entry : newValue.entrySet()) {
                    collection.put((Object)keyBasicUserType.deepClone(entry.getKey()), entry.getValue());
                }
                return newCollection3;
            }
            Object collection = newCollection = this.createMap(newValue.size());
            for (Map.Entry entry : newValue.entrySet()) {
                collection.put(entry.getKey(), (Object)elementBasicUserType.deepClone(entry.getValue()));
            }
            return (V)newCollection;
        }
        return newValue;
    }

    @Override
    public Object getNewInitialValue(UpdateContext context, V clonedValue, V currentValue) {
        boolean cloneValue;
        BasicUserType<Object> keyBasicUserType = this.keyDescriptor.getBasicUserType();
        BasicUserType<Object> elementBasicUserType = this.elementDescriptor.getBasicUserType();
        boolean cloneKey = keyBasicUserType != null && this.keyDescriptor.shouldFlushMutations() && !this.keyDescriptor.isSubview() && !keyBasicUserType.supportsDirtyChecking() && keyBasicUserType.supportsDeepCloning();
        boolean bl = cloneValue = elementBasicUserType != null && this.elementDescriptor.shouldFlushMutations() && !this.elementDescriptor.isSubview() && !elementBasicUserType.supportsDirtyChecking() && elementBasicUserType.supportsDeepCloning();
        if (cloneKey || cloneValue) {
            return clonedValue;
        }
        return currentValue;
    }

    @Override
    public boolean isPassThrough() {
        return !this.collectionUpdatable && !this.keyDescriptor.shouldFlushMutations() && !this.elementDescriptor.shouldFlushMutations();
    }

    @Override
    protected boolean isIndexed() {
        return true;
    }

    @Override
    protected void addFlatViewElementFlushActions(UpdateContext context, TypeDescriptor typeDescriptor, List<MapAction<?>> actions, V current) {
        ViewToEntityMapper mapper = typeDescriptor.getViewToEntityMapper();
        for (Map.Entry entry : current.entrySet()) {
            MutableStateTrackable element;
            DirtyAttributeFlusher flusher;
            Object o = entry.getValue();
            if (!(o instanceof MutableStateTrackable) || (flusher = mapper.getNestedDirtyFlusher(context, element = (MutableStateTrackable)o, null)) == null) continue;
            AbstractPluralAttributeFlusher.EntryState state = AbstractPluralAttributeFlusher.EntryState.EXISTED;
            for (MapAction<?> action : actions) {
                if (MapAttributeFlusher.identityContains(action.getRemovedElements(), element)) {
                    state = state.onRemove();
                    if (!MapAttributeFlusher.identityContains(action.getAddedElements(), element)) continue;
                    state = state.onAdd();
                    continue;
                }
                if (!MapAttributeFlusher.identityContains(action.getAddedElements(), element)) continue;
                state = state.onAdd();
            }
            if (state == AbstractPluralAttributeFlusher.EntryState.ADDED) continue;
            actions.add(new MapPutAction(entry.getKey(), element, (MutableStateTrackable)current));
        }
    }

    @Override
    protected void invokeCollectionAction(UpdateContext context, Object ownerView, Object view, V targetCollection, Object value, List<? extends MapAction<?>> collectionActions) {
        if (this.mapping == null) {
            targetCollection = this.createMap(0);
            for (MapAction<?> action : collectionActions) {
                action.doAction(targetCollection, context, this.loadOnlyMapper, this.keyRemoveListener, this.removeListener);
            }
        } else if (this.flushStrategy == FlushStrategy.QUERY && !context.isForceEntity()) {
            FusedMapActions fusedCollectionActions = null;
            if (this.canFlushSeparateCollectionOperations()) {
                if (collectionActions.isEmpty()) {
                    return;
                }
                if (!(collectionActions.get(0) instanceof MapClearAction)) {
                    fusedCollectionActions = this.getFusedOperations(collectionActions);
                }
            }
            this.flushCollectionOperations(context, ownerView, view, null, (Map)value, null, fusedCollectionActions, true);
        } else {
            for (MapAction<?> action : collectionActions) {
                action.doAction(targetCollection, context, this.loadOnlyMapper, this.keyRemoveListener, this.removeListener);
            }
        }
    }

    @Override
    protected V replaceWithRecordingCollection(UpdateContext context, Object view, V value, List<? extends MapAction<?>> actions) {
        RecordingMap<?, ?, ?> initialValue;
        RecordingMap<?, ?, ?> map;
        Map initialState = (Map)this.viewAttributeAccessor.getInitialValue(view);
        Map map2 = initialState = initialState != null ? initialState : Collections.emptyMap();
        if (value instanceof RecordingMap) {
            map = (RecordingMap<?, ?, ?>)value;
        } else {
            if (value != null) {
                map = this.createRecordingMap(value.size());
                map.getDelegate().putAll(value);
            } else {
                map = this.createRecordingMap(0);
            }
            this.viewAttributeAccessor.setValue(view, map);
        }
        if (actions != null && !actions.isEmpty()) {
            map.initiateActionsAgainstState(actions, initialState);
            map.resetActions(context);
        }
        if ((initialValue = this.cloneDeep(view, (V)null, (V)map)) != value) {
            this.viewAttributeAccessor.setInitialValue(view, initialValue);
        }
        return (V)map;
    }

    @Override
    public Query flushQuery(UpdateContext context, String parameterPrefix, UpdateQueryFactory queryFactory, Query query, Object ownerView, Object view, V current, UnmappedOwnerAwareDeleter ownerAwareDeleter, DirtyAttributeFlusher<?, ?, ?> ownerFlusher) {
        if (!this.supportsQueryFlush()) {
            throw new UnsupportedOperationException("Query flush not supported for configuration!");
        }
        if (this.flushOperation != null) {
            if (current instanceof RecordingMap) {
                ((RecordingMap)current).resetActions(context);
            } else {
                ArrayList actions = new ArrayList();
                actions.add(new MapClearAction());
                if (current != null && !current.isEmpty()) {
                    actions.add(new MapPutAllAction(current, Collections.emptyMap()));
                }
                current = this.replaceWithRecordingCollection(context, view, current, (List<? extends MapAction<?>>)actions);
            }
            this.invokeFlushOperation(context, ownerView, view, null, current);
        } else {
            boolean isRecording = current instanceof RecordingMap;
            if (isRecording) {
                RecordingMap recordingMap = (RecordingMap)current;
                if (this.entityAttributeAccessor == null) {
                    recordingMap.resetActions(context);
                }
                Map<Object, Object> embeddables = null;
                if (this.elementDescriptor.shouldFlushMutations()) {
                    if (this.elementDescriptor.shouldJpaPersistOrMerge()) {
                        this.mergeAndRequeue(context, recordingMap, (Map<Object, Object>)recordingMap.getDelegate());
                    } else if (this.elementDescriptor.isSubview() && (this.elementDescriptor.isIdentifiable() || this.isIndexed())) {
                        embeddables = this.flushCollectionViewElements(context, current);
                    }
                }
                if (this.entityAttributeAccessor != null && this.collectionUpdatable) {
                    Map initial = (Map)this.viewAttributeAccessor.getInitialValue(view);
                    if (initial instanceof RecordingMap) {
                        initial = ((RecordingMap)initial).getInitialVersion();
                    }
                    recordingMap.resetActions(context);
                    this.flushCollectionOperations(context, ownerView, view, initial, current, embeddables, null, initial != null);
                }
            } else {
                AbstractPluralAttributeFlusher.EqualityChecker equalityChecker = this.elementDescriptor.isSubview() ? AbstractPluralAttributeFlusher.EqualsEqualityChecker.INSTANCE : new AbstractPluralAttributeFlusher.IdentityEqualityChecker(this.elementDescriptor.getBasicUserType());
                Map initial = (Map)this.viewAttributeAccessor.getInitialValue(view);
                if (initial instanceof RecordingMap) {
                    initial = ((RecordingMap)initial).getInitialVersion();
                }
                List<MapAction<Map<Object, Object>>> actions = initial == null || !this.elementDescriptor.supportsDeepEqualityCheck() || this.elementDescriptor.getBasicUserType() != null && !this.elementDescriptor.getBasicUserType().supportsDeepCloning() ? this.replaceActions(current) : this.determineCollectionActions(context, initial, current, equalityChecker);
                current = this.replaceWithRecordingCollection(context, view, current, (List<? extends MapAction<?>>)actions);
                Map<Object, Object> embeddables = null;
                if (this.elementDescriptor.shouldFlushMutations()) {
                    if (this.elementDescriptor.shouldJpaPersistOrMerge()) {
                        this.mergeAndRequeue(context, null, (Map<Object, Object>)current);
                    } else if (this.elementDescriptor.isSubview() && (this.elementDescriptor.isIdentifiable() || this.isIndexed())) {
                        embeddables = this.flushCollectionViewElements(context, current);
                    }
                }
                if (this.entityAttributeAccessor != null && this.collectionUpdatable) {
                    this.flushCollectionOperations(context, ownerView, view, initial, current, embeddables, null, initial != null);
                }
            }
        }
        return query;
    }

    protected final DeleteCriteriaBuilder<?> createCollectionDeleter(UpdateContext context) {
        DeleteCriteriaBuilder deleteCb = context.getEntityViewManager().getCriteriaBuilderFactory().deleteCollection(context.getEntityManager(), this.ownerEntityClass, "e", this.getMapping());
        deleteCb.setWhereExpression(this.ownerIdWhereFragment);
        return deleteCb;
    }

    protected Map<Object, Object> appendRemoveSpecific(UpdateContext context, DeleteCriteriaBuilder<?> deleteCb, FusedMapActions fusedCollectionActions) {
        deleteCb.where("KEY(e." + this.getMapping() + ")").in(fusedCollectionActions.getRemovedKeys(context));
        return fusedCollectionActions.getRemoved();
    }

    protected boolean deleteElements(UpdateContext context, Object ownerView, Object view, V value, boolean removeSpecific, FusedMapActions fusedCollectionActions, boolean deleteAll) {
        DeleteCriteriaBuilder<?> deleteCb = null;
        boolean removedAll = true;
        Map<Object, Object> removedObjects = Collections.emptyMap();
        if (!deleteAll && fusedCollectionActions != null) {
            if (fusedCollectionActions.getRemoveCount() > 0) {
                deleteCb = this.createCollectionDeleter(context);
                if (removeSpecific) {
                    removedObjects = this.appendRemoveSpecific(context, deleteCb, fusedCollectionActions);
                    removedAll = false;
                    if (removedObjects.isEmpty()) {
                        deleteCb = null;
                    }
                }
            } else {
                removedAll = false;
            }
        } else {
            deleteCb = this.createCollectionDeleter(context);
        }
        if (deleteCb != null) {
            Query deleteQuery = deleteCb.getQuery();
            this.ownerIdFlusher.flushQuery(context, null, null, deleteQuery, ownerView, view, this.ownerIdFlusher.getViewAttributeAccessor().getValue(ownerView), null, null);
            deleteQuery.executeUpdate();
            if (removedAll) {
                return true;
            }
            this.processRemovedObjects(context, removedObjects);
        }
        return false;
    }

    protected void addElements(UpdateContext context, Object ownerView, Object view, Map<Object, Object> removedAllObjects, boolean flushAtOnce, V value, Map<Object, Object> embeddablesToUpdate, FusedMapActions fusedCollectionActions, boolean initialKnown) {
        Object appends;
        String mapping = this.getMapping();
        if (fusedCollectionActions == null || !removedAllObjects.isEmpty()) {
            appends = value;
            Iterator<Map.Entry<Object, Object>> iterator = removedAllObjects.entrySet().iterator();
            ArrayList<FusedMapActions.RemoveWrapper> removeWrappers = null;
            while (iterator.hasNext()) {
                Map.Entry<Object, Object> entry = iterator.next();
                Object v = value.get(entry.getKey());
                if (v == null) continue;
                if (!v.equals(entry.getValue())) {
                    if (removeWrappers == null) {
                        removeWrappers = new ArrayList<FusedMapActions.RemoveWrapper>();
                    }
                    removeWrappers.add(new FusedMapActions.RemoveWrapper(entry.getKey()));
                }
                iterator.remove();
            }
            if (removeWrappers != null) {
                for (Object e : removeWrappers) {
                    removedAllObjects.put(e, null);
                }
            }
        } else {
            Map<Object, Object> replaces = fusedCollectionActions.getReplaces();
            if (replaces.size() != 0 || embeddablesToUpdate != null && !embeddablesToUpdate.isEmpty()) {
                UpdateCriteriaBuilder updateCb = context.getEntityViewManager().getCriteriaBuilderFactory().updateCollection(context.getEntityManager(), this.ownerEntityClass, "e", mapping);
                updateCb.setExpression(mapping, ":element");
                updateCb.setWhereExpression(this.ownerIdWhereFragment);
                updateCb.where("KEY(" + mapping + ")").eqExpression(":key");
                Query query = updateCb.getQuery();
                if (replaces.size() != 0) {
                    this.ownerIdFlusher.flushQuery(context, null, null, query, ownerView, view, this.ownerIdFlusher.getViewAttributeAccessor().getValue(ownerView), null, null);
                    boolean bl = this.elementDescriptor.isJpaEntity() && !this.elementDescriptor.shouldJpaPersist();
                    ViewToEntityMapper keyViewToEntityMapper = this.keyDescriptor.getLoadOnlyViewToEntityMapper();
                    ViewToEntityMapper valueViewToEntityMapper = this.elementDescriptor.getLoadOnlyViewToEntityMapper();
                    for (Map.Entry<Object, Object> replace : replaces.entrySet()) {
                        Object k = replace.getKey();
                        Object v = replace.getValue();
                        if (keyViewToEntityMapper == null) {
                            if (bl && this.keyDescriptor.getBasicUserType().shouldPersist(k)) {
                                throw new IllegalStateException("Collection " + this.attributeName + " references an unsaved transient instance - save the transient instance before flushing: " + k);
                            }
                        } else {
                            k = keyViewToEntityMapper.applyToEntity(context, null, k);
                        }
                        if (valueViewToEntityMapper == null) {
                            if (bl && this.elementDescriptor.getBasicUserType().shouldPersist(v)) {
                                throw new IllegalStateException("Collection " + this.attributeName + " references an unsaved transient instance - save the transient instance before flushing: " + v);
                            }
                        } else {
                            v = valueViewToEntityMapper.applyToEntity(context, null, v);
                        }
                        query.setParameter("key", k);
                        query.setParameter("element", v);
                        query.executeUpdate();
                    }
                }
                if (embeddablesToUpdate != null && !embeddablesToUpdate.isEmpty()) {
                    for (Map.Entry<Object, Object> entry : embeddablesToUpdate.entrySet()) {
                        query.setParameter("key", entry.getKey());
                        query.setParameter("element", entry.getValue());
                        query.executeUpdate();
                    }
                }
            }
            appends = fusedCollectionActions.getAdded();
        }
        if (appends.size() > 0) {
            InsertCriteriaBuilder insertCb = context.getEntityViewManager().getCriteriaBuilderFactory().insertCollection(context.getEntityManager(), this.ownerEntityClass, mapping);
            String keyEntityIdAttributeName = this.keyDescriptor.getEntityIdAttributeName();
            String keyAttributeIdAttributeName = this.keyDescriptor.getAttributeIdAttributeName();
            if (keyEntityIdAttributeName == null) {
                insertCb.fromValues(this.ownerEntityClass, "KEY(" + mapping + ")", "key", 1);
            } else if (keyEntityIdAttributeName.equals(keyAttributeIdAttributeName)) {
                insertCb.fromIdentifiableValues(this.keyDescriptor.getJpaType(), "key", 1);
            } else {
                insertCb.fromIdentifiableValues(this.keyDescriptor.getJpaType(), keyAttributeIdAttributeName, "key", 1);
            }
            String string = this.elementDescriptor.getEntityIdAttributeName();
            String attributeIdAttributeName = this.elementDescriptor.getAttributeIdAttributeName();
            if (string == null) {
                insertCb.fromValues(this.ownerEntityClass, mapping, "val", 1);
            } else if (string.equals(attributeIdAttributeName)) {
                insertCb.fromIdentifiableValues(this.elementDescriptor.getJpaType(), "val", 1);
            } else {
                insertCb.fromIdentifiableValues(this.elementDescriptor.getJpaType(), attributeIdAttributeName, "val", 1);
            }
            insertCb.bind("KEY(" + mapping + ")").select("key");
            for (int i = 0; i < this.ownerIdBindFragments.length; i += 2) {
                insertCb.bind(this.ownerIdBindFragments[i]).select(this.ownerIdBindFragments[i + 1]);
            }
            insertCb.bind(mapping).select("val");
            Query query = insertCb.getQuery();
            this.ownerIdFlusher.flushQuery(context, null, null, query, ownerView, view, this.ownerIdFlusher.getViewAttributeAccessor().getValue(ownerView), null, null);
            Object[] singletonKeyArray = new Object[1];
            Object[] singletonValueArray = new Object[1];
            List<Object> singletonKeyList = Arrays.asList(singletonKeyArray);
            List<Object> singletonValueList = Arrays.asList(singletonValueArray);
            ViewToEntityMapper keyViewToEntityMapper = this.keyDescriptor.getLoadOnlyViewToEntityMapper();
            ViewToEntityMapper valueViewToEntityMapper = this.elementDescriptor.getLoadOnlyViewToEntityMapper();
            boolean checkTransient = this.elementDescriptor.isJpaEntity() && !this.elementDescriptor.shouldJpaPersist();
            for (Map.Entry entry : appends.entrySet()) {
                Object k = entry.getKey();
                Object v = entry.getValue();
                if (k == null || v == null) continue;
                if (keyViewToEntityMapper == null) {
                    if (checkTransient && this.keyDescriptor.getBasicUserType().shouldPersist(k)) {
                        throw new IllegalStateException("Collection " + this.attributeName + " references an unsaved transient instance - save the transient instance before flushing: " + k);
                    }
                    singletonKeyArray[0] = k;
                } else {
                    singletonKeyArray[0] = keyViewToEntityMapper.applyToEntity(context, null, k);
                }
                if (valueViewToEntityMapper == null) {
                    if (checkTransient && this.elementDescriptor.getBasicUserType().shouldPersist(v)) {
                        throw new IllegalStateException("Collection " + this.attributeName + " references an unsaved transient instance - save the transient instance before flushing: " + v);
                    }
                    singletonValueArray[0] = v;
                } else {
                    singletonValueArray[0] = valueViewToEntityMapper.applyToEntity(context, null, v);
                }
                query.setParameter("key", singletonKeyList);
                query.setParameter("val", singletonValueList);
                query.executeUpdate();
            }
        }
    }

    protected void flushCollectionOperations(UpdateContext context, Object ownerView, Object view, V initial, V value, Map<Object, Object> embeddablesToUpdate, FusedMapActions fusedCollectionActions, boolean initialKnown) {
        boolean removeSpecific = fusedCollectionActions != null && fusedCollectionActions.operationCount() < value.size() + 1;
        Map<Object, Object> removedAllObjects = this.deleteElements(context, ownerView, view, value, removeSpecific, fusedCollectionActions, !initialKnown) ? (fusedCollectionActions == null ? (initial == null ? Collections.emptyMap() : new IdentityHashMap(initial)) : new IdentityHashMap<Object, Object>(fusedCollectionActions.getRemoved())) : Collections.emptyMap();
        this.addElements(context, ownerView, view, removedAllObjects, true, value, embeddablesToUpdate, fusedCollectionActions, initialKnown);
        this.processRemovedObjects(context, removedAllObjects);
    }

    private void processRemovedObjects(UpdateContext context, Map<Object, Object> removedObjects) {
        if (this.keyRemoveListener != null || this.removeListener != null) {
            for (Map.Entry<Object, Object> entry : removedObjects.entrySet()) {
                if (this.keyRemoveListener != null && !(entry.getKey() instanceof FusedMapActions.RemoveWrapper)) {
                    this.keyRemoveListener.onCollectionRemove(context, entry.getKey());
                }
                if (this.removeListener == null || entry.getValue() == null) continue;
                this.removeListener.onCollectionRemove(context, entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Object, Object> flushCollectionViewElements(UpdateContext context, V value) {
        ViewToEntityMapper keyMapper = this.mapper.getKeyMapper();
        ViewToEntityMapper valueMapper = this.mapper.getValueMapper();
        Iterator<Map.Entry<Object, Object>> iter = this.getRecordingIterator((Map<?, ?>)value);
        LinkedHashMap<Object, Object> embeddables = null;
        if (!(this.keyDescriptor.isIdentifiable() && this.elementDescriptor.isIdentifiable() || this.mapping == null)) {
            embeddables = new LinkedHashMap<Object, Object>();
        }
        try {
            while (iter.hasNext()) {
                Map.Entry<Object, Object> entry = iter.next();
                Object k = entry.getKey();
                Object v = entry.getValue();
                Object newKey = k;
                if (keyMapper != null) {
                    newKey = keyMapper.applyToEntity(context, null, k);
                }
                Object newValue = v;
                if (valueMapper != null) {
                    newValue = valueMapper.applyToEntity(context, null, v);
                }
                if (embeddables == null) continue;
                embeddables.put(newKey, newValue);
            }
        }
        finally {
            this.resetRecordingIterator((Map<?, ?>)value);
        }
        return embeddables;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public boolean flushEntity(UpdateContext context, E entity, Object ownerView, Object view, V value, Runnable postReplaceListener) {
        block37: {
            boolean isRecording;
            boolean wasDirty;
            boolean replace;
            block35: {
                block42: {
                    List<MapAction<Map<Object, Object>>> actions;
                    block49: {
                        block36: {
                            block45: {
                                block48: {
                                    block46: {
                                        block47: {
                                            block44: {
                                                block43: {
                                                    block38: {
                                                        RecordingMap recordingMap;
                                                        block34: {
                                                            block41: {
                                                                block40: {
                                                                    block39: {
                                                                        if (this.flushOperation != null) {
                                                                            if (value instanceof RecordingMap) {
                                                                                ((RecordingMap)value).resetActions(context);
                                                                            } else {
                                                                                value = this.replaceWithRecordingCollection(context, view, value, (List<? extends MapAction<?>>)this.collectionActions);
                                                                            }
                                                                            this.invokeFlushOperation(context, ownerView, view, entity, value);
                                                                            return true;
                                                                        }
                                                                        if (!this.collectionUpdatable) break block37;
                                                                        replace = false;
                                                                        wasDirty = false;
                                                                        isRecording = value instanceof RecordingMap;
                                                                        actions = null;
                                                                        Object initial = this.viewAttributeAccessor.getInitialValue(view);
                                                                        if (!isRecording || initial == null) break block38;
                                                                        recordingMap = (RecordingMap)value;
                                                                        if (!this.keyDescriptor.shouldFlushMutations() && !this.elementDescriptor.shouldFlushMutations()) break block34;
                                                                        if (!this.keyDescriptor.shouldJpaPersistOrMerge() && !this.elementDescriptor.shouldJpaPersistOrMerge()) break block39;
                                                                        wasDirty |= this.mergeAndRequeue(context, recordingMap, (Map<Object, Object>)recordingMap.getDelegate());
                                                                        break block34;
                                                                    }
                                                                    if ((!this.keyDescriptor.isSubview() || !this.keyDescriptor.shouldFlushMutations() || !this.keyDescriptor.isIdentifiable() || this.elementDescriptor.isSubview() && this.elementDescriptor.shouldFlushMutations() && !this.elementDescriptor.isIdentifiable()) && (!this.elementDescriptor.isSubview() || !this.elementDescriptor.shouldFlushMutations() || !this.elementDescriptor.isIdentifiable() || this.keyDescriptor.isSubview() && this.keyDescriptor.shouldFlushMutations() && !this.keyDescriptor.isIdentifiable())) break block40;
                                                                    this.flushCollectionViewElements(context, value);
                                                                    wasDirty = true;
                                                                    break block34;
                                                                }
                                                                if (!this.fetch || !this.elementDescriptor.supportsDeepEqualityCheck() || this.entityAttributeAccessor == null) break block41;
                                                                Map jpaCollection = (Map)this.entityAttributeAccessor.getValue(entity);
                                                                if (jpaCollection == null || jpaCollection.isEmpty()) {
                                                                    replace = true;
                                                                    break block34;
                                                                } else {
                                                                    void var14_19;
                                                                    if (this.elementDescriptor.isSubview()) {
                                                                        if (this.elementDescriptor.isIdentifiable()) {
                                                                            AbstractPluralAttributeFlusher.EntityIdWithViewIdEqualityChecker entityIdWithViewIdEqualityChecker = new AbstractPluralAttributeFlusher.EntityIdWithViewIdEqualityChecker(this.elementDescriptor.getViewToEntityMapper());
                                                                        } else {
                                                                            AbstractPluralAttributeFlusher.EntityWithViewEqualityChecker entityWithViewEqualityChecker = new AbstractPluralAttributeFlusher.EntityWithViewEqualityChecker(this.elementDescriptor.getViewToEntityMapper());
                                                                        }
                                                                    } else {
                                                                        AbstractPluralAttributeFlusher.DeepEqualityChecker deepEqualityChecker = new AbstractPluralAttributeFlusher.DeepEqualityChecker(this.elementDescriptor.getBasicUserType());
                                                                    }
                                                                    actions = this.determineJpaCollectionActions(context, jpaCollection, value, (AbstractPluralAttributeFlusher.EqualityChecker)var14_19);
                                                                    if (actions.size() > value.size()) {
                                                                        replace = true;
                                                                        break block34;
                                                                    } else {
                                                                        for (MapAction<Map<Object, Object>> action : actions) {
                                                                            action.doAction(jpaCollection, context, this.loadOnlyMapper, this.keyRemoveListener, this.removeListener);
                                                                        }
                                                                        if (actions.isEmpty()) return false;
                                                                        return true;
                                                                    }
                                                                }
                                                            }
                                                            replace = true;
                                                        }
                                                        if (replace) break block35;
                                                        if (this.entityAttributeAccessor == null) {
                                                            wasDirty |= !recordingMap.resetActions(context).isEmpty();
                                                            break block35;
                                                        } else {
                                                            Map map = (Map)this.entityAttributeAccessor.getValue(entity);
                                                            if (map == null) {
                                                                replace = true;
                                                                break block35;
                                                            } else {
                                                                wasDirty |= recordingMap.hasActions();
                                                                recordingMap.replay(map, context, this.loadOnlyMapper, this.keyRemoveListener, this.removeListener);
                                                            }
                                                        }
                                                        break block35;
                                                    }
                                                    actions = this.replaceActions(value);
                                                    value = this.replaceWithRecordingCollection(context, view, value, (List<? extends MapAction<?>>)actions);
                                                    if (!this.fetch) break block42;
                                                    if (value != null && !value.isEmpty()) break block43;
                                                    replace = true;
                                                    break block36;
                                                }
                                                if (!this.keyDescriptor.shouldFlushMutations() || this.keyDescriptor.isIdentifiable()) break block44;
                                                replace = true;
                                                if (this.elementDescriptor.shouldFlushMutations() && this.elementDescriptor.isIdentifiable()) {
                                                    this.mergeAndRequeue(context, null, (Map<Object, Object>)value);
                                                }
                                                break block36;
                                            }
                                            if (!this.elementDescriptor.shouldFlushMutations()) break block45;
                                            if (!this.keyDescriptor.shouldFlushMutations()) break block46;
                                            if (!this.keyDescriptor.shouldJpaPersistOrMerge() && !this.elementDescriptor.shouldJpaPersistOrMerge()) break block47;
                                            wasDirty |= this.mergeAndRequeue(context, null, (Map<Object, Object>)value);
                                            break block36;
                                        }
                                        if (this.keyDescriptor.isSubview() || this.elementDescriptor.isSubview()) {
                                            if (this.elementDescriptor.isIdentifiable()) {
                                                this.flushCollectionViewElements(context, value);
                                                wasDirty = true;
                                                break block36;
                                            } else {
                                                replace = true;
                                                this.mergeAndRequeue(context, null, (Map<Object, Object>)value);
                                            }
                                            break block36;
                                        } else {
                                            replace = true;
                                        }
                                        break block36;
                                    }
                                    if (!this.elementDescriptor.shouldJpaPersistOrMerge()) break block48;
                                    wasDirty |= this.mergeAndRequeue(context, null, (Map<Object, Object>)value);
                                    break block36;
                                }
                                if (this.elementDescriptor.isSubview()) {
                                    if (this.elementDescriptor.isIdentifiable()) {
                                        this.flushCollectionViewElements(context, value);
                                    }
                                    break block36;
                                } else if (!this.elementDescriptor.supportsDeepEqualityCheck()) {
                                    replace = true;
                                }
                                break block36;
                            }
                            if (this.elementDescriptor.supportsEqualityCheck() && this.keyDescriptor.shouldFlushMutations() && this.keyDescriptor.isIdentifiable()) {
                                wasDirty |= this.mergeAndRequeue(context, null, (Map<Object, Object>)value);
                            }
                        }
                        if (replace) break block35;
                        if (this.entityAttributeAccessor != null) break block49;
                        wasDirty = true;
                        break block35;
                    }
                    Map jpaCollection = (Map)this.entityAttributeAccessor.getValue(entity);
                    if (jpaCollection == null || jpaCollection.isEmpty()) {
                        replace = true;
                        break block35;
                    } else {
                        actions = this.determineJpaCollectionActions(context, jpaCollection, value, this.elementEqualityChecker);
                        if (actions.size() > value.size()) {
                            replace = true;
                            break block35;
                        } else {
                            for (MapAction<Map<Object, Object>> mapAction : actions) {
                                mapAction.doAction(jpaCollection, context, this.loadOnlyMapper, this.keyRemoveListener, this.removeListener);
                            }
                            wasDirty |= !actions.isEmpty();
                        }
                    }
                    break block35;
                }
                replace = true;
            }
            if (!replace) return wasDirty;
            if (isRecording) {
                ((RecordingMap)value).resetActions(context);
            }
            this.replaceCollection(context, ownerView, view, entity, value, FlushStrategy.ENTITY);
            return true;
        }
        if (this.keyDescriptor.shouldFlushMutations()) return this.mergeCollectionElements(context, ownerView, view, entity, value);
        if (this.elementDescriptor.shouldFlushMutations()) {
            return this.mergeCollectionElements(context, ownerView, view, entity, value);
        }
        this.replaceCollection(context, ownerView, view, entity, value, FlushStrategy.ENTITY);
        return true;
    }

    private Iterator<Map.Entry<Object, Object>> getRecordingIterator(Map<?, ?> value) {
        if (value instanceof RecordingMap && (this.mapper.getKeyMapper() != null || this.mapper.getValueMapper() != null)) {
            return ((RecordingMap)value).recordingIterator();
        }
        return value.entrySet().iterator();
    }

    private void resetRecordingIterator(Map<?, ?> value) {
        if (value instanceof RecordingMap && (this.mapper.getKeyMapper() != null || this.mapper.getValueMapper() != null)) {
            ((RecordingMap)value).resetRecordingIterator();
        }
    }

    protected List<MapAction<Map<Object, Object>>> replaceActions(V value) {
        ArrayList<MapAction<Map<Object, Object>>> actions = new ArrayList<MapAction<Map<Object, Object>>>();
        actions.add(new MapClearAction());
        if (value != null && !value.isEmpty()) {
            actions.add(new MapPutAllAction(value, Collections.emptyMap()));
        }
        return actions;
    }

    @Override
    public List<PostFlushDeleter> remove(UpdateContext context, E entity, Object view, V value) {
        Map map = view instanceof DirtyStateTrackable ? (Map)this.viewAttributeAccessor.getInitialValue(view) : value;
        if (map != null && !map.isEmpty()) {
            if (this.flushStrategy == FlushStrategy.QUERY && !context.isForceEntity() && !this.jpaProviderDeletesCollection) {
                this.removeByOwnerId(context, ((EntityViewProxy)view).$$_getId(), false);
            }
            if (this.cascadeDeleteListener != null || this.keyCascadeDeleteListener != null) {
                ArrayList<Object> values;
                ArrayList<Object> keys;
                if (map instanceof RecordingMap) {
                    RecordingMap recordingMap = (RecordingMap)map;
                    Set set = recordingMap.getRemovedKeys();
                    Set removedElements = recordingMap.getRemovedElements();
                    Set addedKeys = recordingMap.getAddedKeys();
                    Set addedElements = recordingMap.getAddedElements();
                    keys = new ArrayList(recordingMap.size() + set.size());
                    values = new ArrayList(recordingMap.size() + removedElements.size());
                    for (Map.Entry entry : map.entrySet()) {
                        if (this.keyCascadeDeleteListener != null && !addedKeys.contains(entry.getKey())) {
                            keys.add(entry.getKey());
                        }
                        if (this.cascadeDeleteListener == null || addedElements.contains(entry.getValue())) continue;
                        values.add(entry.getValue());
                    }
                    if (this.keyCascadeDeleteListener != null) {
                        keys.addAll(set);
                    }
                    if (this.cascadeDeleteListener != null) {
                        values.addAll(removedElements);
                    }
                } else {
                    keys = new ArrayList<Object>(map.size());
                    values = new ArrayList<Object>(map.size());
                    for (Map.Entry entry : map.entrySet()) {
                        if (this.keyCascadeDeleteListener != null) {
                            keys.add(entry.getKey());
                        }
                        if (this.cascadeDeleteListener == null) continue;
                        values.add(entry.getValue());
                    }
                }
                if (keys.size() > 0 || values.size() > 0) {
                    ArrayList<PostFlushDeleter> list = new ArrayList<PostFlushDeleter>(2);
                    if (keys.size() > 0) {
                        list.add(new PostFlushCollectionElementDeleter(this.keyCascadeDeleteListener, keys));
                    }
                    if (values.size() > 0) {
                        list.add(new PostFlushCollectionElementDeleter(this.cascadeDeleteListener, values));
                    }
                    return list;
                }
            }
        }
        return Collections.emptyList();
    }

    @Override
    public List<PostFlushDeleter> removeByOwnerId(UpdateContext context, Object id) {
        return this.removeByOwnerId(context, id, true);
    }

    private List<PostFlushDeleter> removeByOwnerId(UpdateContext context, Object ownerId, boolean cascade) {
        EntityViewManagerImpl evm = context.getEntityViewManager();
        if (cascade) {
            ArrayList<Object> elementIds;
            if (evm.getDbmsDialect().supportsReturningColumns()) {
                List tuples = ((DeleteCriteriaBuilder)evm.getCriteriaBuilderFactory().deleteCollection(context.getEntityManager(), this.ownerEntityClass, "e", this.mapping).where(this.ownerIdAttributeName).eq(ownerId)).executeWithReturning(new String[]{this.mapping + "." + this.elementDescriptor.getAttributeIdAttributeName()}).getResultList();
                elementIds = new ArrayList<Object>(tuples.size());
                for (Tuple tuple : tuples) {
                    elementIds.add(tuple.get(0));
                }
            } else {
                elementIds = ((CriteriaBuilder)((CriteriaBuilder)evm.getCriteriaBuilderFactory().create(context.getEntityManager(), this.ownerEntityClass, "e").where(this.ownerIdAttributeName).eq(ownerId)).select("e." + this.mapping + "." + this.elementDescriptor.getAttributeIdAttributeName())).getResultList();
                if (!elementIds.isEmpty() && !this.jpaProviderDeletesCollection) {
                    DeleteCriteriaBuilder cb = evm.getCriteriaBuilderFactory().deleteCollection(context.getEntityManager(), this.ownerEntityClass, "e", this.mapping);
                    cb.where(this.ownerIdAttributeName).eq(ownerId);
                    cb.executeUpdate();
                }
            }
            return Collections.singletonList(new PostFlushCollectionElementByIdDeleter(this.elementDescriptor.getElementToEntityMapper(), elementIds));
        }
        if (!this.jpaProviderDeletesCollection) {
            DeleteCriteriaBuilder cb = evm.getCriteriaBuilderFactory().deleteCollection(context.getEntityManager(), this.ownerEntityClass, "e", this.mapping);
            cb.where("e." + this.ownerIdAttributeName).eq(ownerId);
            cb.executeUpdate();
        }
        return Collections.emptyList();
    }

    @Override
    public void remove(UpdateContext context, Object id) {
        throw new UnsupportedOperationException("Unsupported!");
    }

    @Override
    public void removeFromEntity(UpdateContext context, E entity) {
        Map value = (Map)this.entityAttributeAccessor.getValue(entity);
        if (value != null) {
            if (this.cascadeDeleteListener != null || this.keyCascadeDeleteListener != null) {
                if (!value.isEmpty()) {
                    for (Map.Entry entry : value.entrySet()) {
                        if (this.keyCascadeDeleteListener != null) {
                            this.keyCascadeDeleteListener.onEntityCollectionRemove(context, entry.getKey());
                        }
                        if (this.cascadeDeleteListener == null) continue;
                        this.cascadeDeleteListener.onEntityCollectionRemove(context, entry.getValue());
                    }
                    this.entityAttributeAccessor.setValue(entity, null);
                }
            } else {
                value.clear();
            }
        }
    }

    @Override
    protected boolean canFlushSeparateCollectionOperations() {
        return true;
    }

    @Override
    public boolean requiresDeleteCascadeAfterRemove() {
        return false;
    }

    @Override
    public boolean isViewOnlyDeleteCascaded() {
        return this.viewOnlyDeleteCascaded;
    }

    protected final <X> X persistOrMergeKey(UpdateContext context, EntityManager em, X object) {
        return this.persistOrMerge(em, object, this.keyDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean mergeAndRequeue(UpdateContext context, RecordingMap recordingCollection, Map<Object, Object> newCollection) {
        EntityManager em = context.getEntityManager();
        HashMap<Object, Object> queuedElements = null;
        ViewToEntityMapper keyMapper = this.mapper.getKeyMapper();
        ViewToEntityMapper valueMapper = this.mapper.getValueMapper();
        boolean flushKey = this.keyDescriptor.shouldJpaPersistOrMerge();
        boolean flushValue = this.elementDescriptor.shouldJpaPersistOrMerge();
        Iterator<Map.Entry<Object, Object>> iter = this.getRecordingIterator(newCollection);
        try {
            while (iter.hasNext()) {
                Map.Entry<Object, Object> entry = iter.next();
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (flushKey) {
                    key = this.persistOrMergeKey(context, em, key);
                } else if (keyMapper != null) {
                    keyMapper.applyToEntity(context, null, key);
                }
                if (flushValue) {
                    value = this.persistOrMerge(em, value);
                } else if (valueMapper != null) {
                    valueMapper.applyToEntity(context, null, value);
                }
                if (key != entry.getKey()) {
                    if (queuedElements == null) {
                        queuedElements = new HashMap<Object, Object>(newCollection.size());
                    }
                    iter.remove();
                    queuedElements.put(key, value);
                    if (recordingCollection == null) continue;
                    recordingCollection.replaceActionElement(entry.getKey(), entry.getValue(), key, value);
                    continue;
                }
                if (value == entry.getValue()) continue;
                entry.setValue(value);
            }
        }
        finally {
            this.resetRecordingIterator(newCollection);
        }
        if (queuedElements != null) {
            newCollection.putAll(queuedElements);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean mergeCollectionElements(UpdateContext context, Object ownerView, Object view, E entity, V value) {
        boolean needsRequeuing;
        if (this.elementFlushers != null) {
            if (this.flushStrategy == FlushStrategy.ENTITY || context.isForceEntity()) {
                for (CollectionElementAttributeFlusher elementFlusher : this.elementFlushers) {
                    elementFlusher.flushEntity(context, entity, ownerView, view, value, null);
                }
            } else {
                for (CollectionElementAttributeFlusher elementFlusher : this.elementFlushers) {
                    elementFlusher.flushQuery(context, null, null, null, ownerView, view, value, null, null);
                }
            }
            return !this.elementFlushers.isEmpty();
        }
        boolean bl = needsRequeuing = this.keyDescriptor.shouldJpaMerge() || value instanceof RecordingMap && this.elementDescriptor.shouldJpaMerge();
        if (needsRequeuing) {
            if (value instanceof RecordingMap) {
                return this.mergeAndRequeue(context, (RecordingMap)value, (Map<Object, Object>)((RecordingMap)value).getDelegate());
            }
            return this.mergeAndRequeue(context, null, (Map<Object, Object>)value);
        }
        EntityManager em = context.getEntityManager();
        ViewToEntityMapper keyMapper = this.mapper.getKeyMapper();
        ViewToEntityMapper valueMapper = this.mapper.getValueMapper();
        boolean flushKey = this.keyDescriptor.shouldJpaPersistOrMerge();
        boolean flushValue = this.elementDescriptor.shouldJpaPersistOrMerge();
        Iterator<Map.Entry<Object, Object>> iter = this.getRecordingIterator((Map<?, ?>)value);
        try {
            while (iter.hasNext()) {
                Map.Entry<Object, Object> entry = iter.next();
                Object k = entry.getKey();
                Object v = entry.getValue();
                if (flushKey) {
                    this.persistOrMergeKey(context, em, k);
                } else if (keyMapper != null) {
                    keyMapper.applyToEntity(context, null, k);
                }
                if (v != null) {
                    if (flushValue) {
                        v = this.persistOrMerge(em, v);
                    } else if (valueMapper != null) {
                        valueMapper.applyToEntity(context, null, v);
                    }
                }
                if (v == entry.getValue()) continue;
                entry.setValue(v);
            }
        }
        finally {
            this.resetRecordingIterator((Map<?, ?>)value);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void replaceCollection(UpdateContext context, Object ownerView, Object view, E entity, V value, FlushStrategy flushStrategy) {
        if (flushStrategy == FlushStrategy.QUERY) {
            Map<Object, Object> removedAllObjects = this.deleteElements(context, ownerView, view, value, false, null, true) ? Collections.emptyMap() : Collections.emptyMap();
            this.addElements(context, ownerView, view, removedAllObjects, true, value, null, null, true);
            this.processRemovedObjects(context, removedAllObjects);
        } else if (this.entityAttributeAccessor != null) {
            if (this.keyDescriptor.isSubview() || this.elementDescriptor.isSubview()) {
                Object newMap;
                if (value == null) {
                    newMap = this.createJpaMap(0);
                } else {
                    newMap = this.createJpaMap(value.size());
                    ViewToEntityMapper keyMapper = this.mapper.getKeyMapper();
                    ViewToEntityMapper valueMapper = this.mapper.getValueMapper();
                    Iterator<Map.Entry<Object, Object>> iter = this.getRecordingIterator((Map<?, ?>)value);
                    try {
                        while (iter.hasNext()) {
                            Map.Entry<Object, Object> entry = iter.next();
                            Object k = entry.getKey();
                            Object v = entry.getValue();
                            if (keyMapper != null) {
                                k = keyMapper.applyToEntity(context, null, k);
                            }
                            if (valueMapper != null) {
                                v = valueMapper.applyToEntity(context, null, v);
                            }
                            newMap.put((Object)k, (Object)v);
                        }
                    }
                    finally {
                        this.resetRecordingIterator((Map<?, ?>)value);
                    }
                }
                this.entityAttributeAccessor.setValue(entity, newMap);
            } else {
                this.entityAttributeAccessor.setValue(entity, value);
            }
        }
    }

    @Override
    public <X> DirtyChecker<X>[] getNestedCheckers(V current) {
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public DirtyChecker.DirtyKind getDirtyKind(V initial, V current) {
        if (current == null) {
            if (initial != null) return DirtyChecker.DirtyKind.UPDATED;
            return DirtyChecker.DirtyKind.NONE;
        }
        if (initial == null) {
            return DirtyChecker.DirtyKind.UPDATED;
        }
        if (initial == current) {
            if (!(current instanceof RecordingMap)) return DirtyChecker.DirtyKind.NONE;
            RecordingMap recordingCollection = (RecordingMap)current;
            if (recordingCollection.hasActions()) {
                return DirtyChecker.DirtyKind.MUTATED;
            }
            if (!this.keyDescriptor.shouldFlushMutations() && !this.elementDescriptor.shouldFlushMutations()) return DirtyChecker.DirtyKind.NONE;
            if (this.keyDescriptor.shouldFlushMutations() && !this.keyDescriptor.supportsDirtyCheck() || this.elementDescriptor.shouldFlushMutations() && !this.elementDescriptor.supportsDirtyCheck()) {
                return DirtyChecker.DirtyKind.MUTATED;
            }
            if (!recordingCollection.$$_isDirty() && (!this.keyDescriptor.shouldFlushMutations() || this.keyDescriptor.shouldFlushMutations() && this.keyDescriptor.isSubview()) && (!this.elementDescriptor.shouldFlushMutations() || this.elementDescriptor.shouldFlushMutations() && this.elementDescriptor.isSubview())) {
                return DirtyChecker.DirtyKind.NONE;
            }
            ViewToEntityMapper keyMapper = this.keyDescriptor.getViewToEntityMapper();
            ViewToEntityMapper valueMapper = this.elementDescriptor.getViewToEntityMapper();
            BasicUserType<Object> keyUserType = this.keyDescriptor.getBasicUserType();
            BasicUserType<Object> valueUserType = this.elementDescriptor.getBasicUserType();
            for (Map.Entry entry : recordingCollection.entrySet()) {
                String[] dirtyProperties;
                DirtyStateTrackable element;
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (this.keyDescriptor.supportsDirtyCheck()) {
                    if (this.keyDescriptor.isSubview()) {
                        if (key instanceof DirtyStateTrackable) {
                            element = (DirtyStateTrackable)key;
                            if (keyMapper.getUpdater(value).getDirtyChecker().getDirtyKind(element, element) == DirtyChecker.DirtyKind.MUTATED) {
                                return DirtyChecker.DirtyKind.MUTATED;
                            }
                        }
                    } else {
                        dirtyProperties = keyUserType.getDirtyProperties(value);
                        if (dirtyProperties != null) {
                            return DirtyChecker.DirtyKind.MUTATED;
                        }
                    }
                }
                if (!this.elementDescriptor.supportsDirtyCheck()) continue;
                if (this.elementDescriptor.isSubview()) {
                    if (!(value instanceof DirtyStateTrackable)) continue;
                    element = (DirtyStateTrackable)value;
                    if (valueMapper.getUpdater(value).getDirtyChecker().getDirtyKind(element, element) != DirtyChecker.DirtyKind.MUTATED) continue;
                    return DirtyChecker.DirtyKind.MUTATED;
                }
                dirtyProperties = valueUserType.getDirtyProperties(value);
                if (dirtyProperties == null) continue;
                return DirtyChecker.DirtyKind.MUTATED;
            }
            return DirtyChecker.DirtyKind.NONE;
        } else {
            if (initial.size() != current.size()) {
                return DirtyChecker.DirtyKind.MUTATED;
            }
            if (!this.keyDescriptor.shouldFlushMutations() && !this.elementDescriptor.shouldFlushMutations()) return this.collectionEquals(initial, current) ? DirtyChecker.DirtyKind.NONE : DirtyChecker.DirtyKind.MUTATED;
            if (this.keyDescriptor.shouldFlushMutations() && !this.keyDescriptor.supportsDirtyCheck() || this.elementDescriptor.shouldFlushMutations() && !this.elementDescriptor.supportsDirtyCheck()) {
                if (this.keyDescriptor.shouldFlushMutations() && !this.keyDescriptor.isSubview() && (!this.keyDescriptor.shouldFlushMutations() || !this.keyDescriptor.getBasicUserType().supportsDeepCloning()) || this.elementDescriptor.shouldFlushMutations() && !this.elementDescriptor.isSubview() && (!this.elementDescriptor.shouldFlushMutations() || !this.elementDescriptor.getBasicUserType().supportsDeepCloning())) return DirtyChecker.DirtyKind.MUTATED;
                return this.collectionEquals(initial, current) ? DirtyChecker.DirtyKind.NONE : DirtyChecker.DirtyKind.MUTATED;
            }
            ViewToEntityMapper keyMapper = this.keyDescriptor.getViewToEntityMapper();
            ViewToEntityMapper valueMapper = this.elementDescriptor.getViewToEntityMapper();
            BasicUserType<Object> keyUserType = this.keyDescriptor.getBasicUserType();
            BasicUserType<Object> valueUserType = this.elementDescriptor.getBasicUserType();
            for (Map.Entry entry : current.entrySet()) {
                String[] dirtyProperties;
                DirtyStateTrackable element;
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (!Objects.equals(initial.get(key), value)) {
                    return DirtyChecker.DirtyKind.MUTATED;
                }
                if (this.keyDescriptor.supportsDirtyCheck()) {
                    if (this.keyDescriptor.isSubview()) {
                        if (key instanceof DirtyStateTrackable) {
                            element = (DirtyStateTrackable)key;
                            if (keyMapper.getUpdater(value).getDirtyChecker().getDirtyKind(element, element) == DirtyChecker.DirtyKind.MUTATED) {
                                return DirtyChecker.DirtyKind.MUTATED;
                            }
                        }
                    } else {
                        dirtyProperties = keyUserType.getDirtyProperties(value);
                        if (dirtyProperties != null) {
                            return DirtyChecker.DirtyKind.MUTATED;
                        }
                    }
                }
                if (!this.elementDescriptor.supportsDirtyCheck()) continue;
                if (this.elementDescriptor.isSubview()) {
                    if (!(value instanceof DirtyStateTrackable)) continue;
                    element = (DirtyStateTrackable)value;
                    if (valueMapper.getUpdater(value).getDirtyChecker().getDirtyKind(element, element) != DirtyChecker.DirtyKind.MUTATED) continue;
                    return DirtyChecker.DirtyKind.MUTATED;
                }
                dirtyProperties = valueUserType.getDirtyProperties(value);
                if (dirtyProperties == null) continue;
                return DirtyChecker.DirtyKind.MUTATED;
            }
        }
        return DirtyChecker.DirtyKind.NONE;
    }

    @Override
    public DirtyChecker<E> getElementDirtyChecker(E element) {
        if (!this.elementDescriptor.shouldFlushMutations()) {
            return null;
        }
        if (this.elementDescriptor.isSubview()) {
            EntityViewUpdater updater = this.elementDescriptor.getViewToEntityMapper().getUpdater(element);
            if (updater == null) {
                throw new IllegalArgumentException("Found unexpected element in plural attribute '" + this.attributeName + "'. The object does not seem to be flushable: " + element);
            }
            return updater.getDirtyChecker();
        }
        if (this.elementDescriptor.isJpaEntity()) {
            return this.elementDescriptor.getEntityToEntityMapper().getDirtyChecker();
        }
        return this.elementDirtyChecker;
    }

    @Override
    public DirtyChecker<Object> getKeyDirtyChecker(Object element) {
        if (!this.keyDescriptor.shouldFlushMutations()) {
            return null;
        }
        if (this.keyDescriptor.isSubview()) {
            EntityViewUpdater updater = this.keyDescriptor.getViewToEntityMapper().getUpdater(element);
            if (updater == null) {
                throw new IllegalArgumentException("Found unexpected key in map attribute '" + this.attributeName + "'. The object does not seem to be flushable: " + element);
            }
            return updater.getDirtyChecker();
        }
        if (this.keyDescriptor.isJpaEntity()) {
            return this.keyDescriptor.getEntityToEntityMapper().getDirtyChecker();
        }
        return this.keyDirtyChecker;
    }

    @Override
    public DirtyAttributeFlusher<MapAttributeFlusher<E, V>, E, V> getDirtyFlusher(UpdateContext context, Object view, Object initial, Object current) {
        if (this.collectionUpdatable) {
            if (initial != current) {
                if (current == null || ((Map)current).isEmpty()) {
                    if (initial != null && ((Map)initial).isEmpty()) {
                        return null;
                    }
                    return this.partialFlusher(false, AbstractPluralAttributeFlusher.PluralFlushOperation.COLLECTION_REPLACE_ONLY, Collections.EMPTY_LIST, Collections.emptyList());
                }
                if (initial == null || initial != null && ((Map)initial).isEmpty()) {
                    return this.partialFlusher(false, AbstractPluralAttributeFlusher.PluralFlushOperation.COLLECTION_REPLACE_ONLY, Collections.EMPTY_LIST, Collections.emptyList());
                }
                if (initial instanceof RecordingCollection) {
                    initial = ((RecordingCollection)initial).getInitialVersion();
                }
                if (this.keyDescriptor.shouldFlushMutations()) {
                    if (this.keyDescriptor.supportsDirtyCheck()) {
                        if (this.elementDescriptor.shouldFlushMutations()) {
                            if (this.elementDescriptor.supportsDirtyCheck()) {
                                return this.determineDirtyFlusherForNewCollection(context, (Map)initial, (Map)current);
                            }
                            if (this.elementDescriptor.supportsDeepEqualityCheck()) {
                                if (this.canFlushSeparateCollectionOperations() && this.elementDescriptor.getBasicUserType() != null && this.elementDescriptor.getBasicUserType().supportsDeepCloning()) {
                                    AbstractPluralAttributeFlusher.EqualityChecker equalityChecker = this.elementDescriptor.isSubview() ? AbstractPluralAttributeFlusher.EqualsEqualityChecker.INSTANCE : new AbstractPluralAttributeFlusher.IdentityEqualityChecker(this.elementDescriptor.getBasicUserType());
                                    List<MapAction<Map<Object, Object>>> actions = initial == null ? this.replaceActions((Map)current) : this.determineCollectionActions(context, (Map)initial, (Map)current, equalityChecker);
                                    if (actions.isEmpty()) {
                                        return null;
                                    }
                                    return this.partialFlusher(true, AbstractPluralAttributeFlusher.PluralFlushOperation.COLLECTION_REPLAY_ONLY, actions, Collections.emptyList());
                                }
                                return this;
                            }
                            if (this.elementDescriptor.isJpaEntity()) {
                                AbstractPluralAttributeFlusher.EqualityChecker equalityChecker = this.elementDescriptor.isSubview() ? AbstractPluralAttributeFlusher.EqualsEqualityChecker.INSTANCE : new AbstractPluralAttributeFlusher.IdentityEqualityChecker(this.elementDescriptor.getBasicUserType());
                                List<MapAction<Map<Object, Object>>> actions = initial == null ? this.replaceActions((Map)current) : this.determineCollectionActions(context, (Map)initial, (Map)current, equalityChecker);
                                return this.partialFlusher(true, AbstractPluralAttributeFlusher.PluralFlushOperation.COLLECTION_REPLAY_AND_ELEMENT, actions, this.getElementFlushers(context, (V)((Map)current), (List<? extends MapAction<?>>)actions));
                            }
                            return this.partialFlusher(false, AbstractPluralAttributeFlusher.PluralFlushOperation.COLLECTION_REPLACE_ONLY, Collections.EMPTY_LIST, Collections.emptyList());
                        }
                        return this.determineDirtyFlusherForNewCollection(context, (Map)initial, (Map)current);
                    }
                    if (this.keyDescriptor.supportsDeepEqualityCheck() || this.keyDescriptor.isJpaEntity()) {
                        return this;
                    }
                    return this.partialFlusher(false, AbstractPluralAttributeFlusher.PluralFlushOperation.COLLECTION_REPLACE_ONLY, Collections.EMPTY_LIST, Collections.emptyList());
                }
                if (this.elementDescriptor.shouldFlushMutations()) {
                    if (this.elementDescriptor.supportsDirtyCheck()) {
                        return this.determineDirtyFlusherForNewCollection(context, (Map)initial, (Map)current);
                    }
                    if (this.elementDescriptor.supportsDeepEqualityCheck()) {
                        if (this.canFlushSeparateCollectionOperations() && this.elementDescriptor.getBasicUserType() != null && this.elementDescriptor.getBasicUserType().supportsDeepCloning()) {
                            AbstractPluralAttributeFlusher.EqualityChecker equalityChecker = this.elementDescriptor.isSubview() ? AbstractPluralAttributeFlusher.EqualsEqualityChecker.INSTANCE : new AbstractPluralAttributeFlusher.IdentityEqualityChecker(this.elementDescriptor.getBasicUserType());
                            List<MapAction<Map<Object, Object>>> actions = initial == null ? this.replaceActions((Map)current) : this.determineCollectionActions(context, (Map)initial, (Map)current, equalityChecker);
                            if (actions.isEmpty()) {
                                return null;
                            }
                            return this.partialFlusher(true, AbstractPluralAttributeFlusher.PluralFlushOperation.COLLECTION_REPLAY_ONLY, actions, Collections.emptyList());
                        }
                        return this;
                    }
                    if (this.elementDescriptor.isJpaEntity()) {
                        AbstractPluralAttributeFlusher.EqualityChecker equalityChecker = this.elementDescriptor.isSubview() ? AbstractPluralAttributeFlusher.EqualsEqualityChecker.INSTANCE : new AbstractPluralAttributeFlusher.IdentityEqualityChecker(this.elementDescriptor.getBasicUserType());
                        List<MapAction<Map<Object, Object>>> actions = initial == null ? this.replaceActions((Map)current) : this.determineCollectionActions(context, (Map)initial, (Map)current, equalityChecker);
                        return this.partialFlusher(true, AbstractPluralAttributeFlusher.PluralFlushOperation.COLLECTION_REPLAY_AND_ELEMENT, actions, this.getElementFlushers(context, (V)((Map)current), (List<? extends MapAction<?>>)actions));
                    }
                    return this.partialFlusher(false, AbstractPluralAttributeFlusher.PluralFlushOperation.COLLECTION_REPLACE_ONLY, Collections.EMPTY_LIST, Collections.emptyList());
                }
                return this.determineDirtyFlusherForNewCollection(context, (Map)initial, (Map)current);
            }
            if (initial != null && !(initial instanceof RecordingMap) && ((Map)initial).isEmpty()) {
                return null;
            }
            if (current instanceof RecordingMap && !((RecordingMap)current).hasActions() && ((RecordingMap)current).isEmpty()) {
                return null;
            }
            if (this.keyDescriptor.shouldFlushMutations()) {
                if (this.keyDescriptor.supportsDirtyCheck()) {
                    if (this.elementDescriptor.shouldFlushMutations()) {
                        if (this.elementDescriptor.supportsDirtyCheck()) {
                            if (current instanceof RecordingMap) {
                                return this.getDirtyFlusherForRecordingCollection(context, (V)((Map)initial), (RecordingMap)current);
                            }
                            return this;
                        }
                        if (this.elementDescriptor.supportsDeepEqualityCheck() || this.elementDescriptor.isJpaEntity()) {
                            if (current instanceof RecordingMap && this.elementDescriptor.isIdentifiable()) {
                                List<MapAction<Object>> actions = ((RecordingMap)current).getActions();
                                if (actions == null) {
                                    actions = Collections.emptyList();
                                }
                                return this.partialFlusher(true, AbstractPluralAttributeFlusher.PluralFlushOperation.COLLECTION_REPLAY_AND_ELEMENT, actions, this.getElementFlushers(context, (V)((Map)current), (List<? extends MapAction<?>>)actions));
                            }
                            return this;
                        }
                        return this.partialFlusher(false, AbstractPluralAttributeFlusher.PluralFlushOperation.COLLECTION_REPLACE_ONLY, Collections.EMPTY_LIST, Collections.emptyList());
                    }
                    if (current instanceof RecordingMap) {
                        return this.getDirtyFlusherForRecordingCollection(context, (V)((Map)initial), (RecordingMap)current);
                    }
                    return this;
                }
                return this;
            }
            if (this.elementDescriptor.shouldFlushMutations()) {
                if (this.elementDescriptor.supportsDirtyCheck()) {
                    if (current instanceof RecordingMap) {
                        return this.getDirtyFlusherForRecordingCollection(context, (V)((Map)initial), (RecordingMap)current);
                    }
                    return this;
                }
                if (this.elementDescriptor.supportsDeepEqualityCheck() || this.elementDescriptor.isJpaEntity()) {
                    if (current instanceof RecordingMap) {
                        List<MapAction<Object>> actions = ((RecordingMap)current).getActions();
                        if (actions == null) {
                            actions = Collections.emptyList();
                        }
                        if (this.elementDescriptor.isIdentifiable()) {
                            return this.partialFlusher(true, AbstractPluralAttributeFlusher.PluralFlushOperation.COLLECTION_REPLAY_AND_ELEMENT, actions, this.getElementFlushers(context, (V)((Map)current), (List<? extends MapAction<?>>)actions));
                        }
                    }
                    return this;
                }
                return this.partialFlusher(false, AbstractPluralAttributeFlusher.PluralFlushOperation.COLLECTION_REPLACE_ONLY, Collections.EMPTY_LIST, Collections.emptyList());
            }
            if (current instanceof RecordingMap) {
                return this.getDirtyFlusherForRecordingCollection(context, (V)((Map)initial), (RecordingMap)current);
            }
            return this;
        }
        if (this.keyDescriptor.shouldFlushMutations() || this.elementDescriptor.shouldFlushMutations()) {
            if (initial != current) {
                return null;
            }
            if (!this.keyDescriptor.isIdentifiable() || !this.elementDescriptor.isIdentifiable()) {
                return this;
            }
            return this.getElementOnlyFlusher(context, (Map)current);
        }
        return null;
    }

    protected DirtyAttributeFlusher<MapAttributeFlusher<E, V>, E, V> determineDirtyFlusherForNewCollection(UpdateContext context, V initial, V current) {
        AbstractPluralAttributeFlusher.EqualityChecker equalityChecker = this.elementDescriptor.isSubview() ? AbstractPluralAttributeFlusher.EqualsEqualityChecker.INSTANCE : new AbstractPluralAttributeFlusher.IdentityEqualityChecker(this.elementDescriptor.getBasicUserType());
        List collectionActions = this.determineCollectionActions(context, initial, current, equalityChecker);
        if (collectionActions.size() == 0) {
            List<CollectionElementAttributeFlusher<E, V>> elementFlushers = this.getElementFlushers(context, current, (List<? extends MapAction<?>>)collectionActions);
            if (elementFlushers == null) {
                return this;
            }
            return this.getReplayAndElementFlusher(context, initial, current, collectionActions, elementFlushers);
        }
        if (initial == null || initial != null && collectionActions.size() > current.size()) {
            if (this.elementDescriptor.shouldFlushMutations()) {
                return this.getReplaceOrMergeAndElementFlusher(context, initial, current);
            }
            return this.getReplaceOrMergeOnlyFlusher(context, initial, current);
        }
        if (initial != null && current instanceof RecordingMap) {
            RecordingMap recordingCollection = (RecordingMap)current;
            recordingCollection.initiateActionsAgainstState(collectionActions, initial);
        }
        if (this.elementDescriptor.shouldFlushMutations()) {
            List<CollectionElementAttributeFlusher<E, V>> elementFlushers = this.getElementFlushers(context, current, (List<? extends MapAction<?>>)collectionActions);
            if (elementFlushers == null) {
                return this;
            }
            return this.getReplayAndElementFlusher(context, initial, current, collectionActions, elementFlushers);
        }
        return this.getReplayOnlyFlusher(context, initial, current, collectionActions);
    }

    protected List<MapAction<Map<Object, Object>>> determineJpaCollectionActions(UpdateContext context, V initial, V current, AbstractPluralAttributeFlusher.EqualityChecker equalityChecker) {
        ArrayList<MapAction<Map<Object, Object>>> actions = new ArrayList<MapAction<Map<Object, Object>>>();
        Map.Entry[] objectsToAdd = current.entrySet().toArray(new Map.Entry[current.size()]);
        if (this.keyDescriptor.isSubview() && this.keyDescriptor.isIdentifiable()) {
            AttributeAccessor entityIdAccessor = this.keyDescriptor.getViewToEntityMapper().getEntityIdAccessor();
            AttributeAccessor subviewIdAccessor = this.keyDescriptor.getViewToEntityMapper().getViewIdAccessor();
            block0: for (Map.Entry entry : initial.entrySet()) {
                Object initialObject = entry.getKey();
                Object initialViewId = entityIdAccessor.getValue(initialObject);
                Object initialElement = MapAttributeFlusher.getViewElement(context, this.elementDescriptor, entry.getValue());
                for (int i = 0; i < objectsToAdd.length; ++i) {
                    Object currentViewId;
                    Map.Entry entryToAdd = objectsToAdd[i];
                    Object currentObject = entryToAdd.getKey();
                    if (currentObject == REMOVED_MARKER || !initialViewId.equals(currentViewId = subviewIdAccessor.getValue(currentObject))) continue;
                    objectsToAdd[i] = REMOVED_MARKER;
                    if (equalityChecker.isEqual(context, entry.getValue(), entryToAdd.getValue())) continue block0;
                    if (this.keyDescriptor.shouldFlushMutations()) {
                        actions.add(new MapRemoveAction(initialObject, initialElement));
                    }
                    actions.add(new MapPutAction(entryToAdd.getKey(), entryToAdd.getValue(), initialElement));
                    continue block0;
                }
                actions.add(new MapRemoveAction(initialObject, initialElement));
            }
        } else {
            BasicUserType<Object> basicUserType = this.keyDescriptor.getBasicUserType();
            block2: for (Map.Entry entry : initial.entrySet()) {
                Object initialObject = entry.getKey();
                Object initialElement = MapAttributeFlusher.getViewElement(context, this.elementDescriptor, entry.getValue());
                for (int i = 0; i < objectsToAdd.length; ++i) {
                    Map.Entry entryToAdd = objectsToAdd[i];
                    Object currentObject = entryToAdd.getKey();
                    if (currentObject == REMOVED_MARKER || !basicUserType.isEqual(initialObject, currentObject)) continue;
                    objectsToAdd[i] = REMOVED_MARKER;
                    if (equalityChecker.isEqual(context, entry.getValue(), entryToAdd.getValue())) continue block2;
                    if (this.keyDescriptor.shouldFlushMutations()) {
                        actions.add(new MapRemoveAction(initialObject, initialElement));
                    }
                    actions.add(new MapPutAction(entryToAdd.getKey(), entryToAdd.getValue(), initialElement));
                    continue block2;
                }
                actions.add(new MapRemoveAction(initialObject, initialElement));
            }
        }
        for (int i = 0; i < objectsToAdd.length; ++i) {
            Map.Entry currentObject = objectsToAdd[i];
            if (currentObject == REMOVED_MARKER) continue;
            Object initialElement = MapAttributeFlusher.getViewElement(context, this.elementDescriptor, initial.get(currentObject.getKey()));
            actions.add(new MapPutAction(currentObject.getKey(), currentObject.getValue(), initialElement));
        }
        return actions;
    }

    protected List<MapAction<Map<Object, Object>>> determineCollectionActions(UpdateContext context, V initial, V current, AbstractPluralAttributeFlusher.EqualityChecker equalityChecker) {
        ArrayList<MapAction<Map<Object, Object>>> actions = new ArrayList<MapAction<Map<Object, Object>>>();
        Map.Entry[] objectsToAdd = current.entrySet().toArray(new Map.Entry[current.size()]);
        if (initial != null && !initial.isEmpty()) {
            Object initialObject;
            if (this.keyDescriptor.isSubview() && this.keyDescriptor.isIdentifiable()) {
                AttributeAccessor subviewIdAccessor = this.keyDescriptor.getViewToEntityMapper().getViewIdAccessor();
                block0: for (Map.Entry entry : initial.entrySet()) {
                    initialObject = entry.getKey();
                    Object initialViewId = subviewIdAccessor.getValue(initialObject);
                    for (int i = 0; i < objectsToAdd.length; ++i) {
                        Object currentViewId;
                        Map.Entry entryToAdd = objectsToAdd[i];
                        Object currentObject = entryToAdd.getKey();
                        if (currentObject == REMOVED_MARKER || !initialViewId.equals(currentViewId = subviewIdAccessor.getValue(currentObject))) continue;
                        objectsToAdd[i] = REMOVED_MARKER;
                        if (equalityChecker.isEqual(context, entry.getValue(), entryToAdd.getValue())) continue block0;
                        if (this.keyDescriptor.shouldFlushMutations()) {
                            actions.add(new MapRemoveAction(initialObject, initial));
                        }
                        actions.add(new MapPutAction(entryToAdd.getKey(), entryToAdd.getValue(), initial));
                        continue block0;
                    }
                    actions.add(new MapRemoveAction(initialObject, initial));
                }
            } else {
                BasicUserType<Object> basicUserType = this.keyDescriptor.getBasicUserType();
                block2: for (Map.Entry entry : initial.entrySet()) {
                    initialObject = entry.getKey();
                    for (int i = 0; i < objectsToAdd.length; ++i) {
                        Map.Entry entryToAdd = objectsToAdd[i];
                        Object currentObject = entryToAdd.getKey();
                        if (currentObject == REMOVED_MARKER || !basicUserType.isEqual(initialObject, currentObject)) continue;
                        objectsToAdd[i] = REMOVED_MARKER;
                        if (equalityChecker.isEqual(context, entry.getValue(), entryToAdd.getValue())) continue block2;
                        if (this.keyDescriptor.shouldFlushMutations()) {
                            actions.add(new MapRemoveAction(initialObject, initial));
                        }
                        actions.add(new MapPutAction(entryToAdd.getKey(), entryToAdd.getValue(), initial));
                        continue block2;
                    }
                    actions.add(new MapRemoveAction(initialObject, initial));
                }
            }
        }
        for (int i = 0; i < objectsToAdd.length; ++i) {
            Map.Entry currentObject = objectsToAdd[i];
            if (currentObject == REMOVED_MARKER) continue;
            actions.add(new MapPutAction(currentObject.getKey(), currentObject.getValue(), initial));
        }
        return actions;
    }

    @Override
    protected CollectionElementAttributeFlusher<E, V> createPersistFlusher(TypeDescriptor typeDescriptor, Object element) {
        return new PersistCollectionElementAttributeFlusher(element, this.optimisticLockProtected);
    }

    @Override
    protected CollectionElementAttributeFlusher<E, V> createMergeFlusher(TypeDescriptor typeDescriptor, Object element) {
        if (typeDescriptor == this.keyDescriptor) {
            return new MergeMapKeyAttributeFlusher(element, this.optimisticLockProtected);
        }
        return new MergeMapValueAttributeFlusher(element, this.optimisticLockProtected);
    }

    @Override
    protected List<CollectionElementAttributeFlusher<E, V>> getElementFlushers(UpdateContext context, V current, List<? extends MapAction<?>> actions) {
        ArrayList elementFlushers = new ArrayList();
        if (this.determineElementFlushers(context, this.keyDescriptor, elementFlushers, current.keySet(), actions, current)) {
            return null;
        }
        if (this.determineElementFlushers(context, this.elementDescriptor, elementFlushers, current.values(), actions, current)) {
            return null;
        }
        return elementFlushers;
    }

    protected MapAttributeFlusher<E, V> partialFlusher(boolean fetch, AbstractPluralAttributeFlusher.PluralFlushOperation operation, List<? extends MapAction<?>> collectionActions, List<CollectionElementAttributeFlusher<E, V>> elementFlushers) {
        return new MapAttributeFlusher<E, V>(this, fetch, operation, collectionActions, elementFlushers);
    }

    @Override
    protected boolean collectionEquals(V initial, V current) {
        if (initial == null || initial.size() != current.size()) {
            return false;
        }
        return initial.equals(current);
    }

    @Override
    protected DirtyAttributeFlusher<MapAttributeFlusher<E, V>, E, V> getDirtyFlusherForRecordingCollection(UpdateContext context, V initial, RecordingMap<?, ?, ?> collection) {
        if (collection.hasActions()) {
            List<MapAction<?>> actions = collection.getActions();
            if (this.keyDescriptor.shouldFlushMutations() && !this.keyDescriptor.isIdentifiable()) {
                return this;
            }
            if (this.elementDescriptor.shouldFlushMutations()) {
                List elementFlushers;
                if (this.elementDescriptor.isBasic()) {
                    return this;
                }
                if (this.elementDescriptor.isSubview() && this.elementDescriptor.supportsDirtyCheck() && !this.elementDescriptor.isIdentifiable() && this.isIndexed()) {
                    actions = new ArrayList(actions);
                }
                if ((elementFlushers = this.getElementFlushers(context, (V)collection, (List<? extends MapAction<?>>)actions)) == null) {
                    return this;
                }
                return this.getReplayAndElementFlusher(context, initial, collection, actions, elementFlushers);
            }
            return this.getReplayOnlyFlusher(context, initial, collection, actions);
        }
        if (this.keyDescriptor.shouldFlushMutations() || this.elementDescriptor.shouldFlushMutations()) {
            if (this.keyDescriptor.shouldFlushMutations() && this.keyDescriptor.isBasic() || this.elementDescriptor.shouldFlushMutations() && this.elementDescriptor.isBasic()) {
                return this;
            }
            return this.getElementOnlyFlusher(context, collection);
        }
        return null;
    }

    protected FusedMapActions getFusedOperations(List<? extends MapAction<?>> collectionActions) {
        return new FusedMapActions(this.keyDescriptor.getLoadOnlyViewToEntityMapper(), collectionActions);
    }
}

