/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl;

import com.blazebit.persistence.parser.EntityMetamodel;
import com.blazebit.persistence.parser.expression.ArrayExpression;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.FunctionExpression;
import com.blazebit.persistence.parser.expression.PathExpression;
import com.blazebit.persistence.parser.expression.PropertyExpression;
import com.blazebit.persistence.parser.expression.VisitorAdapter;
import com.blazebit.persistence.parser.predicate.IsEmptyPredicate;
import com.blazebit.persistence.parser.predicate.MemberOfPredicate;
import com.blazebit.persistence.parser.util.ExpressionUtils;
import com.blazebit.persistence.parser.util.JpaMetamodelUtils;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.PluralAttribute;

public class CollectionJoinMappingGathererExpressionVisitor
extends VisitorAdapter {
    private final EntityMetamodel metamodel;
    private final ManagedType<?> managedType;
    private final List<String> paths;

    public CollectionJoinMappingGathererExpressionVisitor(ManagedType<?> managedType, EntityMetamodel metamodel) {
        this.metamodel = metamodel;
        this.managedType = managedType;
        this.paths = new ArrayList<String>();
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public void visit(PropertyExpression expression) {
        throw new UnsupportedOperationException("This method should never be called!");
    }

    public void visit(PathExpression expression) {
        List expressions = expression.getExpressions();
        int size = expressions.size();
        StringBuilder sb = new StringBuilder(size * 10);
        ManagedType t = this.managedType;
        Attribute jpaAttribute = null;
        for (int i = 0; i < size; ++i) {
            Expression e = (Expression)expressions.get(i);
            if (e instanceof ArrayExpression) {
                ArrayExpression arrayExpression = (ArrayExpression)e;
                arrayExpression.getIndex().accept((Expression.Visitor)this);
                continue;
            }
            String baseName = e.toString();
            if (i != 0) {
                sb.append('.');
            }
            sb.append(e.toString());
            try {
                jpaAttribute = t.getAttribute(baseName);
            }
            catch (IllegalArgumentException ex) {
                jpaAttribute = null;
            }
            if (jpaAttribute == null) continue;
            t = this.metamodel.getManagedType(JpaMetamodelUtils.resolveFieldClass((Class)t.getJavaType(), (Attribute)jpaAttribute));
            if (!(jpaAttribute instanceof PluralAttribute)) continue;
            this.paths.add(sb.toString());
        }
        if (jpaAttribute instanceof PluralAttribute) {
            this.paths.add(sb.toString());
        }
    }

    public void visit(IsEmptyPredicate predicate) {
    }

    public void visit(MemberOfPredicate predicate) {
    }

    public void visit(FunctionExpression expression) {
        if (!ExpressionUtils.isSizeFunction((FunctionExpression)expression)) {
            super.visit(expression);
        }
    }
}

