/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.collection;

import com.blazebit.persistence.view.impl.collection.RecordingMap;
import java.util.Iterator;
import java.util.Map;

public class RecordingValuesIterator<E>
implements Iterator<E> {
    private final RecordingMap<Map<?, E>, ?, E> recordingMap;
    private final Iterator<Map.Entry<?, E>> iterator;
    private Object current;

    public RecordingValuesIterator(RecordingMap<? extends Map<?, E>, ?, E> recordingMap) {
        this.recordingMap = recordingMap;
        this.iterator = recordingMap.delegate.entrySet().iterator();
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public E next() {
        Map.Entry<?, E> entry = this.iterator.next();
        this.current = entry.getKey();
        return entry.getValue();
    }

    @Override
    public void remove() {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        this.recordingMap.addRemoveAction(this.current);
        this.iterator.remove();
        this.current = null;
    }
}

