/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.mapper;

import com.blazebit.persistence.ObjectBuilder;
import com.blazebit.persistence.view.EntityViewManager;
import com.blazebit.persistence.view.impl.accessor.AttributeAccessor;
import com.blazebit.persistence.view.impl.entity.EntityTupleizer;
import com.blazebit.persistence.view.impl.mapper.Mapper;

public class ReferenceViewAttributeMapper<S, T>
implements Mapper<S, T> {
    private final EntityViewManager evm;
    private final AttributeAccessor entityAccessor;
    private final EntityTupleizer entityTupleizer;
    private final Class<?> entityViewClass;
    private final AttributeAccessor viewAccessor;
    private final ObjectBuilder<?> idViewBuilder;

    public ReferenceViewAttributeMapper(EntityViewManager evm, AttributeAccessor entityAccessor, Class<?> entityViewClass, EntityTupleizer entityTupleizer, AttributeAccessor viewAccessor, ObjectBuilder<?> idViewBuilder) {
        this.evm = evm;
        this.entityAccessor = entityAccessor;
        this.entityViewClass = entityViewClass;
        this.entityTupleizer = entityTupleizer;
        this.viewAccessor = viewAccessor;
        this.idViewBuilder = idViewBuilder;
    }

    @Override
    public void map(S source, T target) {
        Object id = this.entityAccessor.getValue(source);
        if (this.idViewBuilder != null) {
            id = this.idViewBuilder.build(this.entityTupleizer.tupleize(id));
        }
        this.viewAccessor.setValue(target, this.evm.getReference(this.entityViewClass, id));
    }
}

