/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.objectbuilder.mapper;

import com.blazebit.persistence.parser.EntityMetamodel;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionFactory;
import com.blazebit.persistence.parser.util.JpaMetamodelUtils;
import com.blazebit.persistence.spi.ServiceProvider;
import com.blazebit.persistence.view.impl.ExpressionUtils;
import com.blazebit.persistence.view.impl.PrefixingQueryGenerator;
import com.blazebit.persistence.view.impl.metamodel.AbstractAttribute;
import com.blazebit.persistence.view.impl.objectbuilder.SecondaryMapper;
import com.blazebit.persistence.view.impl.objectbuilder.mapper.ExpressionTupleElementMapper;
import com.blazebit.persistence.view.impl.objectbuilder.mapper.TupleElementMapper;
import com.blazebit.persistence.view.impl.objectbuilder.transformator.TupleTransformatorFactory;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.TupleListTransformer;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.TupleListTransformerFactory;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.TupleTransformerFactory;
import com.blazebit.persistence.view.metamodel.Attribute;
import com.blazebit.persistence.view.metamodel.ListAttribute;
import com.blazebit.persistence.view.metamodel.MapAttribute;
import com.blazebit.persistence.view.metamodel.MappingAttribute;
import com.blazebit.persistence.view.metamodel.MethodAttribute;
import com.blazebit.persistence.view.metamodel.ParameterAttribute;
import com.blazebit.persistence.view.metamodel.SubqueryAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;

public class TupleElementMapperBuilder
implements ServiceProvider {
    private static final ExpressionTupleElementMapper NULL_MAPPER = new ExpressionTupleElementMapper(null, "NULL", null, null, null, new String[0]);
    private final int mapperIndex;
    private final String aliasPrefix;
    private final String mappingPrefix;
    private final String idPrefix;
    private final Map<String, Type<?>> rootTypes;
    private final EntityMetamodel metamodel;
    private final ExpressionFactory ef;
    private final String constraint;
    private final Integer subtypeIndex;
    private final List<TupleElementMapper> mappers;
    private final List<String> parameterMappings;
    private final List<SecondaryMapper> secondaryMapper;
    private final TupleTransformatorFactory tupleTransformatorFactory;

    public TupleElementMapperBuilder(int mapperIndex, String constraint, Integer subtypeIndex, String aliasPrefix, String mappingPrefix, String idPrefix, EntityType<?> treatType, EntityMetamodel metamodel, ExpressionFactory ef, Map<String, Type<?>> rootTypes) {
        this(mapperIndex, constraint, subtypeIndex, aliasPrefix, mappingPrefix, idPrefix, treatType, metamodel, ef, new ArrayList<TupleElementMapper>(), new ArrayList<String>(), new ArrayList<SecondaryMapper>(), new TupleTransformatorFactory(), rootTypes);
    }

    public TupleElementMapperBuilder(int mapperIndex, String constraint, Integer subtypeIndex, String aliasPrefix, String mappingPrefix, String idPrefix, EntityType<?> treatType, EntityMetamodel metamodel, ExpressionFactory ef, List<TupleElementMapper> mappers, List<String> parameterMappings, List<SecondaryMapper> secondaryMapper, TupleTransformatorFactory tupleTransformatorFactory, Map<String, Type<?>> rootTypes) {
        this.mapperIndex = mapperIndex;
        this.constraint = constraint;
        this.subtypeIndex = subtypeIndex;
        this.aliasPrefix = aliasPrefix;
        this.mappingPrefix = treatType != null ? "TREAT(" + mappingPrefix + " AS " + treatType.getName() + ")" : mappingPrefix;
        this.idPrefix = idPrefix;
        this.rootTypes = rootTypes;
        this.metamodel = metamodel;
        this.ef = ef;
        this.mappers = mappers;
        this.parameterMappings = parameterMappings;
        this.secondaryMapper = secondaryMapper;
        this.tupleTransformatorFactory = tupleTransformatorFactory;
    }

    public <T> T getService(Class<T> serviceClass) {
        if (serviceClass == ExpressionFactory.class) {
            return (T)this.ef;
        }
        return null;
    }

    public String constraint() {
        return this.constraint;
    }

    public int mapperIndex() {
        return this.mapperIndex + this.mappers.size();
    }

    public void addMapper(TupleElementMapper mapper) {
        this.mappers.add(mapper);
        this.parameterMappings.add(null);
    }

    public void addMappers(TupleElementMapper[] mappers) {
        Collections.addAll(this.mappers, mappers);
        for (int i = 0; i < mappers.length; ++i) {
            this.parameterMappings.add(null);
        }
    }

    public List<TupleElementMapper> getMappers() {
        return this.mappers;
    }

    public void addQueryParam(String paramName) {
        this.mappers.add(NULL_MAPPER);
        this.parameterMappings.add(paramName);
    }

    public void addSecondaryMapper(SecondaryMapper mapper) {
        this.secondaryMapper.add(mapper);
    }

    public void addSecondaryMappers(SecondaryMapper[] mappers) {
        Collections.addAll(this.secondaryMapper, mappers);
    }

    public String getAlias(String attributeName) {
        return this.getAlias(this.aliasPrefix, attributeName);
    }

    private String getAlias(String prefix, String attributeName) {
        if (prefix == null) {
            return attributeName.intern();
        }
        return (prefix + "_" + attributeName).intern();
    }

    public String getAlias(Attribute<?, ?> attribute, boolean isKey) {
        return this.getAlias(this.aliasPrefix, attribute, isKey);
    }

    private String getAlias(String prefix, Attribute<?, ?> attribute, boolean isKey) {
        if (isKey) {
            prefix = prefix + "_key";
        }
        if (attribute instanceof MethodAttribute) {
            return this.getAlias(prefix, ((MethodAttribute)attribute).getName());
        }
        return this.getAlias(prefix, "$" + ((ParameterAttribute)attribute).getIndex());
    }

    public String getMapping(Expression expression, Class<?> expressionType) {
        Set idAttributes;
        if (expressionType == null) {
            return this.getMapping(expression);
        }
        ManagedType managedType = this.metamodel.getManagedType(expressionType);
        if (managedType == null || !JpaMetamodelUtils.isIdentifiable((ManagedType)managedType) || (idAttributes = JpaMetamodelUtils.getIdAttributes((IdentifiableType)((IdentifiableType)managedType))).size() > 1) {
            return this.getMapping(expression);
        }
        SingularAttribute idAttr = (SingularAttribute)idAttributes.iterator().next();
        if (ExpressionUtils.isEmptyOrThis(expression)) {
            return this.getMapping(this.mappingPrefix, idAttr.getName());
        }
        return this.getMapping(expression) + '.' + idAttr.getName();
    }

    public String getMapping() {
        return this.mappingPrefix;
    }

    public String getMapping(String mapping) {
        return this.getMapping(this.mappingPrefix, mapping);
    }

    public String getMapping(SubqueryAttribute<?, ?> subqueryAttribute) {
        StringBuilder sb = new StringBuilder();
        subqueryAttribute.renderSubqueryExpression(this.mappingPrefix, (ServiceProvider)this, sb);
        return sb.toString().intern();
    }

    public String getMapping(Expression expression) {
        StringBuilder sb = new StringBuilder();
        if (this.mappingPrefix != null && !this.mappingPrefix.isEmpty()) {
            PrefixingQueryGenerator generator = new PrefixingQueryGenerator(this.ef, this.mappingPrefix, null, null, this.rootTypes.keySet(), true, false);
            generator.setQueryBuffer(sb);
            expression.accept((Expression.Visitor)generator);
        } else {
            sb.append(expression);
        }
        return sb.toString().intern();
    }

    private String getMapping(String prefixParts, String mapping) {
        StringBuilder sb = new StringBuilder();
        this.applyMapping(sb, prefixParts, mapping);
        return sb.toString().intern();
    }

    private void applyMapping(StringBuilder sb, String prefixParts, String mapping) {
        if (mapping.isEmpty()) {
            if (prefixParts != null && !prefixParts.isEmpty()) {
                sb.append(AbstractAttribute.stripThisFromMapping(prefixParts));
            }
            return;
        }
        if (prefixParts != null && !prefixParts.isEmpty()) {
            Expression expr = this.ef.createSimpleExpression(mapping, false, false, true);
            PrefixingQueryGenerator generator = new PrefixingQueryGenerator(this.ef, prefixParts, null, null, this.rootTypes.keySet(), true, false);
            generator.setQueryBuffer(sb);
            expr.accept((Expression.Visitor)generator);
        } else {
            sb.append(mapping);
        }
    }

    public String getIdMapping(MappingAttribute<?, ?> mappingAttribute) {
        return this.getMapping(this.idPrefix, mappingAttribute);
    }

    public String getMapping(MappingAttribute<?, ?> mappingAttribute) {
        return this.getMapping(this.mappingPrefix, mappingAttribute);
    }

    public String getKeyMapping(MapAttribute<?, ?, ?> mappingAttribute) {
        return this.getKeyMapping(this.getMapping((MappingAttribute)mappingAttribute), mappingAttribute);
    }

    public String getKeyMapping(String prefix, MapAttribute<?, ?, ?> mappingAttribute) {
        StringBuilder sb = new StringBuilder();
        mappingAttribute.renderKeyMapping(prefix, (ServiceProvider)this, sb);
        return sb.toString().intern();
    }

    public String getIndexMapping(ListAttribute<?, ?> mappingAttribute) {
        return this.getIndexMapping(this.getMapping((MappingAttribute)mappingAttribute), mappingAttribute);
    }

    public String getIndexMapping(String prefix, ListAttribute<?, ?> mappingAttribute) {
        StringBuilder sb = new StringBuilder();
        mappingAttribute.renderIndexMapping(prefix, (ServiceProvider)this, sb);
        return sb.toString().intern();
    }

    private String getMapping(String prefixParts, MappingAttribute<?, ?> mappingAttribute) {
        StringBuilder sb = new StringBuilder();
        mappingAttribute.renderMapping(prefixParts, (ServiceProvider)this, sb);
        return sb.toString().intern();
    }

    public String getJoinCorrelationAttributePath(String attributePath) {
        if (this.subtypeIndex == null) {
            return attributePath;
        }
        return attributePath + '_' + this.subtypeIndex;
    }

    public TupleTransformatorFactory getTupleTransformatorFactory() {
        return this.tupleTransformatorFactory;
    }

    public void addTupleListTransformer(TupleListTransformer tupleListTransformer) {
        this.tupleTransformatorFactory.add(tupleListTransformer);
    }

    public void addTupleListTransformerFactory(TupleListTransformerFactory tupleListTransformerFactory) {
        this.tupleTransformatorFactory.add(tupleListTransformerFactory);
    }

    public void addTupleTransformerFactory(TupleTransformerFactory tupleTransformerFactory) {
        this.tupleTransformatorFactory.add(tupleTransformerFactory);
    }

    public void addTupleTransformatorFactory(TupleTransformatorFactory tupleTransformatorFactory) {
        this.tupleTransformatorFactory.add(tupleTransformatorFactory);
    }
}

