/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.update;

import com.blazebit.persistence.view.ConvertOption;
import com.blazebit.persistence.view.FlushOperationBuilder;
import com.blazebit.persistence.view.PostCommitListener;
import com.blazebit.persistence.view.PostPersistEntityListener;
import com.blazebit.persistence.view.PostPersistListener;
import com.blazebit.persistence.view.PostRemoveListener;
import com.blazebit.persistence.view.PostRollbackListener;
import com.blazebit.persistence.view.PostUpdateListener;
import com.blazebit.persistence.view.PrePersistEntityListener;
import com.blazebit.persistence.view.PrePersistListener;
import com.blazebit.persistence.view.PreRemoveListener;
import com.blazebit.persistence.view.PreUpdateListener;
import com.blazebit.persistence.view.ViewAndEntityListener;
import com.blazebit.persistence.view.ViewListener;
import com.blazebit.persistence.view.ViewTransition;
import com.blazebit.persistence.view.ViewTransitionListener;
import com.blazebit.persistence.view.impl.EntityViewManagerImpl;
import com.blazebit.persistence.view.impl.metamodel.ManagedViewTypeImplementor;
import com.blazebit.persistence.view.impl.tx.TransactionHelper;
import com.blazebit.persistence.view.impl.update.InitialStateResetter;
import com.blazebit.persistence.view.impl.update.ListenerManager;
import com.blazebit.persistence.view.impl.update.ResetInitialStateSynchronization;
import com.blazebit.persistence.view.impl.update.UpdateContext;
import com.blazebit.persistence.view.impl.update.flush.PostFlushDeleter;
import com.blazebit.persistence.view.impl.update.listener.ViewAndEntityPostPersistListenerImpl;
import com.blazebit.persistence.view.impl.update.listener.ViewAndEntityPrePersistListenerImpl;
import com.blazebit.persistence.view.impl.update.listener.ViewPostCommitListenerImpl;
import com.blazebit.persistence.view.impl.update.listener.ViewPostPersistListenerImpl;
import com.blazebit.persistence.view.impl.update.listener.ViewPostRemoveListenerImpl;
import com.blazebit.persistence.view.impl.update.listener.ViewPostRollbackListenerImpl;
import com.blazebit.persistence.view.impl.update.listener.ViewPostUpdateListenerImpl;
import com.blazebit.persistence.view.impl.update.listener.ViewPrePersistListenerImpl;
import com.blazebit.persistence.view.impl.update.listener.ViewPreRemoveListenerImpl;
import com.blazebit.persistence.view.impl.update.listener.ViewPreUpdateListenerImpl;
import com.blazebit.persistence.view.impl.update.listener.ViewTransitionPostCommitListenerImpl;
import com.blazebit.persistence.view.impl.update.listener.ViewTransitionPostRollbackListenerImpl;
import com.blazebit.persistence.view.metamodel.ManagedViewType;
import com.blazebit.persistence.view.spi.TransactionAccess;
import com.blazebit.persistence.view.spi.type.EntityViewProxy;
import com.blazebit.persistence.view.spi.type.MutableStateTrackable;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.transaction.Synchronization;

public class DefaultUpdateContext
implements UpdateContext,
FlushOperationBuilder {
    private static final Set<ViewTransition> VIEW_TRANSITIONS = EnumSet.allOf(ViewTransition.class);
    private final EntityViewManagerImpl evm;
    private final EntityManager em;
    private final boolean forceFull;
    private final boolean forceEntity;
    private final boolean remove;
    private final Class<?> entityViewClass;
    private final Object object;
    private final Object entity;
    private final TransactionAccess transactionAccess;
    private final InitialStateResetter initialStateResetter;
    private final ListenerManager listenerManager;
    private Map<Object, Object> removedObjects;
    private Map<EntityKey, List<ViewCacheEntry>> viewCache;
    private Set<EntityKey> versionChecked;
    private List<PostFlushDeleter> orphanRemovalDeleters = new ArrayList<PostFlushDeleter>();

    public DefaultUpdateContext(EntityViewManagerImpl evm, EntityManager em, boolean forceFull, boolean forceEntity, boolean remove, Class<?> entityViewClass, Object object, Object entity) {
        this.evm = evm;
        this.em = em;
        this.forceFull = forceFull;
        this.transactionAccess = TransactionHelper.getTransactionAccess(em);
        this.forceEntity = forceEntity;
        this.remove = remove;
        this.entityViewClass = entityViewClass;
        this.object = object;
        this.entity = entity;
        if (!this.transactionAccess.isActive()) {
            throw new IllegalStateException("Transaction is not active!");
        }
        this.listenerManager = new ListenerManager(evm);
        this.initialStateResetter = new ResetInitialStateSynchronization(this, this.listenerManager);
        this.transactionAccess.registerSynchronization((Synchronization)this.initialStateResetter);
    }

    @Override
    public EntityViewManagerImpl getEntityViewManager() {
        return this.evm;
    }

    @Override
    public EntityManager getEntityManager() {
        return this.em;
    }

    @Override
    public boolean containsEntity(Class<?> entityClass, Object id) {
        return this.evm.getJpaProvider().containsEntity(this.em, entityClass, id);
    }

    @Override
    public EntityViewProxy getEntityView(Class<?> viewType, Class<?> entityClass, Object o, boolean convertOnly, boolean prePhase) {
        return this.getEntityView(viewType, entityClass, o, convertOnly, prePhase, this.em);
    }

    @Override
    public EntityViewProxy getEntityView(Class<?> viewType, Class<?> entityClass, Object o, boolean convertOnly, boolean prePhase, EntityManager em) {
        EntityKey entityKey;
        List<ViewCacheEntry> cachedViews;
        Object entityId;
        EntityViewProxy view;
        if (o instanceof EntityViewProxy) {
            view = (EntityViewProxy)o;
            entityId = this.evm.getEntityId(this.em, view);
            entityClass = view.$$_getJpaManagedClass();
        } else {
            view = null;
            entityId = o;
        }
        if (this.viewCache == null) {
            this.viewCache = new HashMap<EntityKey, List<ViewCacheEntry>>();
        }
        if ((cachedViews = this.viewCache.get(entityKey = new EntityKey(entityClass, entityId))) == null) {
            cachedViews = new ArrayList<ViewCacheEntry>();
            this.viewCache.put(entityKey, cachedViews);
        } else {
            Map<Class<?>, Set<Class<?>>> convertibleManagedViewTypes = this.evm.getConvertibleManagedViewTypes();
            EntityViewProxy conversionCandidate = null;
            for (ViewCacheEntry entry : cachedViews) {
                if (prePhase != entry.fromPrePhase) continue;
                if (viewType.isInstance(entry.view)) {
                    return entry.view;
                }
                if (conversionCandidate != null || !convertibleManagedViewTypes.get(entry.view.$$_getEntityViewClass()).contains(viewType)) continue;
                conversionCandidate = entry.view;
            }
            if (conversionCandidate != null) {
                conversionCandidate = (EntityViewProxy)this.evm.convert(conversionCandidate, viewType, new ConvertOption[0]);
                cachedViews.add(new ViewCacheEntry(conversionCandidate, prePhase));
                return conversionCandidate;
            }
        }
        if (view != null && this.evm.getConvertibleManagedViewTypes().get(view.$$_getEntityViewClass()).contains(viewType)) {
            view = (EntityViewProxy)this.evm.convert((Object)view, viewType, new ConvertOption[0]);
            cachedViews.add(new ViewCacheEntry(view, prePhase));
            return view;
        }
        if (convertOnly) {
            return null;
        }
        view = (EntityViewProxy)this.evm.find(em, viewType, entityId);
        cachedViews.add(new ViewCacheEntry(view, prePhase));
        return view;
    }

    @Override
    public boolean hasRemoveListeners(Class<?> entityClass) {
        return this.listenerManager.hasRemoveListeners(entityClass);
    }

    @Override
    public boolean hasPossiblyCancellingRemoveListeners(Class<?> elementEntityClass) {
        return this.listenerManager.hasPossiblyCancellingRemoveListeners(elementEntityClass);
    }

    @Override
    public boolean isForceFull() {
        return this.forceFull;
    }

    @Override
    public boolean isForceEntity() {
        return this.forceEntity;
    }

    @Override
    public boolean addVersionCheck(Class<?> entityClass, Object id) {
        if (this.versionChecked == null) {
            this.versionChecked = new HashSet<EntityKey>();
        }
        return this.versionChecked.add(new EntityKey(entityClass, id));
    }

    @Override
    public boolean addRemovedObject(Object value) {
        if (this.removedObjects == null) {
            this.removedObjects = new IdentityHashMap<Object, Object>();
        }
        return this.removedObjects.put(value, value) == null;
    }

    @Override
    public void removeRemovedObject(Object value) {
        this.removedObjects.remove(value);
    }

    @Override
    public boolean isRemovedObject(Object value) {
        return this.removedObjects != null && this.removedObjects.containsKey(value);
    }

    @Override
    public TransactionAccess getTransactionAccess() {
        return this.transactionAccess;
    }

    @Override
    public InitialStateResetter getInitialStateResetter() {
        return this.initialStateResetter;
    }

    @Override
    public List<PostFlushDeleter> getOrphanRemovalDeleters() {
        return this.orphanRemovalDeleters;
    }

    @Override
    public void removeOrphans(int orphanRemovalStartIndex) {
        for (int i = orphanRemovalStartIndex; i < this.orphanRemovalDeleters.size(); ++i) {
            PostFlushDeleter postFlushDeleter = this.orphanRemovalDeleters.get(i);
            postFlushDeleter.execute(this);
        }
    }

    @Override
    public void invokePrePersist(MutableStateTrackable updatableProxy, Object entity) {
        this.listenerManager.invokePrePersist(this, updatableProxy, entity);
    }

    @Override
    public void invokePostPersist(MutableStateTrackable updatableProxy, Object entity) {
        this.listenerManager.invokePostPersist(this, updatableProxy, entity);
    }

    @Override
    public boolean invokePreUpdate(MutableStateTrackable updatableProxy) {
        return this.listenerManager.invokePreUpdate(this, updatableProxy);
    }

    @Override
    public void invokePostUpdate(MutableStateTrackable updatableProxy) {
        this.listenerManager.invokePostUpdate(this, updatableProxy);
    }

    @Override
    public boolean invokePreRemove(EntityViewProxy entityViewProxy) {
        return this.listenerManager.invokePreRemove(this, entityViewProxy, null, null);
    }

    @Override
    public boolean invokePreRemove(Class<?> entityClass, Object entityId) {
        return this.listenerManager.invokePreRemove(this, null, entityClass, entityId);
    }

    @Override
    public void invokePostRemove(EntityViewProxy entityView) {
        this.listenerManager.invokePostRemove(this, entityView, null, null);
    }

    @Override
    public void invokePostRemove(Class<?> entityClass, Object entityId) {
        this.listenerManager.invokePostRemove(this, null, entityClass, entityId);
    }

    public FlushOperationBuilder onPrePersist(PrePersistListener<?> listener) {
        ManagedViewType<?> managedView = this.evm.getListenerManagedView(listener.getClass(), PrePersistListener.class);
        this.listenerManager.onPrePersist(managedView, managedView.getEntityClass(), listener);
        return this;
    }

    public FlushOperationBuilder onPrePersist(PrePersistEntityListener<?, ?> listener) {
        ManagedViewType<?> managedView = this.evm.getListenerManagedView(listener.getClass(), PrePersistEntityListener.class);
        Class<?> listenerEntityClass = this.evm.getListenerEntityClass(listener.getClass(), PrePersistEntityListener.class);
        this.listenerManager.onPrePersist(managedView, listenerEntityClass, listener);
        return this;
    }

    public FlushOperationBuilder onPostPersist(PostPersistListener<?> listener) {
        ManagedViewType<?> managedView = this.evm.getListenerManagedView(listener.getClass(), PostPersistListener.class);
        this.listenerManager.onPostPersist(managedView, managedView.getEntityClass(), listener);
        return this;
    }

    public FlushOperationBuilder onPostPersist(PostPersistEntityListener<?, ?> listener) {
        ManagedViewType<?> managedView = this.evm.getListenerManagedView(listener.getClass(), PostPersistEntityListener.class);
        Class<?> listenerEntityClass = this.evm.getListenerEntityClass(listener.getClass(), PostPersistEntityListener.class);
        this.listenerManager.onPostPersist(managedView, listenerEntityClass, listener);
        return this;
    }

    public FlushOperationBuilder onPreUpdate(PreUpdateListener<?> listener) {
        ManagedViewType<?> managedView = this.evm.getListenerManagedView(listener.getClass(), PreUpdateListener.class);
        this.listenerManager.onPreUpdate(managedView, managedView.getEntityClass(), listener);
        return this;
    }

    public FlushOperationBuilder onPostUpdate(PostUpdateListener<?> listener) {
        ManagedViewType<?> managedView = this.evm.getListenerManagedView(listener.getClass(), PostUpdateListener.class);
        this.listenerManager.onPostUpdate(managedView, managedView.getEntityClass(), listener);
        return this;
    }

    public FlushOperationBuilder onPreRemove(PreRemoveListener<?> listener) {
        ManagedViewType<?> managedView = this.evm.getListenerManagedView(listener.getClass(), PreRemoveListener.class);
        this.listenerManager.onPreRemove(managedView, managedView.getEntityClass(), listener);
        return this;
    }

    public FlushOperationBuilder onPostRemove(PostRemoveListener<?> listener) {
        ManagedViewType<?> managedView = this.evm.getListenerManagedView(listener.getClass(), PostRemoveListener.class);
        this.listenerManager.onPostRemove(managedView, managedView.getEntityClass(), listener);
        return this;
    }

    public FlushOperationBuilder onPostCommit(PostCommitListener<?> listener) {
        ManagedViewType<?> managedView = this.evm.getListenerManagedView(listener.getClass(), PostCommitListener.class);
        this.listenerManager.onPostCommit(managedView, managedView.getEntityClass(), listener, VIEW_TRANSITIONS);
        return this;
    }

    public FlushOperationBuilder onPostCommit(Set<ViewTransition> viewTransitions, PostCommitListener<?> listener) {
        ManagedViewType<?> managedView = this.evm.getListenerManagedView(listener.getClass(), PostCommitListener.class);
        this.listenerManager.onPostCommit(managedView, managedView.getEntityClass(), listener, viewTransitions);
        return this;
    }

    public FlushOperationBuilder onPostRollback(PostRollbackListener<?> listener) {
        ManagedViewType<?> managedView = this.evm.getListenerManagedView(listener.getClass(), PostRollbackListener.class);
        this.listenerManager.onPostRollback(managedView, managedView.getEntityClass(), listener, VIEW_TRANSITIONS);
        return this;
    }

    public FlushOperationBuilder onPostRollback(Set<ViewTransition> viewTransitions, PostRollbackListener<?> listener) {
        ManagedViewType<?> managedView = this.evm.getListenerManagedView(listener.getClass(), PostRollbackListener.class);
        this.listenerManager.onPostRollback(managedView, managedView.getEntityClass(), listener, viewTransitions);
        return this;
    }

    private <T> ManagedViewTypeImplementor<T> managedView(Class<T> entityViewClass) {
        ManagedViewType managedView = this.evm.getMetamodel().managedView(entityViewClass);
        if (managedView == null && (managedView = this.evm.getMetamodel().managedView(this.evm.getProxyFactory().getEntityViewClass(entityViewClass))) == null) {
            throw new IllegalArgumentException("Can't add a listener for the non-view type: " + entityViewClass.getName());
        }
        return managedView;
    }

    public <T> FlushOperationBuilder onPrePersist(Class<T> entityViewClass, PrePersistListener<T> listener) {
        ManagedViewTypeImplementor<T> managedView = this.managedView(entityViewClass);
        this.listenerManager.onPrePersist(managedView, managedView.getEntityClass(), listener);
        return this;
    }

    public <T> FlushOperationBuilder onPrePersist(Class<T> entityViewClass, PrePersistEntityListener<T, ?> listener) {
        ManagedViewTypeImplementor<T> managedView = this.managedView(entityViewClass);
        this.listenerManager.onPrePersist(managedView, managedView.getEntityClass(), listener);
        return this;
    }

    public <T> FlushOperationBuilder onPostPersist(Class<T> entityViewClass, PostPersistListener<T> listener) {
        ManagedViewTypeImplementor<T> managedView = this.managedView(entityViewClass);
        this.listenerManager.onPostPersist(managedView, managedView.getEntityClass(), listener);
        return this;
    }

    public <T> FlushOperationBuilder onPostPersist(Class<T> entityViewClass, PostPersistEntityListener<T, ?> listener) {
        ManagedViewTypeImplementor<T> managedView = this.managedView(entityViewClass);
        this.listenerManager.onPostPersist(managedView, managedView.getEntityClass(), listener);
        return this;
    }

    public <T> FlushOperationBuilder onPreUpdate(Class<T> entityViewClass, PreUpdateListener<T> listener) {
        ManagedViewTypeImplementor<T> managedView = this.managedView(entityViewClass);
        this.listenerManager.onPreUpdate(managedView, managedView.getEntityClass(), listener);
        return this;
    }

    public <T> FlushOperationBuilder onPostUpdate(Class<T> entityViewClass, PostUpdateListener<T> listener) {
        ManagedViewTypeImplementor<T> managedView = this.managedView(entityViewClass);
        this.listenerManager.onPostUpdate(managedView, managedView.getEntityClass(), listener);
        return this;
    }

    public <T> FlushOperationBuilder onPreRemove(Class<T> entityViewClass, PreRemoveListener<T> listener) {
        ManagedViewTypeImplementor<T> managedView = this.managedView(entityViewClass);
        this.listenerManager.onPreRemove(managedView, managedView.getEntityClass(), listener);
        return this;
    }

    public <T> FlushOperationBuilder onPostRemove(Class<T> entityViewClass, PostRemoveListener<T> listener) {
        ManagedViewTypeImplementor<T> managedView = this.managedView(entityViewClass);
        this.listenerManager.onPostRemove(managedView, managedView.getEntityClass(), listener);
        return this;
    }

    public <T> FlushOperationBuilder onPostCommit(Class<T> entityViewClass, PostCommitListener<T> listener) {
        ManagedViewTypeImplementor<T> managedView = this.managedView(entityViewClass);
        this.listenerManager.onPostCommit(managedView, managedView.getEntityClass(), listener, VIEW_TRANSITIONS);
        return this;
    }

    public <T> FlushOperationBuilder onPostCommit(Class<T> entityViewClass, Set<ViewTransition> viewTransitions, PostCommitListener<T> listener) {
        ManagedViewTypeImplementor<T> managedView = this.managedView(entityViewClass);
        this.listenerManager.onPostCommit(managedView, managedView.getEntityClass(), listener, viewTransitions);
        return this;
    }

    public <T> FlushOperationBuilder onPostRollback(Class<T> entityViewClass, PostRollbackListener<T> listener) {
        ManagedViewTypeImplementor<T> managedView = this.managedView(entityViewClass);
        this.listenerManager.onPostRollback(managedView, managedView.getEntityClass(), listener, VIEW_TRANSITIONS);
        return this;
    }

    public <T> FlushOperationBuilder onPostRollback(Class<T> entityViewClass, Set<ViewTransition> viewTransitions, PostRollbackListener<T> listener) {
        ManagedViewTypeImplementor<T> managedView = this.managedView(entityViewClass);
        this.listenerManager.onPostRollback(managedView, managedView.getEntityClass(), listener, viewTransitions);
        return this;
    }

    public <T, E> FlushOperationBuilder onPrePersist(Class<T> entityViewClass, Class<E> entityClass, PrePersistListener<T> listener) {
        ManagedViewTypeImplementor<T> managedView = this.managedView(entityViewClass);
        this.listenerManager.onPrePersist(managedView, entityClass, listener);
        return this;
    }

    public <T, E> FlushOperationBuilder onPrePersist(Class<T> entityViewClass, Class<E> entityClass, PrePersistEntityListener<T, E> listener) {
        ManagedViewTypeImplementor<T> managedView = this.managedView(entityViewClass);
        this.listenerManager.onPrePersist(managedView, entityClass, listener);
        return this;
    }

    public <T, E> FlushOperationBuilder onPostPersist(Class<T> entityViewClass, Class<E> entityClass, PostPersistListener<T> listener) {
        ManagedViewTypeImplementor<T> managedView = this.managedView(entityViewClass);
        this.listenerManager.onPostPersist(managedView, entityClass, listener);
        return this;
    }

    public <T, E> FlushOperationBuilder onPostPersist(Class<T> entityViewClass, Class<E> entityClass, PostPersistEntityListener<T, E> listener) {
        ManagedViewTypeImplementor<T> managedView = this.managedView(entityViewClass);
        this.listenerManager.onPostPersist(managedView, entityClass, listener);
        return this;
    }

    public <T, E> FlushOperationBuilder onPreUpdate(Class<T> entityViewClass, Class<E> entityClass, PreUpdateListener<T> listener) {
        ManagedViewTypeImplementor<T> managedView = this.managedView(entityViewClass);
        this.listenerManager.onPreUpdate(managedView, entityClass, listener);
        return this;
    }

    public <T, E> FlushOperationBuilder onPostUpdate(Class<T> entityViewClass, Class<E> entityClass, PostUpdateListener<T> listener) {
        ManagedViewTypeImplementor<T> managedView = this.managedView(entityViewClass);
        this.listenerManager.onPostUpdate(managedView, entityClass, listener);
        return this;
    }

    public <T, E> FlushOperationBuilder onPreRemove(Class<T> entityViewClass, Class<E> entityClass, PreRemoveListener<T> listener) {
        ManagedViewTypeImplementor<T> managedView = this.managedView(entityViewClass);
        this.listenerManager.onPreRemove(managedView, entityClass, listener);
        return this;
    }

    public <T, E> FlushOperationBuilder onPostRemove(Class<T> entityViewClass, Class<E> entityClass, PostRemoveListener<T> listener) {
        ManagedViewTypeImplementor<T> managedView = this.managedView(entityViewClass);
        this.listenerManager.onPostRemove(managedView, entityClass, listener);
        return this;
    }

    public <T, E> FlushOperationBuilder onPostCommit(Class<T> entityViewClass, Class<E> entityClass, PostCommitListener<T> listener) {
        ManagedViewTypeImplementor<T> managedView = this.managedView(entityViewClass);
        this.listenerManager.onPostCommit(managedView, entityClass, listener, VIEW_TRANSITIONS);
        return this;
    }

    public <T, E> FlushOperationBuilder onPostCommit(Class<T> entityViewClass, Class<E> entityClass, Set<ViewTransition> viewTransitions, PostCommitListener<T> listener) {
        ManagedViewTypeImplementor<T> managedView = this.managedView(entityViewClass);
        this.listenerManager.onPostCommit(managedView, entityClass, listener, viewTransitions);
        return this;
    }

    public <T, E> FlushOperationBuilder onPostRollback(Class<T> entityViewClass, Class<E> entityClass, PostRollbackListener<T> listener) {
        ManagedViewTypeImplementor<T> managedView = this.managedView(entityViewClass);
        this.listenerManager.onPostRollback(managedView, entityClass, listener, VIEW_TRANSITIONS);
        return this;
    }

    public <T, E> FlushOperationBuilder onPostRollback(Class<T> entityViewClass, Class<E> entityClass, Set<ViewTransition> viewTransitions, PostRollbackListener<T> listener) {
        ManagedViewTypeImplementor<T> managedView = this.managedView(entityViewClass);
        this.listenerManager.onPostRollback(managedView, entityClass, listener, viewTransitions);
        return this;
    }

    public <T> FlushOperationBuilder onPrePersist(Class<T> entityViewClass, ViewListener<T> listener) {
        return this.onPrePersist(entityViewClass, new ViewPrePersistListenerImpl<T>(listener));
    }

    public <T> FlushOperationBuilder onPrePersist(Class<T> entityViewClass, ViewAndEntityListener<T, ?> listener) {
        return this.onPrePersist(entityViewClass, new ViewAndEntityPrePersistListenerImpl(listener));
    }

    public <T> FlushOperationBuilder onPostPersist(Class<T> entityViewClass, ViewListener<T> listener) {
        return this.onPostPersist(entityViewClass, new ViewPostPersistListenerImpl<T>(listener));
    }

    public <T> FlushOperationBuilder onPostPersist(Class<T> entityViewClass, ViewAndEntityListener<T, ?> listener) {
        return this.onPostPersist(entityViewClass, new ViewAndEntityPostPersistListenerImpl(listener));
    }

    public <T> FlushOperationBuilder onPreUpdate(Class<T> entityViewClass, ViewListener<T> listener) {
        return this.onPreUpdate(entityViewClass, new ViewPreUpdateListenerImpl<T>(listener));
    }

    public <T> FlushOperationBuilder onPostUpdate(Class<T> entityViewClass, ViewListener<T> listener) {
        return this.onPostUpdate(entityViewClass, new ViewPostUpdateListenerImpl<T>(listener));
    }

    public <T> FlushOperationBuilder onPreRemove(Class<T> entityViewClass, ViewListener<T> listener) {
        return this.onPreRemove(entityViewClass, new ViewPreRemoveListenerImpl<T>(listener));
    }

    public <T> FlushOperationBuilder onPostRemove(Class<T> entityViewClass, ViewListener<T> listener) {
        return this.onPostRemove(entityViewClass, new ViewPostRemoveListenerImpl<T>(listener));
    }

    public <T> FlushOperationBuilder onPostCommit(Class<T> entityViewClass, ViewListener<T> listener) {
        return this.onPostCommit(entityViewClass, new ViewPostCommitListenerImpl<T>(listener));
    }

    public <T> FlushOperationBuilder onPostCommit(Class<T> entityViewClass, Set<ViewTransition> viewTransitions, ViewListener<T> listener) {
        return this.onPostCommit(entityViewClass, viewTransitions, new ViewPostCommitListenerImpl<T>(listener));
    }

    public <T> FlushOperationBuilder onPostRollback(Class<T> entityViewClass, ViewListener<T> listener) {
        return this.onPostRollback(entityViewClass, new ViewPostRollbackListenerImpl<T>(listener));
    }

    public <T> FlushOperationBuilder onPostRollback(Class<T> entityViewClass, Set<ViewTransition> viewTransitions, ViewListener<T> listener) {
        return this.onPostRollback(entityViewClass, viewTransitions, new ViewPostRollbackListenerImpl<T>(listener));
    }

    public <T, E> FlushOperationBuilder onPrePersist(Class<T> entityViewClass, Class<E> entityClass, ViewListener<T> listener) {
        return this.onPrePersist(entityViewClass, entityClass, new ViewPrePersistListenerImpl<T>(listener));
    }

    public <T, E> FlushOperationBuilder onPrePersist(Class<T> entityViewClass, Class<E> entityClass, ViewAndEntityListener<T, E> listener) {
        return this.onPrePersist(entityViewClass, entityClass, new ViewAndEntityPrePersistListenerImpl<T, E>(listener));
    }

    public <T, E> FlushOperationBuilder onPostPersist(Class<T> entityViewClass, Class<E> entityClass, ViewListener<T> listener) {
        return this.onPostPersist(entityViewClass, entityClass, new ViewPostPersistListenerImpl<T>(listener));
    }

    public <T, E> FlushOperationBuilder onPostPersist(Class<T> entityViewClass, Class<E> entityClass, ViewAndEntityListener<T, E> listener) {
        return this.onPostPersist(entityViewClass, entityClass, new ViewAndEntityPostPersistListenerImpl<T, E>(listener));
    }

    public <T, E> FlushOperationBuilder onPreUpdate(Class<T> entityViewClass, Class<E> entityClass, ViewListener<T> listener) {
        return this.onPreUpdate(entityViewClass, entityClass, new ViewPreUpdateListenerImpl<T>(listener));
    }

    public <T, E> FlushOperationBuilder onPostUpdate(Class<T> entityViewClass, Class<E> entityClass, ViewListener<T> listener) {
        return this.onPostUpdate(entityViewClass, entityClass, new ViewPostUpdateListenerImpl<T>(listener));
    }

    public <T, E> FlushOperationBuilder onPreRemove(Class<T> entityViewClass, Class<E> entityClass, ViewListener<T> listener) {
        return this.onPreRemove(entityViewClass, entityClass, new ViewPreRemoveListenerImpl<T>(listener));
    }

    public <T, E> FlushOperationBuilder onPostRemove(Class<T> entityViewClass, Class<E> entityClass, ViewListener<T> listener) {
        return this.onPostRemove(entityViewClass, entityClass, new ViewPostRemoveListenerImpl<T>(listener));
    }

    public <T, E> FlushOperationBuilder onPostCommit(Class<T> entityViewClass, Class<E> entityClass, ViewListener<T> listener) {
        return this.onPostCommit(entityViewClass, entityClass, new ViewPostCommitListenerImpl<T>(listener));
    }

    public <T, E> FlushOperationBuilder onPostCommit(Class<T> entityViewClass, Class<E> entityClass, Set<ViewTransition> viewTransitions, ViewListener<T> listener) {
        return this.onPostCommit(entityViewClass, entityClass, viewTransitions, new ViewPostCommitListenerImpl<T>(listener));
    }

    public <T, E> FlushOperationBuilder onPostRollback(Class<T> entityViewClass, Class<E> entityClass, ViewListener<T> listener) {
        return this.onPostRollback(entityViewClass, entityClass, new ViewPostRollbackListenerImpl<T>(listener));
    }

    public <T, E> FlushOperationBuilder onPostRollback(Class<T> entityViewClass, Class<E> entityClass, Set<ViewTransition> viewTransitions, ViewListener<T> listener) {
        return this.onPostRollback(entityViewClass, entityClass, viewTransitions, new ViewPostRollbackListenerImpl<T>(listener));
    }

    public void flush() {
        if (this.remove) {
            if (this.entityViewClass == null) {
                this.evm.remove(this, this.object);
            } else {
                this.evm.remove(this, this.entityViewClass, this.object);
            }
        } else if (this.entity == null) {
            this.evm.update(this, this.object);
        } else {
            this.evm.updateTo(this, this.object, this.entity);
        }
    }

    public FlushOperationBuilder onPostCommitPersist(PostCommitListener<?> listener) {
        return this.onPostCommit(EnumSet.of(ViewTransition.PERSIST), listener);
    }

    public FlushOperationBuilder onPostCommitUpdate(PostCommitListener<?> listener) {
        return this.onPostCommit(EnumSet.of(ViewTransition.UPDATE), listener);
    }

    public FlushOperationBuilder onPostCommitRemove(PostCommitListener<?> listener) {
        return this.onPostCommit(EnumSet.of(ViewTransition.REMOVE), listener);
    }

    public FlushOperationBuilder onPostRollbackPersist(PostRollbackListener<?> listener) {
        return this.onPostRollback(EnumSet.of(ViewTransition.PERSIST), listener);
    }

    public FlushOperationBuilder onPostRollbackUpdate(PostRollbackListener<?> listener) {
        return this.onPostRollback(EnumSet.of(ViewTransition.UPDATE), listener);
    }

    public FlushOperationBuilder onPostRollbackRemove(PostRollbackListener<?> listener) {
        return this.onPostRollback(EnumSet.of(ViewTransition.REMOVE), listener);
    }

    public <T> FlushOperationBuilder onPostCommitPersist(Class<T> entityViewClass, PostCommitListener<T> listener) {
        return this.onPostCommit(entityViewClass, EnumSet.of(ViewTransition.PERSIST), listener);
    }

    public <T> FlushOperationBuilder onPostCommitUpdate(Class<T> entityViewClass, PostCommitListener<T> listener) {
        return this.onPostCommit(entityViewClass, EnumSet.of(ViewTransition.UPDATE), listener);
    }

    public <T> FlushOperationBuilder onPostCommitRemove(Class<T> entityViewClass, PostCommitListener<T> listener) {
        return this.onPostCommit(entityViewClass, EnumSet.of(ViewTransition.REMOVE), listener);
    }

    public <T> FlushOperationBuilder onPostRollbackPersist(Class<T> entityViewClass, PostRollbackListener<T> listener) {
        return this.onPostRollback(entityViewClass, EnumSet.of(ViewTransition.PERSIST), listener);
    }

    public <T> FlushOperationBuilder onPostRollbackUpdate(Class<T> entityViewClass, PostRollbackListener<T> listener) {
        return this.onPostRollback(entityViewClass, EnumSet.of(ViewTransition.UPDATE), listener);
    }

    public <T> FlushOperationBuilder onPostRollbackRemove(Class<T> entityViewClass, PostRollbackListener<T> listener) {
        return this.onPostRollback(entityViewClass, EnumSet.of(ViewTransition.REMOVE), listener);
    }

    public <T, E> FlushOperationBuilder onPostCommitPersist(Class<T> entityViewClass, Class<E> entityClass, PostCommitListener<T> listener) {
        return this.onPostCommit(entityViewClass, entityClass, EnumSet.of(ViewTransition.PERSIST), listener);
    }

    public <T, E> FlushOperationBuilder onPostCommitUpdate(Class<T> entityViewClass, Class<E> entityClass, PostCommitListener<T> listener) {
        return this.onPostCommit(entityViewClass, entityClass, EnumSet.of(ViewTransition.UPDATE), listener);
    }

    public <T, E> FlushOperationBuilder onPostCommitRemove(Class<T> entityViewClass, Class<E> entityClass, PostCommitListener<T> listener) {
        return this.onPostCommit(entityViewClass, entityClass, EnumSet.of(ViewTransition.REMOVE), listener);
    }

    public <T, E> FlushOperationBuilder onPostRollbackPersist(Class<T> entityViewClass, Class<E> entityClass, PostRollbackListener<T> listener) {
        return this.onPostRollback(entityViewClass, entityClass, EnumSet.of(ViewTransition.PERSIST), listener);
    }

    public <T, E> FlushOperationBuilder onPostRollbackUpdate(Class<T> entityViewClass, Class<E> entityClass, PostRollbackListener<T> listener) {
        return this.onPostRollback(entityViewClass, entityClass, EnumSet.of(ViewTransition.UPDATE), listener);
    }

    public <T, E> FlushOperationBuilder onPostRollbackRemove(Class<T> entityViewClass, Class<E> entityClass, PostRollbackListener<T> listener) {
        return this.onPostRollback(entityViewClass, entityClass, EnumSet.of(ViewTransition.REMOVE), listener);
    }

    public <T> FlushOperationBuilder onPostCommitPersist(Class<T> entityViewClass, ViewListener<T> listener) {
        return this.onPostCommit(entityViewClass, EnumSet.of(ViewTransition.PERSIST), listener);
    }

    public <T> FlushOperationBuilder onPostCommitUpdate(Class<T> entityViewClass, ViewListener<T> listener) {
        return this.onPostCommit(entityViewClass, EnumSet.of(ViewTransition.UPDATE), listener);
    }

    public <T> FlushOperationBuilder onPostCommitRemove(Class<T> entityViewClass, ViewListener<T> listener) {
        return this.onPostCommit(entityViewClass, EnumSet.of(ViewTransition.REMOVE), listener);
    }

    public <T> FlushOperationBuilder onPostRollbackPersist(Class<T> entityViewClass, ViewListener<T> listener) {
        return this.onPostRollback(entityViewClass, EnumSet.of(ViewTransition.PERSIST), listener);
    }

    public <T> FlushOperationBuilder onPostRollbackUpdate(Class<T> entityViewClass, ViewListener<T> listener) {
        return this.onPostRollback(entityViewClass, EnumSet.of(ViewTransition.UPDATE), listener);
    }

    public <T> FlushOperationBuilder onPostRollbackRemove(Class<T> entityViewClass, ViewListener<T> listener) {
        return this.onPostRollback(entityViewClass, EnumSet.of(ViewTransition.REMOVE), listener);
    }

    public <T, E> FlushOperationBuilder onPostCommitPersist(Class<T> entityViewClass, Class<E> entityClass, ViewListener<T> listener) {
        return this.onPostCommit(entityViewClass, entityClass, EnumSet.of(ViewTransition.PERSIST), listener);
    }

    public <T, E> FlushOperationBuilder onPostCommitUpdate(Class<T> entityViewClass, Class<E> entityClass, ViewListener<T> listener) {
        return this.onPostCommit(entityViewClass, entityClass, EnumSet.of(ViewTransition.UPDATE), listener);
    }

    public <T, E> FlushOperationBuilder onPostCommitRemove(Class<T> entityViewClass, Class<E> entityClass, ViewListener<T> listener) {
        return this.onPostCommit(entityViewClass, entityClass, EnumSet.of(ViewTransition.REMOVE), listener);
    }

    public <T, E> FlushOperationBuilder onPostRollbackPersist(Class<T> entityViewClass, Class<E> entityClass, ViewListener<T> listener) {
        return this.onPostRollback(entityViewClass, entityClass, EnumSet.of(ViewTransition.PERSIST), listener);
    }

    public <T, E> FlushOperationBuilder onPostRollbackUpdate(Class<T> entityViewClass, Class<E> entityClass, ViewListener<T> listener) {
        return this.onPostRollback(entityViewClass, entityClass, EnumSet.of(ViewTransition.UPDATE), listener);
    }

    public <T, E> FlushOperationBuilder onPostRollbackRemove(Class<T> entityViewClass, Class<E> entityClass, ViewListener<T> listener) {
        return this.onPostRollback(entityViewClass, entityClass, EnumSet.of(ViewTransition.REMOVE), listener);
    }

    public <T> FlushOperationBuilder onPostCommit(Class<T> entityViewClass, ViewTransitionListener<T> listener) {
        return this.onPostCommit(entityViewClass, VIEW_TRANSITIONS, new ViewTransitionPostCommitListenerImpl<T>(listener));
    }

    public <T> FlushOperationBuilder onPostCommit(Class<T> entityViewClass, Set<ViewTransition> viewTransitions, ViewTransitionListener<T> listener) {
        return this.onPostCommit(entityViewClass, viewTransitions, new ViewTransitionPostCommitListenerImpl<T>(listener));
    }

    public <T> FlushOperationBuilder onPostRollback(Class<T> entityViewClass, ViewTransitionListener<T> listener) {
        return this.onPostRollback(entityViewClass, VIEW_TRANSITIONS, new ViewTransitionPostRollbackListenerImpl<T>(listener));
    }

    public <T> FlushOperationBuilder onPostRollback(Class<T> entityViewClass, Set<ViewTransition> viewTransitions, ViewTransitionListener<T> listener) {
        return this.onPostRollback(entityViewClass, viewTransitions, new ViewTransitionPostRollbackListenerImpl<T>(listener));
    }

    public <T, E> FlushOperationBuilder onPostCommit(Class<T> entityViewClass, Class<E> entityClass, ViewTransitionListener<T> listener) {
        return this.onPostCommit(entityViewClass, entityClass, VIEW_TRANSITIONS, new ViewTransitionPostCommitListenerImpl<T>(listener));
    }

    public <T, E> FlushOperationBuilder onPostCommit(Class<T> entityViewClass, Class<E> entityClass, Set<ViewTransition> viewTransitions, ViewTransitionListener<T> listener) {
        return this.onPostCommit(entityViewClass, entityClass, viewTransitions, new ViewTransitionPostCommitListenerImpl<T>(listener));
    }

    public <T, E> FlushOperationBuilder onPostRollback(Class<T> entityViewClass, Class<E> entityClass, ViewTransitionListener<T> listener) {
        return this.onPostRollback(entityViewClass, entityClass, VIEW_TRANSITIONS, new ViewTransitionPostRollbackListenerImpl<T>(listener));
    }

    public <T, E> FlushOperationBuilder onPostRollback(Class<T> entityViewClass, Class<E> entityClass, Set<ViewTransition> viewTransitions, ViewTransitionListener<T> listener) {
        return this.onPostRollback(entityViewClass, entityClass, viewTransitions, new ViewTransitionPostRollbackListenerImpl<T>(listener));
    }

    private static class EntityKey {
        private final Class<?> entityClass;
        private final Object entityId;

        public EntityKey(Class<?> entityClass, Object entityId) {
            this.entityClass = entityClass;
            this.entityId = entityId;
        }

        public boolean equals(Object o) {
            EntityKey entityKey = (EntityKey)o;
            return this.entityClass.equals(entityKey.entityClass) && this.entityId.equals(entityKey.entityId);
        }

        public int hashCode() {
            int result = this.entityClass.hashCode();
            result = 31 * result + this.entityId.hashCode();
            return result;
        }
    }

    private static class ViewCacheEntry {
        private final EntityViewProxy view;
        private final boolean fromPrePhase;

        public ViewCacheEntry(EntityViewProxy view, boolean fromPrePhase) {
            this.view = view;
            this.fromPrePhase = fromPrePhase;
        }
    }
}

