/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.update.flush;

import com.blazebit.persistence.DeleteCriteriaBuilder;
import com.blazebit.persistence.InsertCriteriaBuilder;
import com.blazebit.persistence.SubqueryBuilder;
import com.blazebit.persistence.UpdateCriteriaBuilder;
import com.blazebit.persistence.view.FlushStrategy;
import com.blazebit.persistence.view.InverseRemoveStrategy;
import com.blazebit.persistence.view.impl.accessor.AttributeAccessor;
import com.blazebit.persistence.view.impl.accessor.InitialValueAttributeAccessor;
import com.blazebit.persistence.view.impl.change.DirtyChecker;
import com.blazebit.persistence.view.impl.collection.CollectionAction;
import com.blazebit.persistence.view.impl.collection.CollectionClearAction;
import com.blazebit.persistence.view.impl.collection.CollectionInstantiatorImplementor;
import com.blazebit.persistence.view.impl.collection.CollectionRemoveListener;
import com.blazebit.persistence.view.impl.collection.ListAddAction;
import com.blazebit.persistence.view.impl.collection.ListAddAllAction;
import com.blazebit.persistence.view.impl.collection.ListRemoveAction;
import com.blazebit.persistence.view.impl.collection.ListSetAction;
import com.blazebit.persistence.view.impl.collection.RecordingCollection;
import com.blazebit.persistence.view.impl.collection.RecordingList;
import com.blazebit.persistence.view.impl.entity.ViewToEntityMapper;
import com.blazebit.persistence.view.impl.update.UpdateContext;
import com.blazebit.persistence.view.impl.update.flush.AbstractPluralAttributeFlusher;
import com.blazebit.persistence.view.impl.update.flush.CollectionAttributeFlusher;
import com.blazebit.persistence.view.impl.update.flush.CollectionElementAttributeFlusher;
import com.blazebit.persistence.view.impl.update.flush.DirtyAttributeFlusher;
import com.blazebit.persistence.view.impl.update.flush.FusedCollectionActions;
import com.blazebit.persistence.view.impl.update.flush.FusedCollectionIndexActions;
import com.blazebit.persistence.view.impl.update.flush.InverseFlusher;
import com.blazebit.persistence.view.impl.update.flush.TypeDescriptor;
import com.blazebit.persistence.view.spi.type.BasicUserType;
import com.blazebit.persistence.view.spi.type.DirtyStateTrackable;
import com.blazebit.persistence.view.spi.type.MutableStateTrackable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.persistence.EntityManager;
import javax.persistence.Query;

public class IndexedListAttributeFlusher<E, V extends List<?>>
extends CollectionAttributeFlusher<E, V> {
    public IndexedListAttributeFlusher(String attributeName, String mapping, Class<?> ownerEntityClass, String ownerIdAttributeName, String ownerMapping, DirtyAttributeFlusher<?, ?, ?> ownerIdFlusher, DirtyAttributeFlusher<?, ?, ?> elementFlusher, boolean supportsCollectionDml, FlushStrategy flushStrategy, AttributeAccessor attributeMapper, InitialValueAttributeAccessor viewAttributeAccessor, boolean optimisticLockProtected, boolean collectionUpdatable, boolean viewOnlyDeleteCascaded, boolean jpaProviderDeletesCollection, CollectionRemoveListener cascadeDeleteListener, CollectionRemoveListener removeListener, CollectionInstantiatorImplementor<?, ?> collectionInstantiator, TypeDescriptor elementDescriptor, InverseFlusher<E> inverseFlusher, InverseRemoveStrategy inverseRemoveStrategy) {
        super(attributeName, mapping, ownerEntityClass, ownerIdAttributeName, ownerMapping, ownerIdFlusher, elementFlusher, supportsCollectionDml, flushStrategy, attributeMapper, viewAttributeAccessor, optimisticLockProtected, collectionUpdatable, viewOnlyDeleteCascaded, jpaProviderDeletesCollection, cascadeDeleteListener, removeListener, collectionInstantiator, elementDescriptor, inverseFlusher, inverseRemoveStrategy);
    }

    public IndexedListAttributeFlusher(IndexedListAttributeFlusher<E, V> original, boolean fetch) {
        super(original, fetch);
    }

    public IndexedListAttributeFlusher(IndexedListAttributeFlusher<E, V> original, boolean fetch, AbstractPluralAttributeFlusher.PluralFlushOperation flushOperation, List<? extends CollectionAction<?>> collectionActions, List<CollectionElementAttributeFlusher<E, V>> elementFlushers) {
        super(original, fetch, flushOperation, collectionActions, elementFlushers);
    }

    @Override
    protected boolean collectionEquals(V initial, V current) {
        if (initial == null || initial.size() != current.size()) {
            return false;
        }
        return initial.equals(current);
    }

    @Override
    protected boolean mergeAndRequeue(UpdateContext context, RecordingCollection recordingCollection, Collection<Object> newCollection) {
        EntityManager em = context.getEntityManager();
        List realCollection = (List)newCollection;
        for (int i = 0; i < realCollection.size(); ++i) {
            Object merged;
            Object elem = realCollection.get(i);
            if (elem == (merged = this.persistOrMerge(em, elem))) continue;
            if (recordingCollection != null) {
                recordingCollection.replaceActionElement(elem, merged);
            }
            realCollection.set(i, merged);
        }
        return true;
    }

    @Override
    protected CollectionAttributeFlusher<E, V> partialFlusher(boolean fetch, AbstractPluralAttributeFlusher.PluralFlushOperation operation, List<? extends CollectionAction<?>> collectionActions, List<CollectionElementAttributeFlusher<E, V>> elementFlushers) {
        return new IndexedListAttributeFlusher<E, V>(this, fetch, operation, collectionActions, elementFlushers);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public DirtyChecker.DirtyKind getDirtyKind(V initial, V current) {
        if (current == null) {
            if (initial != null) return DirtyChecker.DirtyKind.UPDATED;
            return DirtyChecker.DirtyKind.NONE;
        }
        if (initial == null) {
            return DirtyChecker.DirtyKind.UPDATED;
        }
        if (initial == current) {
            if (!(current instanceof RecordingList)) return DirtyChecker.DirtyKind.NONE;
            return super.getDirtyKind(initial, current);
        }
        if (initial.size() != current.size()) {
            return DirtyChecker.DirtyKind.MUTATED;
        }
        if (!this.elementDescriptor.shouldFlushMutations()) return this.collectionEquals(initial, current) ? DirtyChecker.DirtyKind.NONE : DirtyChecker.DirtyKind.MUTATED;
        if (this.elementDescriptor.supportsDirtyCheck()) {
            if (this.elementDescriptor.isSubview()) {
                ViewToEntityMapper mapper = this.elementDescriptor.getViewToEntityMapper();
                for (int i = 0; i < current.size(); ++i) {
                    Object o = current.get(i);
                    if (!Objects.equals(initial.get(i), o)) {
                        return DirtyChecker.DirtyKind.MUTATED;
                    }
                    if (!(o instanceof DirtyStateTrackable)) continue;
                    DirtyStateTrackable element = (DirtyStateTrackable)o;
                    if (mapper.getUpdater(o).getDirtyChecker().getDirtyKind(element, element) == DirtyChecker.DirtyKind.NONE) continue;
                    return DirtyChecker.DirtyKind.MUTATED;
                }
                return DirtyChecker.DirtyKind.NONE;
            } else {
                BasicUserType<Object> userType = this.elementDescriptor.getBasicUserType();
                for (int i = 0; i < current.size(); ++i) {
                    Object o = current.get(i);
                    if (!Objects.equals(initial.get(i), o)) {
                        return DirtyChecker.DirtyKind.MUTATED;
                    }
                    String[] dirtyProperties = userType.getDirtyProperties(o);
                    if (dirtyProperties == null) continue;
                    return DirtyChecker.DirtyKind.MUTATED;
                }
            }
            return DirtyChecker.DirtyKind.NONE;
        } else {
            if (!this.elementDescriptor.getBasicUserType().supportsDeepCloning()) return DirtyChecker.DirtyKind.MUTATED;
            return this.collectionEquals(initial, current) ? DirtyChecker.DirtyKind.NONE : DirtyChecker.DirtyKind.MUTATED;
        }
    }

    @Override
    protected List<CollectionAction<Collection<?>>> replaceActions(V value) {
        ArrayList actions = new ArrayList();
        actions.add(new CollectionClearAction());
        if (value != null && !value.isEmpty()) {
            actions.add(new ListAddAllAction(0, true, value));
        }
        return actions;
    }

    @Override
    protected Collection<Object> appendRemoveSpecific(UpdateContext context, DeleteCriteriaBuilder<?> deleteCb, FusedCollectionActions fusedCollectionActions) {
        deleteCb.where("INDEX(e." + this.getMapping() + ")").in(fusedCollectionActions.getRemoved(context));
        return fusedCollectionActions.getRemoved();
    }

    @Override
    protected void addElements(UpdateContext context, Object ownerView, Object view, Collection<Object> removedAllObjects, boolean flushAtOnce, boolean removedAllWithoutCollectionActions, V value, List<Object> embeddablesToUpdate, FusedCollectionActions fusedCollectionActions, boolean initialKnown) {
        block28: {
            Object object;
            int i;
            int appendIndex;
            Object appends;
            String mapping = this.getMapping();
            if (fusedCollectionActions == null || !removedAllObjects.isEmpty()) {
                appends = value;
                removedAllObjects.removeAll((Collection<?>)appends);
                appendIndex = 0;
            } else {
                List<FusedCollectionIndexActions.ReplaceOperation> replaces;
                FusedCollectionIndexActions indexActions = (FusedCollectionIndexActions)fusedCollectionActions;
                List<FusedCollectionIndexActions.IndexTranslateOperation> translations = indexActions.getTranslations();
                if (translations.size() != 0) {
                    UpdateCriteriaBuilder updateCb = context.getEntityViewManager().getCriteriaBuilderFactory().updateCollection(context.getEntityManager(), this.ownerEntityClass, "e", mapping);
                    updateCb.setExpression("INDEX(" + mapping + ")", "INDEX(" + mapping + ") + :offset");
                    updateCb.setWhereExpression(this.ownerIdWhereFragment);
                    updateCb.where("INDEX(" + mapping + ")").geExpression(":minIdx");
                    updateCb.where("INDEX(" + mapping + ")").ltExpression(":maxIdx");
                    Query query = updateCb.getQuery();
                    this.ownerIdFlusher.flushQuery(context, null, null, query, ownerView, view, this.ownerIdFlusher.getViewAttributeAccessor().getValue(ownerView), null, null);
                    for (i = 0; i < translations.size(); ++i) {
                        FusedCollectionIndexActions.IndexTranslateOperation translation = translations.get(i);
                        query.setParameter("minIdx", (Object)translation.getStartIndex());
                        query.setParameter("maxIdx", (Object)translation.getEndIndex());
                        query.setParameter("offset", (Object)translation.getOffset());
                        query.executeUpdate();
                    }
                }
                if ((replaces = indexActions.getReplaces()).size() != 0 || embeddablesToUpdate != null && !embeddablesToUpdate.isEmpty()) {
                    UpdateCriteriaBuilder updateCb = context.getEntityViewManager().getCriteriaBuilderFactory().updateCollection(context.getEntityManager(), this.ownerEntityClass, "e", mapping);
                    updateCb.setExpression(mapping, ":element");
                    updateCb.setWhereExpression(this.ownerIdWhereFragment);
                    updateCb.where("INDEX(" + mapping + ")").eqExpression(":idx");
                    Query query = updateCb.getQuery();
                    if (replaces.size() != 0) {
                        boolean checkTransient;
                        this.ownerIdFlusher.flushQuery(context, null, null, query, ownerView, view, this.ownerIdFlusher.getViewAttributeAccessor().getValue(ownerView), null, null);
                        boolean bl = checkTransient = this.elementDescriptor.isJpaEntity() && !this.elementDescriptor.shouldJpaPersist();
                        if (this.elementDescriptor.getViewToEntityMapper() == null) {
                            for (int i2 = 0; i2 < replaces.size(); ++i2) {
                                FusedCollectionIndexActions.ReplaceOperation replace = replaces.get(i2);
                                if (checkTransient && this.elementDescriptor.getBasicUserType().shouldPersist(replace.getNewObject())) {
                                    throw new IllegalStateException("Collection " + this.attributeName + " references an unsaved transient instance - save the transient instance before flushing: " + replace.getNewObject());
                                }
                                query.setParameter("idx", (Object)replace.getIndex());
                                query.setParameter("element", replace.getNewObject());
                                query.executeUpdate();
                            }
                        } else {
                            ViewToEntityMapper loadOnlyViewToEntityMapper = this.elementDescriptor.getLoadOnlyViewToEntityMapper();
                            for (int i3 = 0; i3 < replaces.size(); ++i3) {
                                FusedCollectionIndexActions.ReplaceOperation replace = replaces.get(i3);
                                query.setParameter("idx", (Object)replace.getIndex());
                                query.setParameter("element", loadOnlyViewToEntityMapper.applyToEntity(context, null, replace.getNewObject()));
                                query.executeUpdate();
                            }
                        }
                    }
                    if (embeddablesToUpdate != null && !embeddablesToUpdate.isEmpty()) {
                        for (int i4 = 0; i4 < embeddablesToUpdate.size(); ++i4) {
                            query.setParameter("idx", (Object)i4);
                            query.setParameter("element", embeddablesToUpdate.get(i4));
                            query.executeUpdate();
                        }
                    }
                }
                appends = indexActions.getAdded(context);
                appendIndex = indexActions.getAppendIndex();
                removedAllObjects.removeAll(indexActions.getAdded());
            }
            if (appends.size() <= 1 && (appends.size() != 1 || appends.iterator().next() == null)) break block28;
            InsertCriteriaBuilder insertCb = context.getEntityViewManager().getCriteriaBuilderFactory().insertCollection(context.getEntityManager(), this.ownerEntityClass, mapping);
            String entityIdAttributeName = this.elementDescriptor.getEntityIdAttributeName();
            String attributeIdAttributeName = this.elementDescriptor.getAttributeIdAttributeName();
            if (entityIdAttributeName == null) {
                insertCb.fromValues(this.ownerEntityClass, mapping, "val", 1);
            } else if (entityIdAttributeName.equals(attributeIdAttributeName)) {
                insertCb.fromIdentifiableValues(this.elementDescriptor.getJpaType(), "val", 1);
            } else {
                insertCb.fromIdentifiableValues(this.elementDescriptor.getJpaType(), attributeIdAttributeName, "val", 1);
            }
            if (initialKnown) {
                insertCb.bind("INDEX(" + mapping + ")").select("FUNCTION('TREAT_INTEGER', :idx)");
            } else {
                SubqueryBuilder subquery = (SubqueryBuilder)insertCb.bind("INDEX(" + mapping + ")").selectSubquery("subquery", "COALESCE(subquery + 1, 0)").from(this.ownerEntityClass, "sub").select("MAX(INDEX(sub." + mapping + "))");
                for (i = 0; i < this.ownerIdBindFragments.length; i += 2) {
                    subquery.where("sub." + this.ownerIdBindFragments[i]).eqExpression(this.ownerIdBindFragments[i + 1]);
                }
                subquery.end();
            }
            for (int i5 = 0; i5 < this.ownerIdBindFragments.length; i5 += 2) {
                insertCb.bind(this.ownerIdBindFragments[i5]).select(this.ownerIdBindFragments[i5 + 1]);
            }
            insertCb.bind(mapping).select("val");
            Query query = insertCb.getQuery();
            this.ownerIdFlusher.flushQuery(context, null, null, query, ownerView, view, this.ownerIdFlusher.getViewAttributeAccessor().getValue(ownerView), null, null);
            Object[] singletonArray = new Object[1];
            List<Object> singletonList = Arrays.asList(singletonArray);
            if (this.elementDescriptor.getViewToEntityMapper() == null) {
                boolean checkTransient = this.elementDescriptor.isJpaEntity() && !this.elementDescriptor.shouldJpaPersist();
                Iterator iterator = appends.iterator();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    if (object == null) continue;
                    if (checkTransient && this.elementDescriptor.getBasicUserType().shouldPersist(object)) {
                        throw new IllegalStateException("Collection " + this.attributeName + " references an unsaved transient instance - save the transient instance before flushing: " + object);
                    }
                    singletonArray[0] = object;
                    if (initialKnown) {
                        query.setParameter("idx", (Object)appendIndex++);
                    }
                    query.setParameter("val", singletonList);
                    query.executeUpdate();
                }
            } else {
                ViewToEntityMapper loadOnlyViewToEntityMapper = this.elementDescriptor.getLoadOnlyViewToEntityMapper();
                Iterator iterator = appends.iterator();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    if (object == null) continue;
                    singletonArray[0] = loadOnlyViewToEntityMapper.applyToEntity(context, null, object);
                    if (initialKnown) {
                        query.setParameter("idx", (Object)appendIndex++);
                    }
                    query.setParameter("val", singletonList);
                    query.executeUpdate();
                }
            }
        }
    }

    @Override
    protected boolean canFlushSeparateCollectionOperations() {
        return true;
    }

    @Override
    protected boolean isIndexed() {
        return true;
    }

    @Override
    protected void addFlatViewElementFlushActions(UpdateContext context, TypeDescriptor typeDescriptor, List<CollectionAction<?>> actions, V current) {
        ViewToEntityMapper mapper = typeDescriptor.getViewToEntityMapper();
        for (int i = 0; i < current.size(); ++i) {
            MutableStateTrackable element;
            DirtyAttributeFlusher flusher;
            Object o = current.get(i);
            if (!(o instanceof MutableStateTrackable) || (flusher = mapper.getNestedDirtyFlusher(context, element = (MutableStateTrackable)o, null)) == null) continue;
            AbstractPluralAttributeFlusher.EntryState state = AbstractPluralAttributeFlusher.EntryState.UPDATED;
            Object replacedObject = element;
            for (CollectionAction<?> action : actions) {
                Collection<Object> removedObjects = action.getRemovedObjects();
                if (IndexedListAttributeFlusher.identityContains(removedObjects, element)) {
                    if (IndexedListAttributeFlusher.identityContains(action.getAddedObjects(), element)) {
                        replacedObject = element;
                        state = AbstractPluralAttributeFlusher.EntryState.UPDATED;
                        continue;
                    }
                    state = state.onRemove();
                    continue;
                }
                if (!IndexedListAttributeFlusher.identityContains(action.getAddedObjects(), element)) continue;
                if (removedObjects.isEmpty()) {
                    state = state.onAdd();
                    continue;
                }
                replacedObject = removedObjects.iterator().next();
                state = AbstractPluralAttributeFlusher.EntryState.UPDATED;
            }
            if (state != AbstractPluralAttributeFlusher.EntryState.UPDATED || replacedObject != element) continue;
            actions.add(new ListSetAction(i, false, element, element));
        }
    }

    private int getInitialSize(int size, List<CollectionAction<?>> actions) {
        for (int end = actions.size() - 1; end >= 0; --end) {
            CollectionAction<?> collectionAction = actions.get(end);
            size += collectionAction.getAddedObjects().size() - collectionAction.getRemovedObjects().size();
        }
        return size;
    }

    @Override
    protected FusedCollectionActions getFusedOperations(List<? extends CollectionAction<?>> collectionActions) {
        return new FusedCollectionIndexActions(collectionActions);
    }

    @Override
    protected List<CollectionAction<Collection<?>>> determineJpaCollectionActions(UpdateContext context, V jpaCollection, V value, AbstractPluralAttributeFlusher.EqualityChecker equalityChecker) {
        int i;
        ArrayList actions = new ArrayList();
        int jpaSize = jpaCollection.size();
        int lastUnmatchedIndex = 0;
        for (i = 0; i < jpaSize; ++i) {
            Object jpaElement = jpaCollection.get(i);
            if (i < value.size()) {
                Object viewElement = value.get(i);
                if (!equalityChecker.isEqual(context, jpaElement, viewElement)) break;
                ++lastUnmatchedIndex;
                continue;
            }
            if (i < jpaSize) {
                for (int j = i; j < jpaSize - 1; ++j) {
                    actions.add(new ListRemoveAction(i, false, IndexedListAttributeFlusher.getViewElement(context, this.elementDescriptor, jpaCollection.get(i))));
                }
                actions.add(new ListRemoveAction(i, true, IndexedListAttributeFlusher.getViewElement(context, this.elementDescriptor, jpaCollection.get(i))));
            }
            lastUnmatchedIndex = jpaSize;
            break;
        }
        if (lastUnmatchedIndex < jpaSize) {
            for (i = lastUnmatchedIndex; i < jpaSize - 1; ++i) {
                actions.add(new ListRemoveAction(lastUnmatchedIndex, false, IndexedListAttributeFlusher.getViewElement(context, this.elementDescriptor, jpaCollection.get(lastUnmatchedIndex))));
            }
            actions.add(new ListRemoveAction(lastUnmatchedIndex, true, IndexedListAttributeFlusher.getViewElement(context, this.elementDescriptor, jpaCollection.get(lastUnmatchedIndex))));
        }
        if (lastUnmatchedIndex < value.size()) {
            for (i = lastUnmatchedIndex; i < value.size(); ++i) {
                actions.add(new ListAddAction(lastUnmatchedIndex, true, value.get(i)));
            }
        }
        return actions;
    }

    @Override
    protected List<CollectionAction<Collection<?>>> determineCollectionActions(UpdateContext context, V initial, V current, AbstractPluralAttributeFlusher.EqualityChecker equalityChecker) {
        ArrayList actions = new ArrayList();
        int lastUnmatchedIndex = 0;
        if (initial != null && !initial.isEmpty()) {
            int initialSize = initial.size();
            if (this.elementDescriptor.isSubview() && this.elementDescriptor.isIdentifiable()) {
                AttributeAccessor subviewIdAccessor = this.elementDescriptor.getViewToEntityMapper().getViewIdAccessor();
                for (int i = 0; i < initialSize; ++i) {
                    Object initialViewId = subviewIdAccessor.getValue(initial.get(i));
                    if (i < current.size()) {
                        Object currentViewId = subviewIdAccessor.getValue(current.get(i));
                        if (initialViewId.equals(currentViewId)) {
                            ++lastUnmatchedIndex;
                            continue;
                        }
                    } else {
                        if (i < initialSize) {
                            for (int j = i; j < initialSize - 1; ++j) {
                                actions.add(new ListRemoveAction(i, false, (List<?>)initial));
                            }
                            actions.add(new ListRemoveAction(i, true, (List<?>)initial));
                        }
                        lastUnmatchedIndex = initialSize;
                    }
                    break;
                }
            } else {
                for (int i = 0; i < initialSize; ++i) {
                    Object initialElement = initial.get(i);
                    if (i < current.size()) {
                        Object viewElement = current.get(i);
                        if (equalityChecker.isEqual(context, initialElement, viewElement)) {
                            ++lastUnmatchedIndex;
                            continue;
                        }
                    } else {
                        if (i < initialSize) {
                            for (int j = i; j < initialSize - 1; ++j) {
                                actions.add(new ListRemoveAction(i, false, (List<?>)initial));
                            }
                            actions.add(new ListRemoveAction(i, true, (List<?>)initial));
                        }
                        lastUnmatchedIndex = initialSize;
                    }
                    break;
                }
            }
            if (lastUnmatchedIndex < initialSize) {
                for (int i = lastUnmatchedIndex; i < initialSize - 1; ++i) {
                    actions.add(new ListRemoveAction(lastUnmatchedIndex, false, (List<?>)initial));
                }
                actions.add(new ListRemoveAction(lastUnmatchedIndex, true, (List<?>)initial));
            }
        }
        if (lastUnmatchedIndex < current.size()) {
            for (int i = lastUnmatchedIndex; i < current.size(); ++i) {
                actions.add(new ListAddAction(lastUnmatchedIndex, true, current.get(i)));
            }
        }
        return actions;
    }
}

