/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.update.flush;

import com.blazebit.lang.StringUtils;
import com.blazebit.persistence.CriteriaBuilder;
import com.blazebit.persistence.DeleteCriteriaBuilder;
import com.blazebit.persistence.spi.ExtendedAttribute;
import com.blazebit.persistence.spi.JpaProvider;
import com.blazebit.persistence.view.impl.EntityViewManagerImpl;
import com.blazebit.persistence.view.impl.update.UpdateContext;
import com.blazebit.persistence.view.impl.update.flush.AbstractUnmappedAttributeCascadeDeleter;
import com.blazebit.persistence.view.impl.update.flush.UnmappedAttributeCascadeDeleter;
import com.blazebit.persistence.view.impl.update.flush.UnmappedBasicAttributeCascadeDeleter;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Tuple;

public class UnmappedCollectionAttributeCascadeDeleter
extends AbstractUnmappedAttributeCascadeDeleter {
    private final Class<?> ownerEntityClass;
    private final String ownerIdAttributeName;
    private final String mappedByAttributeName;
    private final boolean jpaProviderDeletesCollection;
    private final UnmappedBasicAttributeCascadeDeleter elementDeleter;

    public UnmappedCollectionAttributeCascadeDeleter(EntityViewManagerImpl evm, String attributeName, ExtendedAttribute<?, ?> attribute, Class<?> ownerEntityClass, String ownerIdAttributeName, boolean disallowCycle) {
        super(evm, attributeName, attribute);
        this.ownerEntityClass = ownerEntityClass;
        this.ownerIdAttributeName = ownerIdAttributeName;
        this.mappedByAttributeName = attribute.getMappedBy();
        JpaProvider jpaProvider = evm.getJpaProvider();
        if (this.elementIdAttributeName != null) {
            this.jpaProviderDeletesCollection = jpaProvider.supportsJoinTableCleanupOnDelete();
            if (this.cascadeDeleteElement) {
                String elementOwnerIdAttributeName = null;
                if (!StringUtils.isEmpty((CharSequence)this.mappedByAttributeName)) {
                    elementOwnerIdAttributeName = this.mappedByAttributeName + "." + ownerIdAttributeName;
                }
                this.elementDeleter = new UnmappedBasicAttributeCascadeDeleter(evm, "", attribute, elementOwnerIdAttributeName, disallowCycle);
            } else {
                this.elementDeleter = null;
            }
        } else {
            this.jpaProviderDeletesCollection = jpaProvider.supportsCollectionTableCleanupOnDelete();
            this.elementDeleter = null;
        }
    }

    private UnmappedCollectionAttributeCascadeDeleter(UnmappedCollectionAttributeCascadeDeleter original, boolean jpaProviderDeletesCollection) {
        super(original);
        this.ownerEntityClass = original.ownerEntityClass;
        this.ownerIdAttributeName = original.ownerIdAttributeName;
        this.mappedByAttributeName = original.mappedByAttributeName;
        this.jpaProviderDeletesCollection = jpaProviderDeletesCollection;
        this.elementDeleter = original.elementDeleter;
    }

    @Override
    public boolean requiresDeleteCascadeAfterRemove() {
        return false;
    }

    @Override
    public void removeById(UpdateContext context, Object id) {
        throw new UnsupportedOperationException("Can't delete collection attribute by id!");
    }

    @Override
    public void removeByOwnerId(UpdateContext context, Object ownerId) {
        EntityViewManagerImpl evm = context.getEntityViewManager();
        if (this.cascadeDeleteElement) {
            if (this.mappedByAttributeName == null) {
                ArrayList<Object> elementIds;
                if (evm.getDbmsDialect().supportsReturningColumns()) {
                    List tuples = ((DeleteCriteriaBuilder)evm.getCriteriaBuilderFactory().deleteCollection(context.getEntityManager(), this.ownerEntityClass, "e", this.attributeName).where(this.ownerIdAttributeName).eq(ownerId)).executeWithReturning(new String[]{this.attributeName + "." + this.elementIdAttributeName}).getResultList();
                    elementIds = new ArrayList<Object>(tuples.size());
                    for (Tuple tuple : tuples) {
                        elementIds.add(tuple.get(0));
                    }
                } else {
                    elementIds = ((CriteriaBuilder)((CriteriaBuilder)evm.getCriteriaBuilderFactory().create(context.getEntityManager(), this.ownerEntityClass, "e").where(this.ownerIdAttributeName).eq(ownerId)).select("e." + this.attributeName + "." + this.elementIdAttributeName)).getResultList();
                    if (!elementIds.isEmpty()) {
                        DeleteCriteriaBuilder cb = evm.getCriteriaBuilderFactory().deleteCollection(context.getEntityManager(), this.ownerEntityClass, "e", this.attributeName);
                        cb.where(this.ownerIdAttributeName).eq(ownerId);
                        cb.executeUpdate();
                    }
                }
                for (Object e : elementIds) {
                    this.elementDeleter.removeById(context, e);
                }
            } else {
                this.elementDeleter.removeByOwnerId(context, ownerId);
            }
        } else if (!this.jpaProviderDeletesCollection) {
            DeleteCriteriaBuilder cb = evm.getCriteriaBuilderFactory().deleteCollection(context.getEntityManager(), this.ownerEntityClass, "e", this.attributeName);
            cb.where(this.ownerIdAttributeName).eq(ownerId);
            cb.executeUpdate();
        }
    }

    @Override
    public UnmappedAttributeCascadeDeleter createFlusherWiseDeleter() {
        return this.jpaProviderDeletesCollection ? new UnmappedCollectionAttributeCascadeDeleter(this, false) : this;
    }
}

