/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl;

import com.blazebit.persistence.CriteriaBuilder;
import com.blazebit.persistence.FullQueryBuilder;
import com.blazebit.persistence.KeysetPage;
import com.blazebit.persistence.PaginatedCriteriaBuilder;
import com.blazebit.persistence.Path;
import com.blazebit.persistence.parser.expression.ExpressionFactory;
import com.blazebit.persistence.spi.ServiceProvider;
import com.blazebit.persistence.view.EntityViewSetting;
import com.blazebit.persistence.view.Sorter;
import com.blazebit.persistence.view.impl.EntityViewConfiguration;
import com.blazebit.persistence.view.impl.EntityViewManagerImpl;
import com.blazebit.persistence.view.impl.macro.MutableEmbeddingViewJpqlMacro;
import com.blazebit.persistence.view.impl.macro.MutableViewJpqlMacro;
import com.blazebit.persistence.view.impl.metamodel.AbstractMethodAttribute;
import com.blazebit.persistence.view.impl.metamodel.ManagedViewTypeImplementor;
import com.blazebit.persistence.view.impl.metamodel.MappingConstructorImpl;
import com.blazebit.persistence.view.impl.metamodel.ViewTypeImplementor;
import com.blazebit.persistence.view.metamodel.AttributeFilterMapping;
import com.blazebit.persistence.view.metamodel.FlatViewType;
import com.blazebit.persistence.view.metamodel.ManagedViewType;
import com.blazebit.persistence.view.metamodel.MappingAttribute;
import com.blazebit.persistence.view.metamodel.MethodAttribute;
import com.blazebit.persistence.view.metamodel.PluralAttribute;
import com.blazebit.persistence.view.metamodel.SingularAttribute;
import com.blazebit.persistence.view.metamodel.ViewFilterMapping;
import com.blazebit.persistence.view.metamodel.ViewType;
import com.blazebit.persistence.view.spi.EmbeddingViewJpqlMacro;
import com.blazebit.persistence.view.spi.ViewJpqlMacro;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;

public final class EntityViewSettingHelper {
    private EntityViewSettingHelper() {
    }

    public static <T, Q extends FullQueryBuilder<T, Q>> Q apply(EntityViewSetting<T, Q> setting, EntityViewManagerImpl evm, CriteriaBuilder<?> criteriaBuilder, String entityViewRoot) {
        HashSet<String> requestedFetches;
        Map<String, Object> optionalParameters;
        ManagedViewType managedView = evm.getMetamodel().managedView(setting.getEntityViewClass());
        if (managedView == null) {
            throw new IllegalArgumentException("There is no entity view for the class '" + setting.getEntityViewClass().getName() + "' registered!");
        }
        MappingConstructorImpl mappingConstructor = (MappingConstructorImpl)managedView.getConstructor(setting.getViewConstructorName());
        if (managedView instanceof FlatViewType) {
            if (managedView.hasJoinFetchedCollections()) {
                throw new IllegalArgumentException("Can't use the flat view '" + managedView.getJavaType().getName() + "' as view root because it contains join fetched collections! Consider adding a @IdMapping to the entity view or use a different fetch strategy for the collections!");
            }
            if (mappingConstructor == null) {
                if (managedView.getConstructors().size() > 1) {
                    mappingConstructor = (MappingConstructorImpl)managedView.getConstructor("init");
                } else if (managedView.getConstructors().size() == 1) {
                    mappingConstructor = (MappingConstructorImpl)managedView.getConstructors().toArray()[0];
                }
            }
            if (mappingConstructor != null && mappingConstructor.hasJoinFetchedCollections()) {
                throw new IllegalArgumentException("Can't use the flat view '" + managedView.getJavaType().getName() + "' with the mapping constructor '" + mappingConstructor.getName() + "' as view root because it contains join fetched collections! Consider adding a @IdMapping to the entity view or use a different fetch strategy for the collections!");
            }
        }
        if (managedView.isUpdatable() && !setting.getFetches().isEmpty()) {
            throw new IllegalArgumentException("Specifying fetches for @UpdatableEntityViews is currently disallowed. Remove the fetches!");
        }
        ExpressionFactory ef = (ExpressionFactory)criteriaBuilder.getService(ExpressionFactory.class);
        if (setting.getOptionalParameters().isEmpty()) {
            optionalParameters = evm.getOptionalParameters();
        } else {
            optionalParameters = new HashMap<String, Object>(evm.getOptionalParameters());
            optionalParameters.putAll(setting.getOptionalParameters());
            optionalParameters = Collections.unmodifiableMap(optionalParameters);
        }
        if (setting.getFetches().isEmpty() || !setting.hasAttributeFilters() && !setting.hasAttributeSorters()) {
            requestedFetches = setting.getFetches();
        } else {
            requestedFetches = new HashSet<String>(setting.getFetches());
            EntityViewSettingHelper.addFetchesForNonMappingAttributes(setting.getAttributeFilterActivations().keySet(), managedView, requestedFetches);
            EntityViewSettingHelper.addFetchesForNonMappingAttributes(setting.getAttributeSorters().keySet(), managedView, requestedFetches);
        }
        Path root = criteriaBuilder.getPath(entityViewRoot);
        entityViewRoot = root.getPath();
        Q queryBuilder = EntityViewSettingHelper.getQueryBuilder(setting, criteriaBuilder, entityViewRoot, managedView, setting.getProperties());
        EntityViewConfiguration configuration = new EntityViewConfiguration((FullQueryBuilder<?, ?>)queryBuilder, ef, (ViewJpqlMacro)new MutableViewJpqlMacro(), (EmbeddingViewJpqlMacro)new MutableEmbeddingViewJpqlMacro(), optionalParameters, (Map<String, Object>)setting.getProperties(), (Collection<String>)requestedFetches, (ManagedViewTypeImplementor<?>)managedView);
        queryBuilder.selectNew(evm.createObjectBuilder((ManagedViewTypeImplementor<?>)managedView, mappingConstructor, root.getJavaType(), entityViewRoot, null, (FullQueryBuilder<?, ?>)criteriaBuilder, configuration, 0, 0, false));
        Set<String> fetches = configuration.getFetches();
        EntityViewSettingHelper.applyAttributeFilters(setting, evm, queryBuilder, entityViewRoot, fetches, managedView);
        EntityViewSettingHelper.applyViewFilters(setting, evm, queryBuilder, managedView);
        EntityViewSettingHelper.applyAttributeSorters(setting, queryBuilder, entityViewRoot, fetches, managedView);
        EntityViewSettingHelper.applyOptionalParameters(optionalParameters, queryBuilder);
        return queryBuilder;
    }

    private static <T, Q extends FullQueryBuilder<T, Q>> Q getQueryBuilder(EntityViewSetting<T, Q> setting, CriteriaBuilder<?> criteriaBuilder, String entityViewRoot, ManagedViewTypeImplementor<?> managedView, Map<String, Object> properties) {
        if (setting.isPaginated()) {
            boolean extractAllKeysets;
            Object o;
            boolean disableCountQuery;
            PaginatedCriteriaBuilder builder;
            boolean forceUseKeyset;
            KeysetPage keysetPage = setting.getKeysetPage();
            boolean bl = forceUseKeyset = keysetPage != null && EntityViewSettingHelper.getBooleanProperty(properties, "com.blazebit.persistence.view.pagination.force_use_keyset", false);
            if (forceUseKeyset) {
                setting.withKeysetPage(null);
            }
            if (managedView instanceof FlatViewType) {
                builder = setting.isKeysetPaginated() ? (setting.getFirstResult() == -1 ? criteriaBuilder.pageAndNavigate(setting.getEntityId(), setting.getMaxResults()).withKeysetExtraction(true) : criteriaBuilder.page(setting.getKeysetPage(), setting.getFirstResult(), setting.getMaxResults())) : (setting.getFirstResult() == -1 ? criteriaBuilder.page(0, setting.getMaxResults()) : criteriaBuilder.page(setting.getFirstResult(), setting.getMaxResults()));
            } else {
                ArrayList<String> expressions;
                String firstExpression;
                MethodAttribute idAttribute = ((ViewTypeImplementor)managedView).getIdAttribute();
                if (idAttribute.isSubview()) {
                    String prefix = EntityViewSettingHelper.getMapping(entityViewRoot, idAttribute, criteriaBuilder);
                    ManagedViewTypeImplementor type = (ManagedViewTypeImplementor)((SingularAttribute)idAttribute).getType();
                    Set attributes = type.getAttributes();
                    Iterator iterator = attributes.iterator();
                    firstExpression = EntityViewSettingHelper.getMapping(prefix, (MethodAttribute)iterator.next(), criteriaBuilder);
                    if (iterator.hasNext()) {
                        expressions = new ArrayList<String>(attributes.size() - 1);
                        while (iterator.hasNext()) {
                            expressions.add(EntityViewSettingHelper.getMapping(prefix, (MethodAttribute)iterator.next(), criteriaBuilder));
                        }
                    } else {
                        expressions = null;
                    }
                } else {
                    expressions = null;
                    firstExpression = EntityViewSettingHelper.getMapping(entityViewRoot, idAttribute, criteriaBuilder);
                }
                builder = setting.isKeysetPaginated() ? (setting.getFirstResult() == -1 ? criteriaBuilder.pageByAndNavigate(setting.getEntityId(), setting.getMaxResults(), firstExpression, EntityViewSettingHelper.getExpressionArray(expressions)).withKeysetExtraction(true) : criteriaBuilder.pageBy(setting.getKeysetPage(), setting.getFirstResult(), setting.getMaxResults(), firstExpression, EntityViewSettingHelper.getExpressionArray(expressions))) : (setting.getFirstResult() == -1 ? criteriaBuilder.pageBy(0, setting.getMaxResults(), firstExpression, EntityViewSettingHelper.getExpressionArray(expressions)) : criteriaBuilder.pageBy(setting.getFirstResult(), setting.getMaxResults(), firstExpression, EntityViewSettingHelper.getExpressionArray(expressions)));
            }
            if (forceUseKeyset) {
                if (keysetPage.getLowest() != null) {
                    builder.beforeKeyset(keysetPage.getLowest());
                } else if (keysetPage.getHighest() != null) {
                    builder.afterKeyset(keysetPage.getHighest());
                }
            }
            if (disableCountQuery = EntityViewSettingHelper.getBooleanProperty(properties, "com.blazebit.persistence.view.pagination.disable_count_query", false)) {
                builder.withCountQuery(false);
            } else {
                Integer boundedCount = null;
                o = properties.get("com.blazebit.persistence.view.pagination.bounded_count");
                if (o != null) {
                    if (o instanceof Integer || o instanceof Long) {
                        boundedCount = ((Number)o).intValue();
                    } else if (o instanceof String) {
                        boundedCount = Integer.parseInt((String)o);
                    } else {
                        throw new IllegalArgumentException("Invalid value of type " + o.getClass().getName() + " given for the integer property: " + "com.blazebit.persistence.view.pagination.bounded_count");
                    }
                }
                if (boundedCount != null) {
                    builder.withBoundedCount((long)boundedCount.intValue());
                }
            }
            Integer highestKeyOffset = null;
            o = properties.get("com.blazebit.persistence.view.pagination.highest_keyset_offset");
            if (o != null) {
                if (o instanceof Integer) {
                    highestKeyOffset = ((Number)o).intValue();
                } else if (o instanceof String) {
                    highestKeyOffset = Integer.parseInt((String)o);
                } else {
                    throw new IllegalArgumentException("Invalid value of type " + o.getClass().getName() + " given for the integer property: " + "com.blazebit.persistence.view.pagination.highest_keyset_offset");
                }
            }
            if (highestKeyOffset != null) {
                builder.withHighestKeysetOffset(highestKeyOffset.intValue());
            }
            if (extractAllKeysets = EntityViewSettingHelper.getBooleanProperty(properties, "com.blazebit.persistence.view.pagination.extract_all_keysets", false)) {
                builder.withExtractAllKeysets(true);
            }
            return (Q)builder;
        }
        return (Q)criteriaBuilder;
    }

    private static void addFetchesForNonMappingAttributes(Set<String> attributePaths, ManagedViewTypeImplementor<?> managedView, Collection<String> requestedFetches) {
        NavigableMap<String, AbstractMethodAttribute<?, ?>> recursiveAttributes = managedView.getRecursiveAttributes();
        block0: for (String attributePath : attributePaths) {
            int dotIndex = attributePath.length();
            do {
                String path;
                AbstractMethodAttribute methodAttribute;
                if ((methodAttribute = (AbstractMethodAttribute)recursiveAttributes.get(path = attributePath.substring(0, dotIndex))).getCorrelationProviderFactory() == null && methodAttribute.getSubqueryProviderFactory() == null) continue;
                requestedFetches.add(attributePath);
                continue block0;
            } while ((dotIndex = attributePath.lastIndexOf(46, dotIndex - 1)) != -1);
        }
    }

    private static boolean getBooleanProperty(Map<String, Object> properties, String key, boolean defaultValue) {
        Object o = properties.get(key);
        if (o == null) {
            return defaultValue;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof String) {
            return Boolean.parseBoolean(o.toString());
        }
        throw new IllegalArgumentException("Invalid value of type " + o.getClass().getName() + " given for the boolean property: " + key);
    }

    private static String getMapping(String prefix, MethodAttribute<?, ?> attribute, ServiceProvider serviceProvider) {
        MappingAttribute mappingAttribute = (MappingAttribute)attribute;
        StringBuilder sb = new StringBuilder(prefix.length() + mappingAttribute.getMapping().length() + 1);
        mappingAttribute.renderMapping(prefix, serviceProvider, sb);
        return sb.toString();
    }

    private static String[] getExpressionArray(List<String> expressions) {
        if (expressions == null || expressions.isEmpty()) {
            return null;
        }
        return expressions.toArray(new String[expressions.size()]);
    }

    private static <T, Q extends FullQueryBuilder<T, Q>> void applyOptionalParameters(Map<String, Object> optionalParameters, Q normalCb) {
        if (!optionalParameters.isEmpty()) {
            for (Map.Entry<String, Object> paramEntry : optionalParameters.entrySet()) {
                if (!normalCb.containsParameter(paramEntry.getKey()) || normalCb.isParameterSet(paramEntry.getKey())) continue;
                normalCb.setParameter(paramEntry.getKey(), paramEntry.getValue());
            }
        }
    }

    private static <T, Q extends FullQueryBuilder<T, Q>> void applyViewFilters(EntityViewSetting<?, ?> setting, EntityViewManagerImpl evm, Q cb, ManagedViewTypeImplementor<?> viewType) {
        for (String filterName : setting.getViewFilters()) {
            ViewFilterMapping filterMapping = ((ViewType)viewType).getViewFilter(filterName);
            if (filterMapping == null) {
                throw new IllegalArgumentException("Could not find view filter mapping with the name '" + filterName + "' in the entity view type '" + viewType.getJavaType().getName() + "'");
            }
            Object provider = evm.createViewFilter(filterMapping.getFilterClass());
            provider.apply(cb);
        }
    }

    private static <T, Q extends FullQueryBuilder<T, Q>> void applyAttributeFilters(EntityViewSetting<?, ?> setting, EntityViewManagerImpl evm, Q cb, String viewRoot, Set<String> fetches, ManagedViewTypeImplementor<?> entityViewRoot) throws IllegalArgumentException {
        String name = entityViewRoot.getJavaType().getSimpleName();
        StringBuilder sb = null;
        for (Map.Entry attributeFilterEntry : setting.getAttributeFilterActivations().entrySet()) {
            String attributeName = (String)attributeFilterEntry.getKey();
            NavigableMap<String, AbstractMethodAttribute<?, ?>> recursiveAttributes = entityViewRoot.getRecursiveAttributes();
            Map.Entry<String, AbstractMethodAttribute<?, ?>> entry = recursiveAttributes.floorEntry(attributeName);
            if (entry == null || !attributeName.startsWith(entry.getKey())) {
                throw new IllegalArgumentException("The attribute with the name '" + attributeName + "' couldn't be found on the view type '" + name + "'");
            }
            if (attributeName.length() != entry.getKey().length()) {
                throw new IllegalArgumentException("No support yet for entity attribute filtering!");
            }
            if (sb == null) {
                sb = new StringBuilder(name.length() + attributeName.length() + 1);
            } else {
                sb.setLength(0);
            }
            String attributeExpression = fetches.isEmpty() || fetches.contains(attributeName) ? EntityViewSettingHelper.buildAlias(sb, name, attributeName) : EntityViewSettingHelper.buildMapping(sb, cb, viewRoot, recursiveAttributes, attributeName);
            for (EntityViewSetting.AttributeFilterActivation filterActivation : (List)attributeFilterEntry.getValue()) {
                MethodAttribute attribute = entry.getValue();
                AttributeFilterMapping filterMapping = attribute.getFilter(filterActivation.getAttributeFilterName());
                if (filterMapping == null) {
                    throw new IllegalArgumentException("Could not find attribute filter mapping with filter name '" + filterActivation.getAttributeFilterName() + "' for attribute '" + attributeName + "' in the entity view type '" + attribute.getDeclaringType().getJavaType().getName() + "'");
                }
                Class filterClass = filterMapping.getFilterClass();
                Class expectedType = attribute.isCollection() ? ((PluralAttribute)attribute).getElementType().getJavaType() : attribute.getJavaType();
                if (filterClass == null) {
                    throw new IllegalArgumentException("No filter mapping given for the attribute '" + attributeName + "' in the entity view type '" + entityViewRoot.getJavaType().getName() + "'");
                }
                Object filter = evm.createAttributeFilter(filterClass, expectedType, filterActivation.getFilterValue());
                filter.apply(cb, attributeExpression);
            }
        }
    }

    private static <T, Q extends FullQueryBuilder<T, Q>> void applyAttributeSorters(EntityViewSetting<?, ?> setting, Q cb, String viewRoot, Set<String> fetches, ManagedViewTypeImplementor<?> entityViewRoot) {
        String name = entityViewRoot.getJavaType().getSimpleName();
        StringBuilder sb = null;
        for (Map.Entry attributeSorterEntry : setting.getAttributeSorters().entrySet()) {
            String attributeName = (String)attributeSorterEntry.getKey();
            NavigableMap<String, AbstractMethodAttribute<?, ?>> recursiveAttributes = entityViewRoot.getRecursiveAttributes();
            Map.Entry<String, AbstractMethodAttribute<?, ?>> entry = recursiveAttributes.floorEntry(attributeName);
            if (entry == null || !attributeName.startsWith(entry.getKey())) {
                throw new IllegalArgumentException("The attribute with the name '" + attributeName + "' couldn't be found on the view type '" + name + "'");
            }
            if (attributeName.length() != entry.getKey().length()) {
                throw new UnsupportedOperationException("No support yet for entity attribute filtering!");
            }
            Sorter sorter = (Sorter)attributeSorterEntry.getValue();
            if (sb == null) {
                sb = new StringBuilder(name.length() + attributeName.length() + 1);
            } else {
                sb.setLength(0);
            }
            String attributeExpression = fetches.isEmpty() || fetches.contains(attributeName) ? EntityViewSettingHelper.buildAlias(sb, name, attributeName) : EntityViewSettingHelper.buildMapping(sb, cb, viewRoot, recursiveAttributes, attributeName);
            sorter.apply(cb, attributeExpression);
        }
    }

    private static <T, Q extends FullQueryBuilder<T, Q>> String buildMapping(StringBuilder sb, Q cb, String viewRoot, NavigableMap<String, AbstractMethodAttribute<?, ?>> recursiveAttributes, String attributePath) {
        AbstractMethodAttribute methodAttribute;
        String parent;
        int dotIndex = -1;
        sb.append(viewRoot);
        while ((dotIndex = attributePath.indexOf(46, dotIndex + 1)) != -1) {
            parent = sb.toString();
            sb.setLength(0);
            methodAttribute = (AbstractMethodAttribute)recursiveAttributes.get(attributePath.substring(0, dotIndex));
            assert (methodAttribute instanceof MappingAttribute);
            methodAttribute.renderMapping(parent, (ServiceProvider)cb, sb);
        }
        parent = sb.toString();
        sb.setLength(0);
        methodAttribute = (AbstractMethodAttribute)recursiveAttributes.get(attributePath);
        assert (methodAttribute instanceof MappingAttribute);
        methodAttribute.renderMapping(parent, (ServiceProvider)cb, sb);
        return sb.toString();
    }

    private static String buildAlias(StringBuilder sb, String name, String attributeName) {
        sb.append(name).append('_');
        for (int i = 0; i < attributeName.length(); ++i) {
            char c = attributeName.charAt(i);
            if (c == '.') {
                sb.append('_');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

