/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl;

import com.blazebit.persistence.CorrelationQueryBuilder;
import com.blazebit.persistence.From;
import com.blazebit.persistence.FromProvider;
import com.blazebit.persistence.JoinOnBuilder;
import com.blazebit.persistence.ParameterHolder;
import com.blazebit.persistence.Path;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionFactory;
import com.blazebit.persistence.view.CorrelationBuilder;
import com.blazebit.persistence.view.CorrelationProviderFactory;
import com.blazebit.persistence.view.impl.ScalarTargetResolvingExpressionVisitor;
import com.blazebit.persistence.view.impl.SimpleParameterHolder;
import com.blazebit.persistence.view.impl.metamodel.MetamodelBuildingContext;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.Type;

public class TypeExtractingCorrelationBuilder
implements CorrelationBuilder,
FromProvider {
    private static final Logger LOG = Logger.getLogger(TypeExtractingCorrelationBuilder.class.getName());
    private final String viewRootName;
    private final MetamodelBuildingContext context;
    private final ScalarTargetResolvingExpressionVisitor resolver;

    private TypeExtractingCorrelationBuilder(String viewRootName, MetamodelBuildingContext context, ScalarTargetResolvingExpressionVisitor resolver) {
        this.viewRootName = viewRootName;
        this.context = context;
        this.resolver = resolver;
    }

    public static Type<?> extractType(CorrelationProviderFactory factory, String viewRootName, MetamodelBuildingContext context, ScalarTargetResolvingExpressionVisitor resolver) {
        TypeExtractingCorrelationBuilder correlationBuilder = new TypeExtractingCorrelationBuilder(viewRootName, context, resolver);
        try {
            factory.create((ParameterHolder)SimpleParameterHolder.INSTANCE, Collections.emptyMap()).applyCorrelation((CorrelationBuilder)correlationBuilder, "alias");
        }
        catch (TypeExtractingException ex) {
            if (ex.type == null) {
                LOG.log(Level.FINEST, "Couldn't determine type", ex);
            }
            return ex.type;
        }
        catch (InvalidManagedTypeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            LOG.log(Level.FINEST, "Couldn't determine type", ex);
        }
        return null;
    }

    public <T> T getService(Class<T> serviceClass) {
        if (ExpressionFactory.class.equals(serviceClass)) {
            return (T)this.context.getTypeExtractionExpressionFactory();
        }
        return null;
    }

    public FromProvider getCorrelationFromProvider() {
        return this;
    }

    public String getCorrelationAlias() {
        return this.viewRootName;
    }

    public JoinOnBuilder<CorrelationQueryBuilder> correlate(Class<?> entityClass) {
        ManagedType managedType;
        try {
            managedType = this.context.getEntityMetamodel().managedType(entityClass);
        }
        catch (Exception ex) {
            throw new InvalidManagedTypeException();
        }
        throw new TypeExtractingException((Type<?>)managedType);
    }

    public JoinOnBuilder<CorrelationQueryBuilder> correlate(EntityType<?> entityType) {
        throw new TypeExtractingException((Type<?>)entityType);
    }

    public JoinOnBuilder<CorrelationQueryBuilder> correlate(String correlationPath) {
        Expression joinPathExpression = this.context.getTypeValidationExpressionFactory().createJoinPathExpression(correlationPath);
        this.resolver.clear();
        joinPathExpression.accept((Expression.Visitor)this.resolver);
        List<ScalarTargetResolvingExpressionVisitor.TargetType> possibleTargetTypes = this.resolver.getPossibleTargetTypes();
        if (possibleTargetTypes.size() == 1) {
            Type type;
            try {
                type = this.context.getEntityMetamodel().type(possibleTargetTypes.get(0).getLeafBaseValueClass());
            }
            catch (Exception ex) {
                throw new InvalidManagedTypeException();
            }
            throw new TypeExtractingException(type);
        }
        throw new TypeExtractingException(null);
    }

    public Set<From> getRoots() {
        return Collections.emptySet();
    }

    public From getFrom(String alias) {
        return null;
    }

    public From getFromByPath(String path) {
        return null;
    }

    public Path getPath(String path) {
        return null;
    }

    private static class TypeExtractingException
    extends RuntimeException {
        private final Type<?> type;

        public TypeExtractingException(Type<?> type) {
            this.type = type;
        }
    }

    private static class InvalidManagedTypeException
    extends RuntimeException {
        private InvalidManagedTypeException() {
        }
    }
}

