/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.accessor;

import com.blazebit.persistence.view.impl.accessor.AttributeAccessor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class EntityMethodAttributeAccessor
implements AttributeAccessor {
    private final Method getter;
    private final Method setter;
    private final Constructor<?> targetTypeConstructor;

    EntityMethodAttributeAccessor(Method getter, Method setter) {
        this(getter, setter, null);
    }

    EntityMethodAttributeAccessor(Method getter, Method setter, Class<?> targetType) {
        getter.setAccessible(true);
        setter.setAccessible(true);
        this.getter = getter;
        this.setter = setter;
        if (targetType == null) {
            this.targetTypeConstructor = null;
        } else {
            try {
                Constructor<?> declaredConstructor = targetType.getDeclaredConstructor(new Class[0]);
                declaredConstructor.setAccessible(true);
                this.targetTypeConstructor = declaredConstructor;
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("The following type is missing a default constructor: " + targetType.getName());
            }
        }
    }

    @Override
    public void setValue(Object entity, Object value) {
        try {
            this.setter.invoke(entity, value);
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't map value [" + value + "] to entity attribute!", e);
        }
    }

    @Override
    public Object getOrCreateValue(Object entity) {
        if (entity == null) {
            return null;
        }
        try {
            Object result = this.getter.invoke(entity, new Object[0]);
            if (result == null && this.targetTypeConstructor != null) {
                result = this.targetTypeConstructor.newInstance(new Object[0]);
                this.setValue(entity, result);
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't access entity attribute value!", e);
        }
    }

    @Override
    public Object getValue(Object entity) {
        if (entity == null) {
            return null;
        }
        try {
            return this.getter.invoke(entity, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't access entity attribute value!", e);
        }
    }
}

