/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.change;

import com.blazebit.persistence.view.change.ChangeModel;
import com.blazebit.persistence.view.change.SingularChangeModel;
import com.blazebit.persistence.view.impl.change.AbstractChangeModel;
import com.blazebit.persistence.view.impl.change.AbstractPluralChangeModel;
import com.blazebit.persistence.view.impl.change.DirtyChecker;
import com.blazebit.persistence.view.impl.change.PluralDirtyChecker;
import com.blazebit.persistence.view.impl.collection.RecordingCollection;
import com.blazebit.persistence.view.impl.metamodel.AbstractMethodAttribute;
import com.blazebit.persistence.view.impl.metamodel.BasicTypeImpl;
import com.blazebit.persistence.view.impl.metamodel.ManagedViewTypeImplementor;
import com.blazebit.persistence.view.impl.type.TypedValue;
import com.blazebit.persistence.view.spi.type.BasicUserType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class AbstractCollectionChangeModel<C extends Collection<V>, V>
extends AbstractPluralChangeModel<C, V, PluralDirtyChecker<C, V>> {
    public AbstractCollectionChangeModel(ManagedViewTypeImplementor<V> type, BasicTypeImpl<V> basicType, C initial, C current, PluralDirtyChecker<C, V> pluralDirtyChecker) {
        super(type, basicType, initial, current, pluralDirtyChecker);
    }

    public List<SingularChangeModel<V>> getElementChanges() {
        if (this.current == null || ((Collection)this.current).isEmpty()) {
            return this.getRemovedElements();
        }
        if (this.initial == null || ((Collection)this.initial).isEmpty()) {
            return this.getAddedElements();
        }
        if (this.initial == this.current && this.current instanceof RecordingCollection) {
            Set addedElements = ((RecordingCollection)this.current).getAddedElements();
            Set removedElements = ((RecordingCollection)this.current).getRemovedElements();
            ArrayList<SingularChangeModel<V>> elementChanges = new ArrayList<SingularChangeModel<V>>(addedElements.size() + removedElements.size());
            if (this.basicType != null) {
                BasicUserType userType = this.basicType.getUserType();
                if (userType.isMutable()) {
                    if (!userType.supportsDirtyChecking() && !userType.supportsDeepCloning()) {
                        for (Object o : (Collection)this.initial) {
                            if (addedElements.contains(o)) continue;
                            this.addElementChangeModel(elementChanges, o, null);
                        }
                        this.addAddedElementChangeModels(elementChanges, (Collection)this.current);
                        return elementChanges;
                    }
                    TypedValue value = new TypedValue(userType);
                    for (Object o : (Collection)this.current) {
                        value.setValue(o);
                        if (addedElements.contains(value) || removedElements.contains(value)) continue;
                        this.addElementChangeModel(elementChanges, o, o);
                    }
                }
            } else {
                for (Object o : (Collection)this.current) {
                    if (addedElements.contains(o) || removedElements.contains(o)) continue;
                    this.addElementChangeModelIfDirty(elementChanges, o, o);
                }
            }
            this.addAddedElementChangeModels(elementChanges, addedElements);
            this.addRemovedElementChangeModels(elementChanges, removedElements);
            return elementChanges;
        }
        ArrayList<SingularChangeModel<V>> elementChanges = new ArrayList<SingularChangeModel<V>>(((Collection)this.current).size());
        if (this.basicType != null) {
            BasicUserType userType = this.basicType.getUserType();
            if (userType.isMutable() && !userType.supportsDirtyChecking() && !userType.supportsDeepCloning()) {
                this.addAddedElementChangeModels(elementChanges, (Collection)this.current);
                this.addRemovedElementChangeModels(elementChanges, (Collection)this.initial);
                return elementChanges;
            }
            TypedValue value = new TypedValue(userType);
            for (Object o : (Collection)this.current) {
                value.setValue(o);
                if (((Collection)this.initial).contains(value)) continue;
                this.addElementChangeModel(elementChanges, null, o);
            }
            for (Object o : (Collection)this.initial) {
                value.setValue(o);
                if (((Collection)this.current).contains(value)) continue;
                this.addElementChangeModel(elementChanges, o, null);
            }
        } else {
            for (Object o : (Collection)this.current) {
                if (!((Collection)this.initial).contains(o)) {
                    this.addElementChangeModel(elementChanges, null, o);
                    continue;
                }
                this.addElementChangeModelIfDirty(elementChanges, o, o);
            }
            for (Object o : (Collection)this.initial) {
                if (((Collection)this.current).contains(o)) continue;
                this.addElementChangeModel(elementChanges, null, o);
            }
        }
        return elementChanges;
    }

    public List<SingularChangeModel<V>> getAddedElements() {
        if (this.current == null || ((Collection)this.current).isEmpty()) {
            return Collections.emptyList();
        }
        if (this.initial == this.current && this.current instanceof RecordingCollection) {
            BasicUserType userType;
            Set addedElements = ((RecordingCollection)this.current).getAddedElements();
            ArrayList<SingularChangeModel<V>> addedElementModels = new ArrayList<SingularChangeModel<V>>(addedElements.size());
            if (this.basicType != null && (userType = this.basicType.getUserType()).isMutable() && !userType.supportsDirtyChecking() && !userType.supportsDeepCloning()) {
                Set removedElements = ((RecordingCollection)this.current).getRemovedElements();
                for (Object o : (Collection)this.current) {
                    if (removedElements.contains(o)) continue;
                    this.addElementChangeModel(addedElementModels, null, o);
                }
                return addedElementModels;
            }
            this.addAddedElementChangeModels(addedElementModels, addedElements);
            return addedElementModels;
        }
        if (this.initial != this.current) {
            if (this.initial == null) {
                ArrayList<SingularChangeModel<V>> addedElementModels = new ArrayList<SingularChangeModel<V>>(((Collection)this.current).size());
                this.addAddedElementChangeModels(addedElementModels, (Collection)this.current);
                return addedElementModels;
            }
            ArrayList<SingularChangeModel<V>> addedElementModels = new ArrayList<SingularChangeModel<V>>();
            if (this.basicType != null) {
                BasicUserType userType = this.basicType.getUserType();
                if (userType.isMutable() && !userType.supportsDirtyChecking() && !userType.supportsDeepCloning()) {
                    this.addAddedElementChangeModels(addedElementModels, (Collection)this.current);
                    return addedElementModels;
                }
                TypedValue value = new TypedValue(userType);
                for (Object o : (Collection)this.current) {
                    value.setValue(o);
                    if (((Collection)this.initial).contains(value)) continue;
                    this.addElementChangeModel(addedElementModels, null, o);
                }
            } else {
                for (Object o : (Collection)this.current) {
                    if (((Collection)this.initial).contains(o)) continue;
                    this.addElementChangeModel(addedElementModels, null, o);
                }
            }
            return addedElementModels;
        }
        return Collections.emptyList();
    }

    public List<SingularChangeModel<V>> getRemovedElements() {
        if (this.current == null || ((Collection)this.current).isEmpty()) {
            if (this.initial == null) {
                return Collections.emptyList();
            }
            if (this.initial != this.current) {
                ArrayList<SingularChangeModel<V>> removedElementModels = new ArrayList<SingularChangeModel<V>>(((Collection)this.initial).size());
                this.addRemovedElementChangeModels(removedElementModels, (Collection)this.initial);
                return removedElementModels;
            }
        }
        if (this.initial == this.current && this.current instanceof RecordingCollection) {
            BasicUserType userType;
            Set removedElements = ((RecordingCollection)this.current).getRemovedElements();
            ArrayList<SingularChangeModel<V>> removedElementModels = new ArrayList<SingularChangeModel<V>>(removedElements.size());
            if (this.basicType != null && (userType = this.basicType.getUserType()).isMutable() && !userType.supportsDirtyChecking() && !userType.supportsDeepCloning()) {
                Set addedElements = ((RecordingCollection)this.current).getAddedElements();
                for (Object o : (Collection)this.initial) {
                    if (addedElements.contains(o)) continue;
                    this.addElementChangeModel(removedElementModels, o, null);
                }
                return removedElementModels;
            }
            this.addRemovedElementChangeModels(removedElementModels, removedElements);
            return removedElementModels;
        }
        if (this.initial != this.current) {
            if (this.initial == null) {
                return Collections.emptyList();
            }
            ArrayList<SingularChangeModel<V>> removedElementModels = new ArrayList<SingularChangeModel<V>>();
            if (this.basicType != null) {
                BasicUserType userType = this.basicType.getUserType();
                if (userType.isMutable() && !userType.supportsDirtyChecking() && !userType.supportsDeepCloning()) {
                    this.addRemovedElementChangeModels(removedElementModels, (Collection)this.initial);
                    return removedElementModels;
                }
                TypedValue value = new TypedValue(userType);
                for (Object o : (Collection)this.initial) {
                    value.setValue(o);
                    if (((Collection)this.current).contains(value)) continue;
                    this.addElementChangeModel(removedElementModels, o, null);
                }
            } else {
                for (Object o : (Collection)this.initial) {
                    if (((Collection)this.current).contains(o)) continue;
                    this.addElementChangeModel(removedElementModels, o, null);
                }
            }
            return removedElementModels;
        }
        return Collections.emptyList();
    }

    public List<SingularChangeModel<V>> getMutatedElements() {
        if (this.current == null || ((Collection)this.current).isEmpty()) {
            return Collections.emptyList();
        }
        if (this.basicType != null && (!this.basicType.getUserType().isMutable() || this.basicType.getUserType().isMutable() && !this.basicType.getUserType().supportsDirtyChecking())) {
            return Collections.emptyList();
        }
        ArrayList<SingularChangeModel<V>> elementModels = new ArrayList<SingularChangeModel<V>>();
        if (this.initial == this.current && this.current instanceof RecordingCollection) {
            Set removedElements = ((RecordingCollection)this.current).getRemovedElements();
            Set addedElements = ((RecordingCollection)this.current).getAddedElements();
            for (Object o : (Collection)this.current) {
                if (removedElements.contains(o) || addedElements.contains(o)) continue;
                this.addElementChangeModelIfDirty(elementModels, o, o);
            }
        } else {
            if (this.initial == null || ((Collection)this.initial).isEmpty()) {
                return Collections.emptyList();
            }
            if (this.basicType != null) {
                TypedValue value = new TypedValue(this.basicType.getUserType());
                for (Object o : (Collection)this.current) {
                    value.setValue(o);
                    if (!((Collection)this.initial).contains(value)) continue;
                    this.addElementChangeModelIfDirty(elementModels, o, o);
                }
            } else {
                for (Object o : (Collection)this.current) {
                    if (!((Collection)this.initial).contains(o)) continue;
                    this.addElementChangeModelIfDirty(elementModels, o, o);
                }
            }
        }
        return elementModels;
    }

    private void addAddedElementChangeModels(List<SingularChangeModel<V>> elementModels, Collection<V> elements) {
        for (V o : elements) {
            this.addElementChangeModel(elementModels, null, o);
        }
    }

    private void addRemovedElementChangeModels(List<SingularChangeModel<V>> elementModels, Collection<V> elements) {
        for (V o : elements) {
            this.addElementChangeModel(elementModels, o, null);
        }
    }

    private void addElementChangeModels(List<SingularChangeModel<V>> elementModels, Collection<V> elements) {
        for (V o : elements) {
            this.addElementChangeModel(elementModels, o, o);
        }
    }

    private void addElementChangeModel(List<SingularChangeModel<V>> elementModels, V initial, V current) {
        DirtyChecker<V> dirtyChecker = ((PluralDirtyChecker)this.pluralDirtyChecker).getElementDirtyChecker(current != null ? current : initial);
        AbstractChangeModel<V, V> elementChangeModel = this.getObjectChangeModel(this.type == null ? this.basicType : this.type, initial, current, dirtyChecker);
        elementModels.add((SingularChangeModel)elementChangeModel);
    }

    private void addElementChangeModelIfDirty(List<SingularChangeModel<V>> elementModels, V initial, V current) {
        DirtyChecker<V> dirtyChecker;
        AbstractChangeModel<V, V> elementChangeModel = this.getObjectChangeModel(this.type == null ? this.basicType : this.type, initial, current, dirtyChecker = ((PluralDirtyChecker)this.pluralDirtyChecker).getElementDirtyChecker(current != null ? current : initial));
        if (elementChangeModel.isDirty()) {
            elementModels.add((SingularChangeModel)elementChangeModel);
        }
    }

    public boolean isDirty(String attributePath) {
        if (this.type == null) {
            throw new IllegalArgumentException("Invalid dereference of the collection element basic type " + this.basicType + " of the path: " + attributePath);
        }
        if (this.current == null) {
            return false;
        }
        if (this.current instanceof RecordingCollection && !((RecordingCollection)this.current).$$_isDirty()) {
            return false;
        }
        for (Object o : (Collection)this.current) {
            DirtyChecker dirtyChecker;
            if (!this.isDirty(this.type, o, o, dirtyChecker = ((PluralDirtyChecker)this.pluralDirtyChecker).getElementDirtyChecker(o), attributePath)) continue;
            return true;
        }
        return false;
    }

    public boolean isChanged(String attributePath) {
        if (this.type == null) {
            throw new IllegalArgumentException("Invalid dereference of the collection element basic type " + this.basicType + " of the path: " + attributePath);
        }
        if (this.current == null) {
            return false;
        }
        if (this.current instanceof RecordingCollection && !((RecordingCollection)this.current).$$_isDirty()) {
            return false;
        }
        for (Object o : (Collection)this.current) {
            DirtyChecker dirtyChecker;
            if (!this.isChanged(this.type, o, o, dirtyChecker = ((PluralDirtyChecker)this.pluralDirtyChecker).getElementDirtyChecker(o), attributePath)) continue;
            return true;
        }
        return false;
    }

    public <X> List<? extends ChangeModel<X>> get(String attributePath) {
        if (this.type == null) {
            throw new IllegalArgumentException("Invalid dereference of the collection element basic type " + this.basicType);
        }
        if (this.current == null) {
            return Collections.emptyList();
        }
        if (this.current instanceof RecordingCollection && !((RecordingCollection)this.current).$$_isDirty()) {
            return Collections.emptyList();
        }
        ArrayList models = new ArrayList(((Collection)this.current).size());
        for (Object o : (Collection)this.current) {
            DirtyChecker dirtyChecker = ((PluralDirtyChecker)this.pluralDirtyChecker).getElementDirtyChecker(o);
            models.addAll(this.getAll(this.type, o, dirtyChecker, attributePath));
        }
        return models;
    }

    @Override
    protected <X> List<? extends ChangeModel<X>> getAll(AbstractMethodAttribute<?, ?> methodAttribute) {
        if (this.type == null) {
            throw new IllegalArgumentException("Invalid dereference of the collection element basic type " + this.basicType);
        }
        if (this.current == null) {
            return Collections.emptyList();
        }
        if (this.current instanceof RecordingCollection && !((RecordingCollection)this.current).$$_isDirty()) {
            return Collections.emptyList();
        }
        if (this.current instanceof RecordingCollection) {
            RecordingCollection recordingCollection = (RecordingCollection)this.current;
            ArrayList models = new ArrayList(((Collection)this.current).size());
            Set addedElements = recordingCollection.getAddedElements();
            for (Object o : (Collection)this.current) {
                DirtyChecker dirtyChecker = ((PluralDirtyChecker)this.pluralDirtyChecker).getElementDirtyChecker(o);
                AbstractChangeModel<Object, Object> elementChangeModel = addedElements.contains(o) ? this.getObjectChangeModel(this.type, null, o, dirtyChecker) : this.getObjectChangeModel(this.type, o, o, dirtyChecker);
                models.add(elementChangeModel.get(methodAttribute));
            }
            return models;
        }
        ArrayList models = new ArrayList(((Collection)this.current).size());
        HashSet initialElements = this.initial == null ? Collections.emptySet() : new HashSet((Collection)this.initial);
        for (Object o : (Collection)this.current) {
            DirtyChecker dirtyChecker = ((PluralDirtyChecker)this.pluralDirtyChecker).getElementDirtyChecker(o);
            AbstractChangeModel<Object, Object> elementChangeModel = initialElements.contains(o) ? this.getObjectChangeModel(this.type, o, o, dirtyChecker) : this.getObjectChangeModel(this.type, null, o, dirtyChecker);
            models.add(elementChangeModel.get(methodAttribute));
        }
        return models;
    }
}

