/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.type;

import com.blazebit.persistence.view.impl.type.AbstractLocalDateTypeConverter;
import java.lang.reflect.Type;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public abstract class CalendarToLocalDateTypeConverter<T extends Calendar>
extends AbstractLocalDateTypeConverter<T> {
    private static final TimeZone UTC_TIMEZONE = TimeZone.getTimeZone("UTC");
    public static final CalendarToLocalDateTypeConverter<Calendar> JAVA_UTIL_CALENDAR_CONVERTER = new CalendarToLocalDateTypeConverter<Calendar>(){

        public Class<?> getUnderlyingType(Class<?> owningClass, Type declaredType) {
            return Calendar.class;
        }

        public Calendar convertToUnderlyingType(Object object) {
            if (object == null) {
                return null;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeZone(UTC_TIMEZONE);
            calendar.setTimeInMillis(this.toEpochDay(object) * 86400000L);
            return calendar;
        }
    };
    public static final CalendarToLocalDateTypeConverter<GregorianCalendar> JAVA_UTIL_GREGORIAN_CALENDAR_CONVERTER = new CalendarToLocalDateTypeConverter<GregorianCalendar>(){

        public Class<?> getUnderlyingType(Class<?> owningClass, Type declaredType) {
            return GregorianCalendar.class;
        }

        public GregorianCalendar convertToUnderlyingType(Object object) {
            if (object == null) {
                return null;
            }
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTimeZone(UTC_TIMEZONE);
            gregorianCalendar.setTimeInMillis(this.toEpochDay(object) * 86400000L);
            return gregorianCalendar;
        }
    };

    public Object convertToViewType(Calendar object) {
        if (object == null) {
            return null;
        }
        return this.ofEpochDay(object.getTimeInMillis() / 86400000L);
    }
}

