/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.update.flush;

import com.blazebit.persistence.view.InverseRemoveStrategy;
import com.blazebit.persistence.view.OptimisticLockException;
import com.blazebit.persistence.view.impl.accessor.AttributeAccessor;
import com.blazebit.persistence.view.impl.accessor.InitialValueAttributeAccessor;
import com.blazebit.persistence.view.impl.change.DirtyChecker;
import com.blazebit.persistence.view.impl.entity.ViewToEntityMapper;
import com.blazebit.persistence.view.impl.update.EntityViewUpdater;
import com.blazebit.persistence.view.impl.update.UpdateContext;
import com.blazebit.persistence.view.impl.update.UpdateQueryFactory;
import com.blazebit.persistence.view.impl.update.flush.AttributeFetchGraphNode;
import com.blazebit.persistence.view.impl.update.flush.DirtyAttributeFlusher;
import com.blazebit.persistence.view.impl.update.flush.FetchGraphNode;
import com.blazebit.persistence.view.impl.update.flush.InverseCollectionElementAttributeFlusher;
import com.blazebit.persistence.view.impl.update.flush.InverseFlusher;
import com.blazebit.persistence.view.impl.update.flush.PostFlushDeleter;
import com.blazebit.persistence.view.impl.update.flush.PostFlushViewToEntityMapperDeleter;
import com.blazebit.persistence.view.impl.update.flush.UnmappedOwnerAwareDeleter;
import com.blazebit.persistence.view.spi.type.DirtyStateTrackable;
import com.blazebit.persistence.view.spi.type.EntityViewProxy;
import com.blazebit.persistence.view.spi.type.MutableStateTrackable;
import com.blazebit.persistence.view.spi.type.TypeConverter;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.persistence.Query;

public class SubviewAttributeFlusher<E, V>
extends AttributeFetchGraphNode<SubviewAttributeFlusher<E, V>>
implements DirtyAttributeFlusher<SubviewAttributeFlusher<E, V>, E, V> {
    private final boolean optimisticLockProtected;
    private final boolean updatable;
    private final boolean cascadeDelete;
    private final boolean orphanRemoval;
    private final boolean viewOnlyDeleteCascaded;
    private final String[] elementIdAttributePaths;
    private final String parameterName;
    private final boolean passThrough;
    private final TypeConverter<Object, Object> converter;
    private final AttributeAccessor entityAttributeAccessor;
    private final InitialValueAttributeAccessor viewAttributeAccessor;
    private final AttributeAccessor subviewIdAccessor;
    private final ViewToEntityMapper viewToEntityMapper;
    private final InverseFlusher<E> inverseFlusher;
    private final InverseCollectionElementAttributeFlusher.Strategy inverseRemoveStrategy;
    private final V value;
    private final boolean update;
    private final boolean supportElementIdQueryFlush;
    private final ViewFlushOperation flushOperation;
    private final DirtyAttributeFlusher<?, E, V> nestedFlusher;

    public SubviewAttributeFlusher(String attributeName, String mapping, boolean optimisticLockProtected, boolean updatable, boolean cascadeDelete, boolean orphanRemoval, boolean viewOnlyDeleteCascaded, TypeConverter<?, ?> converter, boolean fetch, String[] elementIdAttributePaths, String parameterName, boolean passThrough, boolean isEmbedded, AttributeAccessor entityAttributeAccessor, InitialValueAttributeAccessor viewAttributeAccessor, AttributeAccessor subviewIdAccessor, ViewToEntityMapper viewToEntityMapper, InverseFlusher<E> inverseFlusher, InverseRemoveStrategy inverseRemoveStrategy) {
        super(attributeName, mapping, fetch, viewToEntityMapper.getFullGraphNode());
        this.optimisticLockProtected = optimisticLockProtected;
        this.updatable = updatable;
        this.cascadeDelete = cascadeDelete;
        this.orphanRemoval = orphanRemoval;
        this.viewOnlyDeleteCascaded = viewOnlyDeleteCascaded;
        this.converter = converter;
        this.elementIdAttributePaths = elementIdAttributePaths;
        this.inverseFlusher = inverseFlusher;
        this.inverseRemoveStrategy = InverseCollectionElementAttributeFlusher.Strategy.of(inverseRemoveStrategy);
        this.parameterName = parameterName;
        this.passThrough = passThrough;
        this.entityAttributeAccessor = entityAttributeAccessor;
        this.viewAttributeAccessor = viewAttributeAccessor;
        this.subviewIdAccessor = subviewIdAccessor;
        this.viewToEntityMapper = viewToEntityMapper;
        this.value = null;
        this.update = updatable && entityAttributeAccessor != null;
        this.supportElementIdQueryFlush = isEmbedded || viewToEntityMapper.getIdFlusher() == null;
        this.flushOperation = null;
        this.nestedFlusher = null;
    }

    private SubviewAttributeFlusher(SubviewAttributeFlusher original, boolean fetch, V value, boolean update, DirtyAttributeFlusher<?, E, V> nestedFlusher) {
        super(original.attributeName, original.mapping, fetch, nestedFlusher);
        this.optimisticLockProtected = original.optimisticLockProtected;
        this.updatable = original.updatable;
        this.cascadeDelete = original.cascadeDelete;
        this.orphanRemoval = original.orphanRemoval;
        this.viewOnlyDeleteCascaded = original.viewOnlyDeleteCascaded;
        this.converter = original.converter;
        this.elementIdAttributePaths = original.elementIdAttributePaths;
        this.parameterName = original.parameterName;
        this.passThrough = original.passThrough;
        this.entityAttributeAccessor = original.entityAttributeAccessor;
        this.viewAttributeAccessor = original.viewAttributeAccessor;
        this.subviewIdAccessor = original.subviewIdAccessor;
        this.viewToEntityMapper = original.viewToEntityMapper;
        this.inverseFlusher = original.inverseFlusher;
        this.inverseRemoveStrategy = original.inverseRemoveStrategy;
        this.supportElementIdQueryFlush = original.supportElementIdQueryFlush;
        this.value = value;
        this.update = update;
        this.flushOperation = nestedFlusher == null ? ViewFlushOperation.NONE : ViewFlushOperation.CASCADE;
        this.nestedFlusher = nestedFlusher;
    }

    @Override
    protected FetchGraphNode<?> getNestedGraphNode() {
        return this.nestedFlusher != null ? this.nestedFlusher : this.viewToEntityMapper.getFullGraphNode();
    }

    private DirtyAttributeFlusher<?, Object, Object> getElementIdFlusher() {
        return this.viewToEntityMapper.getIdFlusher();
    }

    @Override
    public V cloneDeep(Object view, V oldValue, V newValue) {
        if (this.updatable) {
            return newValue;
        }
        return oldValue;
    }

    @Override
    public Object getNewInitialValue(UpdateContext context, V clonedValue, V currentValue) {
        return currentValue;
    }

    @Override
    public boolean appendUpdateQueryFragment(UpdateContext context, StringBuilder sb, String mappingPrefix, String parameterPrefix, String separator) {
        if (this.update && (this.updatable || this.isPassThrough()) && this.inverseFlusher == null) {
            if (this.supportElementIdQueryFlush) {
                if (mappingPrefix == null) {
                    return this.getElementIdFlusher().appendUpdateQueryFragment(context, sb, this.mapping + ".", this.parameterName + "_", separator);
                }
                return this.getElementIdFlusher().appendUpdateQueryFragment(context, sb, mappingPrefix + this.mapping + ".", parameterPrefix + this.parameterName + "_", separator);
            }
            if (mappingPrefix == null) {
                sb.append(this.mapping);
                sb.append(" = :");
                sb.append(this.parameterName);
            } else {
                sb.append(mappingPrefix).append(this.mapping);
                sb.append(" = :");
                sb.append(parameterPrefix).append(this.parameterName);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean supportsQueryFlush() {
        return true;
    }

    @Override
    public boolean loadForEntityFlush() {
        return true;
    }

    @Override
    public Query flushQuery(UpdateContext context, String parameterPrefix, UpdateQueryFactory queryFactory, Query query, Object ownerView, Object view, V value, UnmappedOwnerAwareDeleter ownerAwareDeleter, DirtyAttributeFlusher<?, ?, ?> ownerFlusher) {
        Object oldValue;
        boolean doUpdate;
        V finalValue = this.flushOperation == null ? value : this.value;
        finalValue = this.getConvertedValue(finalValue);
        boolean bl = doUpdate = this.updatable || this.isPassThrough();
        if (doUpdate && this.orphanRemoval && (oldValue = this.viewAttributeAccessor.getInitialValue(view)) != null && !Objects.equals(oldValue, finalValue)) {
            context.getOrphanRemovalDeleters().add(new PostFlushViewToEntityMapperDeleter(this.viewToEntityMapper, oldValue));
        }
        if (doUpdate && this.inverseFlusher != null && (oldValue = this.viewAttributeAccessor.getInitialValue(view)) != null && !Objects.equals(oldValue, finalValue)) {
            if (this.inverseRemoveStrategy == InverseCollectionElementAttributeFlusher.Strategy.SET_NULL) {
                this.inverseFlusher.flushQuerySetElement(context, oldValue, view, null, null, null);
            } else {
                this.inverseFlusher.removeElement(context, null, oldValue);
            }
        }
        if (this.flushOperation != null) {
            Object newValue;
            if (this.flushOperation == ViewFlushOperation.CASCADE) {
                if (this.update && this.inverseFlusher != null) {
                    if (finalValue != null) {
                        this.inverseFlusher.flushQuerySetElement(context, finalValue, view, view, null, this.nestedFlusher);
                    }
                } else {
                    int updated;
                    int orphanRemovalStartIndex = context.getOrphanRemovalDeleters().size();
                    Query q = this.nestedFlusher.flushQuery(context, parameterPrefix, this.viewToEntityMapper, null, finalValue, null, finalValue, ownerAwareDeleter, this.nestedFlusher);
                    if (q != null && (updated = q.executeUpdate()) != 1) {
                        throw new OptimisticLockException("The update operation did not return the expected update count!", null, finalValue);
                    }
                    context.removeOrphans(orphanRemovalStartIndex);
                }
            } else if (this.update && this.inverseFlusher != null && finalValue != null) {
                this.inverseFlusher.flushQuerySetElement(context, finalValue, view, view, null, null);
            }
            Object v = this.viewToEntityMapper.applyToEntity(context, null, finalValue);
            if (query != null && this.update && this.inverseFlusher == null) {
                Object realValue;
                Object object = realValue = v == null ? null : this.subviewIdAccessor.getValue(finalValue);
                if (this.supportElementIdQueryFlush) {
                    if (parameterPrefix == null) {
                        this.getElementIdFlusher().flushQuery(context, this.parameterName + "_", queryFactory, query, finalValue, null, realValue, ownerAwareDeleter, null);
                    } else {
                        this.getElementIdFlusher().flushQuery(context, parameterPrefix + this.parameterName + "_", queryFactory, query, finalValue, null, realValue, ownerAwareDeleter, null);
                    }
                } else if (parameterPrefix == null) {
                    query.setParameter(this.parameterName, v);
                } else {
                    query.setParameter(parameterPrefix + this.parameterName, v);
                }
            }
            if (finalValue != (newValue = this.viewAttributeAccessor.getMutableStateValue(view))) {
                this.viewAttributeAccessor.setValue(view, newValue);
            }
            return query;
        }
        if (this.updatable || this.isPassThrough()) {
            Object newValue;
            if (this.nestedFlusher != null && this.nestedFlusher != this.viewToEntityMapper.getFullGraphNode()) {
                if (this.update && this.inverseFlusher != null) {
                    if (finalValue != null) {
                        this.inverseFlusher.flushQuerySetElement(context, finalValue, view, view, null, this.nestedFlusher);
                    }
                } else {
                    int updated;
                    int orphanRemovalStartIndex = context.getOrphanRemovalDeleters().size();
                    Query q = this.nestedFlusher.flushQuery(context, parameterPrefix, this.viewToEntityMapper, null, value, null, value, ownerAwareDeleter, this.nestedFlusher);
                    if (q != null && (updated = q.executeUpdate()) != 1) {
                        throw new OptimisticLockException("The update operation did not return the expected update count!", null, value);
                    }
                    context.removeOrphans(orphanRemovalStartIndex);
                }
            } else if (this.update && this.inverseFlusher != null && finalValue != null) {
                this.inverseFlusher.flushQuerySetElement(context, finalValue, view, view, null, null);
            }
            Object v = this.viewToEntityMapper.applyToEntity(context, null, value);
            if (query != null && this.update && this.inverseFlusher == null) {
                Object realValue;
                Object object = realValue = v == null ? null : this.subviewIdAccessor.getValue(value);
                if (this.supportElementIdQueryFlush) {
                    if (parameterPrefix == null) {
                        this.getElementIdFlusher().flushQuery(context, this.parameterName + "_", queryFactory, query, value, null, realValue, ownerAwareDeleter, null);
                    } else {
                        this.getElementIdFlusher().flushQuery(context, parameterPrefix + this.parameterName + "_", queryFactory, query, value, null, realValue, ownerAwareDeleter, null);
                    }
                } else if (parameterPrefix == null) {
                    query.setParameter(this.parameterName, v);
                } else {
                    query.setParameter(parameterPrefix + this.parameterName, v);
                }
            }
            if (value != (newValue = this.viewAttributeAccessor.getMutableStateValue(view))) {
                this.viewAttributeAccessor.setValue(view, newValue);
            }
        } else {
            Object realValue = view == null ? value : this.viewAttributeAccessor.getValue(view);
            if (this.nestedFlusher != null && this.nestedFlusher != this.viewToEntityMapper.getFullGraphNode()) {
                int updated;
                int orphanRemovalStartIndex = context.getOrphanRemovalDeleters().size();
                Query q = this.nestedFlusher.flushQuery(context, parameterPrefix, this.viewToEntityMapper, null, realValue, null, realValue, ownerAwareDeleter, this.nestedFlusher);
                if (q != null && (updated = q.executeUpdate()) != 1) {
                    throw new OptimisticLockException("The update operation did not return the expected update count!", null, realValue);
                }
                context.removeOrphans(orphanRemovalStartIndex);
            } else if (realValue != null && (value == realValue || this.viewIdEqual(value, realValue))) {
                this.viewToEntityMapper.applyToEntity(context, null, realValue);
            }
            if (view != null && value != realValue && this.viewIdEqual(value, realValue)) {
                this.viewAttributeAccessor.setValue(view, realValue);
            }
        }
        return query;
    }

    @Override
    public boolean flushEntity(UpdateContext context, E entity, Object ownerView, Object view, V value, Runnable postReplaceListener) {
        Object oldValue;
        boolean doUpdate;
        V finalValue = this.flushOperation != null ? this.value : value;
        finalValue = this.getConvertedValue(finalValue);
        boolean bl = doUpdate = this.updatable || this.isPassThrough();
        if (doUpdate && this.orphanRemoval && (oldValue = this.viewAttributeAccessor.getInitialValue(view)) != null && !Objects.equals(oldValue, finalValue)) {
            this.viewToEntityMapper.remove(context, oldValue);
            context.getOrphanRemovalDeleters().add(new PostFlushViewToEntityMapperDeleter(this.viewToEntityMapper, oldValue));
        }
        if (doUpdate && this.inverseFlusher != null && (oldValue = this.viewAttributeAccessor.getInitialValue(view)) != null && !Objects.equals(oldValue, finalValue)) {
            if (this.inverseRemoveStrategy == InverseCollectionElementAttributeFlusher.Strategy.SET_NULL) {
                this.inverseFlusher.flushEntitySetElement(context, oldValue, entity, null, null);
            } else {
                this.inverseFlusher.removeElement(context, entity, oldValue);
            }
        }
        if (this.flushOperation != null) {
            Object newValue;
            if (this.flushOperation == ViewFlushOperation.CASCADE) {
                if (this.update && this.inverseFlusher != null) {
                    this.inverseFlusher.flushEntitySetElement(context, finalValue, entity, entity, this.nestedFlusher);
                } else {
                    this.nestedFlusher.flushEntity(context, null, finalValue, null, finalValue, null);
                }
            } else if (this.update && this.inverseFlusher != null) {
                if (finalValue instanceof MutableStateTrackable) {
                    this.inverseFlusher.flushEntitySetElement(context, finalValue, entity, entity, this.viewToEntityMapper.getNestedDirtyFlusher(context, (MutableStateTrackable)finalValue, null));
                } else {
                    this.inverseFlusher.flushEntitySetElement(context, finalValue, entity, entity, null);
                }
            }
            Object v = this.viewToEntityMapper.applyToEntity(context, null, finalValue);
            if (this.update) {
                this.entityAttributeAccessor.setValue(entity, v);
            }
            if (finalValue != (newValue = this.viewAttributeAccessor.getMutableStateValue(view))) {
                this.viewAttributeAccessor.setValue(view, newValue);
            }
            return true;
        }
        boolean wasDirty = false;
        if (this.updatable || this.isPassThrough()) {
            Object newValue;
            if (this.nestedFlusher != null && this.nestedFlusher != this.viewToEntityMapper.getFullGraphNode()) {
                if (this.update && this.inverseFlusher != null) {
                    this.inverseFlusher.flushEntitySetElement(context, finalValue, entity, entity, this.nestedFlusher);
                    wasDirty |= true;
                } else {
                    wasDirty |= this.nestedFlusher.flushEntity(context, null, finalValue, null, finalValue, null);
                }
            } else if (this.update && this.inverseFlusher != null) {
                this.inverseFlusher.flushEntitySetElement(context, finalValue, entity, entity, null);
            }
            Object v = this.viewToEntityMapper.flushToEntity(context, null, finalValue);
            if (v == null) {
                v = finalValue == view ? entity : this.viewToEntityMapper.loadEntity(context, finalValue);
            } else {
                wasDirty = true;
            }
            if (this.update) {
                if (!wasDirty) {
                    Object oldVal = entity == null ? null : this.entityAttributeAccessor.getValue(entity);
                    Object oldId = oldVal == null ? null : this.viewToEntityMapper.getEntityIdAccessor().getValue(oldVal);
                    Object newId = v == null ? null : this.viewToEntityMapper.getEntityIdAccessor().getValue(v);
                    boolean bl2 = wasDirty = oldVal == null && v != null || !Objects.equals(oldId, newId);
                }
                if (wasDirty) {
                    this.entityAttributeAccessor.setValue(entity, v);
                }
            } else if (this.updatable) {
                wasDirty |= !Objects.equals(this.viewAttributeAccessor.getInitialValue(view), finalValue);
            }
            if (finalValue != (newValue = this.viewAttributeAccessor.getMutableStateValue(view))) {
                this.viewAttributeAccessor.setValue(view, newValue);
            }
        } else {
            Object v;
            Object realValue = this.viewAttributeAccessor.getValue(view);
            if (this.nestedFlusher != null && this.nestedFlusher != this.viewToEntityMapper.getFullGraphNode()) {
                wasDirty |= this.nestedFlusher.flushEntity(context, null, realValue, null, realValue, null);
            } else if (realValue != null && (this.entityAttributeAccessor == null || (finalValue == realValue || this.viewIdEqual(finalValue, realValue)) && this.jpaAndViewIdEqual(this.entityAttributeAccessor.getValue(entity), realValue)) && (v = this.viewToEntityMapper.flushToEntity(context, null, realValue)) != null) {
                wasDirty = true;
            }
            if (view != null && finalValue != realValue && this.viewIdEqual(finalValue, realValue)) {
                this.viewAttributeAccessor.setValue(view, realValue);
            }
        }
        return wasDirty;
    }

    protected final V getConvertedValue(V value) {
        if (this.converter != null) {
            return (V)this.converter.convertToUnderlyingType(value);
        }
        return value;
    }

    @Override
    public List<PostFlushDeleter> remove(UpdateContext context, E entity, Object view, V value) {
        Object valueToDelete;
        if (this.cascadeDelete && (valueToDelete = view instanceof DirtyStateTrackable ? this.viewAttributeAccessor.getInitialValue(view) : value) != null) {
            V convertedValue = this.getConvertedValue(valueToDelete);
            this.viewToEntityMapper.remove(context, convertedValue);
        }
        return Collections.emptyList();
    }

    @Override
    public void remove(UpdateContext context, Object id) {
        this.viewToEntityMapper.removeById(context, id);
    }

    @Override
    public List<PostFlushDeleter> removeByOwnerId(UpdateContext context, Object id) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public void removeFromEntity(UpdateContext context, E entity) {
        Object valueToDelete;
        if (this.cascadeDelete && (valueToDelete = this.entityAttributeAccessor.getValue(entity)) != null) {
            this.viewToEntityMapper.removeById(context, this.viewToEntityMapper.getEntityIdAccessor().getValue(valueToDelete));
        }
    }

    @Override
    public boolean requiresDeleteCascadeAfterRemove() {
        return true;
    }

    @Override
    public boolean isViewOnlyDeleteCascaded() {
        return this.viewOnlyDeleteCascaded;
    }

    @Override
    public boolean isPassThrough() {
        return this.passThrough;
    }

    @Override
    public String getElementIdAttributeName() {
        return this.elementIdAttributePaths[0];
    }

    @Override
    public AttributeAccessor getViewAttributeAccessor() {
        return this.viewAttributeAccessor;
    }

    @Override
    public AttributeAccessor getEntityAttributeAccessor() {
        return this.entityAttributeAccessor;
    }

    @Override
    public String getLockOwner() {
        return null;
    }

    @Override
    public boolean isOptimisticLockProtected() {
        if (this.flushOperation != null) {
            if (this.update && this.optimisticLockProtected) {
                return true;
            }
            if (this.flushOperation == ViewFlushOperation.CASCADE) {
                return this.nestedFlusher != null && this.nestedFlusher.getLockOwner() == null;
            }
            return false;
        }
        return this.optimisticLockProtected || this.nestedFlusher != null && this.nestedFlusher.getLockOwner() == null;
    }

    @Override
    public boolean requiresFlushAfterPersist(V value) {
        if (this.inverseFlusher != null) {
            return this.flushOperation != null && this.update || this.flushOperation == null;
        }
        return false;
    }

    @Override
    public boolean requiresDeferredFlush(V value) {
        return value instanceof EntityViewProxy && ((EntityViewProxy)value).$$_isNew() && !this.viewToEntityMapper.cascades(value);
    }

    @Override
    public <X> DirtyChecker<X>[] getNestedCheckers(V current) {
        return this.viewToEntityMapper.getUpdater(current).getDirtyChecker().getNestedCheckers((DirtyStateTrackable)current);
    }

    @Override
    public DirtyChecker.DirtyKind getDirtyKind(V initial, V current) {
        EntityViewUpdater updater;
        if (current == null) {
            if (initial == null) {
                return DirtyChecker.DirtyKind.NONE;
            }
            return DirtyChecker.DirtyKind.UPDATED;
        }
        if (initial == null) {
            return DirtyChecker.DirtyKind.UPDATED;
        }
        if (initial instanceof DirtyStateTrackable && current instanceof DirtyStateTrackable && (updater = this.viewToEntityMapper.getUpdater(current)) != null) {
            return updater.getDirtyChecker().getDirtyKind((DirtyStateTrackable)initial, (DirtyStateTrackable)current);
        }
        return Objects.equals(initial, current) ? DirtyChecker.DirtyKind.NONE : DirtyChecker.DirtyKind.UPDATED;
    }

    @Override
    public DirtyAttributeFlusher<SubviewAttributeFlusher<E, V>, E, V> getDirtyFlusher(UpdateContext context, Object view, Object initial, Object current) {
        if (this.isPassThrough()) {
            return null;
        }
        if (this.updatable) {
            DirtyAttributeFlusher flusher;
            boolean needsUpdate;
            boolean bl = needsUpdate = this.update && !this.viewIdEqual(initial, current);
            if (initial != current && needsUpdate) {
                DirtyAttributeFlusher flusher2 = null;
                if (current instanceof MutableStateTrackable) {
                    flusher2 = this.viewToEntityMapper.getNestedDirtyFlusher(context, (MutableStateTrackable)current, this);
                }
                return new SubviewAttributeFlusher<E, Object>(this, false, current, needsUpdate, flusher2);
            }
            if (initial == null) {
                return null;
            }
            if (current instanceof MutableStateTrackable && (flusher = this.viewToEntityMapper.getNestedDirtyFlusher(context, (MutableStateTrackable)current, this)) != null) {
                return new SubviewAttributeFlusher<E, Object>(this, true, current, needsUpdate, flusher);
            }
            return null;
        }
        Object newValue = this.viewAttributeAccessor.getValue(view);
        if (current == newValue || this.viewIdEqual(initial, newValue)) {
            DirtyAttributeFlusher flusher = this.viewToEntityMapper.getNestedDirtyFlusher(context, (MutableStateTrackable)newValue, this);
            if (flusher != null) {
                return new SubviewAttributeFlusher<E, Object>(this, true, newValue, false, flusher);
            }
            return null;
        }
        return null;
    }

    private boolean jpaAndViewIdEqual(Object entity, V view) {
        Object v2;
        if (entity == null || view == null) {
            return false;
        }
        Object v1 = this.viewToEntityMapper.getEntityIdAccessor().getValue(entity);
        if (v1 == (v2 = this.subviewIdAccessor.getValue(view))) {
            return true;
        }
        if (v1 == null || v2 == null) {
            return false;
        }
        return v1.equals(v2);
    }

    private boolean viewIdEqual(Object initial, Object current) {
        Object v2;
        if (initial == null || current == null) {
            return false;
        }
        Object v1 = this.subviewIdAccessor.getValue(initial);
        if (v1 == (v2 = this.subviewIdAccessor.getValue(current))) {
            return true;
        }
        if (v1 == null || v2 == null) {
            return false;
        }
        return v1.equals(v2);
    }

    private static enum ViewFlushOperation {
        NONE,
        CASCADE;

    }
}

