/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.collection;

import com.blazebit.persistence.view.impl.collection.RecordingList;
import java.util.List;
import java.util.ListIterator;

public class RecordingListIterator<E>
implements ListIterator<E> {
    private final RecordingList<E> recordingList;
    private final ListIterator<E> iterator;

    public RecordingListIterator(RecordingList<E> recordingList, int index) {
        this.recordingList = recordingList;
        this.iterator = ((List)recordingList.delegate).listIterator(index);
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public E next() {
        return this.iterator.next();
    }

    @Override
    public void remove() {
        int idx = this.iterator.previousIndex();
        this.recordingList.addRemoveAction(idx);
        this.iterator.remove();
    }

    @Override
    public void set(E e) {
        int idx = this.iterator.previousIndex();
        this.recordingList.addSetAction(idx, e);
        this.iterator.set(e);
    }

    @Override
    public void add(E e) {
        int idx = this.iterator.nextIndex();
        this.recordingList.addAddAction(idx, e);
        this.iterator.add(e);
    }

    @Override
    public boolean hasPrevious() {
        return this.iterator.hasPrevious();
    }

    @Override
    public E previous() {
        return this.iterator.previous();
    }

    @Override
    public int nextIndex() {
        return this.iterator.nextIndex();
    }

    @Override
    public int previousIndex() {
        return this.iterator.previousIndex();
    }
}

