/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.processor;

import com.blazebit.persistence.view.processor.Context;
import com.blazebit.persistence.view.processor.EntityViewAnnotationProcessor;
import com.blazebit.persistence.view.processor.ImportContext;
import com.blazebit.persistence.view.processor.MetaEntityView;
import com.blazebit.persistence.view.processor.PrintWriterCloser;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.atomic.LongAdder;
import javax.annotation.processing.Filer;
import javax.annotation.processing.FilerException;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import javax.tools.FileObject;

public abstract class ClassWriter
implements Runnable {
    private static final ThreadLocal<SimpleDateFormat> SIMPLE_DATE_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        public SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        }
    };
    private static final ThreadLocal<StringBuilder> THREAD_LOCAL_STRING_BUILDER = new ThreadLocal<StringBuilder>(){

        @Override
        protected StringBuilder initialValue() {
            return new StringBuilder(65536);
        }
    };
    private final FileObject fileObject;
    private final MetaEntityView entity;
    private final ImportContext importContext;
    private final Context context;
    private final Collection<Runnable> mainThreadQueue;
    private final LongAdder elapsedTime;

    public ClassWriter(FileObject fileObject, MetaEntityView entity, ImportContext importContext, Context context, Collection<Runnable> mainThreadQueue, LongAdder elapsedTime) {
        this.fileObject = fileObject;
        this.entity = entity;
        this.importContext = importContext;
        this.context = context;
        this.mainThreadQueue = mainThreadQueue;
        this.elapsedTime = elapsedTime;
    }

    @Override
    public void run() {
        StringBuilder sb = THREAD_LOCAL_STRING_BUILDER.get();
        sb.setLength(0);
        long start = System.nanoTime();
        String basePackage = this.getPackageName();
        PrintWriter pw = null;
        try {
            OutputStream os = this.fileObject.openOutputStream();
            pw = new PrintWriter(os);
            if (!basePackage.isEmpty()) {
                pw.println("package " + basePackage + ";");
                pw.println();
            }
            this.generateBody(sb, this.entity, this.context);
            if (this.importContext != null) {
                pw.println(this.importContext.generateImports());
            }
            pw.println(sb);
            pw.flush();
        }
        catch (FilerException filerEx) {
            this.context.logMessage(Diagnostic.Kind.ERROR, "Problem with Filer: " + filerEx.getMessage());
        }
        catch (IOException ioEx) {
            this.context.logMessage(Diagnostic.Kind.ERROR, "Problem opening file to write [" + this.fileObject.getName() + "]: " + ioEx.getMessage());
        }
        catch (Exception ex) {
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            this.context.logMessage(Diagnostic.Kind.ERROR, "Error during file generation [" + this.fileObject.getName() + "]: " + sw);
        }
        this.elapsedTime.add(System.nanoTime() - start);
        this.mainThreadQueue.add(new PrintWriterCloser(pw));
    }

    protected String getPackageName() {
        return this.entity.getPackageName();
    }

    protected abstract void generateBody(StringBuilder var1, MetaEntityView var2, Context var3);

    public static FileObject createFile(String basePackage, String simpleName, Context context, Element ... originatingElements) {
        Filer filer = context.getProcessingEnvironment().getFiler();
        Element[] elements = originatingElements.length > 0 && filer.getClass().getName().startsWith("org.gradle.api") ? new Element[]{originatingElements[0]} : originatingElements;
        String fullyQualifiedClassName = ClassWriter.getFullyQualifiedClassName(basePackage, simpleName);
        try {
            return filer.createSourceFile(fullyQualifiedClassName, elements);
        }
        catch (FilerException filerEx) {
            context.logMessage(Diagnostic.Kind.ERROR, "Problem with Filer: " + filerEx.getMessage());
        }
        catch (IOException ioEx) {
            context.logMessage(Diagnostic.Kind.ERROR, "Problem opening file to write " + simpleName + ioEx.getMessage());
        }
        return null;
    }

    private static String getFullyQualifiedClassName(String metaModelPackage, String simpleName) {
        String fullyQualifiedClassName = "";
        if (!metaModelPackage.isEmpty()) {
            fullyQualifiedClassName = fullyQualifiedClassName + metaModelPackage + ".";
        }
        fullyQualifiedClassName = fullyQualifiedClassName + simpleName;
        return fullyQualifiedClassName;
    }

    public static String writeGeneratedAnnotation(ImportContext importContext, Context context) {
        StringBuilder generatedAnnotation = new StringBuilder();
        ClassWriter.writeGeneratedAnnotation(generatedAnnotation, importContext, context);
        return generatedAnnotation.toString();
    }

    public static void writeGeneratedAnnotation(StringBuilder generatedAnnotation, ImportContext importContext, Context context) {
        generatedAnnotation.append("@");
        if (importContext == null) {
            generatedAnnotation.append(context.getGeneratedAnnotation().getQualifiedName().toString());
        } else {
            generatedAnnotation.append(importContext.importType(context.getGeneratedAnnotation().getQualifiedName().toString()));
        }
        generatedAnnotation.append("(value = \"").append(EntityViewAnnotationProcessor.class.getName());
        if (context.addGeneratedDate()) {
            generatedAnnotation.append("\", date = \"").append(SIMPLE_DATE_FORMAT.get().format(new Date())).append("\")");
        } else {
            generatedAnnotation.append("\")");
        }
    }

    public static String writeSuppressWarnings() {
        return "@SuppressWarnings({ \"deprecation\", \"rawtypes\", \"unchecked\" })";
    }
}

