/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.processor;

import com.blazebit.persistence.view.processor.BuilderClassWriter;
import com.blazebit.persistence.view.processor.Context;
import com.blazebit.persistence.view.processor.ForeignPackageAdapterClassWriter;
import com.blazebit.persistence.view.processor.ImplementationClassWriter;
import com.blazebit.persistence.view.processor.MetaEntityView;
import com.blazebit.persistence.view.processor.MetamodelClassWriter;
import com.blazebit.persistence.view.processor.MultiRelationClassWriter;
import com.blazebit.persistence.view.processor.RelationClassWriter;
import com.blazebit.persistence.view.processor.TypeUtils;
import com.blazebit.persistence.view.processor.annotation.AnnotationMetaEntityView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"com.blazebit.persistence.view.EntityView"})
@SupportedOptions(value={"debug", "addGenerationDate", "addGeneratedAnnotation", "addSuppressWarningsAnnotation", "strictCascadingCheck", "defaultVersionAttributeName", "defaultVersionAttributeType", "generateImplementations", "generateBuilders", "createEmptyFlatViews", "generateDeepConstants", "optionalParameters", "threads"})
public class EntityViewAnnotationProcessor
extends AbstractProcessor {
    public static final String DEBUG_OPTION = "debug";
    public static final String ADD_GENERATION_DATE = "addGenerationDate";
    public static final String ADD_GENERATED_ANNOTATION = "addGeneratedAnnotation";
    public static final String ADD_SUPPRESS_WARNINGS_ANNOTATION = "addSuppressWarningsAnnotation";
    public static final String STRICT_CASCADING_CHECK = "strictCascadingCheck";
    public static final String DEFAULT_VERSION_ATTRIBUTE_NAME = "defaultVersionAttributeName";
    public static final String DEFAULT_VERSION_ATTRIBUTE_TYPE = "defaultVersionAttributeType";
    public static final String GENERATE_IMPLEMENTATIONS = "generateImplementations";
    public static final String GENERATE_BUILDERS = "generateBuilders";
    public static final String CREATE_EMPTY_FLAT_VIEWS = "createEmptyFlatViews";
    public static final String GENERATE_DEEP_CONSTANTS = "generateDeepConstants";
    public static final String OPTIONAL_PARAMETERS = "optionalParameters";
    public static final String THREADS = "threads";
    private Context context;

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        this.context = new Context(processingEnvironment);
        this.context.getTypeElement("java.lang.Object").getEnclosedElements();
        this.context.getTypeElement("java.io.Serializable").getEnclosedElements();
        this.context.logMessage(Diagnostic.Kind.NOTE, "Blaze-Persistence Entity-View Annotation Processor");
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!(roundEnv.processingOver() || roundEnv.errorRaised() || annotations.isEmpty())) {
            this.execute(annotations, roundEnv);
            return false;
        }
        return false;
    }

    private void execute(Set<? extends TypeElement> annotations, RoundEnvironment roundEnvironment) {
        long initTime;
        int threads = this.context.getThreads();
        ExecutorService executorService = Executors.newFixedThreadPool(threads);
        long start = initTime = System.nanoTime();
        ArrayList<TypeElement> entityViews = new ArrayList<TypeElement>();
        this.discoverEntityViews(entityViews, roundEnvironment.getRootElements());
        this.context.logMessage(Diagnostic.Kind.NOTE, "Annotation processor discovery took " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start) + "ms");
        start = System.nanoTime();
        for (TypeElement typeElement : entityViews) {
            new AnnotationMetaEntityView(typeElement, this.context);
        }
        this.context.logMessage(Diagnostic.Kind.NOTE, "Annotation processor analysis took " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start) + "ms");
        start = System.nanoTime();
        int views = this.createMetaModelClasses(executorService);
        this.context.logMessage(Diagnostic.Kind.NOTE, "Annotation processor generation took " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start) + "ms");
        this.context.logMessage(Diagnostic.Kind.NOTE, "Annotation processor processed " + views + " entity views with " + threads + " threads and took overall " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - initTime) + "ms");
    }

    private static void await(List<Future<?>> futures) {
        for (Future<?> future : futures) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void discoverEntityViews(List<TypeElement> entityViews, Collection<? extends Element> elements) {
        for (Element element : elements) {
            if (this.isEntityView(element)) {
                this.context.logMessage(Diagnostic.Kind.OTHER, "Processing annotated class " + element.toString());
                this.handleRootElementAnnotationMirrors(entityViews, element);
            }
            this.discoverEntityViews(entityViews, element.getEnclosedElements());
        }
    }

    private int createMetaModelClasses(ExecutorService executorService) {
        LongAdder relationTime = new LongAdder();
        LongAdder multiRelationTime = new LongAdder();
        LongAdder metamodelTime = new LongAdder();
        LongAdder implementationTime = new LongAdder();
        LongAdder builderTime = new LongAdder();
        LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();
        int views = 0;
        long startTime = System.nanoTime();
        for (MetaEntityView entityView : this.context.getMetaEntityViews()) {
            if (!entityView.isValid() || !entityView.getModifiers().contains((Object)Modifier.ABSTRACT) && !entityView.getElementKind().isInterface()) continue;
            ++views;
            RelationClassWriter.writeFile(entityView, this.context, executorService, queue, relationTime);
            MultiRelationClassWriter.writeFile(entityView, this.context, executorService, queue, multiRelationTime);
            MetamodelClassWriter.writeFile(entityView, this.context, executorService, queue, metamodelTime);
            if (!this.context.isGenerateImplementations()) continue;
            ForeignPackageAdapterClassWriter.writeFiles(entityView, this.context, executorService, queue, implementationTime);
            ImplementationClassWriter.writeFile(entityView, this.context, executorService, queue, implementationTime);
            if (!this.context.isGenerateBuilders()) continue;
            BuilderClassWriter.writeFile(entityView, this.context, executorService, queue, builderTime);
        }
        executorService.shutdown();
        long endTime = System.nanoTime();
        this.context.logMessage(Diagnostic.Kind.NOTE, "Scheduling tasks took overall " + TimeUnit.NANOSECONDS.toMillis(endTime - startTime) + "ms");
        do {
            Runnable runnable;
            try {
                runnable = queue.poll(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (runnable == null) continue;
            runnable.run();
        } while (!queue.isEmpty() || !executorService.isTerminated() || !queue.isEmpty());
        this.context.logMessage(Diagnostic.Kind.NOTE, "Processing main thread tasks took overall " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - endTime) + "ms");
        this.context.logMessage(Diagnostic.Kind.NOTE, "Generating relation classes took overall " + TimeUnit.NANOSECONDS.toMillis(relationTime.sum()) + "ms");
        this.context.logMessage(Diagnostic.Kind.NOTE, "Generating multi relation classes took overall " + TimeUnit.NANOSECONDS.toMillis(multiRelationTime.sum()) + "ms");
        this.context.logMessage(Diagnostic.Kind.NOTE, "Generating metamodel classes took overall " + TimeUnit.NANOSECONDS.toMillis(metamodelTime.sum()) + "ms");
        if (this.context.isGenerateImplementations()) {
            this.context.logMessage(Diagnostic.Kind.NOTE, "Generating implementation classes took overall " + TimeUnit.NANOSECONDS.toMillis(implementationTime.sum()) + "ms");
        }
        if (this.context.isGenerateBuilders()) {
            this.context.logMessage(Diagnostic.Kind.NOTE, "Generating builder classes took overall " + TimeUnit.NANOSECONDS.toMillis(builderTime.sum()) + "ms");
        }
        return views;
    }

    private boolean isEntityView(Element element) {
        if (element.getKind() == ElementKind.CLASS || element.getKind() == ElementKind.INTERFACE) {
            return TypeUtils.containsAnnotation(element, "com.blazebit.persistence.view.EntityView");
        }
        return false;
    }

    private void handleRootElementAnnotationMirrors(List<TypeElement> entityViews, Element element) {
        if (!ElementKind.CLASS.equals((Object)element.getKind()) && !ElementKind.INTERFACE.equals((Object)element.getKind())) {
            return;
        }
        TypeElement typeElement = (TypeElement)element;
        entityViews.add(typeElement);
        this.context.initializeEntityViewElement(typeElement);
    }
}

