/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.processor;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

public class EntityViewLifecycleMethod {
    private final String name;
    private final String declaringTypeName;
    private final List<String> parameterTypes;
    private final boolean needsReflectionCall;

    public EntityViewLifecycleMethod(ExecutableElement postCreate) {
        this.name = postCreate.getSimpleName().toString();
        TypeElement declaringType = (TypeElement)postCreate.getEnclosingElement();
        this.declaringTypeName = declaringType.getQualifiedName().toString();
        List<? extends VariableElement> parameters = postCreate.getParameters();
        ArrayList<String> parameterTypes = new ArrayList<String>(parameters.size());
        for (VariableElement variableElement : parameters) {
            parameterTypes.add(variableElement.asType().toString());
        }
        this.parameterTypes = parameterTypes;
        Set<Modifier> modifiers = postCreate.getModifiers();
        this.needsReflectionCall = !modifiers.contains((Object)Modifier.PUBLIC) && !modifiers.contains((Object)Modifier.PROTECTED);
    }

    public String getName() {
        return this.name;
    }

    public String getDeclaringTypeName() {
        return this.declaringTypeName;
    }

    public List<String> getParameterTypes() {
        return this.parameterTypes;
    }

    public boolean needsReflectionCall() {
        return this.needsReflectionCall;
    }
}

