/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.processor;

import com.blazebit.persistence.view.processor.ClassWriter;
import com.blazebit.persistence.view.processor.Context;
import com.blazebit.persistence.view.processor.EntityViewLifecycleMethod;
import com.blazebit.persistence.view.processor.EntityViewSpecialMemberMethod;
import com.blazebit.persistence.view.processor.JavaTypeVariable;
import com.blazebit.persistence.view.processor.MappingKind;
import com.blazebit.persistence.view.processor.MetaAttribute;
import com.blazebit.persistence.view.processor.MetaConstructor;
import com.blazebit.persistence.view.processor.MetaEntityView;
import com.blazebit.persistence.view.processor.annotation.AnnotationMetaCollection;
import com.blazebit.persistence.view.processor.annotation.AnnotationMetaVersionAttribute;
import com.blazebit.persistence.view.processor.serialization.FieldSerializationField;
import com.blazebit.persistence.view.processor.serialization.SerializationField;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.LongAdder;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.FileObject;

public final class ImplementationClassWriter
extends ClassWriter {
    public static final String IMPL_CLASS_NAME_SUFFIX = "Impl";
    public static final String EVM_FIELD_NAME = "ENTITY_VIEW_MANAGER";
    public static final String SERIALIZABLE_EVM_FIELD_NAME = "SERIALIZABLE_ENTITY_VIEW_MANAGER";
    private static final String SERIALIZATION_CLASS_NAME_SUFFIX = "Ser";
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();
    private static final String NEW_LINE = System.lineSeparator();

    private ImplementationClassWriter(FileObject fileObject, MetaEntityView entity, Context context, Collection<Runnable> mainThreadQueue, LongAdder elapsedTime) {
        super(fileObject, entity, entity.getImplementationImportContext(), context, mainThreadQueue, elapsedTime);
    }

    public static void writeFile(MetaEntityView entity, Context context, ExecutorService executorService, Collection<Runnable> mainThreadQueue, LongAdder implementationTime) {
        FileObject fileObject = ClassWriter.createFile(entity.getPackageName(), entity.getSimpleName() + IMPL_CLASS_NAME_SUFFIX, context, entity.getOriginatingElements());
        if (fileObject == null) {
            return;
        }
        executorService.submit(new ImplementationClassWriter(fileObject, entity, context, mainThreadQueue, implementationTime));
    }

    @Override
    public void generateBody(StringBuilder sb, MetaEntityView entity, Context context) {
        if (context.addGeneratedAnnotation()) {
            ClassWriter.writeGeneratedAnnotation(sb, entity.getImplementationImportContext(), context);
            sb.append(NEW_LINE);
        }
        if (context.isAddSuppressWarningsAnnotation()) {
            sb.append(ClassWriter.writeSuppressWarnings());
            sb.append(NEW_LINE);
        }
        sb.append("@").append(entity.implementationImportType("com.blazebit.persistence.view.StaticImplementation")).append("(").append(entity.implementationImportType(entity.getQualifiedName())).append(".class)");
        sb.append(NEW_LINE);
        ImplementationClassWriter.printClassDeclaration(sb, entity, context);
        sb.append(NEW_LINE);
        sb.append("    public static volatile ").append(entity.implementationImportType("com.blazebit.persistence.view.EntityViewManager")).append(" ").append(EVM_FIELD_NAME).append(";");
        sb.append(NEW_LINE);
        sb.append("    public static final ").append(entity.implementationImportType("com.blazebit.persistence.view.SerializableEntityViewManager")).append(" ").append(SERIALIZABLE_EVM_FIELD_NAME);
        sb.append(" = new ").append(entity.implementationImportType("com.blazebit.persistence.view.SerializableEntityViewManager")).append("(").append(entity.getSimpleName()).append(IMPL_CLASS_NAME_SUFFIX).append(".class, ").append(EVM_FIELD_NAME).append(");");
        sb.append(NEW_LINE);
        sb.append(NEW_LINE);
        Collection<MetaAttribute> members = entity.getMembers();
        for (MetaAttribute metaMember : members) {
            if (metaMember instanceof AnnotationMetaVersionAttribute) continue;
            metaMember.appendImplementationAttributeDeclarationString(sb);
            sb.append(NEW_LINE);
        }
        sb.append(NEW_LINE);
        ImplementationClassWriter.printConstructors(sb, entity, context);
        sb.append(NEW_LINE);
        for (MetaAttribute metaMember : members) {
            if (metaMember instanceof AnnotationMetaVersionAttribute) continue;
            metaMember.appendImplementationAttributeGetterAndSetterString(sb, context);
            sb.append(NEW_LINE);
        }
        sb.append(NEW_LINE);
        for (EntityViewSpecialMemberMethod specialMember : entity.getSpecialMembers()) {
            if ("com.blazebit.persistence.view.EntityViewManager".equals(specialMember.getReturnTypeName())) {
                sb.append("    @Override").append(NEW_LINE);
                sb.append("    public ").append(entity.implementationImportType(specialMember.getReturnTypeName())).append(" ").append(specialMember.getName()).append("() {").append(NEW_LINE);
                sb.append("        return ").append(SERIALIZABLE_EVM_FIELD_NAME).append(";").append(NEW_LINE);
                sb.append("    }").append(NEW_LINE);
                sb.append(NEW_LINE);
                continue;
            }
            context.logMessage(Diagnostic.Kind.ERROR, "Unsupported special member: " + specialMember);
        }
        MetaAttribute version = entity.getVersionMember();
        sb.append(NEW_LINE);
        sb.append("    private byte $$_kind;").append(NEW_LINE);
        if (entity.isCreatable() || entity.isUpdatable()) {
            sb.append("    private final Object[] $$_initialState;").append(NEW_LINE);
            sb.append("    private final Object[] $$_mutableState;").append(NEW_LINE);
            sb.append("    private final boolean $$_initialized;").append(NEW_LINE);
            sb.append("    private ").append(entity.implementationImportType("java.util.List")).append("<Object> $$_readOnlyParents;").append(NEW_LINE);
            sb.append("    private ").append(entity.implementationImportType("com.blazebit.persistence.view.spi.type.DirtyTracker")).append(" $$_parent;").append(NEW_LINE);
            sb.append("    private int $$_parentIndex;").append(NEW_LINE);
            sb.append("    private long $$_dirty;").append(NEW_LINE);
        }
        if (version != null && version.getPropertyName().equals("$$_version")) {
            sb.append("    private ").append(version.getImplementationTypeString()).append(" ").append(version.getPropertyName()).append(";").append(NEW_LINE);
        }
        sb.append(NEW_LINE);
        sb.append("    @Override").append(NEW_LINE);
        sb.append("    public Class<?> $$_getJpaManagedClass() {").append(NEW_LINE);
        sb.append("        return ").append(entity.implementationImportType(entity.getEntityClass())).append(".class;").append(NEW_LINE);
        sb.append("    }").append(NEW_LINE);
        sb.append("    @Override").append(NEW_LINE);
        sb.append("    public Class<?> $$_getJpaManagedBaseClass() {").append(NEW_LINE);
        sb.append("        return ").append(entity.implementationImportType(entity.getJpaManagedBaseClass())).append(".class;").append(NEW_LINE);
        sb.append("    }").append(NEW_LINE);
        sb.append("    @Override").append(NEW_LINE);
        String entityViewClassName = entity.implementationImportType(entity.getQualifiedName());
        sb.append("    public Class<?> $$_getEntityViewClass() {").append(NEW_LINE);
        sb.append("        return ").append(entityViewClassName).append(".class;").append(NEW_LINE);
        sb.append("    }").append(NEW_LINE);
        sb.append("    @Override").append(NEW_LINE);
        sb.append("    public boolean $$_isNew() {").append(NEW_LINE);
        if (entity.isCreatable()) {
            sb.append("        return $$_kind == (byte) 2;").append(NEW_LINE);
        } else {
            sb.append("        return false;").append(NEW_LINE);
        }
        sb.append("    }").append(NEW_LINE);
        sb.append("    @Override").append(NEW_LINE);
        sb.append("    public boolean $$_isReference() {").append(NEW_LINE);
        sb.append("        return $$_kind == (byte) 1;").append(NEW_LINE);
        sb.append("    }").append(NEW_LINE);
        sb.append("    @Override").append(NEW_LINE);
        sb.append("    public void $$_setIsReference(boolean isReference) {").append(NEW_LINE);
        sb.append("        if (isReference) {").append(NEW_LINE);
        sb.append("            this.$$_kind = (byte) 1;").append(NEW_LINE);
        sb.append("        } else {").append(NEW_LINE);
        sb.append("            this.$$_kind = (byte) 0;").append(NEW_LINE);
        sb.append("        }").append(NEW_LINE);
        sb.append("    }").append(NEW_LINE);
        sb.append("    @Override").append(NEW_LINE);
        sb.append("    public Object $$_getId() {").append(NEW_LINE);
        sb.append("        return ").append(entity.getIdMember() == null ? "null" : entity.getIdMember().getPropertyName()).append(";").append(NEW_LINE);
        sb.append("    }").append(NEW_LINE);
        sb.append("    @Override").append(NEW_LINE);
        sb.append("    public Object $$_getVersion() {").append(NEW_LINE);
        if (version != null) {
            sb.append("        return ").append(version.getPropertyName()).append(";").append(NEW_LINE);
        } else {
            sb.append("        return null;").append(NEW_LINE);
        }
        sb.append("    }").append(NEW_LINE);
        if (entity.isCreatable() || entity.isUpdatable()) {
            sb.append("    @Override").append(NEW_LINE);
            sb.append("    public boolean $$_isDirty() {").append(NEW_LINE);
            if (entity.isAllSupportDirtyTracking()) {
                sb.append("        return $$_dirty != 0L;").append(NEW_LINE);
            } else {
                sb.append("        return true;").append(NEW_LINE);
            }
            sb.append("    }").append(NEW_LINE);
            sb.append("    @Override").append(NEW_LINE);
            sb.append("    public void $$_markDirty(int attributeIndex) {").append(NEW_LINE);
            sb.append("        this.$$_dirty |= (1 << attributeIndex);").append(NEW_LINE);
            sb.append("        if (this.$$_parent != null) {").append(NEW_LINE);
            sb.append("            this.$$_parent.$$_markDirty(this.$$_parentIndex);").append(NEW_LINE);
            sb.append("        }").append(NEW_LINE);
            sb.append("    }").append(NEW_LINE);
            sb.append("    @Override").append(NEW_LINE);
            sb.append("    public void $$_unmarkDirty() {").append(NEW_LINE);
            sb.append("        this.$$_dirty = ").append(entity.getDefaultDirtyMask()).append("L;").append(NEW_LINE);
            sb.append("    }").append(NEW_LINE);
            sb.append("    @Override").append(NEW_LINE);
            sb.append("    public void $$_setParent(").append(entity.implementationImportType("com.blazebit.persistence.view.spi.type.BasicDirtyTracker")).append(" parent, int parentIndex) {").append(NEW_LINE);
            sb.append("        if (this.$$_parent != null) {").append(NEW_LINE);
            sb.append("            throw new IllegalStateException(\"Parent object for \" + this.toString() + \" is already set to \" + this.$$_parent.toString() + \" and can't be set to: \" + parent.toString());").append(NEW_LINE);
            sb.append("        }").append(NEW_LINE);
            sb.append("        this.$$_parent = (").append(entity.implementationImportType("com.blazebit.persistence.view.spi.type.DirtyTracker")).append(") parent;").append(NEW_LINE);
            sb.append("        this.$$_parentIndex = parentIndex;").append(NEW_LINE);
            sb.append("    }").append(NEW_LINE);
            sb.append("    @Override").append(NEW_LINE);
            sb.append("    public boolean $$_hasParent() {").append(NEW_LINE);
            sb.append("        return this.$$_parent != null;").append(NEW_LINE);
            sb.append("    }").append(NEW_LINE);
            sb.append("    @Override").append(NEW_LINE);
            sb.append("    public void $$_unsetParent() {").append(NEW_LINE);
            sb.append("        if (this.$$_parent != null && this.$$_readOnlyParents != null && !this.$$_readOnlyParents.isEmpty()) {").append(NEW_LINE);
            sb.append("            throw new IllegalStateException(\"Can't unset writable parent \" + this.$$_parent.toString() + \" on object \" + this.toString() + \" because it is still connected to read only parents: \" + this.$$_readOnlyParents);").append(NEW_LINE);
            sb.append("        }").append(NEW_LINE);
            sb.append("        this.$$_parent = null;").append(NEW_LINE);
            sb.append("        this.$$_parentIndex = 0;").append(NEW_LINE);
            sb.append("    }").append(NEW_LINE);
            sb.append("    @Override").append(NEW_LINE);
            sb.append("    public boolean $$_isDirty(int attributeIndex) {").append(NEW_LINE);
            if (!entity.isAllSupportDirtyTracking()) {
                sb.append("        switch (attributeIndex) {").append(NEW_LINE);
                for (MetaAttribute member : members) {
                    if (member.getDirtyStateIndex() == -1 || member.supportsDirtyTracking()) continue;
                    sb.append("            case ").append(member.getDirtyStateIndex()).append(": return true;").append(NEW_LINE);
                }
                sb.append("        }").append(NEW_LINE);
            }
            sb.append("        return (this.$$_dirty & (1L << attributeIndex)) != 0;").append(NEW_LINE);
            sb.append("    }").append(NEW_LINE);
            sb.append("    @Override").append(NEW_LINE);
            sb.append("    public <T> boolean $$_copyDirty(T[] source, T[] target) {").append(NEW_LINE);
            sb.append("        if (this.$$_dirty == 0L) {").append(NEW_LINE);
            sb.append("            return false;").append(NEW_LINE);
            sb.append("        } else {").append(NEW_LINE);
            for (MetaAttribute member : members) {
                if (member.getDirtyStateIndex() == -1) continue;
                if (member.supportsDirtyTracking()) {
                    long mask = 1 << member.getDirtyStateIndex();
                    sb.append("            target[").append(member.getDirtyStateIndex()).append("] = (this.$$_dirty & ").append(mask).append(") == 0 ? null : source[").append(member.getDirtyStateIndex()).append("];").append(NEW_LINE);
                    continue;
                }
                sb.append("            target[").append(member.getDirtyStateIndex()).append("] = source[").append(member.getDirtyStateIndex()).append("];").append(NEW_LINE);
            }
            sb.append("            return true;").append(NEW_LINE);
            sb.append("        }").append(NEW_LINE);
            sb.append("    }").append(NEW_LINE);
            sb.append("    @Override").append(NEW_LINE);
            sb.append("    public void $$_setDirty(long[] dirty) {").append(NEW_LINE);
            if (entity.getDefaultDirtyMask() == 0) {
                sb.append("        this.$$_dirty = dirty[0];").append(NEW_LINE);
            } else {
                sb.append("        this.$$_dirty = dirty[0] | ").append(entity.getDefaultDirtyMask()).append("L;").append(NEW_LINE);
            }
            sb.append("        if (this.$$_dirty != 0L && this.$$_parent != null) {").append(NEW_LINE);
            sb.append("            this.$$_parent.$$_markDirty(this.$$_parentIndex);").append(NEW_LINE);
            sb.append("        }").append(NEW_LINE);
            sb.append("    }").append(NEW_LINE);
            sb.append("    @Override").append(NEW_LINE);
            sb.append("    public long[] $$_resetDirty() {").append(NEW_LINE);
            sb.append("        long[] dirty = new long[]{ this.$$_dirty };").append(NEW_LINE);
            sb.append("        this.$$_dirty = ").append(entity.getDefaultDirtyMask()).append("L;").append(NEW_LINE);
            sb.append("        return dirty;").append(NEW_LINE);
            sb.append("    }").append(NEW_LINE);
            sb.append("    @Override").append(NEW_LINE);
            sb.append("    public long[] $$_getDirty() {").append(NEW_LINE);
            sb.append("        return new long[]{ this.$$_dirty };").append(NEW_LINE);
            sb.append("    }").append(NEW_LINE);
            sb.append("    @Override").append(NEW_LINE);
            sb.append("    public long $$_getSimpleDirty() {").append(NEW_LINE);
            sb.append("        return $$_dirty;").append(NEW_LINE);
            sb.append("    }").append(NEW_LINE);
            sb.append("    @Override").append(NEW_LINE);
            sb.append("    public void $$_replaceAttribute(Object oldObject, int attributeIndex, Object newObject) {").append(NEW_LINE);
            sb.append("        switch (attributeIndex) {").append(NEW_LINE);
            for (MetaAttribute member : members) {
                if (member.getDirtyStateIndex() == -1 || member.getSetterName() == null) continue;
                sb.append("            case ").append(member.getDirtyStateIndex()).append(": ");
                sb.append(member.getSetterName()).append('(');
                if (member.isPrimitive()) {
                    ImplementationClassWriter.appendUnwrap(sb, member.getDeclaredJavaType(), "newObject");
                } else {
                    sb.append("(").append(member.getImplementationTypeString()).append(") newObject");
                }
                sb.append("); break;").append(NEW_LINE);
            }
            sb.append("            default: throw new IllegalArgumentException(\"Invalid non-mutable attribute index: \" + attributeIndex);").append(NEW_LINE);
            sb.append("        }").append(NEW_LINE);
            sb.append("    }").append(NEW_LINE);
            sb.append("    @Override").append(NEW_LINE);
            sb.append("    public Object[] $$_getMutableState() {").append(NEW_LINE);
            sb.append("        return $$_mutableState;").append(NEW_LINE);
            sb.append("    }").append(NEW_LINE);
            sb.append("    @Override").append(NEW_LINE);
            sb.append("    public DirtyTracker $$_getParent() {").append(NEW_LINE);
            sb.append("        return $$_parent;").append(NEW_LINE);
            sb.append("    }").append(NEW_LINE);
            sb.append("    @Override").append(NEW_LINE);
            sb.append("    public List<Object> $$_getReadOnlyParents() {").append(NEW_LINE);
            sb.append("        return $$_readOnlyParents;").append(NEW_LINE);
            sb.append("    }").append(NEW_LINE);
            sb.append("    @Override").append(NEW_LINE);
            sb.append("    public void $$_addReadOnlyParent(DirtyTracker readOnlyParent, int parentIndex) {").append(NEW_LINE);
            if (context.isStrictCascadingCheck()) {
                sb.append("        if (this != readOnlyParent && this.$$_parent == null) {").append(NEW_LINE);
                sb.append("            throw new IllegalStateException(\"Can't set read only parent for object \" + this.toString() + \" util it doesn't have a writable parent! First add the object to an attribute with proper cascading. If you just want to reference it convert the object with EntityViewManager.getReference() or EntityViewManager.convert()!\");").append(NEW_LINE);
                sb.append("        }").append(NEW_LINE);
            }
            sb.append("        if (this.$$_readOnlyParents == null) {").append(NEW_LINE);
            sb.append("            this.$$_readOnlyParents = new ").append(entity.implementationImportType("java.util.ArrayList")).append("<>();").append(NEW_LINE);
            sb.append("        }").append(NEW_LINE);
            sb.append("        this.$$_readOnlyParents.add(readOnlyParent);").append(NEW_LINE);
            sb.append("        this.$$_readOnlyParents.add(parentIndex);").append(NEW_LINE);
            sb.append("        return;").append(NEW_LINE);
            sb.append("    }").append(NEW_LINE);
            sb.append("    @Override").append(NEW_LINE);
            sb.append("    public void $$_removeReadOnlyParent(DirtyTracker readOnlyParent, int parentIndex) {").append(NEW_LINE);
            sb.append("        if (this.$$_readOnlyParents != null) {").append(NEW_LINE);
            sb.append("            int size = this.$$_readOnlyParents.size();").append(NEW_LINE);
            sb.append("            for (int i = 0; i < size; i += 2) {").append(NEW_LINE);
            sb.append("                if (this.$$_readOnlyParents.get(i) == readOnlyParent && ((Integer) this.$$_readOnlyParents.get(i + 1)).intValue() == parentIndex) {").append(NEW_LINE);
            sb.append("                    this.$$_readOnlyParents.remove(i + 1);").append(NEW_LINE);
            sb.append("                    this.$$_readOnlyParents.remove(i);").append(NEW_LINE);
            sb.append("                    break;").append(NEW_LINE);
            sb.append("                }").append(NEW_LINE);
            sb.append("            }").append(NEW_LINE);
            sb.append("        }").append(NEW_LINE);
            sb.append("    }").append(NEW_LINE);
            sb.append("    @Override").append(NEW_LINE);
            sb.append("    public int $$_getParentIndex() {").append(NEW_LINE);
            sb.append("        return $$_parentIndex;").append(NEW_LINE);
            sb.append("    }").append(NEW_LINE);
            sb.append("    @Override").append(NEW_LINE);
            sb.append("    public void $$_setIsNew(boolean isNew) {").append(NEW_LINE);
            if (entity.isCreatable()) {
                sb.append("        if (isNew) {").append(NEW_LINE);
                sb.append("            this.$$_kind = (byte) 2;").append(NEW_LINE);
                sb.append("        } else {").append(NEW_LINE);
                sb.append("            this.$$_kind = (byte) 0;").append(NEW_LINE);
                sb.append("        }").append(NEW_LINE);
            } else {
                sb.append("        // No-op").append(NEW_LINE);
            }
            sb.append("    }").append(NEW_LINE);
            sb.append("    @Override").append(NEW_LINE);
            sb.append("    public void $$_setId(Object id) {").append(NEW_LINE);
            if (entity.getIdMember() == null) {
                sb.append("        throw new UnsupportedOperationException(\"No id attribute available!\");").append(NEW_LINE);
            } else {
                sb.append("        this.").append(entity.getIdMember().getPropertyName()).append(" = (").append(entity.getIdMember().getImplementationTypeString()).append(") id;").append(NEW_LINE);
            }
            sb.append("    }").append(NEW_LINE);
            sb.append("    @Override").append(NEW_LINE);
            sb.append("    public void $$_setVersion(Object version) {").append(NEW_LINE);
            if (version == null) {
                sb.append("        throw new UnsupportedOperationException(\"No version attribute available!\");").append(NEW_LINE);
            } else {
                sb.append("        this.").append(version.getPropertyName()).append(" = ");
                if (version.isPrimitive()) {
                    ImplementationClassWriter.appendUnwrap(sb, version.getDeclaredJavaType(), "version");
                } else {
                    sb.append("(").append(version.getImplementationTypeString()).append(") version");
                }
                sb.append(";").append(NEW_LINE);
            }
            sb.append("    }").append(NEW_LINE);
            sb.append("    @Override").append(NEW_LINE);
            sb.append("    public Object[] $$_getInitialState() {").append(NEW_LINE);
            sb.append("        return $$_initialState;").append(NEW_LINE);
            sb.append("    }").append(NEW_LINE);
        }
        ImplementationClassWriter.appendEqualsHashCodeAndToString(sb, entity, context, members, entityViewClassName);
        if (entity.hasSelfConstructor()) {
            ImplementationClassWriter.appendSerializationClass(sb, entity, context);
        }
        sb.append("}");
        sb.append(NEW_LINE);
    }

    private static void appendSerializationClass(StringBuilder sb, MetaEntityView entity, Context context) {
        String serializableClassSimpleName = entity.getSimpleName() + SERIALIZATION_CLASS_NAME_SUFFIX;
        for (MetaConstructor constructor : entity.getConstructors()) {
            if (!constructor.hasSelfParameter()) continue;
            sb.append("    public static ").append(entity.getSimpleName()).append(" createSelf(");
            for (MetaAttribute member : entity.getMembers()) {
                sb.append(member.getImplementationTypeString()).append(" ").append(member.getPropertyName()).append(", ");
            }
            sb.setCharAt(sb.length() - 2, ')');
            sb.append('{').append(NEW_LINE);
            sb.append("        try {").append(NEW_LINE);
            sb.append("            ").append(serializableClassSimpleName).append(" $ = (").append(serializableClassSimpleName).append(")new java.io.ObjectInputStream(new java.io.ByteArrayInputStream(").append(serializableClassSimpleName).append(".EMPTY_INSTANCE_BYTES)).readObject();").append(NEW_LINE);
            for (MetaAttribute member : entity.getMembers()) {
                sb.append("            $.").append(member.getPropertyName()).append(" = ").append(member.getPropertyName()).append(";").append(NEW_LINE);
            }
            sb.append("            return $;").append(NEW_LINE);
            sb.append("        } catch (Exception ex) {").append(NEW_LINE);
            sb.append("            throw new RuntimeException(ex);").append(NEW_LINE);
            sb.append("        }").append(NEW_LINE);
            sb.append("    }").append(NEW_LINE);
        }
        sb.append("    private static class ").append(serializableClassSimpleName);
        List<JavaTypeVariable> typeArguments = entity.getTypeVariables();
        if (!typeArguments.isEmpty()) {
            sb.append("<");
            typeArguments.get(0).append(entity.getImplementationImportContext(), sb);
            for (int i = 1; i < typeArguments.size(); ++i) {
                sb.append(", ");
                typeArguments.get(i).append(entity.getImplementationImportContext(), sb);
            }
            sb.append(">");
        }
        if (entity.getElementKind() == ElementKind.CLASS) {
            sb.append(" extends ").append(entity.implementationImportType(entity.getBaseSuperclass()));
        } else {
            sb.append(" implements ").append(entity.implementationImportType(entity.getQualifiedName()));
        }
        if (typeArguments.isEmpty()) {
            if (!entity.getForeignPackageSuperTypeVariables().isEmpty()) {
                sb.append("<");
                sb.append(entity.getForeignPackageSuperTypeVariables().get(0));
                for (int i = 1; i < entity.getForeignPackageSuperTypeVariables().size(); ++i) {
                    sb.append(", ");
                    sb.append(entity.getForeignPackageSuperTypeVariables().get(i));
                }
                sb.append(">");
            }
        } else {
            sb.append("<");
            if (!entity.getForeignPackageSuperTypeVariables().isEmpty()) {
                sb.append(entity.getForeignPackageSuperTypeVariables().get(0));
                for (int i = 1; i < entity.getForeignPackageSuperTypeVariables().size(); ++i) {
                    sb.append(", ");
                    sb.append(entity.getForeignPackageSuperTypeVariables().get(i));
                }
                sb.append(", ");
            }
            sb.append(typeArguments.get(0).getName());
            for (int i = 1; i < typeArguments.size(); ++i) {
                sb.append(", ");
                sb.append(typeArguments.get(i).getName());
            }
            sb.append(">");
        }
        if (entity.getElementKind() == ElementKind.CLASS) {
            sb.append(" implements ");
        } else {
            sb.append(", ");
        }
        sb.append(entity.implementationImportType(Serializable.class.getName())).append(" {").append(NEW_LINE);
        sb.append("        private static final long serialVersionUID = 1L;").append(NEW_LINE);
        sb.append("        private static final byte[] EMPTY_INSTANCE_BYTES = new byte[]{");
        ImplementationClassWriter.appendBytesAsHex(sb, ImplementationClassWriter.generateEmptyInstanceBytes(entity.getPackageName() + "." + entity.getSimpleName() + IMPL_CLASS_NAME_SUFFIX + "$" + serializableClassSimpleName, entity, context));
        sb.setCharAt(sb.length() - 1, '}');
        sb.append(';').append(NEW_LINE);
        for (MetaAttribute member : entity.getMembers()) {
            sb.append("        public ").append(member.getImplementationTypeString()).append(" ").append(member.getPropertyName()).append(";").append(NEW_LINE);
        }
        for (MetaConstructor constructor : entity.getConstructors()) {
            sb.append("        private ").append(serializableClassSimpleName).append("(");
            if (constructor.getParameters().isEmpty()) {
                sb.append(") {").append(NEW_LINE);
                sb.append("            super();").append(NEW_LINE);
                sb.append("        }").append(NEW_LINE);
                continue;
            }
            for (MetaAttribute parameter : constructor.getParameters()) {
                sb.append(parameter.getImplementationTypeString()).append(" ").append(parameter.getPropertyName()).append(", ");
            }
            sb.setCharAt(sb.length() - 2, ')');
            sb.append("{").append(NEW_LINE);
            sb.append("            super(");
            for (MetaAttribute parameter : constructor.getParameters()) {
                sb.append(parameter.getPropertyName()).append(", ");
            }
            sb.setCharAt(sb.length() - 2, ')');
            sb.setCharAt(sb.length() - 1, ';');
            sb.append(NEW_LINE);
            sb.append("        }").append(NEW_LINE);
        }
        for (MetaAttribute member : entity.getMembers()) {
            sb.append("        @Override").append(NEW_LINE).append("        public ");
            sb.append(member.getImplementationTypeString());
            sb.append(' ').append(member.getGetterName()).append("() {").append(NEW_LINE).append("            return ").append(member.getPropertyName()).append(";").append(NEW_LINE).append("        }").append(NEW_LINE);
            if (member.getSetterName() == null) continue;
            sb.append("        @Override").append(NEW_LINE).append("        public void ").append(member.getSetterName()).append('(');
            sb.append(member.getImplementationTypeString());
            sb.append(' ').append(member.getPropertyName()).append(") {").append(NEW_LINE);
            sb.append("            this.").append(member.getPropertyName()).append(" = ").append(member.getPropertyName()).append(";").append(NEW_LINE);
            sb.append("        }").append(NEW_LINE);
        }
        for (EntityViewSpecialMemberMethod specialMember : entity.getSpecialMembers()) {
            if ("com.blazebit.persistence.view.EntityViewManager".equals(specialMember.getReturnTypeName())) {
                sb.append("        @Override").append(NEW_LINE);
                sb.append("        public ").append(entity.implementationImportType(specialMember.getReturnTypeName())).append(" ").append(specialMember.getName()).append("() {").append(NEW_LINE);
                sb.append("            return ").append(SERIALIZABLE_EVM_FIELD_NAME).append(";").append(NEW_LINE);
                sb.append("        }").append(NEW_LINE);
                sb.append(NEW_LINE);
                continue;
            }
            context.logMessage(Diagnostic.Kind.ERROR, "Unsupported special member: " + specialMember);
        }
        sb.append("    }").append(NEW_LINE);
    }

    private static void appendBytesAsHex(StringBuilder sb, byte[] bytes) {
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            sb.append(" (byte) 0x");
            sb.append(HEX_ARRAY[v >>> 4]);
            sb.append(HEX_ARRAY[v & 0xF]);
            sb.append(',');
        }
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] generateEmptyInstanceBytes(String serializableClassName, MetaEntityView entity, Context context) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            DataOutputStream oos = new DataOutputStream(baos);
            oos.writeShort(-21267);
            oos.writeShort(5);
            oos.writeByte(115);
            oos.writeByte(114);
            oos.writeUTF(serializableClassName);
            oos.writeLong(1L);
            oos.writeByte(2);
            ArrayList<ArrayList<SerializationField>> serializationFieldHierarchy = new ArrayList<ArrayList<SerializationField>>();
            ArrayList<SerializationField> serializationFields = new ArrayList<SerializationField>();
            for (MetaAttribute member : entity.getMembers()) {
                serializationFields.add(member.getSerializationField());
            }
            serializationFieldHierarchy.add(serializationFields);
            ImplementationClassWriter.writeFields(serializationFields, oos);
            oos.writeByte(120);
            TypeElement superclass = entity.getTypeElement();
            TypeMirror serializableTypeMirror = context.getTypeElement(Serializable.class.getName()).asType();
            while (superclass.getKind() == ElementKind.CLASS && !superclass.getQualifiedName().toString().equals("java.lang.Object")) {
                oos.writeByte(114);
                oos.writeUTF(superclass.getQualifiedName().toString());
                ArrayList<SerializationField> fields = new ArrayList<SerializationField>();
                Object var10_12 = null;
                for (Element element : superclass.getEnclosedElements()) {
                    if (element.getKind() != ElementKind.FIELD) continue;
                    VariableElement variableElement = (VariableElement)element;
                    Set<Modifier> modifiers = variableElement.getModifiers();
                    if (modifiers.contains((Object)Modifier.STATIC)) {
                        if (!modifiers.contains((Object)Modifier.PRIVATE) || !modifiers.contains((Object)Modifier.FINAL) || variableElement.asType().getKind() != TypeKind.LONG) continue;
                        Long l = (Long)variableElement.getConstantValue();
                        continue;
                    }
                    if (modifiers.contains((Object)Modifier.TRANSIENT)) continue;
                    fields.add(new FieldSerializationField(variableElement));
                }
                if (context.getTypeUtils().isAssignable(superclass.asType(), serializableTypeMirror)) {
                    void var10_11;
                    if (var10_11 == null) {
                        oos.writeLong(SerializationField.computeDefaultSUID(superclass, fields));
                    } else {
                        oos.writeLong(var10_11.longValue());
                    }
                    oos.writeByte(2);
                } else {
                    oos.writeLong(0L);
                    oos.writeByte(0);
                }
                serializationFieldHierarchy.add(fields);
                ImplementationClassWriter.writeFields(fields, oos);
                oos.writeByte(120);
                superclass = (TypeElement)((DeclaredType)superclass.getSuperclass()).asElement();
            }
            oos.writeByte(112);
            for (List list : serializationFieldHierarchy) {
                block17: for (SerializationField serializationField : list) {
                    if (serializationField.isPrimitive()) {
                        switch (serializationField.getTypeKind()) {
                            case INT: {
                                oos.writeInt(0);
                                continue block17;
                            }
                            case BYTE: {
                                oos.writeByte(0);
                                continue block17;
                            }
                            case LONG: {
                                oos.writeLong(0L);
                                continue block17;
                            }
                            case FLOAT: {
                                oos.writeFloat(0.0f);
                                continue block17;
                            }
                            case DOUBLE: {
                                oos.writeDouble(0.0);
                                continue block17;
                            }
                            case SHORT: {
                                oos.writeShort(0);
                                continue block17;
                            }
                            case CHAR: {
                                oos.writeChar(0);
                                continue block17;
                            }
                            case BOOLEAN: {
                                oos.writeBoolean(false);
                                continue block17;
                            }
                            case VOID: {
                                oos.writeByte(112);
                                continue block17;
                            }
                        }
                        throw new UnsupportedOperationException("Unsupported primitive type: " + serializationField.getTypeCode());
                    }
                    oos.writeByte(112);
                }
            }
            oos.flush();
            return baos.toByteArray();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void writeFields(List<SerializationField> serializationFields, DataOutputStream oos) throws Exception {
        Collections.sort(serializationFields);
        oos.writeShort(serializationFields.size());
        for (SerializationField serializationField : serializationFields) {
            oos.writeByte(serializationField.getTypeCode());
            oos.writeUTF(serializationField.getName());
            if (serializationField.isPrimitive()) continue;
            oos.writeByte(116);
            oos.writeUTF(serializationField.getTypeString());
        }
    }

    private static void appendUnwrap(StringBuilder sb, String type, String field) {
        if ("long".equals(type)) {
            sb.append("((Long) ").append(field).append(").longValue()");
        } else if ("float".equals(type)) {
            sb.append("((Float) ").append(field).append(").floatValue()");
        } else if ("double".equals(type)) {
            sb.append("((Double) ").append(field).append(").doubleValue()");
        } else if ("int".equals(type)) {
            sb.append("((Integer) ").append(field).append(").intValue()");
        } else if ("short".equals(type)) {
            sb.append("((Short) ").append(field).append(").shortValue()");
        } else if ("byte".equals(type)) {
            sb.append("((Byte) ").append(field).append(").byteValue()");
        } else if ("boolean".equals(type)) {
            sb.append("((Boolean) ").append(field).append(").booleanValue()");
        } else if ("char".equals(type)) {
            sb.append("((Character) ").append(field).append(").charValue()");
        } else {
            throw new UnsupportedOperationException("Unwrap not possible for type: " + type);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void appendEqualsHashCodeAndToString(StringBuilder sb, MetaEntityView entity, Context context, Collection<MetaAttribute> members, String entityViewClassName) {
        boolean generateEqualsHashCode;
        boolean bl = generateEqualsHashCode = !entity.hasCustomEqualsOrHashCodeMethod();
        if (generateEqualsHashCode) {
            Collection<MetaAttribute> equalityMembers;
            sb.append("    @Override").append(NEW_LINE);
            sb.append("    public boolean equals(Object obj) {").append(NEW_LINE);
            sb.append("        if (this == obj) {").append(NEW_LINE);
            sb.append("            return true;").append(NEW_LINE);
            sb.append("        }").append(NEW_LINE);
            if (entity.getIdMember() == null) {
                equalityMembers = members;
            } else {
                equalityMembers = Collections.singleton(entity.getIdMember());
                sb.append("        if (obj == null || this.$$_getId() == null) {").append(NEW_LINE);
                sb.append("            return false;").append(NEW_LINE);
                sb.append("        }").append(NEW_LINE);
                sb.append("        if (obj instanceof ").append(entity.implementationImportType("com.blazebit.persistence.view.spi.type.EntityViewProxy")).append(") {").append(NEW_LINE);
                sb.append("            ").append(entity.implementationImportType("com.blazebit.persistence.view.spi.type.EntityViewProxy")).append(" other = (").append(entity.implementationImportType("com.blazebit.persistence.view.spi.type.EntityViewProxy")).append(") obj;").append(NEW_LINE);
                sb.append("            if (this.$$_getJpaManagedBaseClass() == other.$$_getJpaManagedBaseClass() && this.$$_getId().equals(other.$$_getId())) {").append(NEW_LINE);
                sb.append("                return true;").append(NEW_LINE);
                sb.append("            } else {").append(NEW_LINE);
                sb.append("                return false;").append(NEW_LINE);
                sb.append("            }").append(NEW_LINE);
                sb.append("        }").append(NEW_LINE);
            }
            String baseType = entity.implementationImportType(entity.getBaseSuperclass());
            if (!baseType.equals(entityViewClassName)) {
                boolean needsForeignPackageClass = false;
                for (MetaAttribute equalityMember : equalityMembers) {
                    Set<Modifier> modifiers = equalityMember.getGetterModifiers();
                    boolean containsProtected = modifiers.contains((Object)Modifier.PROTECTED);
                    if ((modifiers.contains((Object)Modifier.PUBLIC) || containsProtected) && (!containsProtected || entity.getPackageName().equals(equalityMember.getGetterPackageName()))) continue;
                    needsForeignPackageClass = true;
                }
                if (!needsForeignPackageClass) {
                    baseType = entityViewClassName;
                }
            }
            sb.append("        if (obj instanceof ").append(baseType).append(") {").append(NEW_LINE);
            sb.append("            ").append(baseType).append(" other = (").append(baseType).append(") obj;").append(NEW_LINE);
            for (MetaAttribute member : equalityMembers) {
                if (member instanceof AnnotationMetaVersionAttribute) continue;
                if (member.isPrimitive()) {
                    sb.append("            if (this.").append(member.getPropertyName()).append(" != other.").append(member.getGetterName()).append("()) {").append(NEW_LINE);
                } else {
                    sb.append("            if (!").append(entity.implementationImportType(Objects.class.getName())).append(".equals(this.").append(member.getPropertyName()).append(", other.").append(member.getGetterName()).append("())) {").append(NEW_LINE);
                }
                sb.append("                return false;").append(NEW_LINE);
                sb.append("            }").append(NEW_LINE);
            }
            sb.append("            return true;").append(NEW_LINE);
            sb.append("        }").append(NEW_LINE);
            sb.append("        return false;").append(NEW_LINE);
            sb.append("    }").append(NEW_LINE);
            sb.append("    @Override").append(NEW_LINE);
            sb.append("    public int hashCode() {").append(NEW_LINE);
            sb.append("        long bits;").append(NEW_LINE);
            sb.append("        int hash = 3;").append(NEW_LINE);
            for (MetaAttribute member : equalityMembers) {
                if (member instanceof AnnotationMetaVersionAttribute) continue;
                String type = member.getDeclaredJavaType();
                if ("double".equals(type)) {
                    sb.append("        bits = java.lang.Double.doubleToLongBits(this.").append(member.getPropertyName()).append(");").append(NEW_LINE);
                }
                sb.append("        hash = 83 * hash + ");
                if (member.isPrimitive()) {
                    if ("boolean".equals(type)) {
                        sb.append("(this.").append(member.getPropertyName()).append(" ? 1231 : 1237)");
                    } else if ("byte".equals(type) || "short".equals(type) || "char".equals(type)) {
                        sb.append("(int) this.").append(member.getPropertyName());
                    } else if ("int".equals(type)) {
                        sb.append("this.").append(member.getPropertyName());
                    } else if ("long".equals(type)) {
                        sb.append("(int)(this.").append(member.getPropertyName()).append(" ^ (this.").append(member.getPropertyName()).append(" >>> 32))");
                    } else if ("float".equals(type)) {
                        sb.append("java.lang.Float.floatToIntBits(this.").append(member.getPropertyName()).append(")");
                    } else {
                        if (!"double".equals(type)) throw new IllegalArgumentException("Unsupported primitive type: " + type);
                        sb.append("(int)(bits ^ (bits >>> 32))");
                    }
                } else {
                    sb.append("(this.").append(member.getPropertyName()).append(" != null ? this.").append(member.getPropertyName()).append(".hashCode() : 0)");
                }
                sb.append(";").append(NEW_LINE);
            }
            sb.append("        return hash;").append(NEW_LINE);
            sb.append("    }").append(NEW_LINE);
        }
        if (entity.hasCustomToStringMethod()) return;
        boolean bl2 = true;
        boolean generateToString = bl2;
        if (!generateToString) return;
        sb.append("    @Override").append(NEW_LINE);
        sb.append("    public String toString() {").append(NEW_LINE);
        if (entity.getIdMember() == null) {
            int sizeEstimate = entityViewClassName.length() + 2;
            for (MetaAttribute member : members) {
                if (member instanceof AnnotationMetaVersionAttribute) continue;
                sizeEstimate += member.getPropertyName().length() + 5 + 10;
            }
            sb.append("        StringBuilder sb = new StringBuilder(").append(sizeEstimate).append(");").append(NEW_LINE);
            sb.append("        sb.append(\"").append(entityViewClassName).append("(\");").append(NEW_LINE);
            if (!members.isEmpty()) {
                MetaAttribute member;
                Iterator<MetaAttribute> iterator = members.iterator();
                member = iterator.next();
                sb.append("        sb.append(\"").append(member.getPropertyName()).append(" = \").append(this.").append(member.getPropertyName()).append(");").append(NEW_LINE);
                while (iterator.hasNext()) {
                    member = iterator.next();
                    if (member instanceof AnnotationMetaVersionAttribute) continue;
                    sb.append("        sb.append(\", \");").append(NEW_LINE);
                    sb.append("        sb.append(\"").append(member.getPropertyName()).append(" = \").append(this.").append(member.getPropertyName()).append(");").append(NEW_LINE);
                }
            }
            sb.append("        sb.append(')');").append(NEW_LINE);
            sb.append("        return sb.toString();").append(NEW_LINE);
        } else {
            sb.append("        return \"").append(entityViewClassName).append("(").append(entity.getIdMember().getPropertyName()).append(" = \" + this.").append(entity.getIdMember().getPropertyName()).append(" + \")\";").append(NEW_LINE);
        }
        sb.append("    }").append(NEW_LINE);
    }

    private static void printClassDeclaration(StringBuilder sb, MetaEntityView entity, Context context) {
        int i;
        sb.append("public class ").append(entity.getSimpleName()).append(IMPL_CLASS_NAME_SUFFIX);
        List<JavaTypeVariable> typeArguments = entity.getTypeVariables();
        if (!typeArguments.isEmpty()) {
            sb.append("<");
            typeArguments.get(0).append(entity.getImplementationImportContext(), sb);
            for (i = 1; i < typeArguments.size(); ++i) {
                sb.append(", ");
                typeArguments.get(i).append(entity.getImplementationImportContext(), sb);
            }
            sb.append(">");
        }
        if (entity.getElementKind() == ElementKind.INTERFACE) {
            sb.append(" implements ");
        } else {
            sb.append(" extends ");
        }
        sb.append(entity.implementationImportType(entity.getBaseSuperclass()));
        if (typeArguments.isEmpty()) {
            if (!entity.getForeignPackageSuperTypeVariables().isEmpty()) {
                sb.append("<");
                sb.append(entity.getForeignPackageSuperTypeVariables().get(0));
                for (i = 1; i < entity.getForeignPackageSuperTypeVariables().size(); ++i) {
                    sb.append(", ");
                    sb.append(entity.getForeignPackageSuperTypeVariables().get(i));
                }
                sb.append(">");
            }
        } else {
            sb.append("<");
            if (!entity.getForeignPackageSuperTypeVariables().isEmpty()) {
                sb.append(entity.getForeignPackageSuperTypeVariables().get(0));
                for (i = 1; i < entity.getForeignPackageSuperTypeVariables().size(); ++i) {
                    sb.append(", ");
                    sb.append(entity.getForeignPackageSuperTypeVariables().get(i));
                }
                sb.append(", ");
            }
            sb.append(typeArguments.get(0).getName());
            for (i = 1; i < typeArguments.size(); ++i) {
                sb.append(", ");
                sb.append(typeArguments.get(i).getName());
            }
            sb.append(">");
        }
        if (entity.getElementKind() == ElementKind.INTERFACE) {
            sb.append(", ");
        } else {
            sb.append(" implements ");
        }
        sb.append(entity.implementationImportType("com.blazebit.persistence.view.spi.type.EntityViewProxy"));
        if (entity.isUpdatable() || entity.isCreatable()) {
            sb.append(", ").append(entity.implementationImportType("com.blazebit.persistence.view.spi.type.DirtyStateTrackable"));
        }
        sb.append(" {");
        sb.append(NEW_LINE);
    }

    private static void printConstructors(StringBuilder sb, MetaEntityView entity, Context context) {
        boolean postLoadReflection = ImplementationClassWriter.preparePostLoad(sb, entity, context);
        if (entity.hasEmptyConstructor()) {
            if (entity.getMembers().size() > 0) {
                ImplementationClassWriter.printCreateConstructor(sb, entity, context);
                sb.append(NEW_LINE);
            }
            if (entity.getIdMember() != null && entity.getMembers().size() > 1) {
                ImplementationClassWriter.printIdConstructor(sb, entity, context);
                sb.append(NEW_LINE);
            }
        }
        for (MetaConstructor constructor : entity.getConstructors()) {
            ImplementationClassWriter.printConstructor(sb, constructor, postLoadReflection, context);
            sb.append(NEW_LINE);
            ImplementationClassWriter.printTupleConstructor(sb, constructor, postLoadReflection, context);
            sb.append(NEW_LINE);
            ImplementationClassWriter.printTupleAssignmentConstructor(sb, constructor, postLoadReflection, context);
            sb.append(NEW_LINE);
        }
    }

    private static void printConstructor(StringBuilder sb, MetaConstructor constructor, boolean postLoadReflection, Context context) {
        MetaEntityView entity = constructor.getHostingEntity();
        sb.append("    public ").append(entity.getSimpleName()).append(IMPL_CLASS_NAME_SUFFIX).append("(");
        boolean first = true;
        MetaAttribute idMember = entity.getIdMember();
        if (idMember != null) {
            sb.append(NEW_LINE);
            sb.append("        ").append(idMember.getImplementationTypeString()).append(" ").append(idMember.getPropertyName());
            first = false;
        }
        for (MetaAttribute member : entity.getMembers()) {
            if (first) {
                first = false;
            } else if (member != idMember) {
                sb.append(",");
            }
            if (member == idMember) continue;
            sb.append(NEW_LINE);
            sb.append("        ").append(member.getImplementationTypeString()).append(" ").append(member.getPropertyName());
        }
        for (MetaAttribute member : constructor.getParameters()) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(NEW_LINE);
            sb.append("        ").append(member.getImplementationTypeString()).append(" ").append(member.getPropertyName());
        }
        if (first) {
            sb.append(entity.getSimpleName()).append(IMPL_CLASS_NAME_SUFFIX).append(" noop, ").append(entity.implementationImportType("java.util.Map")).append("<String, Object> ").append("blazePersistenceOptionalParameters").append(") {");
        } else {
            sb.append(NEW_LINE);
            sb.append("    ) {");
        }
        sb.append(NEW_LINE);
        sb.append("        super(");
        first = true;
        for (MetaAttribute member : constructor.getParameters()) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(NEW_LINE);
            sb.append("            ").append(member.getPropertyName());
        }
        if (first) {
            sb.append(");");
        } else {
            sb.append(NEW_LINE);
            sb.append("        );");
        }
        sb.append(NEW_LINE);
        if (entity.isCreatable() || entity.isUpdatable()) {
            if (entity.getDefaultDirtyMask() != 0) {
                sb.append("        this.$$_dirty |= ").append(entity.getDefaultDirtyMask()).append("L;").append(NEW_LINE);
            }
            sb.append("        Object[] initialStateArr = new Object[").append(entity.getMutableAttributeCount()).append("];").append(NEW_LINE);
            sb.append("        Object[] mutableStateArr = new Object[").append(entity.getMutableAttributeCount()).append("];").append(NEW_LINE);
        }
        for (MetaAttribute member : entity.getMembers()) {
            boolean possiblyInitialized = ImplementationClassWriter.appendPossiblyInitializedFragment(sb, constructor, member);
            sb.append("        this.").append(member.getPropertyName()).append(" = ").append(member.getPropertyName()).append(";").append(NEW_LINE);
            if (member.getDirtyStateIndex() != -1) {
                if (possiblyInitialized) {
                    sb.append("            if (this.").append(member.getPropertyName()).append(" == ");
                    if (member.isPrimitive()) {
                        member.appendDefaultValue(sb, false, true, entity.getImplementationImportContext());
                    } else {
                        sb.append("null");
                    }
                    sb.append(") {").append(NEW_LINE);
                    sb.append("                mutableStateArr[").append(member.getDirtyStateIndex()).append("] = ").append(member.getPropertyName()).append(";").append(NEW_LINE);
                    sb.append("            } else {").append(NEW_LINE);
                    sb.append("                mutableStateArr[").append(member.getDirtyStateIndex()).append("] = this.").append(member.getPropertyName()).append(";").append(NEW_LINE);
                    sb.append("            }").append(NEW_LINE);
                    sb.append("            initialStateArr[").append(member.getDirtyStateIndex()).append("] = ");
                    sb.append(member.getPropertyName()).append(";").append(NEW_LINE);
                } else {
                    sb.append("        mutableStateArr[").append(member.getDirtyStateIndex()).append("] = ");
                    sb.append("initialStateArr[").append(member.getDirtyStateIndex()).append("] = ");
                    sb.append(member.getPropertyName()).append(";").append(NEW_LINE);
                }
            }
            if (!possiblyInitialized) continue;
            sb.append("        }").append(NEW_LINE);
        }
        ImplementationClassWriter.printDirtyTrackerRegistration(sb, entity);
        ImplementationClassWriter.printPostLoad(sb, entity, postLoadReflection, context);
        sb.append("    }");
        sb.append(NEW_LINE);
    }

    private static void printTupleConstructor(StringBuilder sb, MetaConstructor constructor, boolean postLoadReflection, Context context) {
        MetaEntityView entity = constructor.getHostingEntity();
        if (constructor.getParameters().isEmpty()) {
            sb.append("    public ").append(entity.getSimpleName()).append(IMPL_CLASS_NAME_SUFFIX).append("(").append(entity.getSimpleName()).append(IMPL_CLASS_NAME_SUFFIX).append(" noop, int offset, Object[] tuple) {").append(NEW_LINE);
            sb.append("        super();").append(NEW_LINE);
        } else {
            sb.append("    public ").append(entity.getSimpleName()).append(IMPL_CLASS_NAME_SUFFIX).append("(").append(NEW_LINE);
            sb.append("        ").append(entity.getSimpleName()).append(IMPL_CLASS_NAME_SUFFIX).append(" noop,").append(NEW_LINE);
            sb.append("        int offset,").append(NEW_LINE);
            sb.append("        Object[] tuple");
            for (MetaAttribute member : constructor.getParameters()) {
                sb.append(",");
                sb.append(NEW_LINE);
                sb.append("        ").append(member.getImplementationTypeString()).append(" ").append(member.getPropertyName());
            }
            sb.append(NEW_LINE).append("    ) {").append(NEW_LINE);
            sb.append("        super(");
            boolean first = true;
            int attributeCount = entity.getMembers().size();
            for (MetaAttribute member : constructor.getParameters()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(NEW_LINE);
                sb.append("            ");
                if (member.isSelf()) {
                    sb.append("createSelf(");
                    for (MetaAttribute attribute : entity.getMembers()) {
                        sb.append(NEW_LINE).append("                (").append(attribute.getImplementationTypeString()).append(") tuple[offset + ").append(attribute.getAttributeIndex()).append("],");
                    }
                    sb.setLength(sb.length() - 1);
                    sb.append(NEW_LINE);
                    sb.append("            )");
                    continue;
                }
                sb.append("(").append(member.getImplementationTypeString()).append(") tuple[offset + ").append(attributeCount + member.getAttributeIndex()).append("]");
            }
            if (first) {
                sb.append(");");
            } else {
                sb.append(NEW_LINE);
                sb.append("        );");
            }
            sb.append(NEW_LINE);
        }
        if (entity.isCreatable() || entity.isUpdatable()) {
            if (entity.getDefaultDirtyMask() != 0) {
                sb.append("        this.$$_dirty |= ").append(entity.getDefaultDirtyMask()).append("L;").append(NEW_LINE);
            }
            sb.append("        Object[] initialStateArr = new Object[").append(entity.getMutableAttributeCount()).append("];").append(NEW_LINE);
            sb.append("        Object[] mutableStateArr = new Object[").append(entity.getMutableAttributeCount()).append("];").append(NEW_LINE);
        }
        for (MetaAttribute member : entity.getMembers()) {
            boolean possiblyInitialized = ImplementationClassWriter.appendPossiblyInitializedFragment(sb, constructor, member);
            sb.append("        this.").append(member.getPropertyName()).append(" = (").append(member.getImplementationTypeString()).append(") tuple[offset + ").append(member.getAttributeIndex()).append("];").append(NEW_LINE);
            if (member.getDirtyStateIndex() != -1) {
                if (possiblyInitialized) {
                    sb.append("            if (this.").append(member.getPropertyName()).append(" == ");
                    if (member.isPrimitive()) {
                        member.appendDefaultValue(sb, false, true, entity.getImplementationImportContext());
                    } else {
                        sb.append("null");
                    }
                    sb.append(") {").append(NEW_LINE);
                    sb.append("                mutableStateArr[").append(member.getDirtyStateIndex()).append("] = tuple[offset + ").append(member.getAttributeIndex()).append("];").append(NEW_LINE);
                    sb.append("            } else {").append(NEW_LINE);
                    sb.append("                mutableStateArr[").append(member.getDirtyStateIndex()).append("] = this.").append(member.getPropertyName()).append(";").append(NEW_LINE);
                    sb.append("            }").append(NEW_LINE);
                    sb.append("            initialStateArr[").append(member.getDirtyStateIndex()).append("] = tuple[offset + ").append(member.getAttributeIndex()).append("];").append(NEW_LINE);
                } else {
                    sb.append("        mutableStateArr[").append(member.getDirtyStateIndex()).append("] = initialStateArr[").append(member.getDirtyStateIndex()).append("] = tuple[offset + ").append(member.getAttributeIndex()).append("];").append(NEW_LINE);
                }
            }
            if (!possiblyInitialized) continue;
            sb.append("        }").append(NEW_LINE);
        }
        ImplementationClassWriter.printDirtyTrackerRegistration(sb, entity);
        ImplementationClassWriter.printPostLoad(sb, entity, postLoadReflection, context);
        sb.append("    }");
        sb.append(NEW_LINE);
    }

    private static boolean appendPossiblyInitializedFragment(StringBuilder sb, MetaConstructor constructor, MetaAttribute member) {
        boolean possiblyInitialized;
        if (constructor == null) {
            for (MetaConstructor metaConstructor : member.getHostingEntity().getConstructors()) {
                if (!metaConstructor.getParameters().isEmpty()) continue;
                constructor = metaConstructor;
                break;
            }
        }
        boolean bl = possiblyInitialized = constructor.isReal() && member.getSetterName() != null;
        if (possiblyInitialized) {
            MetaEntityView entity = member.getHostingEntity();
            sb.append("        if (this.").append(member.getPropertyName()).append(" == ");
            if (member.isPrimitive()) {
                member.appendDefaultValue(sb, false, true, entity.getImplementationImportContext());
            } else {
                sb.append("null");
            }
            sb.append(") {").append(NEW_LINE);
            sb.append("    ");
        }
        return possiblyInitialized;
    }

    private static void printTupleAssignmentConstructor(StringBuilder sb, MetaConstructor constructor, boolean postLoadReflection, Context context) {
        MetaEntityView entity = constructor.getHostingEntity();
        if (constructor.getParameters().isEmpty()) {
            sb.append("    public ").append(entity.getSimpleName()).append(IMPL_CLASS_NAME_SUFFIX).append("(").append(entity.getSimpleName()).append(IMPL_CLASS_NAME_SUFFIX).append(" noop, int offset, int[] assignment, Object[] tuple) {").append(NEW_LINE);
            sb.append("        super();").append(NEW_LINE);
        } else {
            sb.append("    public ").append(entity.getSimpleName()).append(IMPL_CLASS_NAME_SUFFIX).append("(").append(NEW_LINE);
            sb.append("        ").append(entity.getSimpleName()).append(IMPL_CLASS_NAME_SUFFIX).append(" noop,").append(NEW_LINE);
            sb.append("        int offset,").append(NEW_LINE);
            sb.append("        int[] assignment,").append(NEW_LINE);
            sb.append("        Object[] tuple");
            for (MetaAttribute member : constructor.getParameters()) {
                sb.append(",");
                sb.append(NEW_LINE);
                sb.append("        ").append(member.getImplementationTypeString()).append(" ").append(member.getPropertyName());
            }
            sb.append(NEW_LINE).append("    ) {").append(NEW_LINE);
            sb.append("        super(");
            boolean first = true;
            int attributeCount = entity.getMembers().size();
            for (MetaAttribute member : constructor.getParameters()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(NEW_LINE);
                sb.append("            ");
                if (member.isSelf()) {
                    sb.append("createSelf(");
                    for (MetaAttribute attribute : entity.getMembers()) {
                        sb.append(NEW_LINE).append("                (").append(attribute.getImplementationTypeString()).append(") tuple[offset + assignment[").append(attribute.getAttributeIndex()).append("]],");
                    }
                    sb.setLength(sb.length() - 1);
                    sb.append(NEW_LINE);
                    sb.append("            )");
                    continue;
                }
                sb.append("(").append(member.getImplementationTypeString()).append(") tuple[offset + assignment[").append(attributeCount + member.getAttributeIndex()).append("]]");
            }
            if (first) {
                sb.append(");");
            } else {
                sb.append(NEW_LINE);
                sb.append("        );");
            }
            sb.append(NEW_LINE);
        }
        if (entity.isCreatable() || entity.isUpdatable()) {
            if (entity.getDefaultDirtyMask() != 0) {
                sb.append("        this.$$_dirty |= ").append(entity.getDefaultDirtyMask()).append("L;").append(NEW_LINE);
            }
            sb.append("        Object[] initialStateArr = new Object[").append(entity.getMutableAttributeCount()).append("];").append(NEW_LINE);
            sb.append("        Object[] mutableStateArr = new Object[").append(entity.getMutableAttributeCount()).append("];").append(NEW_LINE);
        }
        for (MetaAttribute member : entity.getMembers()) {
            boolean possiblyInitialized = ImplementationClassWriter.appendPossiblyInitializedFragment(sb, constructor, member);
            sb.append("        this.").append(member.getPropertyName()).append(" = (").append(member.getImplementationTypeString()).append(") tuple[offset + assignment[").append(member.getAttributeIndex()).append("]];").append(NEW_LINE);
            if (member.getDirtyStateIndex() != -1) {
                if (possiblyInitialized) {
                    sb.append("            if (this.").append(member.getPropertyName()).append(" == ");
                    if (member.isPrimitive()) {
                        member.appendDefaultValue(sb, false, true, entity.getImplementationImportContext());
                    } else {
                        sb.append("null");
                    }
                    sb.append(") {").append(NEW_LINE);
                    sb.append("                mutableStateArr[").append(member.getDirtyStateIndex()).append("] = tuple[offset + assignment[").append(member.getAttributeIndex()).append("]];").append(NEW_LINE);
                    sb.append("            } else {").append(NEW_LINE);
                    sb.append("                mutableStateArr[").append(member.getDirtyStateIndex()).append("] = this.").append(member.getPropertyName()).append(";").append(NEW_LINE);
                    sb.append("            }").append(NEW_LINE);
                    sb.append("            initialStateArr[").append(member.getDirtyStateIndex()).append("] = tuple[offset + assignment[").append(member.getAttributeIndex()).append("]];").append(NEW_LINE);
                } else {
                    sb.append("        mutableStateArr[").append(member.getDirtyStateIndex()).append("] = initialStateArr[").append(member.getDirtyStateIndex()).append("] = tuple[offset + assignment[").append(member.getAttributeIndex()).append("]];").append(NEW_LINE);
                }
            }
            if (!possiblyInitialized) continue;
            sb.append("        }").append(NEW_LINE);
        }
        ImplementationClassWriter.printDirtyTrackerRegistration(sb, entity);
        ImplementationClassWriter.printPostLoad(sb, entity, postLoadReflection, context);
        sb.append("    }");
        sb.append(NEW_LINE);
    }

    private static void printCreateConstructor(StringBuilder sb, MetaEntityView entity, Context context) {
        EntityViewLifecycleMethod postCreate = entity.getPostCreateForReflection();
        boolean postCreateReflection = false;
        if (postCreate != null && (postCreateReflection = postCreate.needsReflectionCall())) {
            sb.append("    private static final ").append(entity.implementationImportType(Method.class.getName())).append(" $$_post_create;").append(NEW_LINE);
            sb.append("    static {").append(NEW_LINE);
            sb.append("        try {").append(NEW_LINE);
            sb.append("            Method m = ").append(entity.implementationImportType(postCreate.getDeclaringTypeName())).append(".class.getDeclaredMethod(\"").append(postCreate.getName()).append("\"");
            if (!postCreate.getParameterTypes().isEmpty()) {
                for (String parameterType : postCreate.getParameterTypes()) {
                    sb.append(", ").append(entity.implementationImportType(parameterType)).append(".class");
                }
            }
            sb.append(");").append(NEW_LINE);
            sb.append("            m.setAccessible(true);").append(NEW_LINE);
            sb.append("            $$_post_create = m;").append(NEW_LINE);
            sb.append("        } catch (Exception ex) {").append(NEW_LINE);
            sb.append("            throw new RuntimeException(\"Could not initialize post construct accessor!\", ex);").append(NEW_LINE);
            sb.append("        }").append(NEW_LINE);
            sb.append("    }").append(NEW_LINE);
        }
        sb.append("    public ").append(entity.getSimpleName()).append(IMPL_CLASS_NAME_SUFFIX).append("(").append(entity.getSimpleName()).append(IMPL_CLASS_NAME_SUFFIX).append(" noop, ").append(entity.implementationImportType("java.util.Map")).append("<String, Object> ").append("blazePersistenceOptionalParameters").append(") {");
        sb.append(NEW_LINE);
        if (entity.isCreatable() || entity.isUpdatable()) {
            if (entity.getDefaultDirtyMask() != 0) {
                sb.append("        this.$$_dirty |= ").append(entity.getDefaultDirtyMask()).append("L;").append(NEW_LINE);
            }
            sb.append("        Object[] initialStateArr = new Object[").append(entity.getMutableAttributeCount()).append("];").append(NEW_LINE);
            sb.append("        Object[] mutableStateArr = new Object[").append(entity.getMutableAttributeCount()).append("];").append(NEW_LINE);
            if (entity.isCreatable()) {
                sb.append("        this.$$_kind = (byte) 2;").append(NEW_LINE);
            }
        }
        for (MetaAttribute member : entity.getMembers()) {
            boolean possiblyInitialized = ImplementationClassWriter.appendPossiblyInitializedFragment(sb, null, member);
            sb.append("        this.").append(member.getPropertyName()).append(" = ");
            if (member.getDirtyStateIndex() != -1) {
                sb.append("(").append(member.getImplementationTypeString()).append(") (mutableStateArr[").append(member.getDirtyStateIndex()).append("] = ");
            }
            if (member.getKind() == MappingKind.PARAMETER) {
                if (member.isPrimitive()) {
                    sb.append("!").append("blazePersistenceOptionalParameters").append(".containsKey(\"").append(member.getMapping()).append("\") ? ");
                    member.appendDefaultValue(sb, false, true, entity.getImplementationImportContext());
                    sb.append(" : ");
                }
                sb.append("(").append(member.getImplementationTypeString()).append(") ").append("blazePersistenceOptionalParameters").append(".get(\"").append(member.getMapping()).append("\")");
            } else {
                member.appendDefaultValue(sb, true, true, entity.getImplementationImportContext());
            }
            if (member.getDirtyStateIndex() != -1) {
                sb.append(")");
            }
            sb.append(";").append(NEW_LINE);
            if (!possiblyInitialized) continue;
            sb.append("        }").append(NEW_LINE);
        }
        ImplementationClassWriter.printDirtyTrackerRegistration(sb, entity);
        if (postCreate != null) {
            if (postCreateReflection) {
                sb.append("        try {").append(NEW_LINE);
                sb.append("            $$_post_create.invoke(this");
            } else {
                sb.append("        ").append(postCreate.getName()).append("(");
            }
            if (!postCreate.getParameterTypes().isEmpty()) {
                if (postCreateReflection) {
                    sb.append(", ");
                }
                Iterator<Object> iterator = postCreate.getParameterTypes().iterator();
                while (iterator.hasNext()) {
                    String parameterType;
                    switch (parameterType = (String)iterator.next()) {
                        case "com.blazebit.persistence.view.EntityViewManager": {
                            sb.append(SERIALIZABLE_EVM_FIELD_NAME);
                            break;
                        }
                        default: {
                            sb.append("(").append(parameterType).append(") null");
                        }
                    }
                    sb.append(", ");
                }
                sb.setLength(sb.length() - 2);
            }
            sb.append(");").append(NEW_LINE);
            if (postCreateReflection) {
                sb.append("        } catch (Exception ex) {").append(NEW_LINE);
                sb.append("            throw new RuntimeException(\"Could not invoke post create method\", ex);").append(NEW_LINE);
                sb.append("        }").append(NEW_LINE);
            }
        }
        sb.append("    }");
        sb.append(NEW_LINE);
    }

    private static void printDirtyTrackerRegistration(StringBuilder sb, MetaEntityView entity) {
        if (entity.isCreatable() || entity.isUpdatable()) {
            sb.append("        this.$$_initialState = initialStateArr;").append(NEW_LINE);
            sb.append("        this.$$_mutableState = mutableStateArr;").append(NEW_LINE);
            sb.append("        this.$$_initialized = true;").append(NEW_LINE);
            for (MetaAttribute member : entity.getMembers()) {
                if ((member.getDirtyStateIndex() == -1 || !(member instanceof AnnotationMetaCollection)) && !member.isSubview()) continue;
                sb.append("        if (this.").append(member.getPropertyName()).append(" instanceof ").append(entity.implementationImportType("com.blazebit.persistence.view.spi.type.BasicDirtyTracker")).append(") {").append(NEW_LINE);
                sb.append("            ((").append(entity.implementationImportType("com.blazebit.persistence.view.spi.type.BasicDirtyTracker")).append(") this.").append(member.getPropertyName()).append(").$$_setParent(this, ").append(member.getDirtyStateIndex()).append(");").append(NEW_LINE);
                sb.append("        }").append(NEW_LINE);
            }
        }
    }

    private static boolean preparePostLoad(StringBuilder sb, MetaEntityView entity, Context context) {
        EntityViewLifecycleMethod postLoad = entity.getPostLoad();
        boolean postLoadReflection = false;
        if (postLoad != null && (postLoadReflection = postLoad.needsReflectionCall())) {
            sb.append("    private static final ").append(entity.implementationImportType(Method.class.getName())).append(" $$_post_load;").append(NEW_LINE);
            sb.append("    static {").append(NEW_LINE);
            sb.append("        try {").append(NEW_LINE);
            sb.append("            Method m = ").append(entity.implementationImportType(postLoad.getDeclaringTypeName())).append(".class.getDeclaredMethod(\"").append(postLoad.getName()).append("\"");
            if (!postLoad.getParameterTypes().isEmpty()) {
                for (String parameterType : postLoad.getParameterTypes()) {
                    sb.append(", ").append(entity.implementationImportType(parameterType)).append(".class");
                }
            }
            sb.append(");").append(NEW_LINE);
            sb.append("            m.setAccessible(true);").append(NEW_LINE);
            sb.append("            $$_post_load = m;").append(NEW_LINE);
            sb.append("        } catch (Exception ex) {").append(NEW_LINE);
            sb.append("            throw new RuntimeException(\"Could not initialize post construct accessor!\", ex);").append(NEW_LINE);
            sb.append("        }").append(NEW_LINE);
            sb.append("    }").append(NEW_LINE);
        }
        return postLoadReflection;
    }

    private static void printPostLoad(StringBuilder sb, MetaEntityView entity, boolean postLoadReflection, Context context) {
        EntityViewLifecycleMethod postLoad = entity.getPostLoad();
        if (postLoad != null) {
            if (postLoadReflection) {
                sb.append("        try {").append(NEW_LINE);
                sb.append("            $$_post_load.invoke(this");
            } else {
                sb.append("        ").append(postLoad.getName()).append("(");
            }
            if (!postLoad.getParameterTypes().isEmpty()) {
                if (postLoadReflection) {
                    sb.append(", ");
                }
                Iterator<String> iterator = postLoad.getParameterTypes().iterator();
                while (iterator.hasNext()) {
                    String parameterType;
                    switch (parameterType = iterator.next()) {
                        case "com.blazebit.persistence.view.EntityViewManager": {
                            sb.append(SERIALIZABLE_EVM_FIELD_NAME);
                            break;
                        }
                        default: {
                            sb.append("(").append(parameterType).append(") null");
                        }
                    }
                    sb.append(", ");
                }
                sb.setLength(sb.length() - 2);
            }
            sb.append(");").append(NEW_LINE);
            if (postLoadReflection) {
                sb.append("        } catch (Exception ex) {").append(NEW_LINE);
                sb.append("            throw new RuntimeException(\"Could not invoke post load method\", ex);").append(NEW_LINE);
                sb.append("        }").append(NEW_LINE);
            }
        }
    }

    private static void printIdConstructor(StringBuilder sb, MetaEntityView entity, Context context) {
        MetaAttribute idMember = entity.getIdMember();
        sb.append("    public ").append(entity.getSimpleName()).append(IMPL_CLASS_NAME_SUFFIX).append("(");
        sb.append("        ").append(idMember.getImplementationTypeString()).append(" ").append(idMember.getPropertyName());
        sb.append(") {");
        sb.append(NEW_LINE);
        sb.append("        this.$$_kind = (byte) 1;").append(NEW_LINE);
        if (entity.isCreatable() || entity.isUpdatable()) {
            if (entity.getDefaultDirtyMask() != 0) {
                sb.append("        this.$$_dirty |= ").append(entity.getDefaultDirtyMask()).append("L;").append(NEW_LINE);
            }
            sb.append("        Object[] initialStateArr = new Object[").append(entity.getMutableAttributeCount()).append("];").append(NEW_LINE);
            sb.append("        Object[] mutableStateArr = new Object[").append(entity.getMutableAttributeCount()).append("];").append(NEW_LINE);
        }
        for (MetaAttribute member : entity.getMembers()) {
            boolean possiblyInitialized = ImplementationClassWriter.appendPossiblyInitializedFragment(sb, null, member);
            if (member == idMember) {
                sb.append("        this.").append(member.getPropertyName()).append(" = ").append(member.getPropertyName()).append(";");
                sb.append(NEW_LINE);
            } else {
                sb.append("        this.").append(member.getPropertyName()).append(" = ");
                if (member.getDirtyStateIndex() != -1) {
                    sb.append("(").append(member.getImplementationTypeString()).append(") (mutableStateArr[").append(member.getDirtyStateIndex()).append("] = ");
                }
                member.appendDefaultValue(sb, true, false, entity.getImplementationImportContext());
                if (member.getDirtyStateIndex() != -1) {
                    sb.append(")");
                }
                sb.append(";").append(NEW_LINE);
            }
            if (!possiblyInitialized) continue;
            sb.append("        }").append(NEW_LINE);
        }
        ImplementationClassWriter.printDirtyTrackerRegistration(sb, entity);
        sb.append("    }");
        sb.append(NEW_LINE);
    }
}

