/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.processor.serialization;

import com.blazebit.persistence.view.processor.serialization.SerializationField;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;

public class MemberSignature {
    private final Set<Modifier> modifiers;
    private final String name;
    private final String signature;

    public MemberSignature(VariableElement field) {
        this.modifiers = field.getModifiers();
        this.name = field.getSimpleName().toString();
        this.signature = SerializationField.getClassSignature(field.asType());
    }

    public MemberSignature(ExecutableElement meth) {
        this.modifiers = meth.getModifiers();
        this.name = meth.getSimpleName().toString();
        this.signature = SerializationField.getMethodSignature(meth);
    }

    public Set<Modifier> getModifiers() {
        return this.modifiers;
    }

    public String getName() {
        return this.name;
    }

    public String getSignature() {
        return this.signature;
    }
}

