/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.processor;

import com.blazebit.persistence.view.processor.Context;
import com.blazebit.persistence.view.processor.OptionalParameterScanner;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

public class ViewFilter {
    private final String name;
    private final Map<String, String> optionalParameters;

    public ViewFilter(String name, TypeElement filterProvider, Context context) {
        this.name = name;
        HashMap<String, String> optionalParameters = new HashMap<String, String>();
        for (Element element : filterProvider.getEnclosedElements()) {
            ExecutableElement executableElement;
            if (!(element instanceof ExecutableElement) || (executableElement = (ExecutableElement)element).getKind() != ElementKind.METHOD || !"apply".equals(executableElement.getSimpleName().toString())) continue;
            OptionalParameterScanner.scan(optionalParameters, executableElement, context);
        }
        this.optionalParameters = optionalParameters;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getOptionalParameters() {
        return this.optionalParameters;
    }
}

