/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.processor;

import com.blazebit.persistence.view.processor.EntityViewTypeUtils;
import com.blazebit.persistence.view.processor.MetaEntityView;
import com.blazebit.persistence.view.processor.TypeUtils;
import com.blazebit.persistence.view.processor.annotation.AnnotationMetaEntityView;
import com.blazebit.persistence.view.processor.convert.TypeConverter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Parameterizable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

public class Context {
    private static final Object NULL_OBJECT = new Object();
    private final ProcessingEnvironment pe;
    private final boolean logDebug;
    private final TypeElement generatedAnnotation;
    private final Map<String, MetaEntityView> metaEntityViews = new ConcurrentHashMap<String, MetaEntityView>();
    private final ConcurrentMap<String, Boolean> generatedModelClasses = new ConcurrentHashMap<String, Boolean>();
    private final ConcurrentMap<CharSequence, Object> typeElements = new ConcurrentHashMap<CharSequence, Object>();
    private final Map<String, TypeElement> optionalParameters;
    private final Map<String, Map<String, TypeConverter>> converters;
    private final Map<String, Map<String, Element>> initializedViewTypes = new HashMap<String, Map<String, Element>>();
    private final Map<String, Map<String, Element>> initializedViewFilters = new HashMap<String, Map<String, Element>>();
    private final Map<String, Map<String, Element>> initializedEntities = new HashMap<String, Map<String, Element>>();
    private final boolean addGeneratedAnnotation;
    private final boolean addGenerationDate;
    private final boolean addSuppressWarningsAnnotation;
    private final boolean strictCascadingCheck;
    private final boolean generateImplementations;
    private final boolean generateBuilders;
    private final boolean createEmptyFlatViews;
    private final boolean generateDeepConstants;
    private final String defaultVersionAttributeName;
    private final String defaultVersionAttributeType;
    private final int threads;

    public Context(ProcessingEnvironment pe) {
        this.pe = pe;
        this.logDebug = Boolean.parseBoolean(pe.getOptions().get("debug"));
        HashMap<String, TypeElement> optionalParameters = new HashMap<String, TypeElement>();
        HashMap<String, Map<String, TypeConverter>> converters = new HashMap<String, Map<String, TypeConverter>>();
        TypeElement java8AndBelowGeneratedAnnotation = pe.getElementUtils().getTypeElement("javax.annotation.Generated");
        this.generatedAnnotation = java8AndBelowGeneratedAnnotation != null ? java8AndBelowGeneratedAnnotation : pe.getElementUtils().getTypeElement("javax.annotation.processing.Generated");
        for (TypeConverter typeConverter : ServiceLoader.load(TypeConverter.class, Context.class.getClassLoader())) {
            typeConverter.addRegistrations(converters);
        }
        this.converters = converters;
        this.addGeneratedAnnotation = Context.getOption(pe, "addGeneratedAnnotation", true);
        this.addGenerationDate = Context.getOption(pe, "addGenerationDate", false);
        this.addSuppressWarningsAnnotation = Context.getOption(pe, "addSuppressWarningsAnnotation", false);
        this.strictCascadingCheck = Context.getOption(pe, "strictCascadingCheck", true);
        this.generateImplementations = Context.getOption(pe, "generateImplementations", true);
        this.generateBuilders = Context.getOption(pe, "generateBuilders", true);
        this.createEmptyFlatViews = Context.getOption(pe, "createEmptyFlatViews", true);
        this.generateDeepConstants = Context.getOption(pe, "generateDeepConstants", true);
        this.defaultVersionAttributeName = pe.getOptions().get("defaultVersionAttributeName");
        this.defaultVersionAttributeType = pe.getOptions().get("defaultVersionAttributeType");
        String threads = pe.getOptions().get("threads");
        this.threads = threads == null || threads.isEmpty() ? Runtime.getRuntime().availableProcessors() : 1;
        String s = pe.getOptions().get("optionalParameters");
        if (s != null) {
            for (String part : s.split("\\s*;\\s*")) {
                String type;
                String name;
                int idx = part.lastIndexOf(61);
                if (idx == -1) {
                    name = part;
                    type = "java.lang.Object";
                } else {
                    name = part.substring(0, idx);
                    type = part.substring(idx + 1);
                }
                optionalParameters.put(name, pe.getElementUtils().getTypeElement(type));
            }
        }
        this.optionalParameters = optionalParameters;
    }

    private static Boolean getOption(ProcessingEnvironment processingEnvironment, String option, boolean defaultValue) {
        String tmp = processingEnvironment.getOptions().get(option);
        if (tmp == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(tmp);
    }

    public ProcessingEnvironment getProcessingEnvironment() {
        return this.pe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeElement getTypeElement(CharSequence name) {
        Object cached = this.typeElements.get(name);
        if (cached != null) {
            return cached == NULL_OBJECT ? null : (TypeElement)cached;
        }
        Context context = this;
        synchronized (context) {
            TypeElement typeElement = this.pe.getElementUtils().getTypeElement(name);
            if (typeElement == null) {
                this.typeElements.put(name, NULL_OBJECT);
            } else {
                this.typeElements.put(name, typeElement);
            }
            return typeElement;
        }
    }

    public Elements getElementUtils() {
        return this.pe.getElementUtils();
    }

    public Types getTypeUtils() {
        return this.pe.getTypeUtils();
    }

    public Map<String, TypeConverter> getConverter(String fqn) {
        Map<String, TypeConverter> map = this.converters.get(fqn);
        if (map == null) {
            return Collections.emptyMap();
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logMessage(Diagnostic.Kind type, String message) {
        if (!this.logDebug && type.equals((Object)Diagnostic.Kind.OTHER)) {
            return;
        }
        ProcessingEnvironment processingEnvironment = this.pe;
        synchronized (processingEnvironment) {
            this.pe.getMessager().printMessage(type, message);
        }
    }

    public boolean matchesDefaultVersionAttribute(Element member) {
        if (this.getDefaultVersionAttributeName() == null || !this.getDefaultVersionAttributeName().equals(EntityViewTypeUtils.getAttributeName(member))) {
            return false;
        }
        if (member.getKind() == ElementKind.METHOD) {
            return this.getDefaultVersionAttributeType() == null || this.getDefaultVersionAttributeType().equals(((TypeElement)((DeclaredType)((ExecutableType)member.asType()).getReturnType()).asElement()).getQualifiedName().toString());
        }
        return this.getDefaultVersionAttributeType() == null || this.getDefaultVersionAttributeType().equals(((TypeElement)((DeclaredType)member.asType()).asElement()).getQualifiedName().toString());
    }

    public void addMetaEntityViewToContext(String qualifiedName, AnnotationMetaEntityView metaEntityView) {
        this.metaEntityViews.put(qualifiedName, metaEntityView);
    }

    public Collection<MetaEntityView> getMetaEntityViews() {
        return this.metaEntityViews.values();
    }

    public Map<String, MetaEntityView> getMetaEntityViewMap() {
        return this.metaEntityViews;
    }

    public boolean markGenerated(String name) {
        return this.generatedModelClasses.putIfAbsent(name, Boolean.TRUE) == null;
    }

    public TypeElement getGeneratedAnnotation() {
        return this.generatedAnnotation;
    }

    public boolean addGeneratedAnnotation() {
        return this.addGeneratedAnnotation;
    }

    public boolean addGeneratedDate() {
        return this.addGenerationDate;
    }

    public boolean isAddSuppressWarningsAnnotation() {
        return this.addSuppressWarningsAnnotation;
    }

    public boolean isStrictCascadingCheck() {
        return this.strictCascadingCheck;
    }

    public boolean isGenerateImplementations() {
        return this.generateImplementations;
    }

    public boolean isGenerateBuilders() {
        return this.generateBuilders;
    }

    public String getDefaultVersionAttributeName() {
        return this.defaultVersionAttributeName;
    }

    public String getDefaultVersionAttributeType() {
        return this.defaultVersionAttributeType;
    }

    public boolean isCreateEmptyFlatViews() {
        return this.createEmptyFlatViews;
    }

    public boolean isGenerateDeepConstants() {
        return this.generateDeepConstants;
    }

    public Map<String, TypeElement> getOptionalParameters() {
        return this.optionalParameters;
    }

    public int getThreads() {
        return this.threads;
    }

    public Map<String, Element> initializeEntityViewElement(TypeElement entityView) {
        String entityViewFqn = entityView.toString();
        Map<String, Element> members = this.initializedViewTypes.get(entityViewFqn);
        if (members != null) {
            return members;
        }
        TypeMirror typeMirror = entityView.getSuperclass();
        if (typeMirror.getKind() != TypeKind.NONE) {
            TypeElement superclassElement = (TypeElement)this.getTypeUtils().asElement(typeMirror);
            members = this.copySuperclassMembers(this.initializeEntityViewElement(superclassElement));
        } else {
            members = new HashMap<String, Element>();
        }
        this.initializeEntityViewInterfaces(entityView, members);
        this.initializeEnclosingElements(entityView);
        this.initializeAnnotations(entityView);
        this.initializeTypeArguments(entityView);
        this.initializeEntityViewEnclosedElements(entityView, members);
        this.initializedViewTypes.put(entityViewFqn, members);
        return members;
    }

    private Map<String, Element> copySuperclassMembers(Map<String, Element> superclassMembers) {
        HashMap<String, Element> members = new HashMap<String, Element>(superclassMembers.size());
        for (Map.Entry<String, Element> entry : superclassMembers.entrySet()) {
            if (entry.getValue().getKind() == ElementKind.CONSTRUCTOR) continue;
            members.put(entry.getKey(), entry.getValue());
        }
        return members;
    }

    private void initializeTypeArguments(Parameterizable parameterizable) {
        for (TypeParameterElement typeParameterElement : parameterizable.getTypeParameters()) {
            typeParameterElement.asType().getKind();
            for (TypeMirror typeMirror : typeParameterElement.getBounds()) {
                typeMirror.getKind();
            }
        }
    }

    private void initializeEntityViewInterfaces(TypeElement entityView, Map<String, Element> members) {
        for (TypeMirror typeMirror : entityView.getInterfaces()) {
            TypeElement typeElement = (TypeElement)this.getTypeUtils().asElement(typeMirror);
            members.putAll(this.initializeEntityViewElement(typeElement));
        }
    }

    private void initializeEntityViewEnclosedElements(TypeElement entityView, Map<String, Element> members) {
        block4: for (Element element : entityView.getEnclosedElements()) {
            switch (element.getKind()) {
                case METHOD: {
                    ExecutableElement methodElement = (ExecutableElement)element;
                    this.initializeAnnotations(element);
                    this.initializeTypeArguments(methodElement);
                    methodElement.getReturnType().getKind();
                    members.put(element.getSimpleName().toString(), element);
                    continue block4;
                }
                case CONSTRUCTOR: {
                    ExecutableElement constructorElement = (ExecutableElement)element;
                    this.initializeAnnotations(element);
                    this.initializeTypeArguments(constructorElement);
                    for (VariableElement variableElement : constructorElement.getParameters()) {
                        variableElement.asType().getKind();
                        this.initializeAnnotations(variableElement);
                    }
                    members.put(element.toString(), element);
                    continue block4;
                }
            }
            members.put(element.getSimpleName().toString(), element);
        }
    }

    private void initializeEnclosingElements(TypeElement typeElement) {
        for (Element enclosingElement = typeElement.getEnclosingElement(); enclosingElement != null; enclosingElement = enclosingElement.getEnclosingElement()) {
            enclosingElement.getKind();
        }
    }

    private void initializeAnnotations(Element element) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            annotationMirror.getAnnotationType().getKind();
            block15: for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                entry.getKey().getKind();
                Object annotationValue = entry.getValue().getValue();
                if (annotationValue instanceof TypeMirror) {
                    TypeMirror typeMirror = (TypeMirror)annotationValue;
                    typeMirror.getKind();
                    switch (annotationMirror.getAnnotationType().toString()) {
                        case "com.blazebit.persistence.view.EntityView": {
                            if (!entry.getKey().getSimpleName().contentEquals("value")) break;
                            this.initializeEntityElement(typeMirror);
                            break;
                        }
                        case "com.blazebit.persistence.view.ViewFilter": {
                            this.initializeViewFilter(typeMirror);
                            break;
                        }
                    }
                    continue;
                }
                if (!(annotationValue instanceof List)) continue;
                switch (annotationMirror.getAnnotationType().toString()) {
                    case "com.blazebit.persistence.view.ViewFilters": {
                        for (Object value : (List)annotationValue) {
                            value.getAnnotationType().getKind();
                            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> filterEntry : value.getElementValues().entrySet()) {
                                filterEntry.getKey().getKind();
                                Object filterValue = filterEntry.getValue().getValue();
                                if (!(filterValue instanceof TypeMirror)) continue;
                                this.initializeViewFilter((TypeMirror)filterValue);
                            }
                        }
                        continue block15;
                    }
                    default: {
                        for (Object value : (List)annotationValue) {
                            if (!(value instanceof TypeMirror)) continue;
                            ((TypeMirror)value).getKind();
                        }
                        continue block15;
                    }
                }
            }
        }
    }

    private void initializeViewFilter(TypeMirror viewFilter) {
        String fqn = viewFilter.toString();
        Map<String, Element> members = this.initializedViewFilters.get(fqn);
        if (members != null) {
            return;
        }
        members = new HashMap<String, Element>();
        TypeElement typeElement = (TypeElement)this.getTypeUtils().asElement(viewFilter);
        this.initializeEnclosedElements(typeElement, members);
        this.initializedViewFilters.put(fqn, members);
    }

    private Map<String, Element> initializeEntityElement(TypeMirror entity) {
        String fqn = entity.toString();
        Map<String, Element> members = this.initializedEntities.get(fqn);
        if (members != null) {
            return members;
        }
        TypeElement typeElement = (TypeElement)this.getTypeUtils().asElement(entity);
        TypeMirror typeMirror = typeElement.getSuperclass();
        members = typeMirror.getKind() != TypeKind.NONE ? this.copySuperclassMembers(this.initializeEntityElement(typeMirror)) : new HashMap<String, Element>();
        this.initializeEnclosingElements(typeElement);
        this.initializeEnclosedElements(typeElement, members);
        this.initializedEntities.put(fqn, members);
        return members;
    }

    private void initializeEnclosedElements(Element element, Map<String, Element> members) {
        for (Element element2 : element.getEnclosedElements()) {
            element2.getKind();
            String name = element2.getSimpleName().toString();
            members.put(name, element2);
        }
    }

    public Iterable<? extends Element> getAllMembers(TypeElement typeElement) {
        String fqn = typeElement.toString();
        Map<String, Element> elements = this.initializedViewTypes.get(fqn);
        if (elements != null) {
            return elements.values();
        }
        elements = this.initializedEntities.get(fqn);
        if (elements != null) {
            return elements.values();
        }
        elements = this.initializedViewFilters.get(fqn);
        if (elements != null) {
            return elements.values();
        }
        return TypeUtils.getAllMembers(typeElement, this);
    }
}

