/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.processor;

import com.blazebit.persistence.view.processor.ClassWriterUtils;
import com.blazebit.persistence.view.processor.Context;
import com.blazebit.persistence.view.processor.MetaEntityView;
import com.blazebit.persistence.view.processor.TypeUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;

public final class ForeignPackageAdapterClassWriter {
    private static final String NEW_LINE = System.lineSeparator();

    private ForeignPackageAdapterClassWriter() {
    }

    public static void writeFiles(StringBuilder sb, MetaEntityView entity, Context context) {
        ArrayList<Map.Entry<String, TypeElement>> entries = new ArrayList<Map.Entry<String, TypeElement>>(entity.getForeignPackageSuperTypes().entrySet());
        for (int i = 0; i < entries.size(); ++i) {
            Map.Entry<String, TypeElement> entry = entries.get(i);
            String name = entry.getValue().getQualifiedName().toString() + "_" + entity.getQualifiedName().replace('.', '_');
            if (!context.markGenerated(name)) continue;
            String baseType = entries.size() < i + 1 ? entries.get(i + 1).getValue().getQualifiedName().toString() : entity.getQualifiedName();
            sb.setLength(0);
            ForeignPackageAdapterClassWriter.writeFile(sb, entry.getKey(), baseType, name, entry.getValue(), entity, context);
        }
    }

    private static void writeFile(StringBuilder sb, String metaModelPackage, String baseType, String name, TypeElement typeElement, MetaEntityView entity, Context context) {
        ForeignPackageAdapterClassWriter.generateBody(sb, typeElement, baseType, entity, context);
        ClassWriterUtils.writeFile(sb, metaModelPackage, name.substring(metaModelPackage.length() + 1), null, context, entity.getOriginatingElements());
    }

    private static void generateBody(StringBuilder sb, TypeElement typeElement, String baseType, MetaEntityView entity, Context context) {
        int i;
        if (context.addGeneratedAnnotation()) {
            ClassWriterUtils.writeGeneratedAnnotation(sb, null, context);
            sb.append(NEW_LINE);
        }
        if (context.isAddSuppressWarningsAnnotation()) {
            sb.append(ClassWriterUtils.writeSuppressWarnings());
            sb.append(NEW_LINE);
        }
        sb.append("public abstract class ").append(typeElement.getSimpleName().toString()).append('_').append(entity.getQualifiedName().replace('.', '_'));
        List<? extends TypeMirror> typeArguments = ((DeclaredType)entity.getTypeElement().asType()).getTypeArguments();
        List<? extends TypeMirror> typeParameters = ((DeclaredType)typeElement.asType()).getTypeArguments();
        if (typeArguments.isEmpty()) {
            if (!typeParameters.isEmpty()) {
                sb.append('<');
                ForeignPackageAdapterClassWriter.printTypeVariable(sb, (TypeVariable)typeParameters.get(0));
                for (i = 1; i < typeParameters.size(); ++i) {
                    sb.append(", ");
                    ForeignPackageAdapterClassWriter.printTypeVariable(sb, (TypeVariable)typeParameters.get(i));
                }
                sb.append('>');
            }
        } else {
            sb.append('<');
            if (!typeParameters.isEmpty()) {
                ForeignPackageAdapterClassWriter.printTypeVariable(sb, (TypeVariable)typeParameters.get(0));
                for (i = 1; i < typeParameters.size(); ++i) {
                    sb.append(", ");
                    ForeignPackageAdapterClassWriter.printTypeVariable(sb, (TypeVariable)typeParameters.get(i));
                }
                sb.append(", ");
            }
            ForeignPackageAdapterClassWriter.printTypeVariable(sb, (TypeVariable)typeArguments.get(0));
            for (i = 1; i < typeArguments.size(); ++i) {
                sb.append(", ");
                ForeignPackageAdapterClassWriter.printTypeVariable(sb, (TypeVariable)typeArguments.get(i));
            }
            sb.append('>');
        }
        sb.append(" extends ");
        sb.append(baseType);
        if (!typeArguments.isEmpty()) {
            sb.append('<');
            sb.append(typeArguments.get(0));
            for (i = 1; i < typeArguments.size(); ++i) {
                sb.append(", ");
                sb.append(typeArguments.get(i));
            }
            sb.append('>');
        }
        sb.append(" {");
        sb.append(NEW_LINE);
        sb.append(NEW_LINE);
        ForeignPackageAdapterClassWriter.printConstructors(sb, typeElement, entity, context);
        sb.append(NEW_LINE);
        for (Element element : typeElement.getEnclosedElements()) {
            if (!(element instanceof ExecutableElement) || !element.getModifiers().contains((Object)Modifier.ABSTRACT) || element.getModifiers().contains((Object)Modifier.PUBLIC) || element.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
            ExecutableElement executableElement = (ExecutableElement)element;
            boolean packagePrivate = !element.getModifiers().contains((Object)Modifier.PROTECTED);
            boolean isGeneric = false;
            sb.append("    public abstract ");
            sb.append(TypeUtils.toTypeString((DeclaredType)entity.getTypeElement().asType(), executableElement.getReturnType(), context)).append(" ").append(executableElement.getSimpleName()).append("(");
            List<? extends VariableElement> parameters = executableElement.getParameters();
            if (!parameters.isEmpty()) {
                isGeneric = parameters.get(0).asType().getKind() == TypeKind.TYPEVAR;
                ForeignPackageAdapterClassWriter.printParameter(sb, entity, parameters.get(0), 0, context);
                for (int i2 = 1; i2 < parameters.size(); ++i2) {
                    isGeneric = isGeneric || parameters.get(i2).asType().getKind() == TypeKind.TYPEVAR;
                    sb.append(", ");
                    ForeignPackageAdapterClassWriter.printParameter(sb, entity, parameters.get(i2), i2, context);
                }
            }
            sb.append(");");
            sb.append(NEW_LINE);
            if (!packagePrivate || !isGeneric) continue;
            sb.append("    public abstract ");
            sb.append(executableElement.getReturnType()).append(" ").append(executableElement.getSimpleName()).append("(");
            if (!parameters.isEmpty()) {
                sb.append(parameters.get(0).asType()).append(" arg0");
                for (int i2 = 1; i2 < parameters.size(); ++i2) {
                    sb.append(", ");
                    sb.append(parameters.get(i2).asType()).append(" arg").append(i2);
                }
            }
            sb.append(");");
            sb.append(NEW_LINE);
        }
        sb.append(NEW_LINE);
        sb.append("}");
        sb.append(NEW_LINE);
    }

    private static void printParameter(StringBuilder sb, MetaEntityView entity, VariableElement variableElement, int index, Context context) {
        sb.append(TypeUtils.toTypeString((DeclaredType)entity.getTypeElement().asType(), variableElement.asType(), context)).append(" arg").append(index);
    }

    private static void printTypeVariable(StringBuilder sb, TypeVariable t) {
        sb.append(t);
        if (t.getLowerBound().getKind() == TypeKind.NULL) {
            sb.append(" extends ").append(t.getUpperBound().toString());
        } else {
            sb.append(" super ").append(t.getLowerBound().toString());
        }
    }

    private static void printConstructors(StringBuilder sb, TypeElement typeElement, MetaEntityView entity, Context context) {
        String simpleName = typeElement.getSimpleName().toString() + "_" + entity.getQualifiedName().replace('.', '_');
        for (Element element : entity.getTypeElement().getEnclosedElements()) {
            if (element.getModifiers().contains((Object)Modifier.PRIVATE) || element.getKind() != ElementKind.CONSTRUCTOR) continue;
            ExecutableElement constructor = (ExecutableElement)element;
            sb.append("    public ").append(simpleName).append("(");
            boolean first = true;
            for (VariableElement variableElement : constructor.getParameters()) {
                if (first) {
                    first = false;
                    sb.append(NEW_LINE);
                    sb.append("        ").append(variableElement.asType()).append(" ").append(variableElement.getSimpleName());
                    continue;
                }
                sb.append(",");
                sb.append(NEW_LINE);
                sb.append("        ").append(variableElement.asType()).append(" ").append(variableElement.getSimpleName());
                sb.append(NEW_LINE);
            }
            if (first) {
                sb.append(") {");
                sb.append(NEW_LINE);
            } else {
                sb.append("    ) {");
                sb.append(NEW_LINE);
            }
            sb.append("        super(");
            first = true;
            for (VariableElement variableElement : constructor.getParameters()) {
                if (first) {
                    first = false;
                    sb.append(NEW_LINE);
                    sb.append("            ").append(variableElement.getSimpleName());
                    continue;
                }
                sb.append(",");
                sb.append(NEW_LINE);
                sb.append("            ").append(variableElement.getSimpleName());
            }
            if (first) {
                sb.append(");");
                sb.append(NEW_LINE);
            } else {
                sb.append(NEW_LINE);
                sb.append("        );");
                sb.append(NEW_LINE);
            }
            sb.append("    }");
            sb.append(NEW_LINE);
        }
    }
}

