/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.processor;

import com.blazebit.persistence.view.processor.Context;
import com.blazebit.persistence.view.processor.OptionalParameterScanner;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

public class ViewFilter {
    private final String name;
    private final TypeElement filterProvider;
    private final Map<String, TypeElement> optionalParameters;

    public ViewFilter(String name, TypeElement filterProvider, Context context) {
        this.name = name;
        this.filterProvider = filterProvider;
        HashMap<String, TypeElement> optionalParameters = new HashMap<String, TypeElement>();
        for (Element element : filterProvider.getEnclosedElements()) {
            ExecutableElement executableElement;
            if (!(element instanceof ExecutableElement) || (executableElement = (ExecutableElement)element).getKind() != ElementKind.METHOD || !"apply".equals(executableElement.getSimpleName().toString())) continue;
            OptionalParameterScanner.scan(optionalParameters, executableElement, context);
        }
        this.optionalParameters = optionalParameters;
    }

    public String getName() {
        return this.name;
    }

    public TypeElement getFilterProvider() {
        return this.filterProvider;
    }

    public Map<String, TypeElement> getOptionalParameters() {
        return this.optionalParameters;
    }
}

