/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.processor.annotation;

import com.blazebit.persistence.view.processor.Constants;
import com.blazebit.persistence.view.processor.Context;
import com.blazebit.persistence.view.processor.ImportContext;
import com.blazebit.persistence.view.processor.ImportContextImpl;
import com.blazebit.persistence.view.processor.MetaAttribute;
import com.blazebit.persistence.view.processor.MetaConstructor;
import com.blazebit.persistence.view.processor.MetaEntityView;
import com.blazebit.persistence.view.processor.TypeUtils;
import com.blazebit.persistence.view.processor.ViewFilter;
import com.blazebit.persistence.view.processor.annotation.AnnotationMetaAttribute;
import com.blazebit.persistence.view.processor.annotation.AnnotationMetaConstructor;
import com.blazebit.persistence.view.processor.annotation.AnnotationMetaVersionAttribute;
import com.blazebit.persistence.view.processor.annotation.MetaAttributeGenerationVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.tools.Diagnostic;

public class AnnotationMetaEntityView
implements MetaEntityView {
    private final ImportContext metamodelImportContext;
    private final ImportContext relationImportContext;
    private final ImportContext multiRelationImportContext;
    private final ImportContext implementationImportContext;
    private final ImportContext builderImportContext;
    private final TypeElement element;
    private final Element[] originatingElements;
    private final String entityClass;
    private final String jpaManagedBaseClass;
    private final Element entityVersionAttribute;
    private final ExecutableElement postCreate;
    private final ExecutableElement postLoad;
    private final MetaAttribute idMember;
    private final MetaAttribute versionMember;
    private final Map<String, MetaAttribute> members;
    private final List<MetaConstructor> constructors;
    private final Map<String, ExecutableElement> specialMembers;
    private final Map<String, TypeElement> foreignPackageSuperTypes;
    private final List<TypeMirror> foreignPackageSuperTypeVariables;
    private final Map<String, TypeElement> optionalParameters;
    private final Map<String, ViewFilter> viewFilters;
    private final boolean updatable;
    private final boolean creatable;
    private final boolean allSupportDirtyTracking;
    private final int mutableAttributeCount;
    private final int defaultDirtyMask;
    private final boolean hasEmptyConstructor;
    private final boolean hasSelfConstructor;
    private final boolean hasSubviews;
    private final boolean valid;
    private final Context context;
    private final Set<String> addedAccessors = new HashSet<String>();

    /*
     * WARNING - void declaration
     */
    public AnnotationMetaEntityView(TypeElement element, Context context) {
        int n;
        void var12_22;
        void var9_14;
        void var9_12;
        this.element = element;
        this.context = context;
        this.metamodelImportContext = new ImportContextImpl(this.getPackageName());
        this.relationImportContext = new ImportContextImpl(this.getPackageName());
        this.multiRelationImportContext = new ImportContextImpl(this.getPackageName());
        this.implementationImportContext = new ImportContextImpl(this.getPackageName());
        this.builderImportContext = new ImportContextImpl(this.getPackageName());
        this.getContext().logMessage(Diagnostic.Kind.OTHER, "Initializing type " + this.getQualifiedName() + ".");
        String entityClass = null;
        boolean updatable = false;
        boolean creatable = false;
        boolean allSupportDirtyTracking = true;
        HashMap<String, ViewFilter> viewFilters = new HashMap<String, ViewFilter>();
        block14: for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            switch (annotationMirror.getAnnotationType().toString()) {
                case "com.blazebit.persistence.view.EntityView": {
                    entityClass = TypeUtils.getAnnotationValue(annotationMirror, "value").toString();
                    break;
                }
                case "com.blazebit.persistence.view.UpdatableEntityView": {
                    updatable = true;
                    break;
                }
                case "com.blazebit.persistence.view.CreatableEntityView": {
                    creatable = true;
                    break;
                }
                case "com.blazebit.persistence.view.ViewFilter": {
                    AnnotationMetaEntityView.addViewFilter(viewFilters, annotationMirror, context);
                    break;
                }
                case "com.blazebit.persistence.view.ViewFilters": {
                    for (AnnotationMirror value : (List)TypeUtils.getAnnotationValue(annotationMirror, "value")) {
                        AnnotationMetaEntityView.addViewFilter(viewFilters, value, context);
                    }
                    continue block14;
                }
            }
        }
        Element entityVersionAttribute = null;
        Object var9_10 = null;
        TypeElement entityTypeElement = context.getTypeElement(entityClass);
        for (Element element2 : context.getAllMembers(entityTypeElement)) {
            if (!TypeUtils.containsAnnotation(element2, "javax.persistence.Version")) continue;
            entityVersionAttribute = element2;
            break;
        }
        if (AnnotationMetaEntityView.isEntity(entityTypeElement)) {
            TypeElement entityElement = entityTypeElement;
            while (AnnotationMetaEntityView.isEntity(entityTypeElement = context.getTypeElement(TypeUtils.extractClosestRealTypeAsString(entityElement.getSuperclass(), context)))) {
                entityElement = entityTypeElement;
            }
            String string = entityElement.getQualifiedName().toString();
        }
        if (var9_12 == null) {
            String string = entityTypeElement.getQualifiedName().toString();
        }
        this.entityVersionAttribute = entityVersionAttribute;
        this.entityClass = entityClass;
        this.jpaManagedBaseClass = var9_14;
        this.updatable = updatable;
        this.creatable = creatable;
        this.viewFilters = viewFilters;
        Iterable<? extends Element> allMembers = context.getAllMembers(element);
        Object var12_21 = null;
        AnnotationMetaAttribute versionMember = null;
        TreeMap<String, MetaAttribute> members = new TreeMap<String, MetaAttribute>();
        TreeMap<String, ExecutableElement> specialMembers = new TreeMap<String, ExecutableElement>();
        ArrayList<MetaConstructor> constructors = new ArrayList<MetaConstructor>();
        MetaAttributeGenerationVisitor visitor = new MetaAttributeGenerationVisitor(this, context);
        HashMap<String, TypeElement> optionalParameters = new HashMap<String, TypeElement>();
        boolean valid = true;
        boolean hasEmptyConstructor = false;
        boolean hasSelfConstructor = false;
        boolean hasSubviews = false;
        ExecutableElement postCreate = null;
        ExecutableElement postLoad = null;
        HashSet<TypeElement> originatingElements = new HashSet<TypeElement>();
        originatingElements.add(element);
        for (Element element3 : allMembers) {
            if (!(element3 instanceof ExecutableElement)) continue;
            ExecutableElement executableElement = (ExecutableElement)element3;
            Set<Modifier> modifiers = element3.getModifiers();
            if (modifiers.contains((Object)Modifier.STATIC)) continue;
            if (Constants.SPECIAL.contains(executableElement.getReturnType().toString())) {
                specialMembers.put(element3.getSimpleName().toString(), executableElement);
                continue;
            }
            if (modifiers.contains((Object)Modifier.ABSTRACT) && this.isGetterOrSetter(element3)) {
                AnnotationMetaAttribute result = element3.asType().accept(visitor, element3);
                if (result == null) continue;
                if (result.isIdMember()) {
                    AnnotationMetaAttribute annotationMetaAttribute = result;
                } else if (result.isVersion()) {
                    versionMember = result;
                }
                members.put(result.getPropertyName(), result);
                for (Map.Entry<String, TypeElement> entry : result.getOptionalParameters().entrySet()) {
                    TypeElement typeElement = entry.getValue();
                    TypeElement existingTypeElement = (TypeElement)optionalParameters.get(entry.getKey());
                    if (existingTypeElement != null && !context.getTypeUtils().isAssignable(typeElement.asType(), existingTypeElement.asType())) continue;
                    optionalParameters.put(entry.getKey(), entry.getValue());
                }
                if (!result.isSubview()) continue;
                hasSubviews = true;
                originatingElements.add(result.getSubviewElement());
                continue;
            }
            if (!modifiers.contains((Object)Modifier.PRIVATE) && element3.getKind() == ElementKind.CONSTRUCTOR) {
                AnnotationMetaConstructor constructor = new AnnotationMetaConstructor(this, executableElement, visitor, context);
                hasEmptyConstructor = hasEmptyConstructor || constructor.getParameters().isEmpty();
                hasSelfConstructor = hasSelfConstructor || constructor.hasSelfParameter();
                constructors.add(constructor);
                for (Map.Entry<String, TypeElement> entry : constructor.getOptionalParameters().entrySet()) {
                    TypeElement existingTypeElement = (TypeElement)optionalParameters.get(entry.getKey());
                    TypeElement typeElement = entry.getValue();
                    if (existingTypeElement == null || !context.getTypeUtils().isAssignable(typeElement.asType(), existingTypeElement.asType())) continue;
                    optionalParameters.put(entry.getKey(), entry.getValue());
                }
                continue;
            }
            if (!TypeUtils.containsAnnotation(executableElement, "com.blazebit.persistence.view.PostCreate", "com.blazebit.persistence.view.PostLoad")) continue;
            if (TypeUtils.containsAnnotation(executableElement, "com.blazebit.persistence.view.PostCreate")) {
                if (postCreate == null) {
                    postCreate = executableElement;
                } else if (context.getTypeUtils().isAssignable(executableElement.getEnclosingElement().asType(), postCreate.getEnclosingElement().asType())) {
                    postCreate = executableElement;
                }
            }
            if (!TypeUtils.containsAnnotation(executableElement, "com.blazebit.persistence.view.PostLoad")) continue;
            if (postLoad == null) {
                postLoad = executableElement;
                continue;
            }
            if (!context.getTypeUtils().isAssignable(executableElement.getEnclosingElement().asType(), postLoad.getEnclosingElement().asType())) continue;
            postLoad = executableElement;
        }
        int dirtyStateIndex = 0;
        boolean bl = false;
        int index = 0;
        if (var12_22 != null) {
            var12_22.setAttributeIndex(index);
            ++index;
        }
        if (versionMember == null && updatable && entityVersionAttribute != null) {
            versionMember = new AnnotationMetaVersionAttribute(this, context);
            members.put(versionMember.getPropertyName(), versionMember);
        }
        for (MetaAttribute value : members.values()) {
            if (value.getAttributeIndex() != -1) continue;
            value.setAttributeIndex(index);
            if ((creatable || updatable) && value.isMutable() && value != versionMember) {
                value.setDirtyStateIndex(dirtyStateIndex);
                if (!value.supportsDirtyTracking()) {
                    allSupportDirtyTracking = false;
                    n |= 1 << dirtyStateIndex;
                }
                ++dirtyStateIndex;
            }
            ++index;
        }
        this.hasEmptyConstructor = hasEmptyConstructor || constructors.isEmpty();
        this.hasSelfConstructor = hasSelfConstructor;
        this.hasSubviews = hasSubviews;
        this.valid = valid;
        this.allSupportDirtyTracking = allSupportDirtyTracking;
        this.mutableAttributeCount = dirtyStateIndex;
        this.defaultDirtyMask = n;
        if (constructors.isEmpty()) {
            constructors.add(new AnnotationMetaConstructor(this));
        } else {
            constructors.sort(MetaConstructor.NAME_COMPARATOR);
        }
        LinkedHashMap<String, TypeElement> foreignPackageSuperTypes = new LinkedHashMap<String, TypeElement>();
        ArrayList<TypeMirror> foreignPackageSuperTypeVariables = new ArrayList<TypeMirror>();
        TypeMirror superClass = element.getSuperclass();
        PackageElement elementPackage = context.getElementUtils().getPackageOf(element);
        while (superClass.getKind() == TypeKind.DECLARED) {
            String packageName;
            PackageElement superClassPackage;
            TypeElement superClassElement = (TypeElement)((DeclaredType)superClass).asElement();
            if (superClassElement.getModifiers().contains((Object)Modifier.ABSTRACT) && !elementPackage.equals(superClassPackage = context.getElementUtils().getPackageOf(superClassElement)) && !foreignPackageSuperTypes.containsKey(packageName = superClassPackage.getQualifiedName().toString())) {
                foreignPackageSuperTypes.put(packageName, superClassElement);
                for (TypeParameterElement typeParameterElement : superClassElement.getTypeParameters()) {
                    foreignPackageSuperTypeVariables.add(TypeUtils.asMemberOf(context, (DeclaredType)element.asType(), typeParameterElement));
                }
            }
            superClass = superClassElement.getSuperclass();
        }
        this.idMember = var12_22;
        this.versionMember = versionMember;
        this.members = members;
        this.constructors = constructors;
        this.specialMembers = specialMembers;
        this.foreignPackageSuperTypes = foreignPackageSuperTypes;
        this.foreignPackageSuperTypeVariables = foreignPackageSuperTypeVariables;
        this.optionalParameters = optionalParameters;
        this.postCreate = postCreate;
        this.postLoad = postLoad;
        this.originatingElements = originatingElements.toArray(new Element[0]);
    }

    private static boolean isEntity(TypeElement typeElement) {
        for (AnnotationMirror annotationMirror : typeElement.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().toString().equals("javax.persistence.Entity")) continue;
            return true;
        }
        return false;
    }

    private static void addViewFilter(Map<String, ViewFilter> filters, AnnotationMirror mirror, Context context) {
        String name = "";
        TypeMirror type = null;
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : mirror.getElementValues().entrySet()) {
            switch (entry.getKey().getSimpleName().toString()) {
                case "name": {
                    name = (String)entry.getValue().getValue();
                    break;
                }
                case "value": {
                    type = (TypeMirror)entry.getValue().getValue();
                    break;
                }
            }
        }
        filters.put(name, new ViewFilter(name, (TypeElement)((DeclaredType)type).asElement(), context));
    }

    public final Context getContext() {
        return this.context;
    }

    @Override
    public Map<String, TypeElement> getForeignPackageSuperTypes() {
        return this.foreignPackageSuperTypes;
    }

    @Override
    public List<TypeMirror> getForeignPackageSuperTypeVariables() {
        return this.foreignPackageSuperTypeVariables;
    }

    @Override
    public boolean isUpdatable() {
        return this.updatable;
    }

    @Override
    public boolean isCreatable() {
        return this.creatable;
    }

    @Override
    public boolean isAllSupportDirtyTracking() {
        return this.allSupportDirtyTracking;
    }

    @Override
    public int getMutableAttributeCount() {
        return this.mutableAttributeCount;
    }

    @Override
    public boolean hasEmptyConstructor() {
        return this.hasEmptyConstructor;
    }

    @Override
    public boolean hasSelfConstructor() {
        return this.hasSelfConstructor;
    }

    @Override
    public boolean hasSubviews() {
        return this.hasSubviews;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public String getBaseSuperclass() {
        Iterator<TypeElement> iterator = this.foreignPackageSuperTypes.values().iterator();
        if (iterator.hasNext()) {
            return iterator.next().getQualifiedName().toString() + "_" + this.getQualifiedName().replace('.', '_');
        }
        return this.getQualifiedName();
    }

    @Override
    public final String getSimpleName() {
        return TypeUtils.getSimpleTypeName(this.element);
    }

    @Override
    public final String getQualifiedName() {
        return this.element.getQualifiedName().toString();
    }

    @Override
    public String getEntityClass() {
        return this.entityClass;
    }

    @Override
    public String getJpaManagedBaseClass() {
        return this.jpaManagedBaseClass;
    }

    @Override
    public Element getEntityVersionAttribute() {
        return this.entityVersionAttribute;
    }

    @Override
    public ExecutableElement getPostCreate() {
        return this.postCreate;
    }

    @Override
    public ExecutableElement getPostLoad() {
        return this.postLoad;
    }

    @Override
    public final String getPackageName() {
        PackageElement packageOf = this.context.getElementUtils().getPackageOf(this.element);
        return packageOf.getQualifiedName().toString();
    }

    @Override
    public MetaAttribute getIdMember() {
        return this.idMember;
    }

    @Override
    public MetaAttribute getVersionMember() {
        return this.versionMember;
    }

    @Override
    public int getDefaultDirtyMask() {
        return this.defaultDirtyMask;
    }

    @Override
    public Collection<MetaConstructor> getConstructors() {
        return this.constructors;
    }

    @Override
    public Collection<MetaAttribute> getMembers() {
        return this.members.values();
    }

    @Override
    public Collection<ExecutableElement> getSpecialMembers() {
        return this.specialMembers.values();
    }

    @Override
    public ImportContext getMetamodelImportContext() {
        return this.metamodelImportContext;
    }

    @Override
    public ImportContext getRelationImportContext() {
        return this.relationImportContext;
    }

    @Override
    public ImportContext getMultiRelationImportContext() {
        return this.multiRelationImportContext;
    }

    @Override
    public ImportContext getImplementationImportContext() {
        return this.implementationImportContext;
    }

    @Override
    public ImportContext getBuilderImportContext() {
        return this.builderImportContext;
    }

    @Override
    public final String importType(String fqcn) {
        this.implementationImportContext.importType(fqcn);
        this.metamodelImportContext.importType(fqcn);
        this.relationImportContext.importType(fqcn);
        this.multiRelationImportContext.importType(fqcn);
        return this.builderImportContext.importType(fqcn);
    }

    @Override
    public String importTypeExceptMetamodel(String fqcn) {
        this.implementationImportContext.importType(fqcn);
        return this.builderImportContext.importType(fqcn);
    }

    @Override
    public String metamodelImportType(String fqcn) {
        return this.metamodelImportContext.importType(fqcn);
    }

    @Override
    public String relationImportType(String fqcn) {
        return this.relationImportContext.importType(fqcn);
    }

    @Override
    public String multiRelationImportType(String fqcn) {
        return this.multiRelationImportContext.importType(fqcn);
    }

    @Override
    public String implementationImportType(String fqcn) {
        return this.implementationImportContext.importType(fqcn);
    }

    @Override
    public String builderImportType(String fqcn) {
        return this.builderImportContext.importType(fqcn);
    }

    @Override
    public final TypeElement getTypeElement() {
        return this.element;
    }

    @Override
    public Element[] getOriginatingElements() {
        return this.originatingElements;
    }

    @Override
    public Map<String, TypeElement> getOptionalParameters() {
        return this.optionalParameters;
    }

    @Override
    public Map<String, ViewFilter> getViewFilters() {
        return this.viewFilters;
    }

    @Override
    public String getSafeTypeVariable(String typeVariable) {
        List<? extends TypeMirror> typeArguments = ((DeclaredType)this.element.asType()).getTypeArguments();
        if (typeArguments.isEmpty()) {
            return typeVariable;
        }
        String originalTypeVariable = typeVariable;
        int suffix = 0;
        block0: while (true) {
            for (TypeVariable typeVariable2 : typeArguments) {
                if (!typeVariable.equals(typeVariable2.asElement().getSimpleName().toString())) continue;
                typeVariable = originalTypeVariable + suffix++;
                continue block0;
            }
            break;
        }
        return typeVariable;
    }

    private boolean isGetterOrSetter(Element methodOfClass) {
        if (methodOfClass instanceof ExecutableElement) {
            ExecutableType methodType = (ExecutableType)methodOfClass.asType();
            String methodSimpleName = methodOfClass.getSimpleName().toString();
            List<? extends TypeMirror> methodParameterTypes = methodType.getParameterTypes();
            TypeMirror returnType = methodType.getReturnType();
            if (methodSimpleName.startsWith("set") && methodParameterTypes.size() == 1 && "void".equalsIgnoreCase(returnType.toString())) {
                return true;
            }
            if ((methodSimpleName.startsWith("get") || methodSimpleName.startsWith("is")) && methodParameterTypes.isEmpty() && !"void".equalsIgnoreCase(returnType.toString())) {
                return true;
            }
        }
        return false;
    }

    public boolean addAccessorForType(String realType) {
        return this.addedAccessors.add(realType);
    }
}

