/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.processor;

import com.blazebit.persistence.view.processor.BuilderClassWriter;
import com.blazebit.persistence.view.processor.Context;
import com.blazebit.persistence.view.processor.ForeignPackageAdapterClassWriter;
import com.blazebit.persistence.view.processor.ImplementationClassWriter;
import com.blazebit.persistence.view.processor.MetaEntityView;
import com.blazebit.persistence.view.processor.MetamodelClassWriter;
import com.blazebit.persistence.view.processor.MultiRelationClassWriter;
import com.blazebit.persistence.view.processor.RelationClassWriter;
import com.blazebit.persistence.view.processor.TypeUtils;
import com.blazebit.persistence.view.processor.annotation.AnnotationMetaEntityView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"com.blazebit.persistence.view.EntityView"})
@SupportedOptions(value={"debug", "addGenerationDate", "addGeneratedAnnotation", "addSuppressWarningsAnnotation", "strictCascadingCheck", "defaultVersionAttributeName", "defaultVersionAttributeType", "generateImplementations", "generateBuilders", "createEmptyFlatViews", "generateDeepConstants", "optionalParameters", "threads"})
public class EntityViewAnnotationProcessor
extends AbstractProcessor {
    public static final String DEBUG_OPTION = "debug";
    public static final String ADD_GENERATION_DATE = "addGenerationDate";
    public static final String ADD_GENERATED_ANNOTATION = "addGeneratedAnnotation";
    public static final String ADD_SUPPRESS_WARNINGS_ANNOTATION = "addSuppressWarningsAnnotation";
    public static final String STRICT_CASCADING_CHECK = "strictCascadingCheck";
    public static final String DEFAULT_VERSION_ATTRIBUTE_NAME = "defaultVersionAttributeName";
    public static final String DEFAULT_VERSION_ATTRIBUTE_TYPE = "defaultVersionAttributeType";
    public static final String GENERATE_IMPLEMENTATIONS = "generateImplementations";
    public static final String GENERATE_BUILDERS = "generateBuilders";
    public static final String CREATE_EMPTY_FLAT_VIEWS = "createEmptyFlatViews";
    public static final String GENERATE_DEEP_CONSTANTS = "generateDeepConstants";
    public static final String OPTIONAL_PARAMETERS = "optionalParameters";
    public static final String THREADS = "threads";
    private Context context;

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        this.context = new Context(processingEnvironment);
        this.context.logMessage(Diagnostic.Kind.NOTE, "Blaze-Persistence Entity-View Annotation Processor");
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!(roundEnv.processingOver() || roundEnv.errorRaised() || annotations.isEmpty())) {
            this.execute(annotations, roundEnv);
            return false;
        }
        return false;
    }

    private void execute(Set<? extends TypeElement> annotations, RoundEnvironment roundEnvironment) {
        long initTime;
        int threads = this.context.getThreads();
        ExecutorService executorService = threads == 1 ? Executors.newSingleThreadExecutor() : Executors.newFixedThreadPool(threads);
        long start = initTime = System.nanoTime();
        ArrayList<TypeElement> entityViews = new ArrayList<TypeElement>();
        this.discoverEntityViews(entityViews, roundEnvironment.getRootElements());
        this.context.logMessage(Diagnostic.Kind.NOTE, "Annotation processor discovery took " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start) + "ms");
        start = System.nanoTime();
        ArrayList futures = new ArrayList(entityViews.size());
        this.start(executorService, entityViews, futures);
        EntityViewAnnotationProcessor.await(futures);
        this.context.logMessage(Diagnostic.Kind.NOTE, "Annotation processor analysis took " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start) + "ms");
        start = System.nanoTime();
        int views = this.createMetaModelClasses(executorService);
        this.context.logMessage(Diagnostic.Kind.NOTE, "Annotation processor generation took " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start) + "ms");
        this.context.logMessage(Diagnostic.Kind.NOTE, "Annotation processor processed " + views + " entity views with " + threads + " threads and took overall " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - initTime) + "ms");
    }

    private void start(ExecutorService executorService, List<TypeElement> typeElements, List<Future<?>> futures) {
        for (final TypeElement typeElement : typeElements) {
            futures.add(executorService.submit(new Runnable(){

                @Override
                public void run() {
                    AnnotationMetaEntityView metaEntity = new AnnotationMetaEntityView(typeElement, EntityViewAnnotationProcessor.this.context);
                    EntityViewAnnotationProcessor.this.context.addMetaEntityViewToContext(metaEntity.getQualifiedName(), metaEntity);
                }
            }));
        }
    }

    private static void await(List<Future<?>> futures) {
        for (Future<?> future : futures) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void discoverEntityViews(List<TypeElement> entityViews, Collection<? extends Element> elements) {
        for (Element element : elements) {
            if (this.isEntityView(element)) {
                this.context.logMessage(Diagnostic.Kind.OTHER, "Processing annotated class " + element.toString());
                this.handleRootElementAnnotationMirrors(entityViews, element);
            }
            this.discoverEntityViews(entityViews, element.getEnclosedElements());
        }
    }

    private int createMetaModelClasses(ExecutorService executorService) {
        final ThreadLocal<StringBuilder> threadLocalStringBuilder = new ThreadLocal<StringBuilder>(){

            @Override
            protected StringBuilder initialValue() {
                return new StringBuilder(65536);
            }
        };
        final LongAdder relationTime = new LongAdder();
        final LongAdder multiRelationTime = new LongAdder();
        final LongAdder metamodelTime = new LongAdder();
        final LongAdder implementationTime = new LongAdder();
        final LongAdder builderTime = new LongAdder();
        ArrayList futures = new ArrayList();
        int views = 0;
        for (final MetaEntityView entityView : this.context.getMetaEntityViews()) {
            if (!entityView.isValid() || !entityView.getTypeElement().getModifiers().contains((Object)Modifier.ABSTRACT) && !entityView.getTypeElement().getKind().isInterface()) continue;
            ++views;
            futures.add(executorService.submit(new Runnable(){

                @Override
                public void run() {
                    StringBuilder sb = (StringBuilder)threadLocalStringBuilder.get();
                    long start = System.nanoTime();
                    RelationClassWriter.writeFile(sb, entityView, EntityViewAnnotationProcessor.this.context);
                    relationTime.add(System.nanoTime() - start);
                }
            }));
            futures.add(executorService.submit(new Runnable(){

                @Override
                public void run() {
                    StringBuilder sb = (StringBuilder)threadLocalStringBuilder.get();
                    long start = System.nanoTime();
                    MultiRelationClassWriter.writeFile(sb, entityView, EntityViewAnnotationProcessor.this.context);
                    multiRelationTime.add(System.nanoTime() - start);
                }
            }));
            futures.add(executorService.submit(new Runnable(){

                @Override
                public void run() {
                    StringBuilder sb = (StringBuilder)threadLocalStringBuilder.get();
                    long start = System.nanoTime();
                    MetamodelClassWriter.writeFile(sb, entityView, EntityViewAnnotationProcessor.this.context);
                    metamodelTime.add(System.nanoTime() - start);
                }
            }));
            if (!this.context.isGenerateImplementations()) continue;
            futures.add(executorService.submit(new Runnable(){

                @Override
                public void run() {
                    StringBuilder sb = (StringBuilder)threadLocalStringBuilder.get();
                    long start = System.nanoTime();
                    ForeignPackageAdapterClassWriter.writeFiles(sb, entityView, EntityViewAnnotationProcessor.this.context);
                    ImplementationClassWriter.writeFile(sb, entityView, EntityViewAnnotationProcessor.this.context);
                    implementationTime.add(System.nanoTime() - start);
                }
            }));
            if (!this.context.isGenerateBuilders()) continue;
            futures.add(executorService.submit(new Runnable(){

                @Override
                public void run() {
                    StringBuilder sb = (StringBuilder)threadLocalStringBuilder.get();
                    long start = System.nanoTime();
                    BuilderClassWriter.writeFile(sb, entityView, EntityViewAnnotationProcessor.this.context);
                    builderTime.add(System.nanoTime() - start);
                }
            }));
        }
        EntityViewAnnotationProcessor.await(futures);
        this.context.logMessage(Diagnostic.Kind.NOTE, "Generating relation classes took overall " + TimeUnit.NANOSECONDS.toMillis(relationTime.sum()) + "ms");
        this.context.logMessage(Diagnostic.Kind.NOTE, "Generating multi relation classes took overall " + TimeUnit.NANOSECONDS.toMillis(multiRelationTime.sum()) + "ms");
        this.context.logMessage(Diagnostic.Kind.NOTE, "Generating metamodel classes took overall " + TimeUnit.NANOSECONDS.toMillis(metamodelTime.sum()) + "ms");
        if (this.context.isGenerateImplementations()) {
            this.context.logMessage(Diagnostic.Kind.NOTE, "Generating implementation classes took overall " + TimeUnit.NANOSECONDS.toMillis(implementationTime.sum()) + "ms");
        }
        if (this.context.isGenerateBuilders()) {
            this.context.logMessage(Diagnostic.Kind.NOTE, "Generating builder classes took overall " + TimeUnit.NANOSECONDS.toMillis(builderTime.sum()) + "ms");
        }
        return views;
    }

    private boolean isEntityView(Element element) {
        if (element.getKind() == ElementKind.CLASS || element.getKind() == ElementKind.INTERFACE) {
            return TypeUtils.containsAnnotation(element, "com.blazebit.persistence.view.EntityView");
        }
        return false;
    }

    private void handleRootElementAnnotationMirrors(List<TypeElement> entityViews, Element element) {
        if (!ElementKind.CLASS.equals((Object)element.getKind()) && !ElementKind.INTERFACE.equals((Object)element.getKind())) {
            return;
        }
        TypeElement typeElement = (TypeElement)element;
        entityViews.add(typeElement);
        this.context.initializeEntityViewElement(typeElement);
    }
}

