/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.processor;

import com.blazebit.persistence.view.processor.AttributeFilter;
import com.blazebit.persistence.view.processor.ClassWriterUtils;
import com.blazebit.persistence.view.processor.Context;
import com.blazebit.persistence.view.processor.MetaAttribute;
import com.blazebit.persistence.view.processor.MetaEntityView;
import java.util.Collection;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public final class MultiRelationClassWriter {
    public static final String MULTI_RELATION_CLASS_NAME_SUFFIX = "MultiRelation";
    private static final String NEW_LINE = System.lineSeparator();

    private MultiRelationClassWriter() {
    }

    public static void writeFile(StringBuilder sb, MetaEntityView entity, Context context) {
        sb.setLength(0);
        MultiRelationClassWriter.generateBody(sb, entity, context);
        ClassWriterUtils.writeFile(sb, entity.getPackageName(), entity.getSimpleName() + MULTI_RELATION_CLASS_NAME_SUFFIX, entity.getMultiRelationImportContext(), context, entity.getOriginatingElements());
    }

    private static void generateBody(StringBuilder sb, MetaEntityView entity, Context context) {
        entity.multiRelationImportType("java.util.Collection");
        if (context.addGeneratedAnnotation()) {
            ClassWriterUtils.writeGeneratedAnnotation(sb, entity.getMultiRelationImportContext(), context);
            sb.append(NEW_LINE);
        }
        if (context.isAddSuppressWarningsAnnotation()) {
            sb.append(ClassWriterUtils.writeSuppressWarnings());
            sb.append(NEW_LINE);
        }
        String entityViewFqcn = entity.multiRelationImportType(entity.getQualifiedName());
        sb.append("@").append(entity.multiRelationImportType("com.blazebit.persistence.view.StaticRelation")).append("(").append(entityViewFqcn).append(".class)");
        sb.append(NEW_LINE);
        sb.append("public class ").append(entity.getSimpleName()).append(MULTI_RELATION_CLASS_NAME_SUFFIX).append("<T, C extends Collection<").append(entityViewFqcn).append(">, A extends ").append(entity.multiRelationImportType("com.blazebit.persistence.view.metamodel.MethodPluralAttribute")).append("<?, ?, C>> extends ").append(entity.multiRelationImportType("com.blazebit.persistence.view.metamodel.AttributePathWrapper")).append("<T, ").append(entityViewFqcn).append(", C> {").append(NEW_LINE);
        sb.append(NEW_LINE);
        sb.append("    public ").append(entity.getSimpleName()).append(MULTI_RELATION_CLASS_NAME_SUFFIX).append("(").append(entity.multiRelationImportType("com.blazebit.persistence.view.metamodel.AttributePath")).append("<T, ").append(entityViewFqcn).append(", C> path) {").append(NEW_LINE);
        sb.append("        super(path);").append(NEW_LINE);
        sb.append("    }").append(NEW_LINE);
        sb.append(NEW_LINE);
        Collection<MetaAttribute> members = entity.getMembers();
        for (MetaAttribute metaMember : members) {
            if (metaMember.isSynthetic()) continue;
            if (metaMember.isSubview()) {
                String relationType = entity.multiRelationImportType(metaMember.getGeneratedTypePrefix() + (metaMember.isMultiCollection() ? MULTI_RELATION_CLASS_NAME_SUFFIX : "Relation"));
                sb.append("    public ").append(relationType).append("<T, ");
                if (metaMember.isMultiCollection()) {
                    metaMember.appendElementType(sb, entity.getMultiRelationImportContext());
                    sb.append(", ");
                }
                metaMember.appendMetamodelAttributeType(sb, entity.getMultiRelationImportContext());
                sb.append("> ").append(metaMember.getPropertyName()).append("() {").append(NEW_LINE);
                sb.append("        ").append(relationType).append("<").append(entityViewFqcn).append(", ");
                if (metaMember.isMultiCollection()) {
                    metaMember.appendElementType(sb, entity.getMultiRelationImportContext());
                    sb.append(", ");
                }
                metaMember.appendMetamodelAttributeType(sb, entity.getMultiRelationImportContext());
                sb.append("> relation = ").append(entity.getSimpleName()).append("_");
                sb.append('.').append(metaMember.getPropertyName()).append(";").append(NEW_LINE);
                sb.append("        return new ").append(relationType).append("<>(relation == null ? getWrapped().<");
                if (metaMember.isMultiCollection()) {
                    sb.append(entity.multiRelationImportType(metaMember.getModelType()));
                    sb.append(", ");
                }
                metaMember.appendElementType(sb, entity.getMultiRelationImportContext());
                if (metaMember.isMultiCollection()) {
                    sb.append(">getMulti(\"");
                } else {
                    sb.append(">get(\"");
                }
                sb.append(metaMember.getPropertyName()).append("\") : getWrapped().get(relation));").append(NEW_LINE);
            } else {
                sb.append("    public ").append(entity.multiRelationImportType("com.blazebit.persistence.view.metamodel.AttributePath")).append("<T, ");
                sb.append(entity.multiRelationImportType(metaMember.getModelType()));
                sb.append(", ");
                metaMember.appendElementType(sb, entity.getMultiRelationImportContext());
                sb.append("> ").append(metaMember.getPropertyName()).append("() {").append(NEW_LINE);
                sb.append("        ");
                metaMember.appendMetamodelAttributeType(sb, entity.getMultiRelationImportContext());
                sb.append(" attribute = ").append(entity.getSimpleName()).append("_");
                sb.append('.').append(metaMember.getPropertyName()).append(';').append(NEW_LINE);
                sb.append("        return attribute == null ? getWrapped().<");
                if (metaMember.isMultiCollection()) {
                    sb.append(entity.multiRelationImportType(metaMember.getModelType()));
                    sb.append(", ");
                }
                metaMember.appendElementType(sb, entity.getMultiRelationImportContext());
                if (metaMember.isMultiCollection()) {
                    sb.append(">getMulti(\"");
                } else {
                    sb.append(">get(\"");
                }
                sb.append(metaMember.getPropertyName()).append("\") : getWrapped().get(attribute);").append(NEW_LINE);
            }
            sb.append("    }").append(NEW_LINE);
            sb.append(NEW_LINE);
        }
        sb.append("    public A attr() {").append(NEW_LINE);
        sb.append("        return (A) getWrapped().getAttributes().get(getWrapped().getAttributes().size() - 1);").append(NEW_LINE);
        sb.append("    }").append(NEW_LINE);
        for (MetaAttribute metaMember : members) {
            if (metaMember.isSynthetic()) continue;
            for (AttributeFilter filter : metaMember.getFilters()) {
                sb.append(NEW_LINE);
                sb.append("    public ").append(entity.multiRelationImportType("com.blazebit.persistence.view.metamodel.AttributeFilterMappingPath")).append("<T, ");
                if (filter.getFilterValueType().getKind() == TypeKind.TYPEVAR) {
                    sb.append(entity.multiRelationImportType(metaMember.getDeclaredJavaType()));
                } else {
                    DeclaredType filterValueType = (DeclaredType)filter.getFilterValueType();
                    TypeElement filterValueTypeElement = (TypeElement)filterValueType.asElement();
                    sb.append(entity.multiRelationImportType(filterValueTypeElement.getQualifiedName().toString()));
                    if (!filterValueType.getTypeArguments().isEmpty()) {
                        sb.append("<");
                        for (TypeMirror typeMirror : filterValueType.getTypeArguments()) {
                            if (typeMirror.getKind() == TypeKind.TYPEVAR) {
                                sb.append(entity.multiRelationImportType(metaMember.getDeclaredJavaType()));
                            } else {
                                sb.append(entity.multiRelationImportType(typeMirror.toString()));
                            }
                            sb.append(", ");
                        }
                        sb.setLength(sb.length() - 2);
                        sb.append(">");
                    }
                }
                sb.append("> ").append(metaMember.getPropertyName()).append('_');
                if (filter.getName().isEmpty()) {
                    sb.append("filter");
                } else {
                    sb.append(filter.getName());
                }
                sb.append("() {").append(NEW_LINE);
                if (metaMember.isSubview()) {
                    String relationType = entity.multiRelationImportType(metaMember.getGeneratedTypePrefix() + (metaMember.isMultiCollection() ? MULTI_RELATION_CLASS_NAME_SUFFIX : "Relation"));
                    sb.append("        ").append(relationType).append("<").append(entityViewFqcn).append(", ");
                    metaMember.appendMetamodelAttributeType(sb, entity.getMultiRelationImportContext());
                    sb.append("> relation = ").append(entity.getSimpleName()).append("_");
                    sb.append('.').append(metaMember.getPropertyName()).append(";").append(NEW_LINE);
                    sb.append("        return relation == null ? new ").append(entity.multiRelationImportType("com.blazebit.persistence.view.metamodel.AttributeFilterMappingPath")).append("<>(getWrapped().get(\"").append(metaMember.getPropertyName()).append("\"), \"").append(filter.getName()).append("\") : new ").append(entity.multiRelationImportType("com.blazebit.persistence.view.metamodel.AttributeFilterMappingPath")).append("<>(getWrapped().get(relation), relation.").append(metaMember.getPropertyName()).append("_");
                    if (filter.getName().isEmpty()) {
                        sb.append("filter");
                    } else {
                        sb.append(filter.getName());
                    }
                    sb.append("());").append(NEW_LINE);
                } else {
                    sb.append("        ");
                    metaMember.appendMetamodelAttributeType(sb, entity.getMultiRelationImportContext());
                    sb.append(" attribute = ").append(entity.getSimpleName()).append("_");
                    sb.append('.').append(metaMember.getPropertyName()).append(';').append(NEW_LINE);
                    sb.append("        return attribute == null ? new ").append(entity.multiRelationImportType("com.blazebit.persistence.view.metamodel.AttributeFilterMappingPath")).append("<>(getWrapped().get(\"").append(metaMember.getPropertyName()).append("\"), \"").append(filter.getName()).append("\") : new ").append(entity.multiRelationImportType("com.blazebit.persistence.view.metamodel.AttributeFilterMappingPath")).append("<>(getWrapped().get(attribute), ").append(entity.getSimpleName()).append("_").append(".").append(metaMember.getPropertyName()).append("_");
                    if (filter.getName().isEmpty()) {
                        sb.append("filter");
                    } else {
                        sb.append(filter.getName());
                    }
                    sb.append(");").append(NEW_LINE);
                }
                sb.append("    }").append(NEW_LINE);
            }
        }
        sb.append(NEW_LINE);
        sb.append("}");
        sb.append(NEW_LINE);
    }
}

