/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.processor.annotation;

import com.blazebit.persistence.view.processor.Context;
import com.blazebit.persistence.view.processor.ImportContext;
import com.blazebit.persistence.view.processor.TypeUtils;
import com.blazebit.persistence.view.processor.annotation.AnnotationMetaAttribute;
import com.blazebit.persistence.view.processor.annotation.AnnotationMetaEntityView;
import java.util.Comparator;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;

public class AnnotationMetaCollection
extends AnnotationMetaAttribute {
    protected final boolean ordered;
    protected final boolean sorted;
    protected final String comparator;
    protected final String collectionJavaType;
    protected final String elementCollectionJavaType;
    private final String collectionType;
    private final String implementationTypeString;

    public AnnotationMetaCollection(AnnotationMetaEntityView parent, Element element, String collectionType, String collectionJavaType, String elementCollectionJavaType, String elementType, String realElementType, Context context) {
        super(parent, element, elementType, realElementType, context);
        this.elementCollectionJavaType = elementCollectionJavaType;
        boolean ordered = "java.util.List".equals(collectionJavaType);
        boolean sorted = collectionJavaType.startsWith("java.util.Sorted") || collectionJavaType.startsWith("java.util.Navigable");
        String comparator = null;
        AnnotationMirror annotationMirror = TypeUtils.getAnnotationMirror(element, "com.blazebit.persistence.view.CollectionMapping");
        if (annotationMirror != null) {
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                String name = entry.getKey().getSimpleName().toString();
                if ("ordered".equals(name)) {
                    ordered = Boolean.parseBoolean(entry.getValue().toString());
                    continue;
                }
                if (!"comparator".equals(name)) continue;
                String s = entry.getValue().toString();
                if (Comparator.class.getName().equals(s)) continue;
                comparator = s;
                sorted = true;
            }
        }
        this.ordered = ordered;
        this.sorted = sorted;
        this.comparator = comparator;
        this.collectionJavaType = collectionJavaType;
        this.collectionType = collectionType;
        this.implementationTypeString = elementCollectionJavaType == null ? this.getHostingEntity().importTypeExceptMetamodel(collectionJavaType) + "<" + this.getHostingEntity().importType(realElementType) + ">" : this.getHostingEntity().importTypeExceptMetamodel(collectionJavaType) + "<" + this.getHostingEntity().importType(elementCollectionJavaType) + "<" + this.getHostingEntity().importType(elementType) + ">>";
    }

    @Override
    public void appendDefaultValue(StringBuilder sb, boolean createEmpty, boolean createConstructor, ImportContext importContext) {
        if (createEmpty) {
            if (this.getElement().getKind() == ElementKind.PARAMETER) {
                sb.append("new ").append(this.importCollectionType(importContext)).append("<>()");
            } else {
                sb.append("(").append(this.getImplementationTypeString()).append(") (").append(this.collectionJavaType).append("<?>) ");
                sb.append(importContext.importType(this.getDerivedTypeName() + "_")).append('.').append(this.getPropertyName());
                if (this.isSubview()) {
                    sb.append(".attr()");
                }
                sb.append(".getCollectionInstantiator().");
                if (this.getDirtyStateIndex() == -1) {
                    sb.append("createCollection(0)");
                } else {
                    sb.append("createRecordingCollection(0)");
                }
            }
        } else {
            super.appendDefaultValue(sb, createEmpty, createConstructor, importContext);
        }
    }

    @Override
    public boolean isCreateEmptyFlatViews() {
        return false;
    }

    private String importCollectionType(ImportContext importContext) {
        switch (this.collectionJavaType) {
            case "java.util.Set": {
                if (this.ordered) {
                    return importContext.importType("java.util.LinkedHashSet");
                }
                if (this.sorted) {
                    return importContext.importType("java.util.TreeSet");
                }
                return importContext.importType("java.util.HashSet");
            }
            case "java.util.SortedSet": {
                return importContext.importType("java.util.TreeSet");
            }
            case "java.util.NavigableSet": {
                return importContext.importType("java.util.TreeSet");
            }
        }
        return importContext.importType("java.util.ArrayList");
    }

    @Override
    public void appendMetamodelAttributeType(StringBuilder sb, ImportContext importContext) {
        sb.append(importContext.importType(this.getMetaType())).append('<').append(importContext.importType(this.getHostingEntity().getQualifiedName())).append(", ");
        if (this.elementCollectionJavaType != null) {
            sb.append(importContext.importType(this.getModelType())).append(", ");
        }
        this.appendElementType(sb, importContext);
        sb.append('>');
    }

    @Override
    public void appendElementType(StringBuilder sb, ImportContext importContext) {
        if (this.elementCollectionJavaType == null) {
            sb.append(importContext.importType(this.getModelType()));
        } else {
            sb.append(importContext.importType(this.elementCollectionJavaType)).append('<').append(importContext.importType(this.getModelType())).append('>');
        }
    }

    @Override
    public String getImplementationTypeString() {
        return this.implementationTypeString;
    }

    @Override
    public String getMetaType() {
        return this.collectionType;
    }

    public boolean isIndexedList() {
        return "java.util.List".equals(this.collectionJavaType);
    }

    @Override
    public boolean isMultiCollection() {
        return this.elementCollectionJavaType != null;
    }
}

