/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.processor.annotation;

import com.blazebit.persistence.view.processor.Context;
import com.blazebit.persistence.view.processor.MetaAttribute;
import com.blazebit.persistence.view.processor.MetaConstructor;
import com.blazebit.persistence.view.processor.MetaEntityView;
import com.blazebit.persistence.view.processor.annotation.AnnotationMetaAttribute;
import com.blazebit.persistence.view.processor.annotation.AnnotationMetaEntityView;
import com.blazebit.persistence.view.processor.annotation.MetaAttributeGenerationVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class AnnotationMetaConstructor
implements MetaConstructor {
    private final AnnotationMetaEntityView parent;
    private final ExecutableElement element;
    private final boolean isReal;
    private final boolean hasSelfParameter;
    private final String name;
    private final List<MetaAttribute> parameters;
    private final Map<String, TypeElement> optionalParameters;

    public AnnotationMetaConstructor(AnnotationMetaEntityView parent) {
        TypeElement superclass;
        this.parent = parent;
        this.element = null;
        this.name = "init";
        this.parameters = Collections.emptyList();
        this.hasSelfParameter = false;
        boolean isReal = false;
        HashMap<String, TypeElement> optionalParameters = new HashMap<String, TypeElement>();
        TypeMirror superclassMirror = parent.getTypeElement().getSuperclass();
        while (superclassMirror.getKind() != TypeKind.NONE && !"java.lang.Object".equals((superclass = (TypeElement)((DeclaredType)superclassMirror).asElement()).getQualifiedName().toString())) {
            for (Element element : superclass.getEnclosedElements()) {
                String name = element.getSimpleName().toString();
                if (!"<init>".equals(name)) continue;
                isReal = true;
                break;
            }
            if (isReal) break;
            superclassMirror = superclass.getSuperclass();
        }
        this.isReal = isReal;
        this.optionalParameters = optionalParameters;
    }

    public AnnotationMetaConstructor(AnnotationMetaEntityView parent, ExecutableElement element, MetaAttributeGenerationVisitor visitor, Context context) {
        this.parent = parent;
        this.element = element;
        this.isReal = true;
        String name = "init";
        block0: for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().toString().equals("com.blazebit.persistence.view.ViewConstructor")) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                if (!entry.getKey().getSimpleName().toString().equals("value")) continue;
                name = entry.getValue().getValue().toString();
                break block0;
            }
        }
        this.name = name;
        ArrayList<MetaAttribute> parameters = new ArrayList<MetaAttribute>(element.getParameters().size());
        List<? extends VariableElement> list = element.getParameters();
        boolean hasSelfParameter = false;
        HashMap<String, TypeElement> optionalParameters = new HashMap<String, TypeElement>();
        for (int i = 0; i < list.size(); ++i) {
            VariableElement parameter = list.get(i);
            AnnotationMetaAttribute result = parameter.asType().accept(visitor, parameter);
            result.setAttributeIndex(i);
            parameters.add(result);
            for (Map.Entry<String, TypeElement> entry : result.getOptionalParameters().entrySet()) {
                TypeElement typeElement = entry.getValue();
                TypeElement existingTypeElement = (TypeElement)optionalParameters.get(entry.getKey());
                if (existingTypeElement != null && !context.getTypeUtils().isAssignable(typeElement.asType(), existingTypeElement.asType())) continue;
                optionalParameters.put(entry.getKey(), entry.getValue());
            }
            hasSelfParameter = hasSelfParameter || result.isSelf();
        }
        this.parameters = parameters;
        this.hasSelfParameter = hasSelfParameter;
        this.optionalParameters = optionalParameters;
    }

    @Override
    public MetaEntityView getHostingEntity() {
        return this.parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isReal() {
        return this.isReal;
    }

    @Override
    public boolean hasSelfParameter() {
        return this.hasSelfParameter;
    }

    @Override
    public List<MetaAttribute> getParameters() {
        return this.parameters;
    }

    @Override
    public Map<String, TypeElement> getOptionalParameters() {
        return this.optionalParameters;
    }
}

