/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.processor;

import com.blazebit.persistence.view.processor.ClassWriterUtils;
import com.blazebit.persistence.view.processor.Context;
import com.blazebit.persistence.view.processor.MappingKind;
import com.blazebit.persistence.view.processor.MetaAttribute;
import com.blazebit.persistence.view.processor.MetaConstructor;
import com.blazebit.persistence.view.processor.MetaEntityView;
import com.blazebit.persistence.view.processor.TypeUtils;
import com.blazebit.persistence.view.processor.annotation.AnnotationMetaCollection;
import com.blazebit.persistence.view.processor.annotation.AnnotationMetaMap;
import com.blazebit.persistence.view.processor.annotation.AnnotationMetaSingularAttribute;
import java.util.Collection;
import java.util.List;
import javax.lang.model.element.ElementKind;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;

public final class BuilderClassWriter {
    private static final String BUILDER_CLASS_NAME_SUFFIX = "Builder";
    private static final String NEW_LINE = System.lineSeparator();
    private static final String PARAMETER_PREFIX = "Param";

    private BuilderClassWriter() {
    }

    public static void writeFile(StringBuilder sb, MetaEntityView entity, Context context) {
        sb.setLength(0);
        BuilderClassWriter.generateBody(sb, entity, context);
        ClassWriterUtils.writeFile(sb, entity.getPackageName(), entity.getSimpleName() + BUILDER_CLASS_NAME_SUFFIX, entity.getBuilderImportContext(), context, entity.getOriginatingElements());
    }

    private static void generateBody(StringBuilder sb, MetaEntityView entity, Context context) {
        int i;
        if (context.addGeneratedAnnotation()) {
            ClassWriterUtils.writeGeneratedAnnotation(sb, entity.getBuilderImportContext(), context);
            sb.append(NEW_LINE);
        }
        if (context.isAddSuppressWarningsAnnotation()) {
            sb.append(ClassWriterUtils.writeSuppressWarnings());
            sb.append(NEW_LINE);
        }
        sb.append("@").append(entity.builderImportType("com.blazebit.persistence.view.StaticBuilder")).append("(").append(entity.builderImportType(entity.getQualifiedName())).append(".class)");
        sb.append(NEW_LINE);
        BuilderClassWriter.printClassDeclaration(sb, entity, context);
        sb.append(NEW_LINE);
        Collection<MetaAttribute> members = entity.getMembers();
        for (MetaAttribute metaAttribute : members) {
            metaAttribute.appendBuilderAttributeDeclarationString(sb);
            sb.append(NEW_LINE);
        }
        sb.append("    protected final ").append(entity.builderImportType("java.util.Map")).append("<String, Object> optionalParameters;").append(NEW_LINE);
        sb.append(NEW_LINE);
        BuilderClassWriter.printConstructors(sb, entity, context);
        sb.append(NEW_LINE);
        String builderTypeVariable = entity.getSafeTypeVariable("BuilderType");
        for (MetaAttribute metaMember3 : members) {
            BuilderClassWriter.appendMember(sb, entity, metaMember3, builderTypeVariable);
        }
        BuilderClassWriter.appendUtilityMethods(sb, entity, context);
        BuilderClassWriter.appendGetMethods(sb, entity, context);
        BuilderClassWriter.appendWithMethods(sb, entity, builderTypeVariable, context);
        BuilderClassWriter.appendWithBuilderMethods(sb, entity, builderTypeVariable, context);
        sb.append(NEW_LINE);
        List<? extends TypeMirror> list = ((DeclaredType)entity.getTypeElement().asType()).getTypeArguments();
        String elementType = entity.getSafeTypeVariable("ElementType");
        StringBuilder tempSb = new StringBuilder();
        for (MetaConstructor metaConstructor : entity.getConstructors()) {
            String className = Character.toUpperCase(metaConstructor.getName().charAt(0)) + metaConstructor.getName().substring(1);
            sb.append(NEW_LINE);
            sb.append("    public static class ").append(className);
            tempSb.setLength(0);
            tempSb.append(className);
            if (!list.isEmpty()) {
                sb.append("<");
                tempSb.append("<");
                BuilderClassWriter.printTypeVariable(sb, entity, (TypeVariable)list.get(0));
                tempSb.append(list.get(0));
                for (int i3 = 1; i3 < list.size(); ++i3) {
                    sb.append(", ");
                    BuilderClassWriter.printTypeVariable(sb, entity, (TypeVariable)list.get(i3));
                    tempSb.append(", ");
                    tempSb.append(list.get(i3));
                }
                sb.append(">");
                tempSb.append(">");
            }
            String builderType = tempSb.toString();
            sb.append(" extends ").append(entity.getSimpleName()).append(BUILDER_CLASS_NAME_SUFFIX);
            sb.append("<");
            for (int i4 = 0; i4 < list.size(); ++i4) {
                sb.append(list.get(i4));
                sb.append(", ");
            }
            sb.append(entity.builderImportType("com.blazebit.persistence.view.EntityViewBuilder")).append("<").append(entity.builderImportType(entity.getQualifiedName())).append(">");
            sb.append("> implements ");
            sb.append(entity.builderImportType("com.blazebit.persistence.view.EntityViewBuilder"));
            sb.append("<");
            sb.append(entity.builderImportType(entity.getQualifiedName()));
            sb.append(">");
            sb.append(" {").append(NEW_LINE);
            for (MetaAttribute metaMember5 : metaConstructor.getParameters()) {
                metaMember5.appendBuilderAttributeDeclarationString(sb);
                sb.append(NEW_LINE);
            }
            sb.append(NEW_LINE);
            sb.append("        public ").append(className).append("(").append(entity.builderImportType("java.util.Map")).append("<String, Object> optionalParameters) {").append(NEW_LINE);
            sb.append("            super(optionalParameters);").append(NEW_LINE);
            for (MetaAttribute metaMember : metaConstructor.getParameters()) {
                if (metaMember.getKind() != MappingKind.PARAMETER) continue;
                if (metaMember.isPrimitive()) {
                    sb.append("!optionalParameters.containsKey(\"").append(metaMember.getMapping()).append("\") ? ");
                    metaMember.appendDefaultValue(sb, false, true, entity.getBuilderImportContext());
                    sb.append(" : ");
                }
                sb.append("            this.").append(metaMember.getPropertyName()).append(" = (").append(entity.builderImportType(metaMember.getBuilderImplementationTypeString())).append(") optionalParameters.get(\"").append(metaMember.getMapping()).append("\");").append(NEW_LINE);
            }
            sb.append("        }").append(NEW_LINE);
            sb.append(NEW_LINE);
            sb.append("        @Override").append(NEW_LINE);
            sb.append("        public ").append(entity.builderImportType(entity.getQualifiedName())).append(" build() {").append(NEW_LINE);
            sb.append("            return new ").append(entity.builderImportType(TypeUtils.getDerivedTypeName(entity.getTypeElement()) + "Impl")).append("(");
            if (members.isEmpty() && metaConstructor.getParameters().isEmpty()) {
                sb.append("(").append(entity.builderImportType(TypeUtils.getDerivedTypeName(entity.getTypeElement()) + "Impl")).append(") null, optionalParameters);").append(NEW_LINE);
            } else {
                sb.append(NEW_LINE);
                BuilderClassWriter.appendConstructorArguments(sb, entity, metaConstructor);
                sb.append(NEW_LINE).append("            );").append(NEW_LINE);
            }
            sb.append("        }").append(NEW_LINE);
            sb.append(NEW_LINE);
            sb.append("        @Override").append(NEW_LINE);
            sb.append("        public ");
            sb.append(builderType);
            sb.append(" with(int parameterIndex, Object value) {").append(NEW_LINE);
            sb.append("            switch (parameterIndex) {").append(NEW_LINE);
            List<MetaAttribute> parameters = metaConstructor.getParameters();
            boolean first = true;
            for (int i2 = 0; i2 < parameters.size(); ++i2) {
                first = false;
                MetaAttribute metaMember42 = parameters.get(i2);
                sb.append("                case ").append(i2).append(":").append(NEW_LINE);
                sb.append("                    this.").append(metaMember42.getPropertyName()).append(" = ");
                sb.append("value == null ? ");
                metaMember42.appendDefaultValue(sb, true, true, entity.getBuilderImportContext());
                sb.append(" : ");
                sb.append("(").append(metaMember42.getBuilderImplementationTypeString()).append(") value;").append(NEW_LINE);
                sb.append("                    break;").append(NEW_LINE);
            }
            sb.append("                default:").append(NEW_LINE);
            sb.append("                     throw new IllegalArgumentException(\"Unknown parameter index: \" + parameterIndex);").append(NEW_LINE);
            sb.append("        }").append(NEW_LINE);
            if (!first) {
                sb.append("        return this;").append(NEW_LINE);
            }
            sb.append("    }").append(NEW_LINE);
            sb.append(NEW_LINE);
            sb.append("        @Override").append(NEW_LINE);
            sb.append("        public <").append(elementType).append("> ").append(elementType).append(" get(int parameterIndex) {").append(NEW_LINE);
            sb.append("            switch (parameterIndex) {").append(NEW_LINE);
            for (int i2 = 0; i2 < parameters.size(); ++i2) {
                MetaAttribute metaMember = parameters.get(i2);
                sb.append("                case ").append(i2).append(":").append(NEW_LINE);
                sb.append("                    return (").append(elementType).append(") (Object) this.").append(metaMember.getPropertyName()).append(";").append(NEW_LINE);
            }
            sb.append("            }").append(NEW_LINE);
            sb.append("            throw new IllegalArgumentException(\"Unknown parameter index: \" + parameterIndex);").append(NEW_LINE);
            sb.append("        }").append(NEW_LINE);
            for (MetaAttribute metaMember : entity.getMembers()) {
                BuilderClassWriter.appendMemberWith(sb, entity, metaMember, builderType);
            }
            BuilderClassWriter.appendWithMethods(sb, entity, builderType, context);
            BuilderClassWriter.appendWithBuilderMethods(sb, entity, builderType, context);
            BuilderClassWriter.appendWithBuilderMethods(sb, metaConstructor, context, builderType);
            for (MetaAttribute metaMember : metaConstructor.getParameters()) {
                BuilderClassWriter.appendMember(sb, entity, metaMember, builderType);
            }
            sb.append("    }").append(NEW_LINE);
        }
        MetaConstructor constructor = null;
        if (entity.hasEmptyConstructor()) {
            for (MetaConstructor entityConstructor : entity.getConstructors()) {
                if (!entityConstructor.getParameters().isEmpty()) continue;
                constructor = entityConstructor;
                break;
            }
        } else {
            constructor = entity.getConstructors().iterator().next();
        }
        String string = entity.getSafeTypeVariable("BuilderResult");
        sb.append(NEW_LINE);
        sb.append("    public static class Nested<");
        tempSb.setLength(0);
        tempSb.append("Nested<");
        for (int i5 = 0; i5 < list.size(); ++i5) {
            BuilderClassWriter.printTypeVariable(sb, entity, (TypeVariable)list.get(i5));
            sb.append(", ");
            tempSb.append(list.get(i5));
            tempSb.append(", ");
        }
        sb.append(string).append(">");
        tempSb.append(string).append(">");
        String builderType = tempSb.toString();
        sb.append(" extends ").append(entity.getSimpleName()).append(BUILDER_CLASS_NAME_SUFFIX);
        sb.append("<");
        for (int i6 = 0; i6 < list.size(); ++i6) {
            sb.append(list.get(i6));
            sb.append(", ");
        }
        sb.append(builderType);
        sb.append("> implements ");
        sb.append(entity.builderImportType("com.blazebit.persistence.view.EntityViewNestedBuilder"));
        sb.append("<");
        sb.append(entity.builderImportType(entity.getQualifiedName()));
        sb.append(", ").append(string).append(", ");
        sb.append(builderType);
        sb.append("> {").append(NEW_LINE);
        sb.append(NEW_LINE);
        sb.append("        private final ").append(entity.builderImportType("com.blazebit.persistence.view.EntityViewBuilderListener")).append(" listener;").append(NEW_LINE);
        sb.append("        private final ").append(string).append(" result;").append(NEW_LINE);
        for (MetaAttribute metaMember6 : constructor.getParameters()) {
            metaMember6.appendBuilderAttributeDeclarationString(sb);
            sb.append(NEW_LINE);
        }
        sb.append(NEW_LINE);
        sb.append("        public Nested(").append(entity.builderImportType("java.util.Map")).append("<String, Object> optionalParameters, ").append(entity.builderImportType("com.blazebit.persistence.view.EntityViewBuilderListener")).append(" listener, ").append(string).append(" result) {").append(NEW_LINE);
        sb.append("            super(optionalParameters);").append(NEW_LINE);
        for (MetaAttribute metaMember : constructor.getParameters()) {
            if (metaMember.getKind() != MappingKind.PARAMETER) continue;
            if (metaMember.isPrimitive()) {
                sb.append("!optionalParameters.containsKey(\"").append(metaMember.getMapping()).append("\") ? ");
                metaMember.appendDefaultValue(sb, false, true, entity.getBuilderImportContext());
                sb.append(" : ");
            }
            sb.append("            this.").append(metaMember.getPropertyName()).append(" = (").append(entity.builderImportType(metaMember.getBuilderImplementationTypeString())).append(") optionalParameters.get(\"").append(metaMember.getMapping()).append("\");").append(NEW_LINE);
        }
        sb.append("            this.listener = listener;").append(NEW_LINE);
        sb.append("            this.result = result;").append(NEW_LINE);
        sb.append("        }").append(NEW_LINE);
        sb.append(NEW_LINE);
        sb.append("        @Override").append(NEW_LINE);
        sb.append("        public ").append(string).append(" build() {").append(NEW_LINE);
        sb.append("            listener.onBuildComplete(new ").append(entity.builderImportType(TypeUtils.getDerivedTypeName(entity.getTypeElement()) + "Impl")).append("(");
        if (members.isEmpty() && constructor.getParameters().isEmpty()) {
            sb.append("(").append(entity.builderImportType(TypeUtils.getDerivedTypeName(entity.getTypeElement()) + "Impl")).append(") null, optionalParameters));").append(NEW_LINE);
        } else {
            sb.append(NEW_LINE);
            BuilderClassWriter.appendConstructorArguments(sb, entity, constructor);
            sb.append(NEW_LINE).append("            ));").append(NEW_LINE);
        }
        sb.append("            return result;").append(NEW_LINE);
        sb.append("        }").append(NEW_LINE);
        sb.append(NEW_LINE);
        sb.append("        @Override").append(NEW_LINE);
        sb.append("        public ");
        sb.append(builderType);
        sb.append(" with(int parameterIndex, Object value) {").append(NEW_LINE);
        sb.append("        switch (parameterIndex) {").append(NEW_LINE);
        List<MetaAttribute> parameters = constructor.getParameters();
        boolean first = true;
        for (i = 0; i < parameters.size(); ++i) {
            first = false;
            MetaAttribute metaMember7 = parameters.get(i);
            sb.append("            case ").append(i).append(":").append(NEW_LINE);
            sb.append("                this.").append(metaMember7.getPropertyName()).append(" = ");
            sb.append("value == null ? ");
            metaMember7.appendDefaultValue(sb, true, true, entity.getBuilderImportContext());
            sb.append(" : ");
            sb.append("(").append(metaMember7.getBuilderImplementationTypeString()).append(") value;").append(NEW_LINE);
            sb.append("                break;").append(NEW_LINE);
        }
        sb.append("            default:").append(NEW_LINE);
        sb.append("                throw new IllegalArgumentException(\"Unknown parameter index: \" + parameterIndex);").append(NEW_LINE);
        sb.append("        }").append(NEW_LINE);
        if (!first) {
            sb.append("        return this;").append(NEW_LINE);
        }
        sb.append("    }").append(NEW_LINE);
        sb.append(NEW_LINE);
        sb.append("        @Override").append(NEW_LINE);
        sb.append("        public <").append(elementType).append("> ").append(elementType).append(" get(int parameterIndex) {").append(NEW_LINE);
        sb.append("            switch (parameterIndex) {").append(NEW_LINE);
        for (i = 0; i < parameters.size(); ++i) {
            MetaAttribute metaMember = parameters.get(i);
            sb.append("                case ").append(i).append(":").append(NEW_LINE);
            sb.append("                    return (").append(elementType).append(") (Object) this.").append(metaMember.getPropertyName()).append(";").append(NEW_LINE);
        }
        sb.append("            }").append(NEW_LINE);
        sb.append("            throw new IllegalArgumentException(\"Unknown parameter index: \" + parameterIndex);").append(NEW_LINE);
        sb.append("        }").append(NEW_LINE);
        for (MetaAttribute metaMember : entity.getMembers()) {
            BuilderClassWriter.appendMemberWith(sb, entity, metaMember, builderType);
        }
        BuilderClassWriter.appendWithMethods(sb, entity, builderType, context);
        BuilderClassWriter.appendWithBuilderMethods(sb, entity, builderType, context);
        BuilderClassWriter.appendWithBuilderMethods(sb, constructor, context, builderType);
        for (MetaAttribute metaMember : constructor.getParameters()) {
            BuilderClassWriter.appendMember(sb, entity, metaMember, builderType);
        }
        sb.append("    }").append(NEW_LINE);
        sb.append("}");
        sb.append(NEW_LINE);
    }

    private static void appendConstructorArguments(StringBuilder sb, MetaEntityView entity, MetaConstructor constructor) {
        boolean first = true;
        MetaAttribute idMember = entity.getIdMember();
        if (idMember != null) {
            sb.append("            this.").append(idMember.getPropertyName());
            first = false;
        }
        for (MetaAttribute member : entity.getMembers()) {
            if (first) {
                first = false;
            } else if (member != idMember) {
                sb.append(",").append(NEW_LINE);
            }
            if (member == idMember) continue;
            if (member.getConvertedModelType() == null) {
                sb.append("            this.").append(member.getPropertyName());
                continue;
            }
            if (member.isSubview()) {
                sb.append("            (").append(member.getImplementationTypeString()).append(") ").append(entity.getSimpleName()).append("_").append(".").append(member.getPropertyName()).append(".attr().getType().getConverter().convertToViewType(this.").append(member.getPropertyName()).append(')');
                continue;
            }
            sb.append("            (").append(member.getImplementationTypeString()).append(") ").append(entity.getSimpleName()).append("_").append(".").append(member.getPropertyName()).append(".getType().getConverter().convertToViewType(this.").append(member.getPropertyName()).append(')');
        }
        for (MetaAttribute member : constructor.getParameters()) {
            if (first) {
                first = false;
            } else {
                sb.append(",").append(NEW_LINE);
            }
            sb.append("            this.").append(member.getPropertyName());
        }
    }

    private static void appendMember(StringBuilder sb, MetaEntityView entity, MetaAttribute metaMember, String builderType) {
        metaMember.appendBuilderAttributeGetterAndSetterString(sb);
        sb.append(NEW_LINE);
        BuilderClassWriter.appendMemberWith(sb, entity, metaMember, builderType);
    }

    private static void appendMemberWith(StringBuilder sb, MetaEntityView entity, MetaAttribute metaMember, String builderType) {
        ElementKind kind = metaMember.getElement() == null ? null : metaMember.getElement().getKind();
        sb.append("    public ").append(builderType).append(" with");
        if (kind == ElementKind.PARAMETER) {
            sb.append(PARAMETER_PREFIX);
        }
        sb.append(Character.toUpperCase(metaMember.getPropertyName().charAt(0)));
        sb.append(metaMember.getPropertyName(), 1, metaMember.getPropertyName().length());
        sb.append('(');
        sb.append(metaMember.getBuilderImplementationTypeString());
        sb.append(' ').append(metaMember.getPropertyName()).append(") {").append(NEW_LINE).append("        this.").append(metaMember.getPropertyName()).append(" = ").append(metaMember.getPropertyName()).append(";").append(NEW_LINE).append("        return (").append(builderType).append(") this;").append(NEW_LINE).append("    }");
        if (metaMember.isSubview()) {
            String memberBuilderFqn = metaMember.getGeneratedTypePrefix() + BUILDER_CLASS_NAME_SUFFIX;
            List<? extends TypeMirror> typeArguments = ((DeclaredType)metaMember.getSubviewElement().asType()).getTypeArguments();
            if (metaMember instanceof AnnotationMetaMap) {
                int i;
                AnnotationMetaMap mapMember = (AnnotationMetaMap)metaMember;
                String listener = "new " + entity.builderImportType("com.blazebit.persistence.view.MapEntityViewBuilderListener") + "(getMap(\"" + metaMember.getPropertyName() + "\"), key)";
                sb.append(NEW_LINE);
                sb.append("    public ");
                if (!typeArguments.isEmpty()) {
                    sb.append("<");
                    for (i = 0; i < typeArguments.size(); ++i) {
                        sb.append("Sub");
                        BuilderClassWriter.printTypeVariable(sb, entity, (TypeVariable)typeArguments.get(i));
                        sb.append(", ");
                    }
                    sb.setCharAt(sb.length() - 2, '>');
                }
                sb.append(entity.builderImportType(memberBuilderFqn)).append(".Nested<");
                for (i = 0; i < typeArguments.size(); ++i) {
                    sb.append("Sub");
                    sb.append(typeArguments.get(i));
                    sb.append(", ");
                }
                sb.append("? extends ").append(builderType).append("> with");
                if (kind == ElementKind.PARAMETER) {
                    sb.append(PARAMETER_PREFIX);
                }
                sb.append(Character.toUpperCase(metaMember.getPropertyName().charAt(0)));
                sb.append(metaMember.getPropertyName(), 1, metaMember.getPropertyName().length());
                sb.append("Builder(Object key) {").append(NEW_LINE).append("        return new ").append(entity.builderImportType(memberBuilderFqn)).append(".Nested<>(optionalParameters, ").append(listener).append(", (").append(builderType).append(") this);").append(NEW_LINE).append("    }");
                sb.append(NEW_LINE);
                if (mapMember.isKeySubview()) {
                    int i2;
                    String keyMemberBuilderFqn = mapMember.getGeneratedKeyTypePrefix() + BUILDER_CLASS_NAME_SUFFIX;
                    List<? extends TypeMirror> keyTypeArguments = ((DeclaredType)mapMember.getKeySubviewElement().asType()).getTypeArguments();
                    sb.append(NEW_LINE);
                    sb.append("    public ");
                    if (!keyTypeArguments.isEmpty() || !typeArguments.isEmpty()) {
                        sb.append("<");
                        for (i2 = 0; i2 < keyTypeArguments.size(); ++i2) {
                            BuilderClassWriter.printTypeVariable(sb, entity, (TypeVariable)keyTypeArguments.get(i2));
                            sb.append(", ");
                        }
                        for (i2 = 0; i2 < typeArguments.size(); ++i2) {
                            BuilderClassWriter.printTypeVariable(sb, entity, (TypeVariable)typeArguments.get(i2));
                            sb.append(", ");
                        }
                        sb.setCharAt(sb.length() - 2, '>');
                    }
                    sb.append(entity.builderImportType(keyMemberBuilderFqn)).append(".Nested<");
                    for (i2 = 0; i2 < keyTypeArguments.size(); ++i2) {
                        sb.append(keyTypeArguments.get(i2));
                        sb.append(", ");
                    }
                    sb.append("? extends ").append(entity.builderImportType(memberBuilderFqn)).append(".Nested<");
                    for (i2 = 0; i2 < typeArguments.size(); ++i2) {
                        sb.append(typeArguments.get(i2));
                        sb.append(", ");
                    }
                    sb.append("? extends ").append(builderType).append(">> with");
                    if (kind == ElementKind.PARAMETER) {
                        sb.append(PARAMETER_PREFIX);
                    }
                    sb.append(Character.toUpperCase(metaMember.getPropertyName().charAt(0)));
                    sb.append(metaMember.getPropertyName(), 1, metaMember.getPropertyName().length());
                    sb.append("Builder() { ").append(NEW_LINE);
                    sb.append("        ").append(entity.builderImportType("com.blazebit.persistence.view.EntityViewBuilderListener")).append(" listener = new ").append(entity.builderImportType("com.blazebit.persistence.view.MapKeyEntityViewBuilderListener")).append("(getMap(\"").append(metaMember.getPropertyName()).append("\"));").append(NEW_LINE);
                    sb.append("        return new ").append(entity.builderImportType(keyMemberBuilderFqn)).append(".Nested<>(optionalParameters, listener, ").append(NEW_LINE);
                    sb.append("            new ").append(entity.builderImportType(memberBuilderFqn)).append(".Nested<>(optionalParameters, listener, (").append(builderType).append(") this)").append(NEW_LINE);
                    sb.append("        );").append(NEW_LINE);
                    sb.append("    }");
                    sb.append(NEW_LINE);
                }
            } else {
                int i;
                String listener;
                if (metaMember instanceof AnnotationMetaCollection) {
                    if (((AnnotationMetaCollection)metaMember).isIndexedList()) {
                        listener = "new " + entity.builderImportType("com.blazebit.persistence.view.ListEntityViewBuilderListener") + "(getCollection(\"" + metaMember.getPropertyName() + "\"), index)";
                        sb.append(NEW_LINE);
                        sb.append("    public ");
                        if (!typeArguments.isEmpty()) {
                            sb.append("<");
                            for (i = 0; i < typeArguments.size(); ++i) {
                                sb.append("Sub");
                                BuilderClassWriter.printTypeVariable(sb, entity, (TypeVariable)typeArguments.get(i));
                                sb.append(", ");
                            }
                            sb.setCharAt(sb.length() - 2, '>');
                        }
                        sb.append(entity.builderImportType(memberBuilderFqn)).append(".Nested<");
                        for (i = 0; i < typeArguments.size(); ++i) {
                            sb.append("Sub");
                            sb.append(typeArguments.get(i));
                            sb.append(", ");
                        }
                        sb.append("? extends ").append(builderType).append("> with");
                        if (kind == ElementKind.PARAMETER) {
                            sb.append(PARAMETER_PREFIX);
                        }
                        sb.append(Character.toUpperCase(metaMember.getPropertyName().charAt(0)));
                        sb.append(metaMember.getPropertyName(), 1, metaMember.getPropertyName().length());
                        sb.append("Builder(int index) {").append(NEW_LINE).append("        return new ").append(entity.builderImportType(memberBuilderFqn)).append(".Nested<>(optionalParameters, ").append(listener).append(", (").append(builderType).append(") this);").append(NEW_LINE).append("    }");
                        sb.append(NEW_LINE);
                    }
                    listener = "new " + entity.builderImportType("com.blazebit.persistence.view.CollectionEntityViewBuilderListener") + "(getCollection(\"" + metaMember.getPropertyName() + "\"))";
                } else {
                    listener = "new " + entity.builderImportType("com.blazebit.persistence.view.SingularNameEntityViewBuilderListener") + "(this, \"" + metaMember.getPropertyName() + "\")";
                }
                sb.append(NEW_LINE);
                sb.append("    public ");
                if (!typeArguments.isEmpty()) {
                    sb.append("<");
                    for (i = 0; i < typeArguments.size(); ++i) {
                        sb.append("Sub");
                        BuilderClassWriter.printTypeVariable(sb, entity, (TypeVariable)typeArguments.get(i));
                        sb.append(", ");
                    }
                    sb.setCharAt(sb.length() - 2, '>');
                }
                sb.append(entity.builderImportType(memberBuilderFqn)).append(".Nested<");
                for (i = 0; i < typeArguments.size(); ++i) {
                    sb.append("Sub");
                    sb.append(typeArguments.get(i));
                    sb.append(", ");
                }
                sb.append("? extends ").append(builderType).append("> with");
                if (kind == ElementKind.PARAMETER) {
                    sb.append(PARAMETER_PREFIX);
                }
                sb.append(Character.toUpperCase(metaMember.getPropertyName().charAt(0)));
                sb.append(metaMember.getPropertyName(), 1, metaMember.getPropertyName().length());
                sb.append("Builder() {").append(NEW_LINE).append("    return new ").append(entity.builderImportType(memberBuilderFqn)).append(".Nested<>(optionalParameters, ").append(listener).append(", (").append(builderType).append(") this);").append(NEW_LINE).append("    }");
                sb.append(NEW_LINE);
            }
        }
        sb.append(NEW_LINE);
    }

    private static void appendUtilityMethods(StringBuilder sb, MetaEntityView entity, Context context) {
        String collectionType = entity.getSafeTypeVariable("CollectionType");
        String elementType = entity.getSafeTypeVariable("ElementType");
        String keyType = entity.getSafeTypeVariable("KeyType");
        sb.append(NEW_LINE);
        sb.append("    protected <").append(elementType).append("> ").append(elementType).append(" get(").append(entity.builderImportType("com.blazebit.persistence.view.metamodel.Attribute")).append("<?, ?> attr) {").append(NEW_LINE);
        sb.append("        if (attr instanceof ").append(entity.builderImportType("com.blazebit.persistence.view.metamodel.MethodAttribute")).append(") {").append(NEW_LINE);
        sb.append("            return get(((").append(entity.builderImportType("com.blazebit.persistence.view.metamodel.MethodAttribute")).append(") attr).getName());").append(NEW_LINE);
        sb.append("        } else {").append(NEW_LINE);
        sb.append("            return get(((").append(entity.builderImportType("com.blazebit.persistence.view.metamodel.ParameterAttribute")).append(") attr).getIndex());").append(NEW_LINE);
        sb.append("        }").append(NEW_LINE);
        sb.append("    }").append(NEW_LINE);
        sb.append(NEW_LINE);
        sb.append("    protected <").append(collectionType).append(" extends ").append(entity.builderImportType("java.util.Collection")).append("<Object>> ").append(collectionType).append(" getCollection(").append(entity.builderImportType("com.blazebit.persistence.view.metamodel.Attribute")).append("<?, ?> attr) {").append(NEW_LINE);
        sb.append("        if (attr instanceof ").append(entity.builderImportType("com.blazebit.persistence.view.metamodel.MethodAttribute")).append(") {").append(NEW_LINE);
        sb.append("            return getCollection(((").append(entity.builderImportType("com.blazebit.persistence.view.metamodel.MethodAttribute")).append(") attr).getName());").append(NEW_LINE);
        sb.append("        } else {").append(NEW_LINE);
        sb.append("            return getCollection(((").append(entity.builderImportType("com.blazebit.persistence.view.metamodel.ParameterAttribute")).append(") attr).getIndex());").append(NEW_LINE);
        sb.append("        }").append(NEW_LINE);
        sb.append("    }").append(NEW_LINE);
        sb.append(NEW_LINE);
        sb.append("    protected <").append(collectionType).append(" extends ").append(entity.builderImportType("java.util.Map")).append("<Object, Object>> ").append(collectionType).append(" getMap(").append(entity.builderImportType("com.blazebit.persistence.view.metamodel.Attribute")).append("<?, ?> attr) {").append(NEW_LINE);
        sb.append("        if (attr instanceof ").append(entity.builderImportType("com.blazebit.persistence.view.metamodel.MethodAttribute")).append(") {").append(NEW_LINE);
        sb.append("            return getMap(((").append(entity.builderImportType("com.blazebit.persistence.view.metamodel.MethodAttribute")).append(") attr).getName());").append(NEW_LINE);
        sb.append("        } else {").append(NEW_LINE);
        sb.append("            return getMap(((").append(entity.builderImportType("com.blazebit.persistence.view.metamodel.ParameterAttribute")).append(") attr).getIndex());").append(NEW_LINE);
        sb.append("        }").append(NEW_LINE);
        sb.append("    }").append(NEW_LINE);
        sb.append(NEW_LINE);
        sb.append("    protected <").append(collectionType).append(" extends ").append(entity.builderImportType("java.util.Collection")).append("<Object>> ").append(collectionType).append(" getCollection(String attr) {").append(NEW_LINE);
        sb.append("        Object currentValue = get(attr);").append(NEW_LINE);
        sb.append("        if (currentValue == null) {").append(NEW_LINE);
        sb.append("            with(attr, null);").append(NEW_LINE);
        sb.append("            currentValue = get(attr);").append(NEW_LINE);
        sb.append("        }").append(NEW_LINE);
        sb.append("        if (currentValue instanceof ").append(entity.builderImportType("com.blazebit.persistence.view.RecordingContainer")).append("<?>) {").append(NEW_LINE);
        sb.append("            return (").append(collectionType).append(") ((").append(entity.builderImportType("com.blazebit.persistence.view.RecordingContainer")).append("<?>) currentValue).getDelegate();").append(NEW_LINE);
        sb.append("        } else {").append(NEW_LINE);
        sb.append("            return (").append(collectionType).append(") currentValue;").append(NEW_LINE);
        sb.append("        }").append(NEW_LINE);
        sb.append("    }").append(NEW_LINE);
        sb.append(NEW_LINE);
        sb.append("    protected <").append(collectionType).append(" extends ").append(entity.builderImportType("java.util.Map")).append("<Object, Object>> ").append(collectionType).append(" getMap(String attr) {").append(NEW_LINE);
        sb.append("        Object currentValue = get(attr);").append(NEW_LINE);
        sb.append("        if (currentValue == null) {").append(NEW_LINE);
        sb.append("            with(attr, null);").append(NEW_LINE);
        sb.append("            currentValue = get(attr);").append(NEW_LINE);
        sb.append("        }").append(NEW_LINE);
        sb.append("        if (currentValue instanceof ").append(entity.builderImportType("com.blazebit.persistence.view.RecordingContainer")).append("<?>) {").append(NEW_LINE);
        sb.append("            return (").append(collectionType).append(") ((").append(entity.builderImportType("com.blazebit.persistence.view.RecordingContainer")).append("<?>) currentValue).getDelegate();").append(NEW_LINE);
        sb.append("        } else {").append(NEW_LINE);
        sb.append("            return (").append(collectionType).append(") currentValue;").append(NEW_LINE);
        sb.append("        }").append(NEW_LINE);
        sb.append("    }").append(NEW_LINE);
        sb.append(NEW_LINE);
        sb.append("    protected <").append(collectionType).append(" extends ").append(entity.builderImportType("java.util.Collection")).append("<Object>> ").append(collectionType).append(" getCollection(int attr) {").append(NEW_LINE);
        sb.append("        Object currentValue = get(attr);").append(NEW_LINE);
        sb.append("        if (currentValue == null) {").append(NEW_LINE);
        sb.append("            with(attr, null);").append(NEW_LINE);
        sb.append("            currentValue = get(attr);").append(NEW_LINE);
        sb.append("        }").append(NEW_LINE);
        sb.append("        if (currentValue instanceof ").append(entity.builderImportType("com.blazebit.persistence.view.RecordingContainer")).append("<?>) {").append(NEW_LINE);
        sb.append("            return (").append(collectionType).append(") ((").append(entity.builderImportType("com.blazebit.persistence.view.RecordingContainer")).append("<?>) currentValue).getDelegate();").append(NEW_LINE);
        sb.append("        } else {").append(NEW_LINE);
        sb.append("            return (").append(collectionType).append(") currentValue;").append(NEW_LINE);
        sb.append("        }").append(NEW_LINE);
        sb.append("    }").append(NEW_LINE);
        sb.append(NEW_LINE);
        sb.append("    protected <").append(collectionType).append(" extends ").append(entity.builderImportType("java.util.Map")).append("<Object, Object>> ").append(collectionType).append(" getMap(int attr) {").append(NEW_LINE);
        sb.append("        Object currentValue = get(attr);").append(NEW_LINE);
        sb.append("        if (currentValue == null) {").append(NEW_LINE);
        sb.append("            with(attr, null);").append(NEW_LINE);
        sb.append("            currentValue = get(attr);").append(NEW_LINE);
        sb.append("        }").append(NEW_LINE);
        sb.append("        if (currentValue instanceof ").append(entity.builderImportType("com.blazebit.persistence.view.RecordingContainer")).append("<?>) {").append(NEW_LINE);
        sb.append("            return (").append(collectionType).append(") ((").append(entity.builderImportType("com.blazebit.persistence.view.RecordingContainer")).append("<?>) currentValue).getDelegate();").append(NEW_LINE);
        sb.append("        } else {").append(NEW_LINE);
        sb.append("            return (").append(collectionType).append(") currentValue;").append(NEW_LINE);
        sb.append("        }").append(NEW_LINE);
        sb.append("    }").append(NEW_LINE);
        sb.append(NEW_LINE);
        sb.append("    protected void addListValue(").append(entity.builderImportType("java.util.List")).append("<Object> list, int index, Object value) {").append(NEW_LINE);
        sb.append("        if (index > list.size()) {").append(NEW_LINE);
        sb.append("            for (int i = list.size(); i < index; i++) {").append(NEW_LINE);
        sb.append("                list.add(null);").append(NEW_LINE);
        sb.append("            }").append(NEW_LINE);
        sb.append("            list.add(value);").append(NEW_LINE);
        sb.append("        } else if (index < list.size()) {").append(NEW_LINE);
        sb.append("            list.set(index, value);").append(NEW_LINE);
        sb.append("        } else {").append(NEW_LINE);
        sb.append("            list.add(value);").append(NEW_LINE);
        sb.append("        }").append(NEW_LINE);
        sb.append("    }").append(NEW_LINE);
    }

    private static void appendGetMethods(StringBuilder sb, MetaEntityView entity, Context context) {
        Collection<MetaAttribute> members = entity.getMembers();
        String collectionType = entity.getSafeTypeVariable("CollectionType");
        String elementType = entity.getSafeTypeVariable("ElementType");
        String keyType = entity.getSafeTypeVariable("KeyType");
        sb.append(NEW_LINE);
        sb.append("    @Override").append(NEW_LINE);
        sb.append("    public <").append(elementType).append("> ").append(elementType).append(" get(String attribute) {").append(NEW_LINE);
        sb.append("        switch (attribute) {").append(NEW_LINE);
        for (MetaAttribute metaMember : members) {
            sb.append("            case \"").append(metaMember.getPropertyName()).append("\":").append(NEW_LINE);
            sb.append("                return (").append(elementType).append(") (Object) this.").append(metaMember.getPropertyName()).append(";").append(NEW_LINE);
        }
        sb.append("        }").append(NEW_LINE);
        sb.append("        throw new IllegalArgumentException(\"Unknown attribute: \" + attribute);").append(NEW_LINE);
        sb.append("    }").append(NEW_LINE);
        sb.append(NEW_LINE);
        sb.append("    @Override").append(NEW_LINE);
        sb.append("    public <").append(elementType).append("> ").append(elementType).append(" get(").append(entity.builderImportType("com.blazebit.persistence.view.metamodel.SingularAttribute")).append("<").append(entity.builderImportType(entity.getQualifiedName())).append(", ").append(elementType).append("> attribute) {").append(NEW_LINE);
        sb.append("        return get((").append(entity.builderImportType("com.blazebit.persistence.view.metamodel.Attribute")).append("<?, ?>) attribute);").append(NEW_LINE);
        sb.append("    }").append(NEW_LINE);
        sb.append(NEW_LINE);
        sb.append("    @Override").append(NEW_LINE);
        sb.append("    public <").append(collectionType).append("> ").append(collectionType).append(" get(").append(entity.builderImportType("com.blazebit.persistence.view.metamodel.PluralAttribute")).append("<").append(entity.builderImportType(entity.getQualifiedName())).append(", ").append(collectionType).append(", ?> attribute) {").append(NEW_LINE);
        sb.append("        return get((").append(entity.builderImportType("com.blazebit.persistence.view.metamodel.Attribute")).append("<?, ?>) attribute);").append(NEW_LINE);
        sb.append("    }").append(NEW_LINE);
    }

    private static void appendWithMethods(StringBuilder sb, MetaEntityView entity, String builderType, Context context) {
        String builderTypeCast = "(" + builderType + ") ";
        Collection<MetaAttribute> members = entity.getMembers();
        String collectionType = entity.getSafeTypeVariable("CollectionType");
        String elementType = entity.getSafeTypeVariable("ElementType");
        String keyType = entity.getSafeTypeVariable("KeyType");
        sb.append(NEW_LINE);
        sb.append("    @Override").append(NEW_LINE);
        sb.append("    public ").append(builderType).append(" with(String attribute, Object value) {").append(NEW_LINE);
        sb.append("        switch (attribute) {").append(NEW_LINE);
        for (MetaAttribute metaMember : members) {
            sb.append("            case \"").append(metaMember.getPropertyName()).append("\":").append(NEW_LINE);
            sb.append("                this.").append(metaMember.getPropertyName()).append(" = ");
            sb.append("value == null ? ");
            metaMember.appendDefaultValue(sb, true, true, entity.getBuilderImportContext());
            sb.append(" : ");
            sb.append("(").append(metaMember.getBuilderImplementationTypeString()).append(") value;").append(NEW_LINE);
            sb.append("                break;").append(NEW_LINE);
        }
        sb.append("            default:").append(NEW_LINE);
        sb.append("                throw new IllegalArgumentException(\"Unknown attribute: \" + attribute);").append(NEW_LINE);
        sb.append("        }").append(NEW_LINE);
        if (!members.isEmpty()) {
            sb.append("        return ").append(builderTypeCast).append("this;").append(NEW_LINE);
        }
        sb.append("    }").append(NEW_LINE);
        sb.append(NEW_LINE);
        sb.append("    @Override").append(NEW_LINE);
        sb.append("    public <").append(elementType).append("> ").append(builderType).append(" with(").append(entity.builderImportType("com.blazebit.persistence.view.metamodel.SingularAttribute")).append("<").append(entity.builderImportType(entity.getQualifiedName())).append(", ").append(elementType).append("> attribute, ").append(elementType).append(" value) {").append(NEW_LINE);
        sb.append("        if (attribute instanceof ").append(entity.builderImportType("com.blazebit.persistence.view.metamodel.MethodAttribute")).append(") {").append(NEW_LINE);
        sb.append("            return with(((").append(entity.builderImportType("com.blazebit.persistence.view.metamodel.MethodAttribute")).append(") attribute).getName(), value);").append(NEW_LINE);
        sb.append("        } else {").append(NEW_LINE);
        sb.append("            return with(((").append(entity.builderImportType("com.blazebit.persistence.view.metamodel.ParameterAttribute")).append(") attribute).getIndex(), value);").append(NEW_LINE);
        sb.append("        }").append(NEW_LINE);
        sb.append("    }").append(NEW_LINE);
        sb.append(NEW_LINE);
        sb.append("    @Override").append(NEW_LINE);
        sb.append("    public <").append(collectionType).append("> ").append(builderType).append(" with(").append(entity.builderImportType("com.blazebit.persistence.view.metamodel.PluralAttribute")).append("<").append(entity.builderImportType(entity.getQualifiedName())).append(", ").append(collectionType).append(", ?> attribute, ").append(collectionType).append(" value) {").append(NEW_LINE);
        sb.append("        if (attribute instanceof ").append(entity.builderImportType("com.blazebit.persistence.view.metamodel.MethodAttribute")).append(") {").append(NEW_LINE);
        sb.append("            return with(((").append(entity.builderImportType("com.blazebit.persistence.view.metamodel.MethodAttribute")).append(") attribute).getName(), value);").append(NEW_LINE);
        sb.append("        } else {").append(NEW_LINE);
        sb.append("            return with(((").append(entity.builderImportType("com.blazebit.persistence.view.metamodel.ParameterAttribute")).append(") attribute).getIndex(), value);").append(NEW_LINE);
        sb.append("        }").append(NEW_LINE);
        sb.append("    }").append(NEW_LINE);
        sb.append(NEW_LINE);
        sb.append("    @Override").append(NEW_LINE);
        sb.append("    public ").append(builderType).append(" withElement(String attribute, Object value) {").append(NEW_LINE);
        sb.append("        getCollection(attribute).add(value);").append(NEW_LINE);
        sb.append("        return ").append(builderTypeCast).append("this;").append(NEW_LINE);
        sb.append("    }").append(NEW_LINE);
        sb.append(NEW_LINE);
        sb.append("    @Override").append(NEW_LINE);
        sb.append("    public ").append(builderType).append(" withElement(int parameterIndex, Object value) {").append(NEW_LINE);
        sb.append("        getCollection(parameterIndex).add(value);").append(NEW_LINE);
        sb.append("        return ").append(builderTypeCast).append("this;").append(NEW_LINE);
        sb.append("    }").append(NEW_LINE);
        sb.append(NEW_LINE);
        sb.append("    @Override").append(NEW_LINE);
        sb.append("    public ").append(builderType).append(" withListElement(String attribute, int index, Object value) {").append(NEW_LINE);
        sb.append("        List<Object> list = getCollection(attribute);").append(NEW_LINE);
        sb.append("        addListValue(list, index, value);").append(NEW_LINE);
        sb.append("        return ").append(builderTypeCast).append("this;").append(NEW_LINE);
        sb.append("    }").append(NEW_LINE);
        sb.append(NEW_LINE);
        sb.append("    @Override").append(NEW_LINE);
        sb.append("    public ").append(builderType).append(" withListElement(int parameterIndex, int index, Object value) {").append(NEW_LINE);
        sb.append("        List<Object> list = getCollection(parameterIndex);").append(NEW_LINE);
        sb.append("        addListValue(list, index, value);").append(NEW_LINE);
        sb.append("        return ").append(builderTypeCast).append("this;").append(NEW_LINE);
        sb.append("    }").append(NEW_LINE);
        sb.append(NEW_LINE);
        sb.append("    @Override").append(NEW_LINE);
        sb.append("    public ").append(builderType).append(" withEntry(String attribute, Object key, Object value) {").append(NEW_LINE);
        sb.append("        Map<Object, Object> map = getMap(attribute);").append(NEW_LINE);
        sb.append("        map.put(key, value);").append(NEW_LINE);
        sb.append("        return ").append(builderTypeCast).append("this;").append(NEW_LINE);
        sb.append("    }").append(NEW_LINE);
        sb.append(NEW_LINE);
        sb.append("    @Override").append(NEW_LINE);
        sb.append("    public ").append(builderType).append(" withEntry(int parameterIndex, Object key, Object value) {").append(NEW_LINE);
        sb.append("        Map<Object, Object> map = getMap(parameterIndex);").append(NEW_LINE);
        sb.append("        map.put(key, value);").append(NEW_LINE);
        sb.append("        return ").append(builderTypeCast).append("this;").append(NEW_LINE);
        sb.append("    }").append(NEW_LINE);
        sb.append(NEW_LINE);
        sb.append("    @Override").append(NEW_LINE);
        sb.append("    public <").append(elementType).append("> ").append(builderType).append(" withElement(").append(entity.builderImportType("com.blazebit.persistence.view.metamodel.CollectionAttribute")).append("<").append(entity.builderImportType(entity.getQualifiedName())).append(", ").append(elementType).append("> attribute, ").append(elementType).append(" value) {").append(NEW_LINE);
        sb.append("        getCollection(attribute).add(value);").append(NEW_LINE);
        sb.append("        return ").append(builderTypeCast).append("this;").append(NEW_LINE);
        sb.append("    }").append(NEW_LINE);
        sb.append(NEW_LINE);
        sb.append("    @Override").append(NEW_LINE);
        sb.append("    public <").append(elementType).append("> ").append(builderType).append(" withElement(").append(entity.builderImportType("com.blazebit.persistence.view.metamodel.SetAttribute")).append("<").append(entity.builderImportType(entity.getQualifiedName())).append(", ").append(elementType).append("> attribute, ").append(elementType).append(" value) {").append(NEW_LINE);
        sb.append("        getCollection(attribute).add(value);").append(NEW_LINE);
        sb.append("        return ").append(builderTypeCast).append("this;").append(NEW_LINE);
        sb.append("    }").append(NEW_LINE);
        sb.append(NEW_LINE);
        sb.append("    @Override").append(NEW_LINE);
        sb.append("    public <").append(elementType).append("> ").append(builderType).append(" withElement(").append(entity.builderImportType("com.blazebit.persistence.view.metamodel.ListAttribute")).append("<").append(entity.builderImportType(entity.getQualifiedName())).append(", ").append(elementType).append("> attribute, ").append(elementType).append(" value) {").append(NEW_LINE);
        sb.append("        getCollection(attribute).add(value);").append(NEW_LINE);
        sb.append("        return ").append(builderTypeCast).append("this;").append(NEW_LINE);
        sb.append("    }").append(NEW_LINE);
        sb.append(NEW_LINE);
        sb.append("    @Override").append(NEW_LINE);
        sb.append("    public <").append(elementType).append("> ").append(builderType).append(" withListElement(").append(entity.builderImportType("com.blazebit.persistence.view.metamodel.ListAttribute")).append("<").append(entity.builderImportType(entity.getQualifiedName())).append(", ").append(elementType).append("> attribute, int index, ").append(elementType).append(" value) {").append(NEW_LINE);
        sb.append("        List<Object> list = getCollection(attribute);").append(NEW_LINE);
        sb.append("        addListValue(list, index, value);").append(NEW_LINE);
        sb.append("        return ").append(builderTypeCast).append("this;").append(NEW_LINE);
        sb.append("    }").append(NEW_LINE);
        sb.append(NEW_LINE);
        sb.append("    @Override").append(NEW_LINE);
        sb.append("    public <").append(keyType).append(", ").append(elementType).append("> ").append(builderType).append(" withEntry(").append(entity.builderImportType("com.blazebit.persistence.view.metamodel.MapAttribute")).append("<").append(entity.builderImportType(entity.getQualifiedName())).append(", ").append(keyType).append(", ").append(elementType).append("> attribute, ").append(keyType).append(" key, ").append(elementType).append(" value) {").append(NEW_LINE);
        sb.append("        Map<Object, Object> map = getMap(attribute);").append(NEW_LINE);
        sb.append("        map.put(key, value);").append(NEW_LINE);
        sb.append("        return ").append(builderTypeCast).append("this;").append(NEW_LINE);
        sb.append("    }").append(NEW_LINE);
    }

    private static void appendWithBuilderMethods(StringBuilder sb, MetaEntityView entity, String builderType, Context context) {
        Collection<MetaAttribute> members = entity.getMembers();
        String collectionType = entity.getSafeTypeVariable("CollectionType");
        String elementType = entity.getSafeTypeVariable("ElementType");
        String keyType = entity.getSafeTypeVariable("KeyType");
        sb.append(NEW_LINE);
        sb.append("    @Override").append(NEW_LINE);
        sb.append("    public <").append(elementType).append("> ").append(entity.builderImportType("com.blazebit.persistence.view.EntityViewNestedBuilder")).append("<").append(elementType).append(", ? extends ").append(builderType).append(", ?> withSingularBuilder(String attribute) {").append(NEW_LINE);
        sb.append("        switch (attribute) {").append(NEW_LINE);
        for (MetaAttribute metaMember : members) {
            if (!(metaMember instanceof AnnotationMetaSingularAttribute) || !metaMember.isSubview()) continue;
            sb.append("            case \"").append(metaMember.getPropertyName()).append("\":").append(NEW_LINE);
            sb.append("                return (").append(entity.builderImportType("com.blazebit.persistence.view.EntityViewNestedBuilder")).append("<").append(elementType).append(", ? extends ").append(builderType).append(", ?>) (").append(entity.builderImportType("com.blazebit.persistence.view.EntityViewNestedBuilder")).append("<?, ?, ?>) with");
            sb.append(Character.toUpperCase(metaMember.getPropertyName().charAt(0)));
            sb.append(metaMember.getPropertyName(), 1, metaMember.getPropertyName().length()).append("Builder();").append(NEW_LINE);
        }
        sb.append("        }").append(NEW_LINE);
        sb.append("        throw new IllegalArgumentException(\"Unknown attribute: \" + attribute);").append(NEW_LINE);
        sb.append("    }").append(NEW_LINE);
        sb.append(NEW_LINE);
        sb.append("    @Override").append(NEW_LINE);
        sb.append("    public <").append(elementType).append("> ").append(entity.builderImportType("com.blazebit.persistence.view.EntityViewNestedBuilder")).append("<").append(elementType).append(", ? extends ").append(builderType).append(", ?> withCollectionBuilder(String attribute) {").append(NEW_LINE);
        sb.append("        switch (attribute) {").append(NEW_LINE);
        for (MetaAttribute metaMember : members) {
            if (!(metaMember instanceof AnnotationMetaCollection) || metaMember instanceof AnnotationMetaMap || !metaMember.isSubview()) continue;
            sb.append("            case \"").append(metaMember.getPropertyName()).append("\":").append(NEW_LINE);
            sb.append("                return (").append(entity.builderImportType("com.blazebit.persistence.view.EntityViewNestedBuilder")).append("<").append(elementType).append(", ? extends ").append(builderType).append(", ?>) (").append(entity.builderImportType("com.blazebit.persistence.view.EntityViewNestedBuilder")).append("<?, ?, ?>) with");
            sb.append(Character.toUpperCase(metaMember.getPropertyName().charAt(0)));
            sb.append(metaMember.getPropertyName(), 1, metaMember.getPropertyName().length()).append("Builder();").append(NEW_LINE);
        }
        sb.append("        }").append(NEW_LINE);
        sb.append("        throw new IllegalArgumentException(\"Unknown attribute: \" + attribute);").append(NEW_LINE);
        sb.append("    }").append(NEW_LINE);
        sb.append(NEW_LINE);
        sb.append("    @Override").append(NEW_LINE);
        sb.append("    public <").append(elementType).append("> ").append(entity.builderImportType("com.blazebit.persistence.view.EntityViewNestedBuilder")).append("<").append(elementType).append(", ? extends ").append(builderType).append(", ?> withListBuilder(String attribute) {").append(NEW_LINE);
        sb.append("        switch (attribute) {").append(NEW_LINE);
        for (MetaAttribute metaMember : members) {
            if (!(metaMember instanceof AnnotationMetaCollection) || metaMember instanceof AnnotationMetaMap || !metaMember.isSubview()) continue;
            sb.append("            case \"").append(metaMember.getPropertyName()).append("\":").append(NEW_LINE);
            sb.append("                return (").append(entity.builderImportType("com.blazebit.persistence.view.EntityViewNestedBuilder")).append("<").append(elementType).append(", ? extends ").append(builderType).append(", ?>) (").append(entity.builderImportType("com.blazebit.persistence.view.EntityViewNestedBuilder")).append("<?, ?, ?>) with");
            sb.append(Character.toUpperCase(metaMember.getPropertyName().charAt(0)));
            sb.append(metaMember.getPropertyName(), 1, metaMember.getPropertyName().length()).append("Builder();").append(NEW_LINE);
        }
        sb.append("        }").append(NEW_LINE);
        sb.append("        throw new IllegalArgumentException(\"Unknown attribute: \" + attribute);").append(NEW_LINE);
        sb.append("    }").append(NEW_LINE);
        sb.append(NEW_LINE);
        sb.append("    @Override").append(NEW_LINE);
        sb.append("    public <").append(elementType).append("> ").append(entity.builderImportType("com.blazebit.persistence.view.EntityViewNestedBuilder")).append("<").append(elementType).append(", ? extends ").append(builderType).append(", ?> withListBuilder(String attribute, int index) {").append(NEW_LINE);
        sb.append("        switch (attribute) {").append(NEW_LINE);
        for (MetaAttribute metaMember : members) {
            if (!(metaMember instanceof AnnotationMetaCollection) || !((AnnotationMetaCollection)metaMember).isIndexedList() || !metaMember.isSubview()) continue;
            sb.append("            case \"").append(metaMember.getPropertyName()).append("\":").append(NEW_LINE);
            sb.append("                return (").append(entity.builderImportType("com.blazebit.persistence.view.EntityViewNestedBuilder")).append("<").append(elementType).append(", ? extends ").append(builderType).append(", ?>) (").append(entity.builderImportType("com.blazebit.persistence.view.EntityViewNestedBuilder")).append("<?, ?, ?>) with");
            sb.append(Character.toUpperCase(metaMember.getPropertyName().charAt(0)));
            sb.append(metaMember.getPropertyName(), 1, metaMember.getPropertyName().length()).append("Builder(index);").append(NEW_LINE);
        }
        sb.append("        }").append(NEW_LINE);
        sb.append("        throw new IllegalArgumentException(\"Unknown attribute: \" + attribute);").append(NEW_LINE);
        sb.append("    }").append(NEW_LINE);
        sb.append(NEW_LINE);
        sb.append("    @Override").append(NEW_LINE);
        sb.append("    public <").append(elementType).append("> ").append(entity.builderImportType("com.blazebit.persistence.view.EntityViewNestedBuilder")).append("<").append(elementType).append(", ? extends ").append(builderType).append(", ?> withSetBuilder(String attribute) {").append(NEW_LINE);
        sb.append("        switch (attribute) {").append(NEW_LINE);
        for (MetaAttribute metaMember : members) {
            if (!(metaMember instanceof AnnotationMetaCollection) || metaMember instanceof AnnotationMetaMap || !metaMember.isSubview()) continue;
            sb.append("            case \"").append(metaMember.getPropertyName()).append("\":").append(NEW_LINE);
            sb.append("                return (").append(entity.builderImportType("com.blazebit.persistence.view.EntityViewNestedBuilder")).append("<").append(elementType).append(", ? extends ").append(builderType).append(", ?>) (").append(entity.builderImportType("com.blazebit.persistence.view.EntityViewNestedBuilder")).append("<?, ?, ?>) with");
            sb.append(Character.toUpperCase(metaMember.getPropertyName().charAt(0)));
            sb.append(metaMember.getPropertyName(), 1, metaMember.getPropertyName().length()).append("Builder();").append(NEW_LINE);
        }
        sb.append("        }").append(NEW_LINE);
        sb.append("        throw new IllegalArgumentException(\"Unknown attribute: \" + attribute);").append(NEW_LINE);
        sb.append("    }").append(NEW_LINE);
        sb.append(NEW_LINE);
        sb.append("    @Override").append(NEW_LINE);
        sb.append("    public <").append(elementType).append("> ").append(entity.builderImportType("com.blazebit.persistence.view.EntityViewNestedBuilder")).append("<").append(elementType).append(", ? extends ").append(builderType).append(", ?> withMapBuilder(String attribute, Object key) {").append(NEW_LINE);
        sb.append("        switch (attribute) {").append(NEW_LINE);
        for (MetaAttribute metaMember : members) {
            if (!(metaMember instanceof AnnotationMetaMap) || !metaMember.isSubview()) continue;
            sb.append("            case \"").append(metaMember.getPropertyName()).append("\":").append(NEW_LINE);
            sb.append("                return (").append(entity.builderImportType("com.blazebit.persistence.view.EntityViewNestedBuilder")).append("<").append(elementType).append(", ? extends ").append(builderType).append(", ?>) (").append(entity.builderImportType("com.blazebit.persistence.view.EntityViewNestedBuilder")).append("<?, ?, ?>) with");
            sb.append(Character.toUpperCase(metaMember.getPropertyName().charAt(0)));
            sb.append(metaMember.getPropertyName(), 1, metaMember.getPropertyName().length()).append("Builder(key);").append(NEW_LINE);
        }
        sb.append("        }").append(NEW_LINE);
        sb.append("        throw new IllegalArgumentException(\"Unknown attribute: \" + attribute);").append(NEW_LINE);
        sb.append("    }").append(NEW_LINE);
        sb.append(NEW_LINE);
        sb.append("    @Override").append(NEW_LINE);
        sb.append("    public <").append(keyType).append(", ").append(elementType).append("> ").append(entity.builderImportType("com.blazebit.persistence.view.EntityViewNestedBuilder")).append("<").append(keyType).append(", ? extends ").append(entity.builderImportType("com.blazebit.persistence.view.EntityViewNestedBuilder")).append("<").append(elementType).append(", ? extends ").append(builderType).append(", ?>, ?> withMapBuilder(String attribute) {").append(NEW_LINE);
        sb.append("        switch (attribute) {").append(NEW_LINE);
        for (MetaAttribute metaMember : members) {
            if (!(metaMember instanceof AnnotationMetaMap) || !((AnnotationMetaMap)metaMember).isKeySubview() || !metaMember.isSubview()) continue;
            sb.append("            case \"").append(metaMember.getPropertyName()).append("\":").append(NEW_LINE);
            sb.append("                return (").append(entity.builderImportType("com.blazebit.persistence.view.EntityViewNestedBuilder")).append("<").append(keyType).append(", ? extends ").append(entity.builderImportType("com.blazebit.persistence.view.EntityViewNestedBuilder")).append("<").append(elementType).append(", ? extends ").append(builderType).append(", ?>, ?>) (").append(entity.builderImportType("com.blazebit.persistence.view.EntityViewNestedBuilder")).append("<?, ?, ?>) with");
            sb.append(Character.toUpperCase(metaMember.getPropertyName().charAt(0)));
            sb.append(metaMember.getPropertyName(), 1, metaMember.getPropertyName().length()).append("Builder();").append(NEW_LINE);
        }
        sb.append("        }").append(NEW_LINE);
        sb.append("        throw new IllegalArgumentException(\"Unknown attribute: \" + attribute);").append(NEW_LINE);
        sb.append("    }").append(NEW_LINE);
        sb.append(NEW_LINE);
        sb.append("    @Override").append(NEW_LINE);
        sb.append("    public <").append(elementType).append("> ").append(entity.builderImportType("com.blazebit.persistence.view.EntityViewNestedBuilder")).append("<").append(elementType).append(", ? extends ").append(builderType).append(", ?> withBuilder(").append(entity.builderImportType("com.blazebit.persistence.view.metamodel.SingularAttribute"));
        sb.append("<").append(entity.builderImportType(entity.getQualifiedName())).append(", ").append(elementType).append("> attr) {").append(NEW_LINE);
        sb.append("        if (attr instanceof ").append(entity.builderImportType("com.blazebit.persistence.view.metamodel.MethodAttribute")).append(") {").append(NEW_LINE);
        sb.append("            return withSingularBuilder(((").append(entity.builderImportType("com.blazebit.persistence.view.metamodel.MethodAttribute")).append(") attr).getName());").append(NEW_LINE);
        sb.append("        } else {").append(NEW_LINE);
        sb.append("            return withSingularBuilder(((").append(entity.builderImportType("com.blazebit.persistence.view.metamodel.ParameterAttribute")).append(") attr).getIndex());").append(NEW_LINE);
        sb.append("        }").append(NEW_LINE);
        sb.append("    }").append(NEW_LINE);
        sb.append(NEW_LINE);
        sb.append("    @Override").append(NEW_LINE);
        sb.append("    public <").append(elementType).append("> ").append(entity.builderImportType("com.blazebit.persistence.view.EntityViewNestedBuilder")).append("<").append(elementType).append(", ? extends ").append(builderType).append(", ?> withBuilder(").append(entity.builderImportType("com.blazebit.persistence.view.metamodel.CollectionAttribute"));
        sb.append("<").append(entity.builderImportType(entity.getQualifiedName())).append(", ").append(elementType).append("> attr) {").append(NEW_LINE);
        sb.append("        if (attr instanceof ").append(entity.builderImportType("com.blazebit.persistence.view.metamodel.MethodAttribute")).append(") {").append(NEW_LINE);
        sb.append("            return withCollectionBuilder(((").append(entity.builderImportType("com.blazebit.persistence.view.metamodel.MethodAttribute")).append(") attr).getName());").append(NEW_LINE);
        sb.append("        } else {").append(NEW_LINE);
        sb.append("            return withCollectionBuilder(((").append(entity.builderImportType("com.blazebit.persistence.view.metamodel.ParameterAttribute")).append(") attr).getIndex());").append(NEW_LINE);
        sb.append("        }").append(NEW_LINE);
        sb.append("    }").append(NEW_LINE);
        sb.append(NEW_LINE);
        sb.append("    @Override").append(NEW_LINE);
        sb.append("    public <").append(elementType).append("> ").append(entity.builderImportType("com.blazebit.persistence.view.EntityViewNestedBuilder")).append("<").append(elementType).append(", ? extends ").append(builderType).append(", ?> withBuilder(").append(entity.builderImportType("com.blazebit.persistence.view.metamodel.ListAttribute"));
        sb.append("<").append(entity.builderImportType(entity.getQualifiedName())).append(", ").append(elementType).append("> attr) {").append(NEW_LINE);
        sb.append("        if (attr instanceof ").append(entity.builderImportType("com.blazebit.persistence.view.metamodel.MethodAttribute")).append(") {").append(NEW_LINE);
        sb.append("            return withListBuilder(((").append(entity.builderImportType("com.blazebit.persistence.view.metamodel.MethodAttribute")).append(") attr).getName());").append(NEW_LINE);
        sb.append("        } else {").append(NEW_LINE);
        sb.append("            return withListBuilder(((").append(entity.builderImportType("com.blazebit.persistence.view.metamodel.ParameterAttribute")).append(") attr).getIndex());").append(NEW_LINE);
        sb.append("        }").append(NEW_LINE);
        sb.append("    }").append(NEW_LINE);
        sb.append(NEW_LINE);
        sb.append("    @Override").append(NEW_LINE);
        sb.append("    public <").append(elementType).append("> ").append(entity.builderImportType("com.blazebit.persistence.view.EntityViewNestedBuilder")).append("<").append(elementType).append(", ? extends ").append(builderType).append(", ?> withBuilder(").append(entity.builderImportType("com.blazebit.persistence.view.metamodel.ListAttribute"));
        sb.append("<").append(entity.builderImportType(entity.getQualifiedName())).append(", ").append(elementType).append("> attr, int index) {").append(NEW_LINE);
        sb.append("        if (attr instanceof ").append(entity.builderImportType("com.blazebit.persistence.view.metamodel.MethodAttribute")).append(") {").append(NEW_LINE);
        sb.append("            return withListBuilder(((").append(entity.builderImportType("com.blazebit.persistence.view.metamodel.MethodAttribute")).append(") attr).getName(), index);").append(NEW_LINE);
        sb.append("        } else {").append(NEW_LINE);
        sb.append("            return withListBuilder(((").append(entity.builderImportType("com.blazebit.persistence.view.metamodel.ParameterAttribute")).append(") attr).getIndex(), index);").append(NEW_LINE);
        sb.append("        }").append(NEW_LINE);
        sb.append("    }").append(NEW_LINE);
        sb.append(NEW_LINE);
        sb.append("    @Override").append(NEW_LINE);
        sb.append("    public <").append(elementType).append("> ").append(entity.builderImportType("com.blazebit.persistence.view.EntityViewNestedBuilder")).append("<").append(elementType).append(", ? extends ").append(builderType).append(", ?> withBuilder(").append(entity.builderImportType("com.blazebit.persistence.view.metamodel.SetAttribute"));
        sb.append("<").append(entity.builderImportType(entity.getQualifiedName())).append(", ").append(elementType).append("> attr) {").append(NEW_LINE);
        sb.append("        if (attr instanceof ").append(entity.builderImportType("com.blazebit.persistence.view.metamodel.MethodAttribute")).append(") {").append(NEW_LINE);
        sb.append("            return withSetBuilder(((").append(entity.builderImportType("com.blazebit.persistence.view.metamodel.MethodAttribute")).append(") attr).getName());").append(NEW_LINE);
        sb.append("        } else {").append(NEW_LINE);
        sb.append("            return withSetBuilder(((").append(entity.builderImportType("com.blazebit.persistence.view.metamodel.ParameterAttribute")).append(") attr).getIndex());").append(NEW_LINE);
        sb.append("        }").append(NEW_LINE);
        sb.append("    }").append(NEW_LINE);
        sb.append(NEW_LINE);
        sb.append("    @Override").append(NEW_LINE);
        sb.append("    public <").append(keyType).append(", ").append(elementType).append("> ").append(entity.builderImportType("com.blazebit.persistence.view.EntityViewNestedBuilder")).append("<").append(elementType).append(", ? extends ").append(builderType).append(", ?> withBuilder(").append(entity.builderImportType("com.blazebit.persistence.view.metamodel.MapAttribute"));
        sb.append("<").append(entity.builderImportType(entity.getQualifiedName())).append(", ").append(keyType).append(", ").append(elementType).append("> attr, ").append(keyType).append(" key) {").append(NEW_LINE);
        sb.append("        if (attr instanceof ").append(entity.builderImportType("com.blazebit.persistence.view.metamodel.MethodAttribute")).append(") {").append(NEW_LINE);
        sb.append("            return withMapBuilder(((").append(entity.builderImportType("com.blazebit.persistence.view.metamodel.MethodAttribute")).append(") attr).getName(), key);").append(NEW_LINE);
        sb.append("        } else {").append(NEW_LINE);
        sb.append("            return withMapBuilder(((").append(entity.builderImportType("com.blazebit.persistence.view.metamodel.ParameterAttribute")).append(") attr).getIndex(), key);").append(NEW_LINE);
        sb.append("        }").append(NEW_LINE);
        sb.append("    }").append(NEW_LINE);
        sb.append(NEW_LINE);
        sb.append("    @Override").append(NEW_LINE);
        sb.append("    public <").append(keyType).append(", ").append(elementType).append("> ").append(entity.builderImportType("com.blazebit.persistence.view.EntityViewNestedBuilder")).append("<").append(keyType).append(", ? extends ").append(entity.builderImportType("com.blazebit.persistence.view.EntityViewNestedBuilder")).append("<").append(elementType).append(", ? extends ").append(builderType).append(", ?>, ?> withBuilder(");
        sb.append(entity.builderImportType("com.blazebit.persistence.view.metamodel.MapAttribute")).append("<").append(entity.builderImportType(entity.getQualifiedName())).append(", ").append(keyType).append(", ").append(elementType).append("> attr) {").append(NEW_LINE);
        sb.append("        if (attr instanceof ").append(entity.builderImportType("com.blazebit.persistence.view.metamodel.MethodAttribute")).append(") {").append(NEW_LINE);
        sb.append("            return withMapBuilder(((").append(entity.builderImportType("com.blazebit.persistence.view.metamodel.MethodAttribute")).append(") attr).getName());").append(NEW_LINE);
        sb.append("        } else {").append(NEW_LINE);
        sb.append("            return withMapBuilder(((").append(entity.builderImportType("com.blazebit.persistence.view.metamodel.ParameterAttribute")).append(") attr).getIndex());").append(NEW_LINE);
        sb.append("        }").append(NEW_LINE);
        sb.append("    }").append(NEW_LINE);
    }

    private static void appendWithBuilderMethods(StringBuilder sb, MetaConstructor constructor, Context context, String builderType) {
        MetaAttribute metaMember;
        int i;
        String collectionType = constructor.getHostingEntity().getSafeTypeVariable("CollectionType");
        String elementType = constructor.getHostingEntity().getSafeTypeVariable("ElementType");
        String keyType = constructor.getHostingEntity().getSafeTypeVariable("KeyType");
        MetaEntityView entity = constructor.getHostingEntity();
        List<MetaAttribute> members = constructor.getParameters();
        sb.append(NEW_LINE);
        sb.append("    @Override").append(NEW_LINE);
        sb.append("    public <").append(elementType).append("> ").append(entity.builderImportType("com.blazebit.persistence.view.EntityViewNestedBuilder")).append("<").append(elementType).append(", ? extends ").append(builderType).append(", ?> withSingularBuilder(int parameterIndex) {").append(NEW_LINE);
        sb.append("        switch (parameterIndex) {").append(NEW_LINE);
        for (i = 0; i < members.size(); ++i) {
            metaMember = members.get(i);
            if (!(metaMember instanceof AnnotationMetaSingularAttribute) || !metaMember.isSubview()) continue;
            sb.append("            case ").append(i).append(":").append(NEW_LINE);
            sb.append("                return (").append(entity.builderImportType("com.blazebit.persistence.view.EntityViewNestedBuilder")).append("<").append(elementType).append(", ? extends ").append(builderType).append(", ?>) with").append(PARAMETER_PREFIX);
            sb.append(Character.toUpperCase(metaMember.getPropertyName().charAt(0)));
            sb.append(metaMember.getPropertyName(), 1, metaMember.getPropertyName().length()).append("Builder();").append(NEW_LINE);
        }
        sb.append("        }").append(NEW_LINE);
        sb.append("        throw new IllegalArgumentException(\"Unknown parameter index: \" + parameterIndex);").append(NEW_LINE);
        sb.append("    }").append(NEW_LINE);
        sb.append(NEW_LINE);
        sb.append("    @Override").append(NEW_LINE);
        sb.append("    public <").append(elementType).append("> ").append(entity.builderImportType("com.blazebit.persistence.view.EntityViewNestedBuilder")).append("<").append(elementType).append(", ? extends ").append(builderType).append(", ?> withCollectionBuilder(int parameterIndex) {").append(NEW_LINE);
        sb.append("        switch (parameterIndex) {").append(NEW_LINE);
        for (i = 0; i < members.size(); ++i) {
            metaMember = members.get(i);
            if (!(metaMember instanceof AnnotationMetaCollection) || metaMember instanceof AnnotationMetaMap || !metaMember.isSubview()) continue;
            sb.append("            case ").append(i).append(":").append(NEW_LINE);
            sb.append("                return (").append(entity.builderImportType("com.blazebit.persistence.view.EntityViewNestedBuilder")).append("<").append(elementType).append(", ? extends ").append(builderType).append(", ?>) with").append(PARAMETER_PREFIX);
            sb.append(Character.toUpperCase(metaMember.getPropertyName().charAt(0)));
            sb.append(metaMember.getPropertyName(), 1, metaMember.getPropertyName().length()).append("Builder();").append(NEW_LINE);
        }
        sb.append("        }").append(NEW_LINE);
        sb.append("        throw new IllegalArgumentException(\"Unknown parameter index: \" + parameterIndex);").append(NEW_LINE);
        sb.append("    }").append(NEW_LINE);
        sb.append(NEW_LINE);
        sb.append("    @Override").append(NEW_LINE);
        sb.append("    public <").append(elementType).append("> ").append(entity.builderImportType("com.blazebit.persistence.view.EntityViewNestedBuilder")).append("<").append(elementType).append(", ? extends ").append(builderType).append(", ?> withListBuilder(int parameterIndex) {").append(NEW_LINE);
        sb.append("        switch (parameterIndex) {").append(NEW_LINE);
        for (i = 0; i < members.size(); ++i) {
            metaMember = members.get(i);
            if (!(metaMember instanceof AnnotationMetaCollection) || metaMember instanceof AnnotationMetaMap || !metaMember.isSubview()) continue;
            sb.append("            case ").append(i).append(":").append(NEW_LINE);
            sb.append("                return (").append(entity.builderImportType("com.blazebit.persistence.view.EntityViewNestedBuilder")).append("<").append(elementType).append(", ? extends ").append(builderType).append(", ?>) with").append(PARAMETER_PREFIX);
            sb.append(Character.toUpperCase(metaMember.getPropertyName().charAt(0)));
            sb.append(metaMember.getPropertyName(), 1, metaMember.getPropertyName().length()).append("Builder();").append(NEW_LINE);
        }
        sb.append("        }").append(NEW_LINE);
        sb.append("        throw new IllegalArgumentException(\"Unknown parameter index: \" + parameterIndex);").append(NEW_LINE);
        sb.append("    }").append(NEW_LINE);
        sb.append(NEW_LINE);
        sb.append("    @Override").append(NEW_LINE);
        sb.append("    public <").append(elementType).append("> ").append(entity.builderImportType("com.blazebit.persistence.view.EntityViewNestedBuilder")).append("<").append(elementType).append(", ? extends ").append(builderType).append(", ?> withListBuilder(int parameterIndex, int index) {").append(NEW_LINE);
        sb.append("        switch (parameterIndex) {").append(NEW_LINE);
        for (i = 0; i < members.size(); ++i) {
            metaMember = members.get(i);
            if (!(metaMember instanceof AnnotationMetaCollection) || !((AnnotationMetaCollection)metaMember).isIndexedList() || !metaMember.isSubview()) continue;
            sb.append("            case ").append(i).append(":").append(NEW_LINE);
            sb.append("                return (").append(entity.builderImportType("com.blazebit.persistence.view.EntityViewNestedBuilder")).append("<").append(elementType).append(", ? extends ").append(builderType).append(", ?>) with").append(PARAMETER_PREFIX);
            sb.append(Character.toUpperCase(metaMember.getPropertyName().charAt(0)));
            sb.append(metaMember.getPropertyName(), 1, metaMember.getPropertyName().length()).append("Builder(index);").append(NEW_LINE);
        }
        sb.append("        }").append(NEW_LINE);
        sb.append("        throw new IllegalArgumentException(\"Unknown parameter index: \" + parameterIndex);").append(NEW_LINE);
        sb.append("    }").append(NEW_LINE);
        sb.append(NEW_LINE);
        sb.append("    @Override").append(NEW_LINE);
        sb.append("    public <").append(elementType).append("> ").append(entity.builderImportType("com.blazebit.persistence.view.EntityViewNestedBuilder")).append("<").append(elementType).append(", ? extends ").append(builderType).append(", ?> withSetBuilder(int parameterIndex) {").append(NEW_LINE);
        sb.append("        switch (parameterIndex) {").append(NEW_LINE);
        for (i = 0; i < members.size(); ++i) {
            metaMember = members.get(i);
            if (!(metaMember instanceof AnnotationMetaCollection) || metaMember instanceof AnnotationMetaMap || !metaMember.isSubview()) continue;
            sb.append("            case ").append(i).append(":").append(NEW_LINE);
            sb.append("                return (").append(entity.builderImportType("com.blazebit.persistence.view.EntityViewNestedBuilder")).append("<").append(elementType).append(", ? extends ").append(builderType).append(", ?>) with").append(PARAMETER_PREFIX);
            sb.append(Character.toUpperCase(metaMember.getPropertyName().charAt(0)));
            sb.append(metaMember.getPropertyName(), 1, metaMember.getPropertyName().length()).append("Builder();").append(NEW_LINE);
        }
        sb.append("        }").append(NEW_LINE);
        sb.append("        throw new IllegalArgumentException(\"Unknown parameter index: \" + parameterIndex);").append(NEW_LINE);
        sb.append("    }").append(NEW_LINE);
        sb.append(NEW_LINE);
        sb.append("    @Override").append(NEW_LINE);
        sb.append("    public <").append(elementType).append("> ").append(entity.builderImportType("com.blazebit.persistence.view.EntityViewNestedBuilder")).append("<").append(elementType).append(", ? extends ").append(builderType).append(", ?> withMapBuilder(int parameterIndex, Object key) {").append(NEW_LINE);
        sb.append("        switch (parameterIndex) {").append(NEW_LINE);
        for (i = 0; i < members.size(); ++i) {
            metaMember = members.get(i);
            if (!(metaMember instanceof AnnotationMetaMap) || !metaMember.isSubview()) continue;
            sb.append("            case ").append(i).append(":").append(NEW_LINE);
            sb.append("                return (").append(entity.builderImportType("com.blazebit.persistence.view.EntityViewNestedBuilder")).append("<").append(elementType).append(", ? extends ").append(builderType).append(", ?>) with").append(PARAMETER_PREFIX);
            sb.append(Character.toUpperCase(metaMember.getPropertyName().charAt(0)));
            sb.append(metaMember.getPropertyName(), 1, metaMember.getPropertyName().length()).append("Builder(key);").append(NEW_LINE);
        }
        sb.append("        }").append(NEW_LINE);
        sb.append("        throw new IllegalArgumentException(\"Unknown parameter index: \" + parameterIndex);").append(NEW_LINE);
        sb.append("    }").append(NEW_LINE);
        sb.append(NEW_LINE);
        sb.append("    @Override").append(NEW_LINE);
        sb.append("    public <").append(keyType).append(", ").append(elementType).append("> ").append(entity.builderImportType("com.blazebit.persistence.view.EntityViewNestedBuilder")).append("<").append(keyType).append(", ? extends ").append(entity.builderImportType("com.blazebit.persistence.view.EntityViewNestedBuilder")).append("<").append(elementType).append(", ? extends ").append(builderType).append(", ?>, ?> withMapBuilder(int parameterIndex) {").append(NEW_LINE);
        sb.append("        switch (parameterIndex) {").append(NEW_LINE);
        for (i = 0; i < members.size(); ++i) {
            metaMember = members.get(i);
            if (!(metaMember instanceof AnnotationMetaMap) || !((AnnotationMetaMap)metaMember).isKeySubview() || !metaMember.isSubview()) continue;
            sb.append("            case ").append(i).append(":").append(NEW_LINE);
            sb.append("                return (").append(entity.builderImportType("com.blazebit.persistence.view.EntityViewNestedBuilder")).append("<").append(keyType).append(", ? extends ").append(entity.builderImportType("com.blazebit.persistence.view.EntityViewNestedBuilder")).append("<").append(elementType).append(", ? extends ").append(builderType).append(", ?>, ?>) with");
            sb.append(Character.toUpperCase(metaMember.getPropertyName().charAt(0)));
            sb.append(metaMember.getPropertyName(), 1, metaMember.getPropertyName().length()).append("Builder();").append(NEW_LINE);
        }
        sb.append("        }").append(NEW_LINE);
        sb.append("        throw new IllegalArgumentException(\"Unknown parameter index: \" + parameterIndex);").append(NEW_LINE);
        sb.append("    }").append(NEW_LINE);
    }

    private static void printClassDeclaration(StringBuilder sb, MetaEntityView entity, Context context) {
        sb.append("public abstract class ").append(entity.getSimpleName()).append(BUILDER_CLASS_NAME_SUFFIX);
        String builderType = entity.getSafeTypeVariable("BuilderType");
        List<? extends TypeMirror> typeArguments = ((DeclaredType)entity.getTypeElement().asType()).getTypeArguments();
        sb.append("<");
        if (!typeArguments.isEmpty()) {
            BuilderClassWriter.printTypeVariable(sb, entity, (TypeVariable)typeArguments.get(0));
            for (int i = 1; i < typeArguments.size(); ++i) {
                sb.append(", ");
                BuilderClassWriter.printTypeVariable(sb, entity, (TypeVariable)typeArguments.get(i));
            }
            sb.append(", ");
        }
        sb.append(builderType).append(" extends EntityViewBuilderBase<");
        sb.append(entity.builderImportType(entity.getQualifiedName()));
        sb.append(", ").append(builderType).append(">> implements ");
        sb.append(entity.builderImportType("com.blazebit.persistence.view.EntityViewBuilderBase"));
        sb.append("<");
        sb.append(entity.builderImportType(entity.getQualifiedName()));
        sb.append(", ").append(builderType).append(">");
        sb.append(" {");
        sb.append(NEW_LINE);
    }

    private static void printTypeVariable(StringBuilder sb, MetaEntityView entity, TypeVariable t) {
        sb.append(t);
        if (t.getLowerBound().getKind() == TypeKind.NULL) {
            sb.append(" extends ").append(entity.builderImportType(t.getUpperBound().toString()));
        } else {
            sb.append(" super ").append(entity.builderImportType(t.getLowerBound().toString()));
        }
    }

    private static void printConstructors(StringBuilder sb, MetaEntityView entity, Context context) {
        sb.append("    public ").append(entity.getSimpleName()).append(BUILDER_CLASS_NAME_SUFFIX).append("(").append(entity.builderImportType("java.util.Map")).append("<String, Object> optionalParameters) {").append(NEW_LINE);
        for (MetaAttribute member : entity.getMembers()) {
            sb.append("        this.").append(member.getPropertyName()).append(" = ");
            if (member.getKind() == MappingKind.PARAMETER) {
                if (member.isPrimitive()) {
                    sb.append("!optionalParameters.containsKey(\"").append(member.getMapping()).append("\") ? ");
                    member.appendDefaultValue(sb, false, true, entity.getBuilderImportContext());
                    sb.append(" : ");
                }
                sb.append("(").append(entity.builderImportType(member.getImplementationTypeString())).append(") optionalParameters.get(\"").append(member.getMapping()).append("\")").append(NEW_LINE);
            } else {
                member.appendDefaultValue(sb, true, true, entity.getBuilderImportContext());
            }
            sb.append(";");
            sb.append(NEW_LINE);
        }
        sb.append("        this.optionalParameters = optionalParameters;").append(NEW_LINE);
        sb.append("    }");
        sb.append(NEW_LINE);
    }
}

