/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.processor;

import com.blazebit.persistence.view.processor.Context;
import com.blazebit.persistence.view.processor.EntityViewAnnotationProcessor;
import com.blazebit.persistence.view.processor.ImportContext;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.processing.Filer;
import javax.annotation.processing.FilerException;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

public final class ClassWriterUtils {
    private static final ThreadLocal<SimpleDateFormat> SIMPLE_DATE_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        public SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        }
    };

    private ClassWriterUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(StringBuilder sb, String basePackage, String simpleName, ImportContext importContext, Context context, Element ... originatingElements) {
        Filer filer = context.getProcessingEnvironment().getFiler();
        Element[] elements = originatingElements.length > 0 && filer.getClass().getName().startsWith("org.gradle.api") ? new Element[]{originatingElements[0]} : originatingElements;
        try {
            OutputStream os;
            String fullyQualifiedClassName = ClassWriterUtils.getFullyQualifiedClassName(basePackage, simpleName);
            context.getTypeElement(fullyQualifiedClassName);
            Context context2 = context;
            synchronized (context2) {
                JavaFileObject fo = filer.createSourceFile(fullyQualifiedClassName, elements);
                os = fo.openOutputStream();
            }
            PrintWriter pw = new PrintWriter(os);
            if (!basePackage.isEmpty()) {
                pw.println("package " + basePackage + ";");
                pw.println();
            }
            if (importContext != null) {
                pw.println(importContext.generateImports());
            }
            pw.println(sb);
            pw.flush();
            Context context3 = context;
            synchronized (context3) {
                pw.close();
            }
        }
        catch (FilerException filerEx) {
            context.logMessage(Diagnostic.Kind.ERROR, "Problem with Filer: " + filerEx.getMessage());
        }
        catch (IOException ioEx) {
            context.logMessage(Diagnostic.Kind.ERROR, "Problem opening file to write " + simpleName + ioEx.getMessage());
        }
    }

    private static String getFullyQualifiedClassName(String metaModelPackage, String simpleName) {
        String fullyQualifiedClassName = "";
        if (!metaModelPackage.isEmpty()) {
            fullyQualifiedClassName = fullyQualifiedClassName + metaModelPackage + ".";
        }
        fullyQualifiedClassName = fullyQualifiedClassName + simpleName;
        return fullyQualifiedClassName;
    }

    public static String writeGeneratedAnnotation(ImportContext importContext, Context context) {
        StringBuilder generatedAnnotation = new StringBuilder();
        ClassWriterUtils.writeGeneratedAnnotation(generatedAnnotation, importContext, context);
        return generatedAnnotation.toString();
    }

    public static void writeGeneratedAnnotation(StringBuilder generatedAnnotation, ImportContext importContext, Context context) {
        generatedAnnotation.append("@");
        if (importContext == null) {
            generatedAnnotation.append(context.getGeneratedAnnotation().getQualifiedName().toString());
        } else {
            generatedAnnotation.append(importContext.importType(context.getGeneratedAnnotation().getQualifiedName().toString()));
        }
        generatedAnnotation.append("(value = \"").append(EntityViewAnnotationProcessor.class.getName());
        if (context.addGeneratedDate()) {
            generatedAnnotation.append("\", date = \"").append(SIMPLE_DATE_FORMAT.get().format(new Date())).append("\")");
        } else {
            generatedAnnotation.append("\")");
        }
    }

    public static String writeSuppressWarnings() {
        return "@SuppressWarnings({ \"deprecation\", \"rawtypes\" })";
    }
}

