/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.processor;

import com.blazebit.persistence.view.processor.ImportContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class ImportContextImpl
implements ImportContext {
    private static final Map<String, String> PRIMITIVES = new HashMap<String, String>();
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private final Set<String> imports = new TreeSet<String>();
    private final Map<String, String> simpleNames = new HashMap<String, String>();
    private final String basePackage;

    public ImportContextImpl(String basePackage) {
        this.basePackage = basePackage;
    }

    @Override
    public String importType(String fqcn) {
        boolean canBeSimple;
        String result = fqcn;
        String prefix = "";
        if (fqcn.startsWith("? extends ")) {
            prefix = "? extends ";
            fqcn = fqcn.substring(prefix.length());
        } else if (fqcn.startsWith("? super ")) {
            prefix = "? super ";
            fqcn = fqcn.substring(prefix.length());
        }
        String additionalTypePart = null;
        int ltIdx = fqcn.indexOf(60);
        if (ltIdx != -1) {
            additionalTypePart = result.substring(ltIdx);
            fqcn = result = result.substring(0, ltIdx);
        } else {
            int bracketIdx = fqcn.indexOf(91);
            if (bracketIdx != -1) {
                additionalTypePart = result.substring(bracketIdx);
                fqcn = result = result.substring(0, bracketIdx);
            }
        }
        String pureFqcn = fqcn.replace('$', '.');
        String simpleName = ImportContextImpl.unqualify(fqcn);
        String existingFqcn = this.simpleNames.get(simpleName);
        if (existingFqcn != null) {
            canBeSimple = existingFqcn.equals(pureFqcn);
        } else {
            canBeSimple = true;
            this.simpleNames.put(simpleName, pureFqcn);
            this.imports.add(pureFqcn);
        }
        if (this.inSamePackage(fqcn) || this.imports.contains(pureFqcn) && canBeSimple) {
            result = ImportContextImpl.unqualify(result);
        } else if (this.inJavaLang(fqcn)) {
            result = result.substring("java.lang.".length());
        }
        if (additionalTypePart != null) {
            result = result + additionalTypePart;
        }
        result = result.replace('$', '.');
        if (!prefix.isEmpty()) {
            result = prefix + result;
        }
        return result;
    }

    private boolean inDefaultPackage(String className) {
        return className.indexOf(46) == -1;
    }

    private boolean isPrimitive(String className) {
        return PRIMITIVES.containsKey(className);
    }

    private boolean inSamePackage(String className) {
        return ImportContextImpl.isInPackage(className, this.basePackage);
    }

    private static boolean isInPackage(String className, String packageName) {
        return className.regionMatches(0, packageName, 0, packageName.length()) && className.lastIndexOf(46) == packageName.length();
    }

    private boolean inJavaLang(String className) {
        return ImportContextImpl.isInPackage(className, "java.lang");
    }

    @Override
    public String generateImports() {
        StringBuilder builder = new StringBuilder();
        for (String next : this.imports) {
            if (this.isAutoImported(next)) continue;
            builder.append("import ").append(next).append(';').append(LINE_SEPARATOR);
        }
        return builder.toString();
    }

    private boolean isAutoImported(String next) {
        return this.isPrimitive(next) || this.inDefaultPackage(next) || this.inJavaLang(next) || this.inSamePackage(next);
    }

    public static String unqualify(String qualifiedName) {
        int idx = qualifiedName.lastIndexOf(46);
        return idx < 0 ? qualifiedName : qualifiedName.substring(idx + 1);
    }

    static {
        PRIMITIVES.put("char", "Character");
        PRIMITIVES.put("byte", "Byte");
        PRIMITIVES.put("short", "Short");
        PRIMITIVES.put("int", "Integer");
        PRIMITIVES.put("long", "Long");
        PRIMITIVES.put("boolean", "Boolean");
        PRIMITIVES.put("float", "Float");
        PRIMITIVES.put("double", "Double");
    }
}

