/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.processor;

import com.blazebit.persistence.view.processor.Context;
import com.blazebit.persistence.view.processor.OptionalParameterUtils;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import com.sun.source.util.Trees;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;

public final class JavacOptionalParameterScanner {
    private JavacOptionalParameterScanner() {
    }

    public static void scan(Map<String, TypeElement> optionalParameters, ExecutableElement executableElement, Context context) {
        Trees instance = Trees.instance(context.getProcessingEnvironment());
        TreePath path = instance.getPath(executableElement);
        ClassTree classTree = (ClassTree)path.getParentPath().getLeaf();
        HashMap<Name, String> constants = new HashMap<Name, String>();
        for (Tree tree : classTree.getMembers()) {
            VariableTree variableTree;
            Set<Modifier> flags;
            if (!(tree instanceof VariableTree) || !(flags = (variableTree = (VariableTree)tree).getModifiers().getFlags()).contains((Object)Modifier.STATIC) || !flags.contains((Object)Modifier.FINAL) || !(variableTree.getInitializer() instanceof LiteralTree)) continue;
            LiteralTree literalTree = (LiteralTree)variableTree.getInitializer();
            constants.put(variableTree.getName(), (String)literalTree.getValue());
        }
        MethodTree methodTree = (MethodTree)path.getLeaf();
        for (StatementTree statementTree : methodTree.getBody().getStatements()) {
            OptionalParameterCollectingTreeScanner scanner = new OptionalParameterCollectingTreeScanner(optionalParameters, context, constants);
            statementTree.accept(scanner, null);
            if (scanner.last == null) continue;
            OptionalParameterUtils.addOptionalParameters(optionalParameters, scanner.last, context);
        }
    }

    private static class OptionalParameterCollectingTreeScanner
    extends TreeScanner<String, String> {
        private final Map<String, TypeElement> optionalParameters;
        private final Context context;
        private final Map<Name, String> constants;
        private String last;

        public OptionalParameterCollectingTreeScanner(Map<String, TypeElement> optionalParameters, Context context, Map<Name, String> constants) {
            this.optionalParameters = optionalParameters;
            this.context = context;
            this.constants = constants;
        }

        @Override
        public String visitLiteral(LiteralTree literalTree, String aVoid) {
            if (literalTree.getKind() == Tree.Kind.STRING_LITERAL) {
                if (this.last != null) {
                    OptionalParameterUtils.addOptionalParameters(this.optionalParameters, this.last, this.context);
                }
                this.last = (String)literalTree.getValue();
                return this.last;
            }
            return (String)super.visitLiteral(literalTree, aVoid);
        }

        @Override
        public String visitIdentifier(IdentifierTree identifierTree, String s) {
            String value = this.constants.get(identifierTree.getName());
            if (this.last != null) {
                OptionalParameterUtils.addOptionalParameters(this.optionalParameters, this.last, this.context);
            }
            this.last = value;
            return this.last;
        }

        @Override
        public String visitBinary(BinaryTree binaryTree, String s) {
            if (binaryTree.getKind() == Tree.Kind.PLUS) {
                if (this.last != null) {
                    OptionalParameterUtils.addOptionalParameters(this.optionalParameters, this.last, this.context);
                }
                this.last = null;
                String lhs = (String)this.scan(binaryTree.getLeftOperand(), null);
                this.last = null;
                String rhs = (String)this.scan(binaryTree.getRightOperand(), null);
                if (lhs == null) {
                    this.last = rhs;
                    return this.last;
                }
                if (rhs == null) {
                    this.last = lhs;
                    return this.last;
                }
                this.last = lhs + rhs;
                return this.last;
            }
            return (String)super.visitBinary(binaryTree, s);
        }
    }
}

