/*
 * Copyright 2014 - 2024 Blazebit.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.blazebit.persistence.examples.quarkus.base.config;

import com.blazebit.persistence.spi.CriteriaBuilderConfiguration;
import com.blazebit.persistence.spi.FunctionRenderContext;
import com.blazebit.persistence.spi.JpqlMacro;
import com.blazebit.persistence.view.spi.EntityViewConfiguration;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Observes;

@ApplicationScoped
public class BlazePersistenceConfigurator {

    public void observe(@Observes CriteriaBuilderConfiguration config) {
        config.registerMacro("my_macro", new JpqlMacro() {
            @Override
            public void render(FunctionRenderContext context) {
                context.addArgument(0);
            }
        });
    }

    public void observe(@Observes EntityViewConfiguration config) {
        config.setOptionalParameter("optionalParameter", "test");
    }

}
