/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.examples.quarkus.base.resource;

import com.blazebit.persistence.CriteriaBuilder;
import com.blazebit.persistence.CriteriaBuilderFactory;
import com.blazebit.persistence.examples.quarkus.base.entity.Document;
import com.blazebit.persistence.examples.quarkus.base.view.DocumentUpdateView;
import com.blazebit.persistence.examples.quarkus.base.view.DocumentView;
import com.blazebit.persistence.examples.quarkus.base.view.DocumentWithJsonIgnoredNameView;
import com.blazebit.persistence.integration.jaxrs.EntityViewId;
import com.blazebit.persistence.view.EntityViewManager;
import com.blazebit.persistence.view.EntityViewSetting;
import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.transaction.Transactional;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.List;

@Path(value="documents")
public class DocumentResource {
    @Inject
    private EntityManager em;
    @Inject
    private EntityViewManager evm;
    @Inject
    private CriteriaBuilderFactory cbf;

    @Transactional
    @PUT
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public DocumentView updateDocument(@EntityViewId(value="id") DocumentUpdateView documentUpdateView) {
        this.evm.save(this.em, (Object)documentUpdateView);
        return (DocumentView)this.evm.find(this.em, DocumentView.class, (Object)documentUpdateView.getId());
    }

    @POST
    @Transactional
    @Produces(value={"application/json"})
    public Response addDocument(DocumentUpdateView view) {
        this.evm.save(this.em, (Object)view);
        return Response.created((URI)URI.create("/documents/" + view.getId())).build();
    }

    @GET
    @Transactional
    @Produces(value={"application/json"})
    public List<DocumentView> getDocuments(@QueryParam(value="age") List<Long> ages) {
        CriteriaBuilder cb = (CriteriaBuilder)this.cbf.create(this.em, Document.class).where("age").in().fromValues(Long.class, "age", ages).end();
        return ((CriteriaBuilder)this.evm.applySetting(EntityViewSetting.create(DocumentView.class), cb)).getResultList();
    }

    @GET
    @Transactional
    @Produces(value={"application/vnd.blazebit.noname+json"})
    public List<DocumentWithJsonIgnoredNameView> getDocumentsWithJsonIgnoredName(@QueryParam(value="age") List<Long> ages) {
        CriteriaBuilder cb = (CriteriaBuilder)this.cbf.create(this.em, Document.class).where("age").in().fromValues(Long.class, "age", ages).end();
        return ((CriteriaBuilder)this.evm.applySetting(EntityViewSetting.create(DocumentWithJsonIgnoredNameView.class), cb)).getResultList();
    }

    @DELETE
    @Transactional
    public Response clearDocuments() {
        this.cbf.delete(this.em, Document.class).executeUpdate();
        return Response.ok().build();
    }
}

