/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.examples.quarkus.base.resource;

import com.blazebit.persistence.CriteriaBuilderFactory;
import com.blazebit.persistence.examples.quarkus.base.entity.DocumentType;
import com.blazebit.persistence.examples.quarkus.base.view.DocumentTypeCreateView;
import com.blazebit.persistence.examples.quarkus.base.view.DocumentTypeUpdateView;
import com.blazebit.persistence.examples.quarkus.base.view.DocumentTypeView;
import com.blazebit.persistence.integration.jaxrs.EntityViewId;
import com.blazebit.persistence.view.EntityViewManager;
import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.transaction.Transactional;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.net.URI;

@Path(value="document-types")
public class DocumentTypeResource {
    @Inject
    private EntityManager em;
    @Inject
    private EntityViewManager evm;
    @Inject
    private CriteriaBuilderFactory cbf;

    @Transactional
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createDocumentType(DocumentTypeCreateView documentTypeCreateView) {
        this.evm.save(this.em, (Object)documentTypeCreateView);
        return Response.created((URI)URI.create("/document-types/" + documentTypeCreateView.getId())).build();
    }

    @Transactional
    @PUT
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public DocumentTypeView updateDocumentType(@EntityViewId(value="id") DocumentTypeUpdateView documentTypeUpdateView) {
        this.evm.save(this.em, (Object)documentTypeUpdateView);
        return (DocumentTypeView)this.evm.find(this.em, DocumentTypeView.class, (Object)documentTypeUpdateView.getId());
    }

    @DELETE
    @Transactional
    public Response clearDocumentTypes() {
        this.cbf.delete(this.em, DocumentType.class).executeUpdate();
        return Response.ok().build();
    }
}

