/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.examples.quarkus.base.resource;

import com.blazebit.persistence.CriteriaBuilderFactory;
import com.blazebit.persistence.examples.quarkus.base.entity.Person;
import com.blazebit.persistence.examples.quarkus.base.view.PersonCreateView;
import com.blazebit.persistence.examples.quarkus.base.view.PersonUpdateView;
import com.blazebit.persistence.examples.quarkus.base.view.PersonView;
import com.blazebit.persistence.integration.jaxrs.EntityViewId;
import com.blazebit.persistence.view.EntityViewManager;
import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.transaction.Transactional;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.net.URI;

@Path(value="persons")
public class PersonResource {
    @Inject
    private EntityManager em;
    @Inject
    private EntityViewManager evm;
    @Inject
    private CriteriaBuilderFactory cbf;

    @Transactional
    @PUT
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public PersonView updatePerson(@EntityViewId(value="id") PersonUpdateView personUpdateView) {
        this.evm.save(this.em, (Object)personUpdateView);
        return (PersonView)this.evm.find(this.em, PersonView.class, (Object)personUpdateView.getId());
    }

    @POST
    @Transactional
    @Produces(value={"application/json"})
    public Response addPerson(PersonCreateView view) {
        this.evm.save(this.em, (Object)view);
        return Response.created((URI)URI.create("/persons/" + view.getId())).build();
    }

    @DELETE
    @Transactional
    public Response clearPersons() {
        this.cbf.delete(this.em, Person.class).executeUpdate();
        return Response.ok().build();
    }
}

