/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.datanucleus;

import com.blazebit.persistence.ReturningResult;
import com.blazebit.persistence.spi.ExtendedQuerySupport;
import com.blazebit.persistence.spi.ServiceProvider;
import java.lang.reflect.Field;
import java.util.List;
import javax.persistence.EntityManager;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.rdbms.query.JPQLQuery;
import org.datanucleus.store.rdbms.query.RDBMSQueryCompilation;

public class DataNucleusExtendedQuerySupport
implements ExtendedQuerySupport {
    private static final Field DATASTORE_COMPILATION_FIELD;

    public boolean supportsAdvancedSql() {
        return false;
    }

    public boolean needsExampleQueryForAdvancedDml() {
        return false;
    }

    public boolean applyFirstResultMaxResults(javax.persistence.Query query, int firstResult, int maxResults) {
        query.setFirstResult(firstResult);
        query.setMaxResults(maxResults);
        return true;
    }

    public String getSql(EntityManager em, javax.persistence.Query query) {
        Query dnQuery = (Query)query.unwrap(Query.class);
        dnQuery.compile();
        return (String)dnQuery.getNativeQuery();
    }

    public boolean getSqlContainsLimit() {
        return true;
    }

    public List<String> getCascadingDeleteSql(EntityManager em, javax.persistence.Query query) {
        throw new UnsupportedOperationException("Not yet implemeneted!");
    }

    public int getSqlSelectAliasPosition(EntityManager em, javax.persistence.Query query, String alias) {
        throw new UnsupportedOperationException("Not yet implemeneted!");
    }

    public String getSqlAlias(EntityManager em, javax.persistence.Query query, String alias, int queryPartNumber) {
        throw new UnsupportedOperationException("Not yet implemeneted!");
    }

    public ExtendedQuerySupport.SqlFromInfo getSqlFromInfo(EntityManager em, javax.persistence.Query query, String alias, int queryPartNumber) {
        throw new UnsupportedOperationException("Not yet implemeneted!");
    }

    public int getSqlSelectAttributePosition(EntityManager em, javax.persistence.Query query, String alias) {
        throw new UnsupportedOperationException("Not yet implemeneted!");
    }

    public List getResultList(ServiceProvider serviceProvider, List<javax.persistence.Query> participatingQueries, javax.persistence.Query query, String sqlOverride, boolean queryPlanCacheEnabled) {
        this.applySql(query, sqlOverride);
        return query.getResultList();
    }

    public Object getResultStream(ServiceProvider serviceProvider, List<javax.persistence.Query> participatingQueries, javax.persistence.Query query, String sqlOverride, boolean queryPlanCacheEnabled) {
        this.applySql(query, sqlOverride);
        return query.getResultList().stream();
    }

    public Object getSingleResult(ServiceProvider serviceProvider, List<javax.persistence.Query> participatingQueries, javax.persistence.Query query, String sqlOverride, boolean queryPlanCacheEnabled) {
        this.applySql(query, sqlOverride);
        return query.getSingleResult();
    }

    public int executeUpdate(ServiceProvider serviceProvider, List<javax.persistence.Query> participatingQueries, javax.persistence.Query baseQuery, javax.persistence.Query query, String sqlOverride, boolean queryPlanCacheEnabled) {
        this.applySql(query, sqlOverride);
        return query.executeUpdate();
    }

    public ReturningResult<Object[]> executeReturning(ServiceProvider serviceProvider, List<javax.persistence.Query> participatingQueries, javax.persistence.Query modificationBaseQuery, javax.persistence.Query exampleQuery, String sqlOverride, boolean queryPlanCacheEnabled) {
        throw new UnsupportedOperationException("Not yet implemeneted!");
    }

    private void applySql(javax.persistence.Query query, String sqlOverride) {
        Query dnQuery = (Query)query.unwrap(Query.class);
        dnQuery.addExtension("datanucleus.query.compilation.cached", (Object)Boolean.FALSE);
        try {
            RDBMSQueryCompilation datastoreCompilation = (RDBMSQueryCompilation)DATASTORE_COMPILATION_FIELD.get(dnQuery);
            datastoreCompilation.setSQL(sqlOverride);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            DATASTORE_COMPILATION_FIELD = JPQLQuery.class.getDeclaredField("datastoreCompilation");
            DATASTORE_COMPILATION_FIELD.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException("Unsupported datanucleus version!", e);
        }
    }
}

